/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.msg;

import de.effectivecompany.base.msg.Msg;
import de.effectivecompany.base.msg.MsgType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class MsgList
implements Serializable,
Iterable<Msg> {
    private static final long serialVersionUID = 4138870169003580085L;
    private List<Msg> msgList = new ArrayList<Msg>();
    private MsgType maxType = MsgType.INFO;

    public synchronized void addMsg(Msg i_msg) {
        if (i_msg != null) {
            if (i_msg.getType() == MsgType.PROGRESS) {
                throw new RuntimeException("No progress messages allowed");
            }
            this.msgList.add(i_msg);
            if (i_msg.getType() != null && i_msg.getType().ordinal() > this.maxType.ordinal()) {
                this.maxType = i_msg.getType();
            }
        }
    }

    public List<Msg> getMsgList() {
        return this.msgList;
    }

    public synchronized void clear() {
        this.msgList.clear();
        this.maxType = MsgType.INFO;
    }

    public synchronized boolean removeMsg(Msg msg) {
        boolean ret = false;
        if (msg != null) {
            for (Msg m : this.msgList) {
                if (m.getMsg().getMsgNumber() != msg.getMsg().getMsgNumber()) continue;
                ret = this.msgList.remove(m);
                break;
            }
        }
        return ret;
    }

    public MsgType getMaxSeverity() {
        return this.maxType;
    }

    public boolean hasMessages() {
        return this.msgList.size() > 0;
    }

    public synchronized void addMsgList(MsgList i_listToAdd) {
        if (i_listToAdd != null) {
            i_listToAdd.forEach(msg1 -> {
                boolean found = false;
                if (this.msgList.parallelStream().anyMatch(msg2 -> msg2.getMsg() == msg1.getMsg())) {
                    found = true;
                }
                if (!found) {
                    this.msgList.add((Msg)msg1);
                }
            });
            if (i_listToAdd.getMaxSeverity().isHigher(this.getMaxSeverity())) {
                this.maxType = i_listToAdd.getMaxSeverity();
            }
        }
    }

    public synchronized void addMsgList(MsgList i_listToAdd, String i_source) {
        if (i_listToAdd != null) {
            i_listToAdd.forEach(msg1 -> {
                boolean found = false;
                if (this.msgList.parallelStream().anyMatch(msg2 -> msg2.getMsg() == msg1.getMsg())) {
                    found = true;
                }
                if (!found) {
                    msg1.setDetailSource(i_source + "->" + msg1.getDetailSource());
                    this.msgList.add((Msg)msg1);
                }
            });
            if (i_listToAdd.getMaxSeverity().isHigher(this.getMaxSeverity())) {
                this.maxType = i_listToAdd.getMaxSeverity();
            }
        }
    }

    @Override
    public Iterator<Msg> iterator() {
        return this.msgList.iterator();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (Msg msg : this.msgList) {
            buf.append(msg.toString() + "\n");
        }
        return buf.toString();
    }
}

