/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.report;

import de.effectivecompany.base.efcbl.domain.AbstractDomainObject;
import de.effectivecompany.base.efcbl.util.FactoryHelper;
import de.effectivecompany.base.meta.TypeInfo;
import de.effectivecompany.base.util.SpringHelper;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.data.AbstractClasspathAwareDataAdapterService;
import net.sf.jasperreports.data.ClasspathAwareDataAdapter;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.util.JRResourcesUtil;

public abstract class AbstractDataProvider {
    private JasperReport myReport;
    private boolean companyFound = false;
    private int companyAtLevel = -1;
    private static int MAX_DEEP_LEVEL = 3;
    private URLClassLoader urlLoader;

    public JasperReport getReport() {
        return this.myReport;
    }

    protected void setReport(JasperReport myReport) {
        this.myReport = myReport;
    }

    protected Object getParamValue(JasperReport report, JRParameter[] params, String name) throws JRException {
        Object paramVal = null;
        JREvaluator eval = JasperCompileManager.loadEvaluator((JasperReport)report);
        if (params == null) {
            params = report.getParameters();
        }
        for (JRParameter param : params) {
            if (!param.getName().equals(name)) continue;
            paramVal = eval.evaluate(param.getDefaultValueExpression());
            break;
        }
        return paramVal;
    }

    protected Object getService(Class<?> serviceClass) throws IllegalAccessException {
        Field beanField = null;
        for (Field field : serviceClass.getFields()) {
            if (!field.getName().equals("BEAN_ID")) continue;
            beanField = field;
            break;
        }
        if (beanField == null) {
            return null;
        }
        String beanId = (String)beanField.get(serviceClass);
        return SpringHelper.getBean(beanId);
    }

    protected JRField[] getFieldsFromInfo(String prefixDesc, String prefixName, Object metaInfo, int i_level, DataAdapterService con, boolean withHist, boolean withBoFields) throws JRException {
        return this.getFieldsFromInfo(prefixDesc, prefixName, metaInfo, i_level, withHist, withBoFields, null, con);
    }

    private Map<String, TypeInfo> getFieldTypeMap(Object metaInfo) throws JRException {
        Class[] partypes = new Class[]{};
        Object[] args = new Object[]{};
        HashMap<String, TypeInfo> fieldTypeMap = new HashMap();
        try {
            fieldTypeMap = (Map)metaInfo.getClass().getMethod("fieldTypeMap", partypes).invoke(metaInfo, args);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        return fieldTypeMap;
    }

    private int getGetTypeInfoTye(Object typeInfo) throws JRException {
        Class[] partypes = new Class[]{};
        Object[] args = new Object[]{};
        int type = 0;
        try {
            type = (Integer)typeInfo.getClass().getMethod("getType", partypes).invoke(typeInfo, args);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        return type;
    }

    private String getTypeInfoClassName(Object typeInfo) throws JRException {
        String className;
        Class[] partypes = new Class[]{};
        Object[] args = new Object[]{};
        try {
            className = (String)typeInfo.getClass().getMethod("getClassName", partypes).invoke(typeInfo, args);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new JRException(e.getMessage());
        }
        return className;
    }

    protected JRField[] getFieldsFromInfo(String prefixDesc, String prefixName, Object metaInfo, int level, boolean withHist, boolean withBoFields, Object typeInfo, DataAdapterService con) throws JRException {
        ArrayList<JRField> availableFields = new ArrayList<JRField>();
        int nextLevel = level + 1;
        Map<String, TypeInfo> fieldTypeMap = this.getFieldTypeMap(metaInfo);
        Vector<String> keys = new Vector<String>(fieldTypeMap.keySet());
        Collections.sort(keys);
        Iterator<String> iter = keys.iterator();
        if (this.companyAtLevel < 0) {
            while (iter.hasNext()) {
                typeInfo = fieldTypeMap.get(iter.next());
                if (!this.getTypeInfoClassName(typeInfo).equals("de.effectivecompany.app.bascl.ClBasCompany")) continue;
                this.companyAtLevel = level;
                break;
            }
        }
        for (String fieldName : keys) {
            typeInfo = fieldTypeMap.get(fieldName);
            int type = this.getGetTypeInfoTye(typeInfo);
            if (type == 0) {
                JRDesignField field = this.createField(prefixDesc, prefixName, fieldName, typeInfo);
                try {
                    String className = this.getTypeInfoClassName(typeInfo);
                    Object instance = FactoryHelper.newInstanceFromName(className, this.getClassLoader(con));
                    Class<?> abstractDomain = Class.forName(AbstractDomainObject.class.getName(), true, instance.getClass().getClassLoader());
                    if (abstractDomain.isAssignableFrom(instance.getClass())) {
                        if (level < MAX_DEEP_LEVEL) {
                            if (className.equals("de.effectivecompany.app.bascl.ClBasCompany")) {
                                if (level == this.companyAtLevel && !this.companyFound) {
                                    this.companyFound = true;
                                    this.addSubfields(withHist, withBoFields, availableFields, nextLevel, field, instance, typeInfo, con);
                                }
                            } else if (className.equals("de.effectivecompany.app.sys.HistInfo")) {
                                if (withHist) {
                                    this.addSubfields(withHist, withBoFields, availableFields, nextLevel, field, instance, typeInfo, con);
                                }
                            } else {
                                this.addSubfields(withHist, withBoFields, availableFields, nextLevel, field, instance, typeInfo, con);
                            }
                        }
                        if (!withBoFields) continue;
                        if (className.equals("de.effectivecompany.app.sys.HistInfo")) {
                            if (!withHist) continue;
                            availableFields.add((JRField)field);
                            continue;
                        }
                        availableFields.add((JRField)field);
                        continue;
                    }
                    availableFields.add((JRField)field);
                    continue;
                }
                catch (ClassNotFoundException e1) {
                    throw new JRException("Error: Problem getting fields: " + e1.getMessage());
                }
            }
            if (type == 1) {
                availableFields.add((JRField)this.createField(prefixDesc, prefixName, fieldName, typeInfo));
                continue;
            }
            if (type == 2) {
                availableFields.add((JRField)this.createField(prefixDesc, prefixName, fieldName, typeInfo));
                continue;
            }
            if (type != 3) continue;
            availableFields.add((JRField)this.createField(prefixDesc, prefixName, fieldName, typeInfo));
        }
        return availableFields.toArray(new JRField[0]);
    }

    private void addSubfields(boolean withHist, boolean withBoFields, List<JRField> availableFields, int nextLevel, JRDesignField field, Object instance, Object typeInfo, DataAdapterService con) throws JRException {
        JRField[] subfields = this.getFieldsFromInfo(field.getDescription(), field.getName(), instance, nextLevel, withHist, withBoFields, typeInfo, con);
        if (subfields != null) {
            for (JRField subfield : subfields) {
                availableFields.add(subfield);
            }
        }
    }

    private JRDesignField createField(String prefixDesc, String prefixName, String fieldName, Object info) throws JRException {
        JRDesignField field = new JRDesignField();
        String className = this.getTypeInfoClassName(info);
        field.setValueClassName(className);
        Object name = fieldName;
        Object desc = fieldName;
        if (prefixName != null && prefixName.length() > 0) {
            name = prefixName + "." + fieldName;
            desc = prefixDesc + "." + fieldName;
        }
        field.setDescription((String)desc);
        field.setName((String)name);
        return field;
    }

    protected ClassLoader getClassLoader(DataAdapterService con) {
        if (con != null) {
            if (this.urlLoader == null) {
                AbstractClasspathAwareDataAdapterService ad = (AbstractClasspathAwareDataAdapterService)con;
                ClasspathAwareDataAdapter dataAdapter = (ClasspathAwareDataAdapter)ad.getDataAdapter();
                List classpath = dataAdapter.getClasspath();
                ArrayList<URL> urls = new ArrayList<URL>();
                for (String path : classpath) {
                    File file = JRResourcesUtil.resolveFile(null, (String)path);
                    if (file == null || !file.exists()) continue;
                    try {
                        urls.add(file.toURI().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                this.urlLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]));
                return this.urlLoader;
            }
            return this.urlLoader;
        }
        return AbstractDataProvider.class.getClassLoader();
    }
}

