/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.report;

import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.report.AbstractDataProvider;
import java.util.Vector;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EfcBeanQueryExecuter
extends AbstractDataProvider
implements JRQueryExecuter {
    private static Logger logger = LoggerFactory.getLogger(EfcBeanQueryExecuter.class);
    private BusinessObject bo;
    private Class<?> boClass;

    public EfcBeanQueryExecuter(BusinessObject dataSrc, Class<?> boClass) {
        this.bo = dataSrc;
        this.boClass = boClass;
        if (this.boClass == null) {
            this.boClass = this.bo.getClass();
        }
    }

    public boolean cancelQuery() throws JRException {
        return false;
    }

    public void close() {
    }

    public JRDataSource createDatasource() throws JRException {
        JRBeanCollectionDataSource datasrc;
        if (this.bo != null) {
            Vector<BusinessObject> coll = new Vector<BusinessObject>();
            coll.add(this.bo);
            logger.debug("Added: {}", (Object)this.bo.toString());
            datasrc = new JRBeanCollectionDataSource(coll, false);
        } else {
            BusinessObject dummyBo;
            Vector<BusinessObject> coll = new Vector<BusinessObject>();
            try {
                dummyBo = (BusinessObject)this.boClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception ex) {
                throw new JRException("error while creating dummy bo", (Throwable)ex);
            }
            coll.add(dummyBo);
            datasrc = new JRBeanCollectionDataSource(coll, false);
        }
        return datasrc;
    }
}

