/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.report;

import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.report.AbstractDataProvider;
import de.effectivecompany.base.report.EfcBeanQueryExecuter;
import de.effectivecompany.base.report.EfcServiceQueryExecuter;
import de.effectivecompany.base.report.query.BeanQuery;
import de.effectivecompany.base.report.query.QueryReader;
import de.effectivecompany.base.report.query.ServiceQuery;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.fill.JRFillParameter;
import net.sf.jasperreports.engine.query.AbstractQueryExecuterFactory;
import net.sf.jasperreports.engine.query.JREmptyQueryExecuter;
import net.sf.jasperreports.engine.query.JRQueryExecuter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EfcQueryExecuterFactory
extends AbstractQueryExecuterFactory {
    private static Logger logger = LoggerFactory.getLogger(EfcQueryExecuterFactory.class);

    public Object[] getBuiltinParameters() {
        return new Object[]{"EFC_BEAN_DATA", BusinessObject.class, "EFC_USERNAME", String.class, "EFC_PRNSRVNAME", String.class, "EFC_PRNRPT", String.class, "EFC_PRNLANGU", String.class, "EFC_SYSLANGU", String.class, "EFC_SYSPROGCLASS", String.class, "EFC_PRNTYPE", String.class, "EFC_APPSERVER_RESOURCE_URL", String.class};
    }

    public boolean supportsQueryParameterType(String arg0) {
        return true;
    }

    public JRQueryExecuter createQueryExecuter(JasperReportsContext arg0, JRDataset dataset, Map<String, ? extends JRValueParameter> paramMap) throws JRException {
        AbstractDataProvider queryExecuter = null;
        JRQuery query = dataset.getQuery();
        if (query != null) {
            String queryText = query.getText();
            QueryReader reader = new QueryReader(queryText);
            logger.debug("query: {}", (Object)queryText);
            if (queryText.trim().equals("")) {
                return new JREmptyQueryExecuter();
            }
            if (reader.isBeanQuery()) {
                Class<?> boClass;
                if (((JRFillParameter)paramMap.get("EFC_BEAN_DATA")).getValue() == null) {
                    BeanQuery bq = new BeanQuery(queryText.substring(1, queryText.indexOf(" ")), reader.isWithHistory(), reader.isWithBoFields());
                    boClass = bq.getBeanClass();
                } else {
                    boClass = ((BusinessObject)((JRFillParameter)paramMap.get("EFC_BEAN_DATA")).getValue()).getClass();
                }
                BusinessObject bo = (BusinessObject)((JRFillParameter)paramMap.get("EFC_BEAN_DATA")).getValue();
                queryExecuter = new EfcBeanQueryExecuter(bo, boClass);
            } else {
                StringBuilder finalQuery = new StringBuilder();
                ArrayList<Class> paramClasses = new ArrayList<Class>(5);
                ArrayList<Object> paramValues = new ArrayList<Object>(5);
                block6: for (JRQueryChunk chunk : query.getChunks()) {
                    switch (chunk.getType()) {
                        case 4: {
                            continue block6;
                        }
                        case 2: {
                            Class paramClass = null;
                            JRParameter[] params = dataset.getParameters();
                            for (int i = 0; i < params.length; ++i) {
                                if (!params[i].getName().equals(chunk.getText())) continue;
                                paramClass = params[i].getValueClass();
                                break;
                            }
                            Object value = ((JRFillParameter)paramMap.get(chunk.getText())).getValue();
                            paramClasses.add(paramClass);
                            paramValues.add(value);
                            finalQuery.append("?");
                            continue block6;
                        }
                        case 3: {
                            continue block6;
                        }
                        case 1: {
                            finalQuery.append(chunk.getText());
                        }
                    }
                }
                Pattern pattern = Pattern.compile("([a-z]+)\\.([a-z]+)\\.([a-z0-9]+)\\((.*)", 2);
                Matcher matcher = pattern.matcher(finalQuery.toString());
                if (!matcher.matches()) {
                    throw new JRException("invalid expression");
                }
                String module = matcher.group(1);
                String serviceName = matcher.group(2);
                String methodName = matcher.group(3);
                ServiceQuery svcQuery = new ServiceQuery(module, serviceName, methodName, paramClasses.toArray(new Class[0]), reader.isWithHistory(), reader.isWithBoFields());
                queryExecuter = new EfcServiceQueryExecuter(svcQuery, paramValues.toArray());
            }
        } else {
            throw new JRException("no query defined");
        }
        return queryExecuter;
    }
}

