/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.report.query;

import de.effectivecompany.base.report.AbstractDataProvider;
import de.effectivecompany.base.report.query.Query;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.data.AbstractClasspathAwareDataAdapterService;
import net.sf.jasperreports.data.ClasspathAwareDataAdapter;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.util.JRResourcesUtil;

public class BeanQuery
extends AbstractDataProvider
implements Query {
    private String classPath;
    private boolean withHistory = true;
    private boolean withBoFields = false;
    private Class<?> beanClass;
    private String[] namespaces;
    private DataAdapterService con;

    public BeanQuery(String classString) throws JRException {
        this(classString, true, false, null);
    }

    public BeanQuery(String classString, boolean withHistory, boolean withBoFields) throws JRException {
        this(classString, withHistory, withBoFields, null, null);
    }

    public BeanQuery(String classString, boolean withHistory, boolean withBoFields, DataAdapterService con) throws JRException {
        this(classString, withHistory, withBoFields, null, con);
    }

    public BeanQuery(String classString, boolean withHistory, boolean withBoFields, String[] namespaces, DataAdapterService con) throws JRException {
        this.classPath = "de.effectivecompany.app." + classString;
        this.withHistory = withHistory;
        this.withBoFields = withBoFields;
        this.namespaces = namespaces;
        this.con = con;
        try {
            this.beanClass = Class.forName(this.classPath, true, this.getClassLoader(con));
        }
        catch (ClassNotFoundException ex) {
            throw new JRException("invalid bean class: " + this.classPath, (Throwable)ex);
        }
    }

    @Override
    public JRField[] getFields() throws JRException {
        try {
            Object bean = this.beanClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            ArrayList<JRField> finalFields = new ArrayList<JRField>();
            JRField[] fetchedFields = this.getFieldsFromInfo("", "", bean, 0, this.con, this.withHistory, this.withBoFields);
            if (this.namespaces == null) {
                return fetchedFields;
            }
            for (int i = 0; i < fetchedFields.length; ++i) {
                for (int j = 0; j < this.namespaces.length; ++j) {
                    if (!fetchedFields[i].getName().matches(this.namespaces[j])) continue;
                    finalFields.add(fetchedFields[i]);
                }
            }
            return finalFields.toArray(new JRField[0]);
        }
        catch (InstantiationException e) {
            throw new JRException("Error: Problem getting fields: " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new JRException("Error: Problem getting fields: " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new JRException("Error: Problem getting fields: " + e.getMessage(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new JRException("Error: Problem getting fields: " + e.getMessage(), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new JRException("Error: Problem getting fields: " + e.getMessage(), (Throwable)e);
        }
        catch (SecurityException e) {
            throw new JRException("Error: Problem getting fields: " + e.getMessage(), (Throwable)e);
        }
    }

    public boolean isWithHistory() {
        return this.withHistory;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    protected ClassLoader getClassLoader(DataAdapterService con) {
        AbstractClasspathAwareDataAdapterService ad = (AbstractClasspathAwareDataAdapterService)con;
        ClasspathAwareDataAdapter dataAdapter = (ClasspathAwareDataAdapter)ad.getDataAdapter();
        List classpath = dataAdapter.getClasspath();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : classpath) {
            File file = JRResourcesUtil.resolveFile(null, (String)path);
            if (file == null || !file.exists()) continue;
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]));
    }
}

