/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.report.query;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryReader {
    private static Logger logger = LoggerFactory.getLogger(QueryReader.class);
    private String baseQuery;
    private String finalQuery;
    private boolean withHistory = true;
    private boolean withBoFields = false;
    private String[] namespaces;

    public QueryReader(String query) {
        String additionalQuery = "";
        this.baseQuery = query;
        this.finalQuery = query;
        if (this.isBeanQuery()) {
            if (this.finalQuery.contains(" ")) {
                additionalQuery = this.finalQuery.substring(this.finalQuery.indexOf(" "));
                this.finalQuery = this.finalQuery.substring(1, this.finalQuery.indexOf(" "));
            } else {
                this.finalQuery = this.finalQuery.substring(1);
            }
        } else if (this.finalQuery.contains(")")) {
            additionalQuery = this.finalQuery.substring(this.finalQuery.indexOf(")") + 1);
            this.finalQuery = this.finalQuery.substring(0, this.finalQuery.indexOf(")") + 1);
        }
        logger.debug("final query: " + this.finalQuery);
        logger.debug("additional query: {}", (Object)additionalQuery);
        this.withHistory = !additionalQuery.contains(" NOHIST");
        this.withBoFields = additionalQuery.contains(" WITHBO");
        if (additionalQuery.contains(" USING")) {
            String usingBlock = additionalQuery.substring(additionalQuery.indexOf(" USING") + 6);
            Object[] namespaces = usingBlock.split(",");
            for (int i = 0; i < namespaces.length; ++i) {
                namespaces[i] = ((String)namespaces[i]).trim();
                this.namespaces = namespaces;
            }
            logger.warn("using ns: " + Arrays.toString(namespaces));
        }
    }

    public boolean isWithHistory() {
        return this.withHistory;
    }

    public boolean isWithBoFields() {
        return this.withBoFields;
    }

    public boolean isBeanQuery() {
        if (this.baseQuery == null) {
            return false;
        }
        if (this.baseQuery.length() > 1) {
            return this.baseQuery.charAt(0) == '&';
        }
        return false;
    }

    public String getFinalQuery() {
        return this.finalQuery;
    }

    public String[] getNamespaces() {
        return this.namespaces;
    }
}

