/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.report.query;

import de.effectivecompany.base.data.StatisticDataObject;
import de.effectivecompany.base.data.StatisticListEntry;
import de.effectivecompany.base.meta.TypeInfo;
import de.effectivecompany.base.report.AbstractDataProvider;
import de.effectivecompany.base.report.EfcStatisticDataSource;
import de.effectivecompany.base.report.query.Query;
import de.effectivecompany.base.util.SpringHelper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceQuery
extends AbstractDataProvider
implements Query {
    private static Logger logger = LoggerFactory.getLogger(ServiceQuery.class);
    private String module;
    private String serviceClassName;
    private Class<?> serviceClass;
    private String methodName;
    private Class<?>[] paramClasses;
    private boolean withHistory = true;
    private boolean withBoFields = false;
    private String[] namespaces;
    private DataAdapterService con;

    public ServiceQuery(String mod, String svc, String mtd, Class<?>[] paramClasses, boolean withHistory, boolean withBoFields) throws JRException {
        this(mod, svc, mtd, paramClasses, withHistory, withBoFields, null, null);
    }

    public ServiceQuery(String mod, String svc, String mtd, Class<?>[] paramClasses, boolean withHistory, boolean withBoFields, String[] namespaces, DataAdapterService con) throws JRException {
        this.module = mod;
        this.serviceClassName = svc;
        this.methodName = mtd;
        this.paramClasses = paramClasses;
        this.withHistory = withHistory;
        this.withBoFields = withBoFields;
        this.namespaces = namespaces;
        this.con = con;
        String className = this.getFullClasspath();
        try {
            this.serviceClass = Class.forName(className, true, this.getClassLoader(con));
        }
        catch (ClassNotFoundException ex) {
            throw new JRException("service class not found: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public String getFullClasspath() {
        return "de.effectivecompany.app." + this.module + ".service." + this.serviceClassName;
    }

    public Object getService() {
        try {
            Field field = this.serviceClass.getField("BEAN_ID");
            String beanId = (String)field.get(this.serviceClass);
            return SpringHelper.getBean(beanId);
        }
        catch (Exception e) {
            throw new RuntimeException("error while getting service: " + e.getMessage(), e);
        }
    }

    public Method getMethod() {
        Method[] methods;
        for (Method method : methods = this.serviceClass.getMethods()) {
            if (!method.getName().equals(this.methodName) || !Arrays.equals(method.getParameterTypes(), this.paramClasses)) continue;
            return method;
        }
        return null;
    }

    @Override
    public JRField[] getFields() throws JRException {
        JRDesignField field;
        ArrayList<JRDesignField> ret;
        Type type;
        Method method = this.getMethod();
        if (method == null) {
            throw new JRException("failed to get method " + this.methodName + "(" + Arrays.toString(this.paramClasses) + ")");
        }
        Class returnType = method.getReturnType();
        if (returnType == null) {
            throw new JRException("selected method returns nothing");
        }
        if (List.class.isAssignableFrom(returnType) && (type = method.getGenericReturnType()) instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type[] args = pt.getActualTypeArguments();
            if (args != null && args[0] != null) {
                returnType = (Class)args[0];
            } else {
                throw new JRException("Error: Can't get type of the list elements!");
            }
        }
        if (StatisticListEntry.class.isAssignableFrom(returnType)) {
            ret = new ArrayList<JRDesignField>();
            field = new JRDesignField();
            field.setName("group");
            field.setValueClass(StatisticListEntry.S_GROUP_CLASS);
            ret.add(field);
            field = new JRDesignField();
            field.setName("dataset");
            field.setValueClass(StatisticListEntry.S_DATASET_CLASS);
            ret.add(field);
            field = new JRDesignField();
            field.setName("values");
            field.setValueClass(StatisticListEntry.S_VALUE_CLASS);
            ret.add(field);
            return ret.toArray(new JRField[0]);
        }
        if (StatisticDataObject.class.isAssignableFrom(returnType)) {
            ret = new ArrayList();
            field = new JRDesignField();
            field.setName("dataset");
            field.setValueClass(EfcStatisticDataSource.F_DATASET_CLASS);
            ret.add(field);
            field = new JRDesignField();
            field.setName("datasetkey");
            field.setValueClass(EfcStatisticDataSource.F_DATASETKEY_CLASS);
            ret.add(field);
            field = new JRDesignField();
            field.setName("group");
            field.setValueClass(EfcStatisticDataSource.F_GROUP_CLASS);
            ret.add(field);
            field = new JRDesignField();
            field.setName("groupkey");
            field.setValueClass(EfcStatisticDataSource.F_GROUPKEY_CLASS);
            ret.add(field);
            field = new JRDesignField();
            field.setName("value");
            field.setValueClass(EfcStatisticDataSource.F_VALUE_CLASS);
            ret.add(field);
            field = new JRDesignField();
            field.setName("value2");
            field.setValueClass(EfcStatisticDataSource.F_VALUE2_CLASS);
            ret.add(field);
            field = new JRDesignField();
            field.setName("value_min");
            field.setValueClass(EfcStatisticDataSource.F_VALUEMIN_CLASS);
            ret.add(field);
            field = new JRDesignField();
            field.setName("value_max");
            field.setValueClass(EfcStatisticDataSource.F_VALUEMAX_CLASS);
            ret.add(field);
            return ret.toArray(new JRField[0]);
        }
        Object bo = null;
        Class<?> typeInfo = null;
        logger.debug("ReturnType is: " + returnType.getName());
        try {
            bo = returnType.getConstructor(new Class[0]).newInstance(new Object[0]);
            typeInfo = Class.forName(TypeInfo.class.getName(), true, this.getClassLoader(this.con));
        }
        catch (InstantiationException e) {
            logger.debug(returnType.getName());
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            logger.debug(returnType.getName());
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            logger.debug(returnType.getName());
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            logger.debug(returnType.getName());
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            logger.debug(returnType.getName());
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            logger.debug(returnType.getName());
            e.printStackTrace();
        }
        catch (SecurityException e) {
            logger.debug(returnType.getName());
            e.printStackTrace();
        }
        ArrayList<JRField> finalFields = new ArrayList<JRField>();
        JRField[] fetchedFields = this.getFieldsFromInfo("", "", bo, 0, this.withHistory, this.withBoFields, typeInfo, this.con);
        if (this.namespaces == null) {
            return fetchedFields;
        }
        for (int i = 0; i < fetchedFields.length; ++i) {
            for (int j = 0; j < this.namespaces.length; ++j) {
                if (!fetchedFields[i].getName().matches(this.namespaces[j])) continue;
                finalFields.add(fetchedFields[i]);
            }
        }
        return finalFields.toArray(new JRField[0]);
    }
}

