/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.util;

import de.effectivecompany.base.util.ApplicationServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ApplicationServicesLocator {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationServicesLocator.class);
    private static ApplicationServicesLocator INSTANCE;
    private ApplicationServices applicationServices;

    public ApplicationServicesLocator() {
        ApplicationServicesLocator.load(this);
    }

    public ApplicationServicesLocator(ApplicationServices applicationServices) {
        this.setApplicationServices(applicationServices);
        ApplicationServicesLocator.load(this);
    }

    public static ApplicationServicesLocator instance() {
        Assert.state((INSTANCE != null ? 1 : 0) != 0, (String)"The application services locator instance has not yet been initialized.");
        return INSTANCE;
    }

    public static boolean isLoaded() {
        return INSTANCE != null;
    }

    public static void load(ApplicationServicesLocator instance) {
        if (INSTANCE != null) {
            logger.info("Replacing existing ApplicationServicesLocator instance with: " + instance);
        }
        INSTANCE = instance;
    }

    public static ApplicationServices services() {
        return ApplicationServicesLocator.instance().getApplicationServices();
    }

    public void setApplicationServices(ApplicationServices applicationServices) {
        this.applicationServices = applicationServices;
    }

    public ApplicationServices getApplicationServices() {
        return this.applicationServices;
    }
}

