/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.base.util;

import de.effectivecompany.base.efcbl.error.ApplicationException;
import de.effectivecompany.base.efcbl.error.SystemException;
import java.lang.reflect.Field;
import java.sql.Connection;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component(value="applicationContextProvider")
public class SpringHelper
implements ApplicationContextAware,
ApplicationListener<ApplicationEvent> {
    private static boolean isServerContext = false;
    private static boolean contextIsLoaded = false;
    private static boolean isTopSQLSyntax = false;
    private static boolean isLimitSQLSyntax = false;
    private static boolean isSQL2008Syntax = false;
    public static final String BEAN_FACTORY_ID = "de.effectivecompany.internal.beanfactory";
    public static ApplicationException SEARCH_LIMIT_EXCEED_EXCEPTION = null;
    public static int DB_SERACH_LIMIT = -1;
    private static String SQL_SYNTAX = null;

    public static final String getSpringBeanFactoryId() {
        return BEAN_FACTORY_ID;
    }

    public static Object getService(Class<?> clazz) {
        String name = "";
        try {
            Field beanID = clazz.getField("BEAN_ID");
            name = (String)beanID.get(clazz);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return SpringHelper.getBean(name);
    }

    public static void preLoad() {
    }

    public static String getSQLSyntax() {
        if (SQL_SYNTAX == null) {
            DataSource ds = (DataSource)SpringHelper.getBean("dataSource");
            String drvName = "";
            try {
                Connection con = ds.getConnection();
                drvName = con.getMetaData().getDriverName().toLowerCase();
                con.close();
            }
            catch (Exception e) {
                System.err.println("Could not determine jdbc driver name");
            }
            if (drvName.contains("derby")) {
                SQL_SYNTAX = "DERBY";
            } else if (drvName.contains("mysql")) {
                SQL_SYNTAX = "MYSQL";
            } else if (drvName.contains("mariadb")) {
                SQL_SYNTAX = "MARIADB";
            } else if (drvName.contains("microsoft") || drvName.contains("jtds")) {
                SQL_SYNTAX = "MSSQL";
            } else if (drvName.contains("PostgreSQL")) {
                SQL_SYNTAX = "POSTGRE";
            }
        }
        return SQL_SYNTAX == null ? "UNKNONW" : SQL_SYNTAX;
    }

    public static boolean isTopSQLSyntax() {
        return isTopSQLSyntax;
    }

    public static boolean isLimitSQLSyntax() {
        return isLimitSQLSyntax;
    }

    public static boolean isSQL2008Syntax() {
        return isSQL2008Syntax;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        AplicationContextHolder.CONTEXT_PROV.setContext(context);
        isServerContext = true;
    }

    public static ApplicationContext getApplicationContext() {
        return AplicationContextHolder.CONTEXT_PROV.context;
    }

    public boolean isContextLoaded() {
        return contextIsLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getBean(String beanName) {
        if (!contextIsLoaded && isServerContext) {
            throw new SystemException("000", "getBean called before context initialized.");
        }
        if (SpringHelper.getApplicationContext() != null) return SpringHelper.getApplicationContext().getBean(beanName);
        Class<SpringHelper> clazz = SpringHelper.class;
        synchronized (SpringHelper.class) {
            if (SpringHelper.getApplicationContext() != null) return SpringHelper.getApplicationContext().getBean(beanName);
            GenericApplicationContext ctx = new GenericApplicationContext();
            ctx.setClassLoader(SpringHelper.class.getClassLoader());
            XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)ctx);
            reader.setValidationMode(0);
            reader.loadBeanDefinitions((Resource)new ClassPathResource("/de/effectivecompany/app/clientApplicationContext.xml", SpringHelper.class));
            ctx.refresh();
            AplicationContextHolder.CONTEXT_PROV.setContext((ApplicationContext)ctx);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return SpringHelper.getApplicationContext().getBean(beanName);
        }
    }

    public static boolean isServerContext() {
        return isServerContext;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            contextIsLoaded = true;
            try {
                isTopSQLSyntax = SpringHelper.getSQLSyntax().equals("MSSQL");
                isLimitSQLSyntax = SpringHelper.getSQLSyntax().equals("MYSQL") || SpringHelper.getSQLSyntax().equals("POSTGRE") || SpringHelper.getSQLSyntax().equals("MARIADB");
                isSQL2008Syntax = SpringHelper.getSQLSyntax().equals("DERBY");
            }
            catch (Exception e) {
                System.err.println("Could not determine limit syntax.");
            }
            Logger logger = LoggerFactory.getLogger((String)"EFC SpringApplicationContext");
            logger.info("Application context loaded.");
            if (isTopSQLSyntax) {
                logger.info("For SQL limit use TOP syntax");
            }
            if (isLimitSQLSyntax) {
                logger.info("For SQL limit use LIMIT syntax");
            }
            if (isSQL2008Syntax) {
                logger.info("For SQL limit use SQL2008 syntax");
            }
        }
    }

    public static boolean runInEclipse() {
        String inEclipseStr = System.getProperty("runInEclipse");
        return "true".equalsIgnoreCase(inEclipseStr);
    }

    public static String loadLazy() {
        if (SpringHelper.runInEclipse()) {
            return "true";
        }
        return "false";
    }

    private static final class InnerContextResource {
        private ApplicationContext context;

        private InnerContextResource() {
        }

        private void setContext(ApplicationContext context) {
            this.context = context;
        }
    }

    private static class AplicationContextHolder {
        private static final InnerContextResource CONTEXT_PROV = new InnerContextResource();

        private AplicationContextHolder() {
        }
    }
}

