/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.shape;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.shape.mxBasicShape;
import com.mxgraph.shape.mxIMarker;
import com.mxgraph.shape.mxMarkerRegistry;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxLine;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class mxConnectorShape
extends mxBasicShape {
    @Override
    public void paintShape(mxGraphics2DCanvas canvas, mxCellState state) {
        if (state.getAbsolutePointCount() > 1 && this.configureGraphics(canvas, state, false)) {
            ArrayList<mxPoint> pts = new ArrayList<mxPoint>(state.getAbsolutePoints());
            Map<String, Object> style = state.getStyle();
            boolean dashed = mxUtils.isTrue(style, mxConstants.STYLE_DASHED);
            Object dashedValue = style.get(mxConstants.STYLE_DASHED);
            if (dashed) {
                style.remove(mxConstants.STYLE_DASHED);
                canvas.getGraphics().setStroke(canvas.createStroke(style));
            }
            this.translatePoint(pts, 0, this.paintMarker(canvas, state, true));
            this.translatePoint(pts, pts.size() - 1, this.paintMarker(canvas, state, false));
            if (dashed) {
                style.put(mxConstants.STYLE_DASHED, dashedValue);
                canvas.getGraphics().setStroke(canvas.createStroke(style));
            }
            this.paintPolyline(canvas, pts, state.getStyle());
        }
    }

    protected void paintPolyline(mxGraphics2DCanvas canvas, List<mxPoint> points, Map<String, Object> style) {
        boolean rounded = this.isRounded(style) && canvas.getScale() > mxConstants.MIN_SCALE_FOR_ROUNDED_LINES;
        canvas.paintPolyline(points.toArray(new mxPoint[points.size()]), rounded);
    }

    public boolean isRounded(Map<String, Object> style) {
        return mxUtils.isTrue(style, mxConstants.STYLE_ROUNDED, false);
    }

    private void translatePoint(List<mxPoint> points, int index, mxPoint offset) {
        if (offset != null) {
            mxPoint pt = (mxPoint)points.get(index).clone();
            pt.setX(pt.getX() + offset.getX());
            pt.setY(pt.getY() + offset.getY());
            points.set(index, pt);
        }
    }

    public mxPoint paintMarker(mxGraphics2DCanvas canvas, mxCellState state, boolean source) {
        Map<String, Object> style = state.getStyle();
        float strokeWidth = (float)((double)mxUtils.getFloat(style, mxConstants.STYLE_STROKEWIDTH, 1.0f) * canvas.getScale());
        String type = mxUtils.getString(style, source ? mxConstants.STYLE_STARTARROW : mxConstants.STYLE_ENDARROW, "");
        float size = mxUtils.getFloat(style, source ? mxConstants.STYLE_STARTSIZE : mxConstants.STYLE_ENDSIZE, mxConstants.DEFAULT_MARKERSIZE);
        Color color = mxUtils.getColor(style, mxConstants.STYLE_STROKECOLOR);
        canvas.getGraphics().setColor(color);
        double absSize = (double)size * canvas.getScale();
        List<mxPoint> points = state.getAbsolutePoints();
        mxLine markerVector = this.getMarkerVector(points, source, absSize);
        mxPoint p0 = new mxPoint(markerVector.getX(), markerVector.getY());
        mxPoint pe = markerVector.getEndPoint();
        mxPoint offset = null;
        double dx = pe.getX() - p0.getX();
        double dy = pe.getY() - p0.getY();
        double dist = Math.max(1.0, Math.sqrt(dx * dx + dy * dy));
        double unitX = dx / dist;
        double unitY = dy / dist;
        double nx = unitX * absSize;
        double ny = unitY * absSize;
        double strokeX = unitX * (double)strokeWidth;
        double strokeY = unitY * (double)strokeWidth;
        pe = (mxPoint)pe.clone();
        pe.setX(pe.getX() - strokeX / 2.0);
        pe.setY(pe.getY() - strokeY / 2.0);
        mxIMarker marker = mxMarkerRegistry.getMarker(type);
        if (marker != null) {
            offset = marker.paintMarker(canvas, state, type, pe, nx, ny, absSize, source);
            if (offset != null) {
                offset.setX(offset.getX() - strokeX / 2.0);
                offset.setY(offset.getY() - strokeY / 2.0);
            }
        } else {
            nx = dx * (double)strokeWidth / dist;
            ny = dy * (double)strokeWidth / dist;
            offset = new mxPoint(-strokeX / 2.0, -strokeY / 2.0);
        }
        return offset;
    }

    protected mxLine getMarkerVector(List<mxPoint> points, boolean source, double markerSize) {
        int n = points.size();
        mxPoint p0 = source ? points.get(1) : points.get(n - 2);
        mxPoint pe = source ? points.get(0) : points.get(n - 1);
        for (int count = 1; count < n - 1 && Math.round(p0.getX() - pe.getX()) == 0L && Math.round(p0.getY() - pe.getY()) == 0L; ++count) {
            p0 = source ? points.get(1 + count) : points.get(n - 2 - count);
        }
        return new mxLine(p0, pe);
    }
}

