/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.data;

import de.effectivecompany.app.syscl.ClSysPrnSrv;
import de.effectivecompany.base.datatypes.EFCBlob;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.pdmodel.PDDocument;

public class EFCReportContainer {
    private String info;
    private EFCBlob efcBlob;
    private PDDocument pdDocument;
    private ByteBuffer bufferData;
    private Map<String, Object> paramMap = new HashMap<String, Object>();
    private ClSysPrnSrv clSysPrnSrv;
    private Integer copyCount;

    public EFCReportContainer(EFCBlob efcBlob) {
        this.efcBlob = efcBlob;
        this.clSysPrnSrv = new ClSysPrnSrv();
        if (efcBlob.getData() != null) {
            this.bufferData = ByteBuffer.wrap(efcBlob.getData());
        }
        this.generatePDDocument();
    }

    public EFCReportContainer(EFCBlob efcBlob, ClSysPrnSrv clSysPrnSrv) {
        this.efcBlob = efcBlob;
        this.clSysPrnSrv = clSysPrnSrv;
        if (this.clSysPrnSrv != null && this.clSysPrnSrv.getPrncopy() != null) {
            this.copyCount = this.clSysPrnSrv.getPrncopy().getIntValue();
        }
        if (efcBlob.getData() != null) {
            this.bufferData = ByteBuffer.wrap(efcBlob.getData());
        }
        this.generatePDDocument();
    }

    public EFCReportContainer(String info, ClSysPrnSrv clSysPrnSrv, byte[] data, Map<String, Object> paramMap) {
        this.info = info;
        this.clSysPrnSrv = clSysPrnSrv;
        if (this.clSysPrnSrv != null && this.clSysPrnSrv.getPrncopy() != null) {
            this.copyCount = this.clSysPrnSrv.getPrncopy().getIntValue();
        }
        this.efcBlob = new EFCBlob(data);
        this.paramMap = paramMap;
        if (data != null) {
            this.bufferData = ByteBuffer.wrap(data);
        }
        this.generatePDDocument();
    }

    public EFCBlob getEfcBlob() {
        return this.efcBlob;
    }

    public ClSysPrnSrv getClSysPrnSrv() {
        return this.clSysPrnSrv;
    }

    public Object getDocument() {
        if (this.pdDocument != null) {
            return this.pdDocument;
        }
        return null;
    }

    public void closeDocument() {
        try {
            if (this.pdDocument != null) {
                this.pdDocument.close();
                this.pdDocument = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getInfo() {
        return this.info;
    }

    public ByteBuffer getBufferData() {
        return this.bufferData;
    }

    public void generatePDDocument() {
        if (this.clSysPrnSrv != null && this.clSysPrnSrv.getPrntype() != null && this.clSysPrnSrv.getPrntype().equals(30)) {
            this.closeDocument();
        } else {
            try {
                this.pdDocument = Loader.loadPDF((RandomAccessRead)new RandomAccessReadBuffer(this.bufferData.array()));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public String toString() {
        return "EFCReportContainer [bufferData=" + this.bufferData + ", clSysPrnSrv=" + this.clSysPrnSrv + ", data=" + this.efcBlob.toString() + ", efcBlob=" + this.efcBlob + ", info=" + this.info + ", pdDocument=" + this.pdDocument;
    }

    public Integer getCopyCount() {
        return this.copyCount;
    }

    public void setCopyCount(Integer copyCount) {
        this.copyCount = copyCount;
    }

    public Map<String, Object> getParamMap() {
        return this.paramMap;
    }
}

