/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gantt;

import com.google.gson.Gson;
import de.effectivecompany.app.sst.SoGanttData;
import de.effectivecompany.gantt.GanttListener;
import de.effectivecompany.gantt.jsonutil.SoGanttDataAdapter;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.manager.EFCPropertyManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefMenuModel;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefContextMenuHandlerAdapter;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefFocusHandlerAdapter;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefMessageRouterHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GanttView
extends EFCPanel {
    public static Logger logger = LoggerFactory.getLogger(GanttView.class);
    private SoGanttData gantt;
    private CefClient client;
    private CefBrowser browser;
    private List<GanttListener> listeners = new ArrayList<GanttListener>();
    private CefMessageRouter msgRouter;
    private boolean isLoaded = false;
    private JPanel p = new JPanel(new BorderLayout());
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");

    public GanttView() {
        super("");
        this.client = CefApp.getInstance().createClient();
        this.client.addDisplayHandler((CefDisplayHandler)new CefDisplayHandlerAdapter(){

            public boolean onConsoleMessage(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line) {
                switch (level) {
                    case LOGSEVERITY_DEFAULT: 
                    case LOGSEVERITY_INFO: {
                        logger.info(message);
                        break;
                    }
                    case LOGSEVERITY_ERROR: 
                    case LOGSEVERITY_FATAL: {
                        if (message != null && !message.contains("setData is not defined")) {
                            EFCDesktop.reportError(message, null);
                            break;
                        }
                        logger.error(message);
                        break;
                    }
                    case LOGSEVERITY_WARNING: {
                        logger.warn(message);
                    }
                }
                return false;
            }
        });
        this.client.addLifeSpanHandler((CefLifeSpanHandler)new CefLifeSpanHandlerAdapter(){

            public boolean doClose(CefBrowser browser) {
                browser.doClose();
                return false;
            }
        });
        this.msgRouter = CefMessageRouter.create();
        this.msgRouter.addHandler((CefMessageRouterHandler)new CefMessageRouterHandlerAdapter(){

            public boolean onQuery(CefBrowser browser, CefFrame frame, long queryId, String request, boolean persistent, CefQueryCallback callback) {
                if (request != null && !request.isEmpty()) {
                    if (request.equals("complete")) {
                        GanttView.this.isLoaded = true;
                        GanttView.this.setLocked(false);
                        return true;
                    }
                    StringTokenizer to = new StringTokenizer(request, ";");
                    if (to.countTokens() == 2) {
                        for (GanttListener hl : GanttView.this.listeners) {
                            hl.onSelection(to.nextToken(), to.nextToken());
                        }
                        return true;
                    }
                    if (to.countTokens() == 8) {
                        if (to.nextToken().equals("dragEnd")) {
                            for (GanttListener hl : GanttView.this.listeners) {
                                try {
                                    String id = to.nextToken();
                                    String resource = to.nextToken();
                                    Date newStart = sdf.parse(to.nextToken());
                                    Date newEnd = sdf.parse(to.nextToken());
                                    Date min = sdfDate.parse(to.nextToken());
                                    Date max = sdfDate.parse(to.nextToken());
                                    HashMap<String, List<Date>> liveMovedElements = new HashMap<String, List<Date>>();
                                    Map tmpMap = (Map)new Gson().fromJson(to.nextToken(), Map.class);
                                    tmpMap.forEach((key, value) -> {
                                        ArrayList<Date> tmpList = new ArrayList<Date>();
                                        try {
                                            tmpList.add(sdf.parse((String)value.get(0)));
                                            tmpList.add(sdf.parse((String)value.get(1)));
                                        }
                                        catch (ParseException e) {
                                            logger.error("dragEnd Fehler: ", (Throwable)e);
                                        }
                                        liveMovedElements.put((String)key, (List<Date>)tmpList);
                                    });
                                    hl.onDragEnd(id, resource, newStart, newEnd, min, max, liveMovedElements);
                                }
                                catch (ParseException e) {
                                    logger.error("dragEnd Fehler: ", (Throwable)e);
                                }
                            }
                        }
                        return true;
                    }
                }
                return super.onQuery(browser, frame, queryId, request, persistent, callback);
            }
        }, true);
        this.client.addMessageRouter(this.msgRouter);
        this.client.addFocusHandler((CefFocusHandler)new CefFocusHandlerAdapter(){

            public boolean onSetFocus(CefBrowser arg0, CefFocusHandler.FocusSource arg1) {
                return true;
            }
        });
        this.client.addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                if (browser.getURL() != null && !browser.getURL().isEmpty() && !browser.getURL().equals("about:blank")) {
                    GanttView.this.fillGantt();
                }
                GanttView.this.setLocked(false);
            }

            public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                super.onLoadError(browser, frame, errorCode, errorText, failedUrl);
                GanttView.this.setLocked(false);
                SwingUtilities.windowForComponent(browser.getUIComponent()).validate();
            }
        });
        this.browser = this.client.createBrowser("about:blank", true, false);
        this.client.addContextMenuHandler((CefContextMenuHandler)new CefContextMenuHandlerAdapter(){

            public void onBeforeContextMenu(CefBrowser browser, CefFrame frame, CefContextMenuParams params, CefMenuModel model) {
                model.clear();
            }
        });
        this.browser.createImmediately();
        this.p.add(this.browser.getUIComponent(), "Center");
        this.add((Component)this.p, "Center");
    }

    public void addGanttLIstener(GanttListener listener) {
        this.listeners.add(listener);
    }

    public void setLocked(boolean isLocked) {
        if (isLocked) {
            this.setCursor(new Cursor(3));
        } else {
            this.setCursor(new Cursor(0));
        }
        this.browser.getUIComponent().setEnabled(!isLocked);
    }

    private void fillGantt() {
        if (this.browser != null && this.gantt != null) {
            this.browser.executeJavaScript("setData(" + SoGanttDataAdapter.getAsJsonObject(this.gantt).toString() + ")", "", 0);
        }
    }

    private String getGanttURL() {
        return EFCPropertyManager.getClientProperties().getProperty("efcserver.protocol") + "://" + EFCPropertyManager.getClientProperties().getProperty("efcserver.serverName") + ":" + EFCPropertyManager.getClientProperties().getProperty("efcserver.httpPort") + EFCPropertyManager.getClientProperties().getProperty("efcserver.contextPath") + "/resources/gantt.html";
    }

    public void setData(SoGanttData gantt) {
        this.gantt = gantt;
        if (this.isLoaded) {
            this.fillGantt();
        } else {
            this.browser.loadURL(this.getGanttURL());
        }
    }

    @Override
    public void terminate() {
        this.removeAll();
        this.client.removeMessageRouter(this.msgRouter);
        this.client.dispose();
    }
}

