/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.StatusPrinter;
import com.jgoodies.forms.util.DefaultUnitConverter;
import de.effectivecompany.app.app.DcLocale;
import de.effectivecompany.app.app.service.SvSysApp;
import de.effectivecompany.app.app.service.SvSysUser;
import de.effectivecompany.base.datatypes.EFCCode;
import de.effectivecompany.base.i18n.MergeResourceBundle;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.dialog.EFCLoginDialog;
import de.effectivecompany.gui.components.root.EFCMainFrame;
import de.effectivecompany.gui.events.TAPIEvent;
import de.effectivecompany.gui.events.util.EFCEventBus;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.manager.EFCPropertyManager;
import de.effectivecompany.gui.util.AuthResult;
import de.effectivecompany.gui.util.EFCThreadUtil;
import de.effectivecompany.tapimon.TAPIEventData;
import de.effectivecompany.tapimon.TAPIEventType;
import de.effectivecompany.tapimon.TAPIMon;
import de.effectivecompany.websocket.EFCStompSessionHandler;
import java.io.IOException;
import java.io.StringReader;
import java.net.SocketException;
import java.net.URI;
import java.util.Locale;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javafx.application.Application;
import javafx.application.Platform;
import javax.swing.JFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandler;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.socket.WebSocketHttpHeaders;
import org.springframework.web.socket.client.WebSocketClient;
import org.springframework.web.socket.client.standard.StandardWebSocketClient;
import org.springframework.web.socket.messaging.WebSocketStompClient;
import org.xnap.commons.i18n.I18n;

public class EFC {
    private static Logger logger = LoggerFactory.getLogger(EFC.class);
    private static final EFC instance;
    private JFrame mainframe;
    private AuthenticationManager authenticationManager;
    private ResourceBundle commonProps;
    private ExecutorService executorService = Executors.newFixedThreadPool(1);
    final String subscriptionId = UUID.randomUUID().toString();
    private String user;
    private String password;
    private boolean reconnectMsgBus = true;
    private CountDownLatch latch;
    public static TAPIMon.LogCallback cb;
    public static TAPIMon.TAPIEventCallback ecb;

    public JFrame getMainFrame() {
        return this.mainframe;
    }

    private EFC() {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        StatusPrinter.print((Context)lc);
    }

    public static EFC getInstance() {
        return instance;
    }

    public static EFC getInstance(String user, String password) {
        EFC.instance.user = user;
        EFC.instance.password = password;
        return instance;
    }

    public void run(CountDownLatch appCanTerminate) {
        this.authenticationManager = (AuthenticationManager)EFCThreadUtil.fatCallable(() -> {
            SecurityContextHolder.setStrategyName((String)"MODE_GLOBAL");
            this.commonProps = this.createMessages();
            AuthenticationManager manager = (AuthenticationManager)SpringHelper.getBean((String)"authenticationManager");
            return manager;
        });
        this.firstDialogOrSecMngFinished(appCanTerminate);
    }

    private synchronized void firstDialogOrSecMngFinished(CountDownLatch appCanTerminate) {
        if (this.authenticationManager != null) {
            appCanTerminate.countDown();
            Platform.setImplicitExit((boolean)false);
            Application.setUserAgentStylesheet((String)ClassLoader.getSystemResource("css/EFCStyleStandard.css").toExternalForm());
            EFCThreadUtil.doLaterFAT(() -> EFCLoginDialog.getAuthentication(this.user, this.password));
        }
    }

    public void startEFC() {
        DefaultUnitConverter.getInstance().setDefaultDialogFont(EFCLookAndFeelManager.FONT_EFC_STANDARD);
        EFCLookAndFeelManager.getInstance().initCustomClientProps();
        try {
            logger.info("java.library.path:" + System.getProperty("java.library.path"));
            this.mainframe = EFCMainFrame.getInstance();
            if (this.mainframe != null) {
                this.mainframe.pack();
                this.mainframe.setExtendedState(6);
                this.mainframe.setVisible(true);
                this.mainframe.toFront();
                this.connectMsgBus();
                this.initializeTAPIMon();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void initializeTAPIMon() {
        if (com.sun.jna.Platform.isWindows()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        logger.info("Initializing TAPIMon...");
                        TAPIMon.INSTANCE.initLib();
                        TAPIMon.INSTANCE.registerLogCallback(cb);
                        TAPIMon.INSTANCE.registerEventCallback(ecb);
                        TAPIMon.INSTANCE.startMonitor();
                    }
                    catch (Exception e) {
                        logger.error("TAPIMon initialization failed: {}", (Object)e.getMessage());
                        e.printStackTrace();
                    }
                }
            }).start();
        }
    }

    public void connectMsgBus() {
        this.latch = new CountDownLatch(1);
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                String host = EFCPropertyManager.getClientProperties().getProperty("efcserver.serverName");
                URI uri = URI.create("ws://" + host + ":61613");
                try {
                    StandardWebSocketClient webSocketClient = new StandardWebSocketClient();
                    ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
                    WebSocketStompClient stompClient = new WebSocketStompClient((WebSocketClient)webSocketClient);
                    stompClient.setMessageConverter((MessageConverter)new StringMessageConverter());
                    taskScheduler.afterPropertiesSet();
                    long[] heartbeat = new long[]{2000L, 10000L};
                    stompClient.setDefaultHeartbeat(heartbeat);
                    stompClient.setTaskScheduler((TaskScheduler)taskScheduler);
                    EFCStompSessionHandler handler = new EFCStompSessionHandler(EFC.this.latch);
                    StompSession session = (StompSession)stompClient.connect(uri.toString(), new WebSocketHttpHeaders(), new StompHeaders(), (StompSessionHandler)handler, new Object[0]).get(30L, TimeUnit.SECONDS);
                    EFC.this.latch.await();
                    handler.unsubscribe();
                    if (session.isConnected()) {
                        session.disconnect();
                    }
                }
                catch (Throwable t) {
                    logger.error("Message bus problem:", t);
                    t.printStackTrace(System.err);
                }
                if (EFC.this.reconnectMsgBus) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        logger.error("Problems waiting for re-connect", (Throwable)e);
                    }
                    logger.info("Reconnecting to message bus...");
                    EFC.this.executorService.execute(new Runnable(){

                        @Override
                        public void run() {
                            EFC.this.connectMsgBus();
                        }
                    });
                }
            }
        });
    }

    public void doLogout() {
        SecurityContextHolder.clearContext();
    }

    public AuthResult doLogin(Authentication auth) {
        Authentication result = null;
        String lastError = "";
        try {
            SecurityContext context = SecurityContextHolder.createEmptyContext();
            context.setAuthentication(auth);
            SecurityContextHolder.setContext((SecurityContext)context);
            result = this.authenticationManager.authenticate(auth);
            this.createCustomMessages();
        }
        catch (AuthenticationException ex) {
            result = null;
            lastError = ex.getMessage();
            logger.error("AuthenticationException during login...", (Throwable)ex);
        }
        catch (RemoteAccessException ex) {
            logger.error("RemoteAccessException during login...", (Throwable)ex);
            if (ex.getCause() instanceof SocketException) {
                lastError = ex.getCause().getMessage();
            }
            if (ex.getCause() instanceof IOException) {
                result = null;
                lastError = ex.getCause().getMessage();
            }
            throw ex;
        }
        if (result != null && !result.isAuthenticated()) {
            result = null;
        }
        return new AuthResult(result, lastError);
    }

    private ResourceBundle createMessages() {
        ResourceBundle commonProps = this.createResourceBundle("i18n/messages");
        Translator.setI18n((I18n)new I18n(commonProps));
        return commonProps;
    }

    private void createCustomMessages() {
        ResourceBundle customProps = this.createCustomResourceBundle();
        if (customProps != null) {
            MergeResourceBundle bundle = new MergeResourceBundle(this.commonProps, customProps);
            Translator.setI18n((I18n)new I18n((ResourceBundle)bundle));
        }
    }

    private ResourceBundle createCustomResourceBundle() {
        PropertyResourceBundle bundle = null;
        SvSysUser svSysUsr = (SvSysUser)SpringHelper.getService(SvSysUser.class);
        SvSysApp svSysApp = (SvSysApp)SpringHelper.getService(SvSysApp.class);
        Locale usrLocale = null;
        DcLocale dcLocale = new DcLocale();
        try {
            dcLocale = svSysUsr.getUsrLocale();
            if (dcLocale.getLocalelangu().getData() != null && !dcLocale.getLocalelangu().getData().isEmpty()) {
                usrLocale = dcLocale.getLocalecountry().getData() != null && !dcLocale.getLocalecountry().getData().isEmpty() ? new Locale(dcLocale.getLocalelangu().getData(), dcLocale.getLocalecountry().getData()) : new Locale(dcLocale.getLocalelangu().getData());
            }
        }
        catch (Throwable th) {
            logger.error("", th);
        }
        if (usrLocale == null) {
            usrLocale = Locale.getDefault();
        }
        if (usrLocale != Locale.getDefault()) {
            this.commonProps = ResourceBundle.getBundle("i18n/messages", usrLocale, this.getClass().getClassLoader());
            Translator.setI18n((I18n)new I18n(this.commonProps));
        }
        EFCCode messageCode = null;
        String messages = "";
        try {
            messageCode = svSysApp.getResourceBundle(dcLocale.getLocalelangu(), dcLocale.getLocalecountry());
            messages = messageCode.toString();
        }
        catch (Throwable th) {
            logger.error("", th);
        }
        if (!messages.equals("")) {
            try {
                bundle = new PropertyResourceBundle(new StringReader(messages));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bundle;
    }

    private ResourceBundle createResourceBundle(String bundleName) {
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName);
        return bundle;
    }

    public String createPropertyString() {
        Properties props = EFCPropertyManager.getClientProperties();
        if (props == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Server: ");
        sb.append(props.getProperty("efcserver.serverName", "unknown server"));
        return sb.toString();
    }

    public void shutdown() {
        this.shutdownSysMsgBus();
        this.shutdownTAPIMon();
    }

    private void shutdownTAPIMon() {
        if (com.sun.jna.Platform.isWindows()) {
            try {
                TAPIMon.INSTANCE.closeLib();
            }
            catch (Throwable t) {
                logger.info("Error during TAPI shutdown:", t);
            }
        }
    }

    private void shutdownSysMsgBus() {
        this.reconnectMsgBus = false;
        this.latch.countDown();
    }

    static {
        cb = new TAPIMon.LogCallback(){

            @Override
            public void log(String msg) {
                logger.info(msg);
            }
        };
        ecb = new TAPIMon.TAPIEventCallback(){

            @Override
            public void event(TAPIMon.TAPIData data) {
                if (data != null && data.number != null) {
                    String phoneNumber = new String(data.number).replace(" ", "");
                    phoneNumber = phoneNumber.replace("(", "");
                    phoneNumber = phoneNumber.replace(")", "");
                    logger.info("TAPIEvent arrived: INCOMING_CALL, id: {}", (Object)phoneNumber);
                    TAPIEventData d = new TAPIEventData();
                    d.setType(TAPIEventType.INCOMING_CALL);
                    d.setIncommingID(phoneNumber);
                    TAPIEvent evt = new TAPIEvent(d);
                    EFCEventBus.getInstance().post(evt);
                }
            }
        };
        instance = new EFC();
    }
}

