/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.actions;

import de.effectivecompany.app.pjm.BoPjmDoc;
import de.effectivecompany.app.syswfl.BoWflProc;
import de.effectivecompany.app.syswfl.BoWflTask;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.msg.MsgType;
import de.effectivecompany.gui.actions.EFCAbstractAction;
import de.effectivecompany.gui.components.EFCController;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.fx.wfl.service.EFCStartProcessService;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.components.root.EFCMainFrame;
import de.effectivecompany.gui.components.swing.EFCMessageListDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javafx.application.Platform;
import javafx.concurrent.Task;

public class EFCActionWflStartProcess
extends EFCAbstractAction {
    private static final long serialVersionUID = -795069753634735602L;
    public static final String IDENT = "wfl_startprocess";
    private BoPjmDoc project;
    private EFCController controller;

    public EFCActionWflStartProcess(BoPjmDoc project, EFCController controller) {
        this.putValue("Name", Translator.tr((String)"ACTION_WFL_START_PROC"));
        this.putValue("ShortDescription", Translator.tr((String)"ACTION_WFL_START_PROC_DESC"));
        this.project = project;
        this.controller = controller;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.processAction(IDENT, null);
        if (Platform.isFxApplicationThread()) {
            this.execute();
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    EFCActionWflStartProcess.this.execute();
                }
            });
        }
    }

    private void execute() {
        EFCMap variables = new EFCMap();
        if (this.project.getPjmdocnum() != null && this.project.getPjmdocnum().getData() != null && !this.project.getPjmdocnum().getData().isEmpty()) {
            variables.put((Object)new EFCString("var_pjmdocnum"), (Object)this.project.getPjmdocnum());
        }
        if (this.project.getPjmdockey() != null && this.project.getPjmdockey().getPjmdockey().getData() != null && !this.project.getPjmdockey().getPjmdockey().getData().isEmpty()) {
            variables.put((Object)new EFCString("var_pjmdockey"), (Object)this.project.getPjmdockey().getPjmdockey());
        }
        EFCStartProcessService processService = new EFCStartProcessService();
        Task<BoWflProc> task = processService.createTask(this.project.getPjmdockey().getActivitiprocdefid().getActivitiprocdefid().getData(), (EFCMap<EFCString, EFCString>)variables);
        task.setOnRunning(handler -> this.controller.lockControl());
        task.setOnSucceeded(handler -> {
            this.controller.unlockControl();
            System.out.println(handler.getSource().valueProperty().getValue().toString());
            if (handler.getSource().valueProperty().getValue() instanceof BoWflTask) {
                BoWflTask bo = (BoWflTask)handler.getSource().valueProperty().getValue();
                if (bo.getCompleteMsgList().getMaxSeverity() == MsgType.ERROR) {
                    EFCMessageListDialog messageDlg = new EFCMessageListDialog((Frame)EFCMainFrame.getInstance(), true);
                    messageDlg.show(bo.getCompleteMsgList().getMsgList());
                } else {
                    EFCDesktop.getInstance();
                    EFCDesktop.showInfoDlg(Translator.tr((String)"WFL_PROC_INFO_STARTED"));
                }
            } else {
                EFCDesktop.getInstance();
                EFCDesktop.showErrorDlg("WFL_PROC_ERROR_STARTED");
            }
        });
        task.setOnFailed(handler -> {
            this.controller.unlockControl();
            EFCDesktop.reportError(handler.getSource().getException());
        });
        WflController.getInstance().executeTask(task);
    }

    @Override
    public String getIdent() {
        return IDENT;
    }
}

