/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components;

import de.effectivecompany.app.scb.BoScbBas;
import de.effectivecompany.app.sys.MdSysXml;
import de.effectivecompany.app.sys.SysObjRef;
import de.effectivecompany.app.sys.SysParam;
import de.effectivecompany.app.syscl.ClSysPrnGrp;
import de.effectivecompany.app.syscl.ClSysPrnGrpDet;
import de.effectivecompany.app.syswfl.BoWflTask;
import de.effectivecompany.base.datatypes.EFCBlob;
import de.effectivecompany.base.datatypes.EFCBoolean;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.efcbl.error.ApplicationException;
import de.effectivecompany.base.gui.data.DefaultSearchService;
import de.effectivecompany.base.gui.data.SearchService;
import de.effectivecompany.base.gui.filter.Filter;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.gui.interfaces.GuiService;
import de.effectivecompany.base.gui.interfaces.ScrollList;
import de.effectivecompany.base.gui.key.Key;
import de.effectivecompany.base.gui.scroll.ScrollListData;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.msg.Msg;
import de.effectivecompany.base.msg.MsgList;
import de.effectivecompany.base.msg.MsgType;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.data.DummyGuiService;
import de.effectivecompany.data.EFCFrDlgResultObject;
import de.effectivecompany.data.EFCReportBatchListEntry;
import de.effectivecompany.data.EFCReportContainer;
import de.effectivecompany.data.EFCReportSelectionListEntry;
import de.effectivecompany.gui.actions.EFCAbstractAction;
import de.effectivecompany.gui.actions.EFCActionWindowLock;
import de.effectivecompany.gui.actions.EFCAdditionalActionInfo;
import de.effectivecompany.gui.components.EFCMainMenu;
import de.effectivecompany.gui.components.EFCMainSyncSwingWorker;
import de.effectivecompany.gui.components.EFCPrintPreviewDialog;
import de.effectivecompany.gui.components.EFCStatusBar;
import de.effectivecompany.gui.components.EFCToolBar;
import de.effectivecompany.gui.components.editor.EFCAbstractEditor;
import de.effectivecompany.gui.components.editor.EFCAbstractPrimaryEditor;
import de.effectivecompany.gui.components.editor.EFCAbstractTextEditor;
import de.effectivecompany.gui.components.editor.EFCBooleanEditor;
import de.effectivecompany.gui.components.editor.EFCLabel;
import de.effectivecompany.gui.components.editor.EFCObjectListEditor;
import de.effectivecompany.gui.components.editor.EFCTextHtmlEditor;
import de.effectivecompany.gui.components.frame.EFCFrameInfo;
import de.effectivecompany.gui.components.frame.EFCFrameLayoutInfo;
import de.effectivecompany.gui.components.frame.EFCHelp;
import de.effectivecompany.gui.components.frame.EFCInternalFrameView;
import de.effectivecompany.gui.components.frame.EFCPDFViewer;
import de.effectivecompany.gui.components.frame.EFCPrintSelectionDialog;
import de.effectivecompany.gui.components.frame.EFCTableExportDialog;
import de.effectivecompany.gui.components.frame.searchframe.EFCSearchFrame;
import de.effectivecompany.gui.components.panel.EFCBOTablePanel;
import de.effectivecompany.gui.components.panel.EFCGraphPanel;
import de.effectivecompany.gui.components.panel.EFCListTablePanel;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.components.panel.EFCSubPanel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.components.root.EFCMainFrame;
import de.effectivecompany.gui.components.swing.EFCMessageListDialog;
import de.effectivecompany.gui.components.swing.EFCProgressDlg;
import de.effectivecompany.gui.components.swing.model.explorer.ETreeElement;
import de.effectivecompany.gui.components.table.EFCColumnResizer;
import de.effectivecompany.gui.constants.EFCAction;
import de.effectivecompany.gui.constants.EFCActionAcceleratorKey;
import de.effectivecompany.gui.constants.EFCPredefinedMenu;
import de.effectivecompany.gui.constants.EFCPredefinedToolBar;
import de.effectivecompany.gui.data.BusinessObjectModel;
import de.effectivecompany.gui.enums.EFCObjectState;
import de.effectivecompany.gui.enums.EFCPrintBatchMode;
import de.effectivecompany.gui.enums.EFCScrollMissMode;
import de.effectivecompany.gui.enums.EFCWindowMode;
import de.effectivecompany.gui.events.util.InputFieldValueSyncronizer;
import de.effectivecompany.gui.exceptions.ActionNotAllowedException;
import de.effectivecompany.gui.exceptions.InvalidTableSelectionException;
import de.effectivecompany.gui.factory.EFCPanelSingleton;
import de.effectivecompany.gui.factory.EFCPrintFactory;
import de.effectivecompany.gui.factory.EFCReportSingleton;
import de.effectivecompany.gui.handlers.GenericEventHandler;
import de.effectivecompany.gui.interfaces.element.EditorComponent;
import de.effectivecompany.gui.interfaces.frame.ActionHandlerFrame;
import de.effectivecompany.gui.interfaces.frame.BOFrame;
import de.effectivecompany.gui.interfaces.frame.EFCFrame;
import de.effectivecompany.gui.interfaces.handler.ActionHandler;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import de.effectivecompany.gui.interfaces.panel.TablePanel;
import de.effectivecompany.gui.manager.EFCBaseViewManager;
import de.effectivecompany.gui.manager.EFCDataChangeManager;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.EFCClosure;
import de.effectivecompany.gui.util.EFCThreadUtil;
import de.effectivecompany.gui.util.EUFieldStyler;
import de.effectivecompany.msg.Msg1033;
import de.effectivecompany.report.jasper.ReportInfoVerifier;
import de.effectivecompany.thread.EFCPrintBatchTask;
import de.effectivecompany.thread.EFCPrintTask;
import groovy.lang.Closure;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.control.Label;
import javafx.scene.paint.Paint;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.MediaTray;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EFCController
implements ActionHandlerFrame,
ActionHandler,
EFCFrame,
BOFrame,
ReportInfoVerifier {
    public static Logger logger = LoggerFactory.getLogger(EFCController.class);
    private EnumSet<EFCAction> menu;
    protected EFCInternalFrameView view;
    protected EFCController parentController;
    protected String title;
    private boolean handlingEvents = true;
    protected EFCPanel panel = new EFCPanel("");
    protected List<EFCController> childs = new LinkedList<EFCController>();
    protected List<EFCSearchFrame> searchFrames = new LinkedList<EFCSearchFrame>();
    protected EFCController dialogFrame;
    protected static String NS_BASE = "de.effectivecompany.client";
    protected GuiService guiService;
    private BusinessObjectModel businessObjectModel = new BusinessObjectModel();
    protected String printListId = "";
    private boolean dialogLock;
    protected boolean isWindowPositionLocked = false;
    protected Integer showInfoForSeconds = null;
    protected AtomicInteger newTableIndex = new AtomicInteger(-1);
    protected ScrollList baseScrollList;
    private DataChangeManager dataChangeManager = new EFCDataChangeManager();
    protected EFCBaseViewManager viewManager;
    private String orderField;
    private String scrollValue;
    private String newOrderField;
    private String orderColName;
    protected Filter baseFilter = new Filter();
    protected Filter scrollFilter = new Filter();
    protected Map<String, Object> launchParam;
    protected HashMap<String, Object> paramList = new HashMap();
    protected SysParam sysParam = new SysParam();
    protected SysObjRef sysObjRef = new SysObjRef();
    protected BoWflTask wflTaskObjRef;
    protected String layoutFile = "";
    protected Class<?> businessObjectClass;
    protected SearchService searchService = new DefaultSearchService();
    protected EFCProgressDlg progressDialog = new EFCProgressDlg(EFCMainFrame.getInstance());
    private EFCScrollMissMode scrollMissMode = EFCScrollMissMode.ASK;
    private EFCWindowMode windowMode;
    private List<EFCWindowMode> disabledWindowModes = new ArrayList<EFCWindowMode>(4);
    private GenericEventHandler mainEventHandler;
    private EFCFrameInfo infoBox;
    protected EFCReportSelectionListEntry defaultReport;
    protected List<EFCReportSelectionListEntry> availableDocReports;
    protected List<EFCReportSelectionListEntry> availableListReports;
    protected List<EFCReportSelectionListEntry> availableBatchReports;
    protected List<EFCReportSelectionListEntry> availableLabelReports;
    private EFCObjectState objectState;
    protected List<String> handleChangedFields = new ArrayList<String>();
    private boolean controlLocked;
    private EFCPrintSelectionDialog printSelectionDialog;
    protected EFCThreadUtil saveThreadUtil;
    protected EFCThreadUtil activeThreadUtil;
    private EFCMap<String, Boolean> menuBlackListMap;
    protected Boolean checkLastInputValueChanged = false;

    public EFCController(String title, EnumSet<EFCAction> menu, EFCPredefinedMenu efcPredefinedMenu, EFCPredefinedToolBar efcPredefinedToolBar, Dimension dimension) {
        this(null, title, menu, efcPredefinedMenu, efcPredefinedToolBar, dimension, null, null);
    }

    public EFCController(String title, EnumSet<EFCAction> menu, EFCPredefinedMenu efcPredefinedMenu, EFCPredefinedToolBar efcPredefinedToolBar, Dimension dimension, String mainService) {
        this(null, title, menu, efcPredefinedMenu, efcPredefinedToolBar, dimension, mainService, null);
    }

    public EFCController(EFCController parent, String title, EnumSet<EFCAction> menu, EFCPredefinedMenu efcPredefinedMenu, EFCPredefinedToolBar efcPredefinedToolBar, Dimension dimension) {
        this(parent, title, menu, efcPredefinedMenu, efcPredefinedToolBar, dimension, null, null);
    }

    public EFCController(EFCController parent, String title, EnumSet<EFCAction> menu, EFCPredefinedMenu efcPredefinedMenu, EFCPredefinedToolBar efcPredefinedToolBar, Dimension dimension, String mainService) {
        this(parent, title, menu, efcPredefinedMenu, efcPredefinedToolBar, dimension, mainService, null);
    }

    public EFCController(EFCController parent, String title, EnumSet<EFCAction> menu, EFCPredefinedMenu efcPredefinedMenu, EFCPredefinedToolBar efcPredefinedToolBar, Dimension dimension, String mainService, Map<String, Object> param) {
        this(parent, title, menu, efcPredefinedMenu, efcPredefinedToolBar, dimension, mainService, param, null);
    }

    public EFCController(EFCController parent, String title, EnumSet<EFCAction> menu, EFCPredefinedMenu efcPredefinedMenu, EFCPredefinedToolBar efcPredefinedToolBar, Dimension dimension, String mainService, Map<String, Object> param, String[] buttonNames) {
        this(parent, title, menu, efcPredefinedMenu, efcPredefinedToolBar, dimension, mainService, param, null, buttonNames);
    }

    public EFCController(EFCController parent, String title, EnumSet<EFCAction> menu, EFCPredefinedMenu efcPredefinedMenu, EFCPredefinedToolBar efcPredefinedToolBar, Dimension dimension, String mainService, Map<String, Object> param, BusinessObject bo, String[] buttonNames) {
        this.parentController = parent;
        this.menu = menu;
        this.title = title;
        this.view = new EFCInternalFrameView(title, dimension, this);
        EFCDesktop.getInstance().add(this.view);
        this.view.setFrameIcon(EFCLookAndFeelManager.ICON_APP_WUG);
        EFCMainMenu mainMenu = null;
        if (menu != EFCAction.M_NO_MENU) {
            mainMenu = efcPredefinedMenu != null && efcPredefinedToolBar != null ? new EFCMainMenu(efcPredefinedMenu, efcPredefinedToolBar) : new EFCMainMenu();
            this.view.setEFCMainMenu(mainMenu);
            this.view.setEFCToolBar(mainMenu.getToolBar());
        }
        this.viewManager = new EFCBaseViewManager(mainMenu, this);
        if (buttonNames != null) {
            this.view.addButtonBar(buttonNames);
            this.view.setDialogView(true);
            this.parentController.dialogFrame = this;
            this.setBusObj(bo);
        } else {
            this.view.setEFCStatusBar();
            if (this.parentController != null) {
                this.parentController.addChild(this);
            }
        }
        this.initProgressDialog();
        this.launchParam = param == null ? new HashMap() : param;
        this.setGuiService(mainService);
        this.progressDialog.setBarValue(20);
        this.mainEventHandler = new GenericEventHandler(this);
        this.initDataChangeManager();
        this.businessObjectModel.addDataSetListener(new InputFieldValueSyncronizer(this.businessObjectModel, this.viewManager));
        this.progressDialog.setBarValue(30);
        if (this.launchParam.containsKey("KEY") && this.launchParam.get("KEY") instanceof Key) {
            this.sync((Key)this.launchParam.get("KEY"), this.paramList);
        }
        if (this.launchParam.containsKey("SHOWINFOFORSECONDS") && this.launchParam.get("SHOWINFOFORSECONDS") instanceof String) {
            try {
                this.showInfoForSeconds = Integer.parseInt((String)this.launchParam.get("SHOWINFOFORSECONDS"));
            }
            catch (NumberFormatException nex) {
                this.showInfoForSeconds = null;
            }
        }
    }

    private void initDataChangeManager() {
        this.dataChangeManager.addFocusChangeListener(this.mainEventHandler);
        this.dataChangeManager.addSelectionContextChangeListener(this.mainEventHandler);
        this.dataChangeManager.addUserInputListener(this.mainEventHandler);
        this.dataChangeManager.addUserInteractionListener(this.mainEventHandler);
        this.dataChangeManager.addValueChangeListener(this.mainEventHandler);
        this.dataChangeManager.addBusinessTableInteractionListener(this.mainEventHandler);
        this.dataChangeManager.addListTableDataListener(this.mainEventHandler);
        this.dataChangeManager.addDragEventListener(this.mainEventHandler);
    }

    private void terminateDataChangeManager() {
        this.dataChangeManager.removeFocusChangeListener(this.mainEventHandler);
        this.dataChangeManager.removeSelectionContextChangeListener(this.mainEventHandler);
        this.dataChangeManager.removeUserInputListener(this.mainEventHandler);
        this.dataChangeManager.removeUserInteractionListener(this.mainEventHandler);
        this.dataChangeManager.removeValueChangeListener(this.mainEventHandler);
        this.dataChangeManager.removeBusinessTableInteractionListener(this.mainEventHandler);
        this.dataChangeManager.removeListTableDataListener(this.mainEventHandler);
        this.dataChangeManager.removeDragEventListener(this.mainEventHandler);
        this.dataChangeManager = null;
    }

    private void initProgressDialog() {
        this.progressDialog.setVisible(true);
        this.progressDialog.setTitle(Translator.tr((String)"MSG_FRAME_LAUNCH_PROGRAM_TITLE"));
        this.progressDialog.setText(Translator.tr((String)"MSG_FRAME_LAUNCH_PROGRAM_STARTTEXT"));
        this.progressDialog.setBarValue(10);
    }

    protected void init() {
        if (this.progressDialog != null) {
            this.progressDialog.setBarValue(90);
        }
        logger.debug("loading reports");
        new Thread(new Runnable(){

            @Override
            public void run() {
                EFCController.this.initReports();
            }
        }).start();
        if (this.launchParam.containsKey("ACCELERATORKEYS")) {
            try {
                String accKeyParam = (String)this.launchParam.get("ACCELERATORKEYS");
                String[] accKeys = accKeyParam.split("\\|");
                String actionIdent = "";
                String actionAccKey = "";
                for (String accKey : accKeys) {
                    String[] acc = accKey.split(":");
                    actionIdent = acc[0];
                    actionAccKey = acc[1];
                    logger.info("Tastenkuerzel - ActionIdent: " + acc[0]);
                    logger.info("Tastenkuerzel - Key: " + acc[1]);
                    this.viewManager.addAcceleratorKeyToAction(actionIdent, EFCActionAcceleratorKey.valueOf(actionAccKey));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.progressDialog != null) {
            this.progressDialog.setBarValue(95);
        }
        logger.debug("doing layout stuff");
        ((Component)this.view).doLayout();
        if (this.view.getEFCToolBar() != null) {
            for (EFCAbstractAction action : this.view.getEFCToolBar().getActions()) {
                if (!(action instanceof EFCActionWindowLock)) continue;
                ((EFCActionWindowLock)action).setSelected(this.isWindowPositionLocked);
            }
        }
        if (this.wflTaskObjRef != null) {
            this.viewManager.addMenuWflItemTask(this.wflTaskObjRef, this);
        }
        if (this.getMainMenu() != null && this.menuBlackListMap != null) {
            this.getMainMenu().processMenuBlacklist(this.menuBlackListMap);
        }
        if (!this.view.isDialogView()) {
            this.setViewVisible();
        }
        if (this.progressDialog != null) {
            this.progressDialog.setBarValue(100);
        }
        if (this.progressDialog != null) {
            this.progressDialog.dispose();
        }
        this.progressDialog = null;
    }

    public void openDialog(EFCController dialog) {
        EFCThreadUtil.doLater(() -> {
            dialog.executeDialog();
            this.lockFrameForDialog();
        });
    }

    public void executeDialog() {
        this.setWindowMode(EFCWindowMode.MODE_EDIT);
        this.setViewVisible();
    }

    public void closeDialog() {
        this.actionExit();
    }

    public void setViewVisible() {
        ((Component)this.view).setVisible(true);
    }

    public void setViewInvisible() {
        ((Component)this.view).setVisible(false);
    }

    public String getLastActiveIdent() {
        return this.viewManager.getLastActiveIdent();
    }

    public String getActiveTableIdent() {
        String activeIdent = this.viewManager.getActiveIdent();
        return activeIdent;
    }

    public String getActiveTableSelectionFocusIdent() {
        String activeIdent = this.viewManager.getActiveTableSelectionFocusIdent();
        return activeIdent;
    }

    public void setActiveTableSelectionFocusIdent(String ident) {
        this.viewManager.setActiveTableSelectionFocusIdent(ident);
    }

    public void setActiveTableIdent(String ident) {
        this.viewManager.setActiveIdent(ident);
    }

    public void setLastActiveIdent(String ident) {
        this.viewManager.setLastActiveIdent(ident);
    }

    public Filter getBaseFilter() {
        return this.baseFilter;
    }

    public Filter getSearchFieldFilter(String ident) {
        return this.getBaseFilter();
    }

    public void setBaseFilter(Filter baseFilter) {
        this.baseFilter = baseFilter;
    }

    public Filter getScrollFilter() {
        return this.scrollFilter;
    }

    public void setScrollFilter(Filter scrollFilter) {
        this.scrollFilter = scrollFilter;
    }

    public SysParam getSysParam() {
        return this.sysParam;
    }

    public void setSysParam(SysParam paramObj) {
        this.sysParam = paramObj;
    }

    public SysObjRef getSysObjRef() {
        return this.sysObjRef;
    }

    public void setSysObjRef(SysObjRef sysObjRef) {
        this.sysObjRef = sysObjRef;
    }

    public Class<?> getBusinessObjectClass() {
        return this.businessObjectClass;
    }

    public HashMap<String, Object> getParamList() {
        return this.paramList;
    }

    public void setParamList(HashMap<String, Object> paramList) {
        this.paramList = paramList;
    }

    public void putParam(String key, Object value) {
        this.paramList.put(key, value);
    }

    public Map<String, Object> getLaunchParam() {
        return this.launchParam;
    }

    protected void refreshScrollList() {
        EditorComponent editorComponent;
        JComponent component;
        String ident = this.viewManager.getActiveField();
        if (ident != null && !ident.isEmpty() && (component = this.viewManager.getField(ident)) instanceof EditorComponent && ((editorComponent = (EditorComponent)((Object)component)).getMetadata().isKey() || editorComponent.getMetadata().isScroll())) {
            this.newOrderField = editorComponent.getIdent();
        }
        this.scrollValue = null;
        if (this.newOrderField != null) {
            EditorComponent ec;
            if (this.getElementManager().getField(this.newOrderField) instanceof EditorComponent && (ec = (EditorComponent)((Object)this.getElementManager().getField(this.newOrderField))).isModified()) {
                String obj = null;
                ec.setModified(false);
                obj = ec instanceof EFCObjectListEditor ? ((EFCObjectListEditor)ec).getSimpleValue() : ec.getValue().toString();
                this.scrollValue = obj.equals("") || obj == null ? null : obj.toString();
            }
            if (this.baseScrollList != null && this.orderField != null && this.scrollValue != null) {
                ScrollListData data = this.baseScrollList.get();
                this.refreshScrollList(data.getKey());
                return;
            }
            if (this.getBusObj() != null && !this.getBusObjKey().isEmpty()) {
                this.refreshScrollList(this.getBusObjKey());
                return;
            }
        }
        this.refreshScrollList(null);
    }

    protected void refreshScrollList(Key startpoint) {
        if (!(this.newOrderField == null || this.orderField != null && this.orderField.equals(this.newOrderField))) {
            this.orderColName = this.orderField = this.newOrderField;
            if (this.orderColName.contains(".")) {
                this.orderColName = this.orderField.substring(this.orderField.lastIndexOf(".") + 1);
            }
            logger.debug("loading new scrollList ordered by newOrderField: " + this.orderColName);
            this.baseScrollList = this.guiService.getScrollList(this.orderColName, this.scrollFilter);
        } else if (this.baseScrollList == null) {
            if (this.orderField == null) {
                this.orderColName = null;
                logger.debug("loading new scrollList (not ordered)");
                this.baseScrollList = this.guiService.getScrollList(this.scrollFilter);
            } else {
                this.orderColName = this.orderField;
                if (this.orderColName.contains(".")) {
                    this.orderColName = this.orderField.substring(this.orderField.lastIndexOf(".") + 1);
                }
                logger.debug("loading new scrollList ordered by orderField: " + this.orderColName);
                this.baseScrollList = this.guiService.getScrollList(this.orderColName, this.scrollFilter);
            }
        }
        if (startpoint != null && this.baseScrollList != null) {
            this.baseScrollList.setPosition(this.baseScrollList.find(startpoint));
        }
    }

    protected void resetScrollList() {
        this.newOrderField = null;
        this.baseScrollList = null;
        this.setStatusText("");
        this.refreshScrollList();
    }

    protected void resetScrollList(Key startpoint) {
        if (this.newOrderField != null && !this.orderField.equals(this.newOrderField)) {
            this.orderColName = this.orderField = this.newOrderField;
            if (this.orderColName.contains(".")) {
                this.orderColName = this.orderField.substring(this.orderField.lastIndexOf(".") + 1);
            }
            logger.debug("loading new scrollList ordered by newOrderField: " + this.orderColName);
            this.baseScrollList = this.guiService.getScrollList(this.orderColName, this.scrollFilter);
        } else if (this.orderField == null) {
            this.orderColName = null;
            logger.debug("loading new scrollList (not ordered)");
            this.baseScrollList = this.guiService.getScrollList(this.scrollFilter);
        } else {
            this.orderColName = this.orderField;
            if (this.orderColName.contains(".")) {
                this.orderColName = this.orderField.substring(this.orderField.lastIndexOf(".") + 1);
            }
            logger.debug("loading new scrollList ordered by orderField: " + this.orderColName);
            this.baseScrollList = this.guiService.getScrollList(this.orderColName, this.scrollFilter);
        }
        if (startpoint != null) {
            this.baseScrollList.setPosition(this.baseScrollList.find(startpoint));
        }
    }

    protected void initReports() {
        Object menuText;
        String defItem;
        logger.debug("initReports start");
        this.defaultReport = null;
        LinkedList<EFCReportSelectionListEntry> defaultReports = new LinkedList<EFCReportSelectionListEntry>();
        this.availableBatchReports = new LinkedList<EFCReportSelectionListEntry>();
        this.availableDocReports = new LinkedList<EFCReportSelectionListEntry>();
        this.availableListReports = new LinkedList<EFCReportSelectionListEntry>();
        this.availableLabelReports = new LinkedList<EFCReportSelectionListEntry>();
        ClSysPrnGrp prngrp = EFCPanelSingleton.getInstance().getClSysPrnGrp(this.printListId);
        for (ClSysPrnGrpDet item : prngrp.getSysprngrpdetList()) {
            if (item.getIsdisabled() != null && item.getIsdisabled().getData() != null && item.getIsdisabled().getData().booleanValue()) continue;
            switch (item.getPrnsrvtype().toInteger()) {
                case 30: {
                    this.availableBatchReports.add(new EFCReportSelectionListEntry(item));
                    break;
                }
                case 20: {
                    this.availableDocReports.add(new EFCReportSelectionListEntry(item));
                    break;
                }
                case 10: {
                    this.availableListReports.add(new EFCReportSelectionListEntry(item));
                    break;
                }
                case 40: {
                    this.availableLabelReports.add(new EFCReportSelectionListEntry(item));
                }
            }
            if (item.getIsdefault() == null || item.getIsdefault().getData() == null || !item.getIsdefault().getData().booleanValue()) continue;
            defaultReports.add(new EFCReportSelectionListEntry(item));
        }
        if (this.launchParam.containsKey("PRINTLISTITEM")) {
            logger.error("Der Parameter PRINTLISTITEM ist 'deprecated' - PRNGRPDET benutzen!");
            defaultReports.clear();
            defItem = this.launchParam.get("PRINTLISTITEM").toString();
            for (ClSysPrnGrpDet item : prngrp.getSysprngrpdetList()) {
                if (!item.getItem().toString().equals(defItem)) continue;
                defaultReports.add(new EFCReportSelectionListEntry(item));
                break;
            }
        }
        if (this.launchParam.containsKey("PRNGRPDET")) {
            defaultReports.clear();
            defItem = this.launchParam.get("PRNGRPDET").toString();
            for (ClSysPrnGrpDet item : prngrp.getSysprngrpdetList()) {
                if (!item.getItem().toString().equals(defItem)) continue;
                defaultReports.add(new EFCReportSelectionListEntry(item));
                break;
            }
        }
        if (defaultReports.size() > 1) {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_PRNSRV_DEFAULT_ERROR", (Object)defaultReports.size()), Translator.tr((String)"MSG_FRAME_PRNSRV_DEFAULT_ERROR_TITLE"));
        } else if (defaultReports.size() == 1) {
            this.defaultReport = (EFCReportSelectionListEntry)defaultReports.get(0);
            Object shortText = this.getMainMenu().getAction(EFCAction.A_PRINT).getValue("ShortDescription").toString();
            shortText = (String)shortText + " [" + this.defaultReport.getReportName() + "]";
            this.getMainMenu().getAction(EFCAction.A_PRINT).putValue("ShortDescription", shortText);
        }
        if (this.availableDocReports.size() > 0) {
            menuText = this.getMainMenu().getAction(EFCAction.A_PRINT_DOC).getValue("Name").toString();
            menuText = (String)menuText + " [" + this.availableDocReports.size() + "]";
            this.getMainMenu().getAction(EFCAction.A_PRINT_DOC).putValue("Name", menuText);
        }
        if (this.availableListReports.size() > 0) {
            menuText = this.getMainMenu().getAction(EFCAction.A_PRINT_LST).getValue("Name").toString();
            menuText = (String)menuText + " [" + this.availableListReports.size() + "]";
            this.getMainMenu().getAction(EFCAction.A_PRINT_LST).putValue("Name", menuText);
        }
        if (this.availableBatchReports.size() > 0) {
            menuText = this.getMainMenu().getAction(EFCAction.A_PRINT_BAT).getValue("Name").toString();
            menuText = (String)menuText + " [" + this.availableBatchReports.size() + "]";
            this.getMainMenu().getAction(EFCAction.A_PRINT_BAT).putValue("Name", menuText);
        }
        if (this.availableLabelReports.size() > 0) {
            menuText = this.getMainMenu().getAction(EFCAction.A_PRINT_LBL).getValue("Name").toString();
            menuText = (String)menuText + " [" + this.availableLabelReports.size() + "]";
            this.getMainMenu().getAction(EFCAction.A_PRINT_LBL).putValue("Name", menuText);
        }
        logger.debug("initReports finished");
    }

    public GuiService getGuiService() {
        return this.guiService;
    }

    public void setGuiService(String mainServiceName) {
        if (mainServiceName != null) {
            this.guiService = (GuiService)SpringHelper.getBean((String)mainServiceName);
        } else {
            logger.debug("using dummy gui service");
            this.guiService = new DummyGuiService();
        }
    }

    public final void setWindowMode(EFCWindowMode mode) {
        EFCThreadUtil.doLater(() -> {
            if (mode == null) {
                return;
            }
            if (this.disabledWindowModes.contains((Object)mode)) {
                this.showErrorDlg(Translator.tr((String)"MSG_FRAME_THIS_WINMODE_IS_NOT_ALLOWED"));
                return;
            }
            try {
                if (this.windowMode == null) {
                    switch (mode) {
                        case MODE_INFO: {
                            this.switchToInfoMode(this.windowMode);
                            break;
                        }
                        case MODE_INFO_SCROLL: {
                            this.switchToInfoScrollMode(this.windowMode);
                            break;
                        }
                        case MODE_SCROLL: {
                            this.switchToScrollMode(this.windowMode);
                            break;
                        }
                        case MODE_EDIT: {
                            this.switchToEditMode(this.windowMode);
                            break;
                        }
                        case MODE_NEW: {
                            this.switchToNewMode(this.windowMode);
                        }
                    }
                } else if (this.isModeSwitchOK(this.windowMode, mode)) {
                    switch (mode) {
                        case MODE_INFO: {
                            this.switchToInfoMode(this.windowMode);
                            break;
                        }
                        case MODE_INFO_SCROLL: {
                            this.switchToInfoScrollMode(this.windowMode);
                            break;
                        }
                        case MODE_SCROLL: {
                            this.switchToScrollMode(this.windowMode);
                            break;
                        }
                        case MODE_EDIT: {
                            this.switchToEditMode(this.windowMode);
                            break;
                        }
                        case MODE_NEW: {
                            this.switchToNewMode(this.windowMode);
                        }
                    }
                }
            }
            catch (ActionNotAllowedException anae) {
                this.showErrorDlg(anae.getMessage(), Translator.tr((String)"MSG_FRAME_ERROR_ACTION_NOT_ALLOWED_TITLE"));
            }
            this.onWindowModeSwitched();
        });
    }

    public boolean isModeSwitchOK(EFCWindowMode oldmode, EFCWindowMode newmode) throws ActionNotAllowedException {
        return true;
    }

    protected void switchToEditMode(EFCWindowMode oldmode) throws ActionNotAllowedException {
        this.windowMode = EFCWindowMode.MODE_EDIT;
    }

    protected void switchToNewMode(EFCWindowMode oldmode) throws ActionNotAllowedException {
        this.windowMode = EFCWindowMode.MODE_NEW;
    }

    protected void switchToScrollMode(EFCWindowMode oldmode) throws ActionNotAllowedException {
        this.windowMode = EFCWindowMode.MODE_SCROLL;
    }

    protected void switchToInfoMode(EFCWindowMode oldmode) throws ActionNotAllowedException {
        this.windowMode = EFCWindowMode.MODE_INFO;
    }

    protected void switchToInfoScrollMode(EFCWindowMode oldmode) throws ActionNotAllowedException {
        this.windowMode = EFCWindowMode.MODE_INFO_SCROLL;
    }

    public EFCWindowMode getWindowMode() {
        return this.windowMode;
    }

    public void addInvalidWindowMode(EFCWindowMode mode) {
        this.disabledWindowModes.add(mode);
    }

    public void removeInvalidWindowMode(EFCWindowMode mode) {
        this.disabledWindowModes.remove((Object)mode);
    }

    @Override
    public boolean isModified() {
        return this.businessObjectModel.isModified();
    }

    @Override
    public void setModified(boolean modified) {
        this.businessObjectModel.setModified(modified);
    }

    @Override
    public ElementManager getElementManager() {
        return this.viewManager;
    }

    @Override
    public DataChangeManager getDataChangeManager() {
        return this.dataChangeManager;
    }

    public String getOrderField() {
        return this.orderField;
    }

    public void setOrderField(String orderfield) {
        this.orderField = orderfield;
    }

    public ScrollList getBaseScrollList() {
        return this.baseScrollList;
    }

    public void setBaseScrollList(ScrollList baselist) {
        this.baseScrollList = baselist;
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public String getSearchServiceTitle() {
        return "";
    }

    public void setSearchService(String i_searchServiceName) {
        this.searchService = (SearchService)SpringHelper.getBean((String)i_searchServiceName);
    }

    protected void initLayoutInfo() {
        EFCFrameLayoutInfo posInfo = EFCPanelSingleton.getInstance().getFramePosition(this.getClass().getSimpleName(), this.getParentController() != null ? this.getParentController().getClass().getSimpleName() : null);
        if (posInfo != null) {
            Dimension dim = new Dimension(posInfo.getWidth(), posInfo.getHeight());
            this.view.setSize(dim);
            this.view.setPreferredSize(dim);
            try {
                this.view.setMaximum(false);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
            EFCDesktop.getInstance().getDesktopManager().setBoundsForFrame(this.view, posInfo.getLocationX(), posInfo.getLocationY(), this.view.getPreferredSize().width, this.view.getPreferredSize().height);
            this.isWindowPositionLocked = true;
            logger.info("setzte Benutzer-bezogene Frame-Position in: " + this.getClass().getSimpleName() + (String)(this.getParentController() != null ? " - " + this.getParentController().getClass().getSimpleName() : ""));
        }
    }

    protected void loadLayout(String filename, Class<? extends BusinessObject> objectclass) {
        EFCPanelSingleton generator = EFCPanelSingleton.getInstance();
        if (this.progressDialog != null) {
            this.progressDialog.setBarValue(50);
        }
        try {
            this.viewManager.resetForLayout();
            BusinessObject currentBO = this.getBusObj();
            this.setBusObj(objectclass.newInstance());
            this.panel = generator.generatePanel(filename, objectclass, this.viewManager, this.dataChangeManager, this.businessObjectModel, this);
            this.view.setMainPanel(this.panel);
            this.setBusObj(currentBO);
            this.loadFields();
            this.setWindowMode(this.getWindowMode());
        }
        catch (Exception ex) {
            EFCDesktop.reportError(ex);
        }
        if (this.progressDialog != null) {
            this.progressDialog.setBarValue(60);
        }
        this.layoutFile = filename;
        this.businessObjectClass = objectclass;
        this.initLayoutInfo();
        EFCThreadUtil.edtBuilder(th -> th.doOutside(() -> {
            CopyOnWriteArrayList<EFCBOTablePanel> panels = this.getElementManager().getAllBOTablePanels("");
            this.businessObjectModel.setBusinessObjectClass(objectclass);
            panels.parallelStream().forEach(table -> {
                String tableIdent = table.getIdent();
                this.businessObjectModel.initGetterSetter(tableIdent);
            });
            this.getElementManager().getAllFieldIdents().parallelStream().forEach(ident -> {
                try {
                    this.businessObjectModel.initGetterSetter((String)ident);
                }
                catch (InvalidTableSelectionException ex) {
                    logger.debug("could not update, table has no selection");
                }
            });
        }));
    }

    public String getLayoutFileName() {
        return this.layoutFile;
    }

    public Key getPopupParam(String fieldident) {
        logger.debug("EFCController.getPopupParam()");
        return new Key();
    }

    public void lockFrame() {
        this.lockFrame(true);
    }

    public void lockFrame(boolean lockChilds) {
        this.lockControl(lockChilds);
        this.dataChangeManager.setFocusListening(false);
        this.viewManager.setFocusableField(null);
    }

    protected void lockFrameForDialog() {
        if (this.dialogLock) {
            return;
        }
        this.dialogLock = true;
        this.lockFrame();
    }

    public void unLockFrame(boolean focusField) {
        this.unLockFrame(focusField, true);
    }

    public void unLockFrame(boolean focusField, boolean unlockParent) {
        if (this.dialogLock || this.view == null) {
            return;
        }
        ((Component)this.view).setCursor(Cursor.getDefaultCursor());
        this.unlockControl(unlockParent);
        this.dataChangeManager.setFocusListening(true);
        if (focusField) {
            JTextField focusableField = this.viewManager.getFocusableField();
            if (focusableField != null && focusableField.isEditable()) {
                focusableField.requestFocusInWindow();
            } else {
                JComponent compo;
                Component comp = this.getFocusOwner();
                if (comp != null) {
                    comp.requestFocusInWindow();
                    if (comp instanceof JTextField && ((JTextField)comp).isEditable()) {
                        ((JTextField)comp).selectAll();
                    }
                } else if (this.viewManager != null && this.viewManager.getFocusableField() == null && this.searchFrames.size() == 0 && (compo = this.viewManager.getField(this.viewManager.getLastActiveField())) != null) {
                    compo.requestFocusInWindow();
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(compo);
                }
            }
        }
    }

    public void unLockFrame() {
        this.unLockFrame(true, true);
    }

    protected void unLockFrameForDialog() {
        this.dialogLock = false;
        this.unLockFrame();
    }

    private boolean prepareForScroll() {
        this.refreshScrollList();
        if (this.baseScrollList.size() == 0) {
            this.showWarningDlg(Translator.tr((String)"MSG_FRAME_SCROLL_NO_DATA"), Translator.tr((String)"MSG_FRAME_SCROLL_NO_DATA_TITLE"));
            this.setStatusText("");
            return false;
        }
        return true;
    }

    private void scroll(boolean reverse) {
        try {
            this.onScrollStart(reverse);
            if (this.getBusObj() != null || this.scrollValue != null) {
                if (this.scrollValue == null) {
                    if (reverse) {
                        this.baseScrollList.previous();
                    } else {
                        this.baseScrollList.next();
                    }
                } else {
                    int current = this.baseScrollList.getPosition();
                    boolean found = reverse ? this.baseScrollList.previousEqual(this.orderColName.toUpperCase(), (Object)this.scrollValue) : this.baseScrollList.nextEqual(this.orderColName.toUpperCase(), (Object)this.scrollValue);
                    if (!found) {
                        switch (this.scrollMissMode) {
                            case ASK: {
                                int result = this.showYesNoDlg(Translator.tr((String)"MSG_FRAME_SCROLL_NO_DATA_FOUND"), Translator.tr((String)"MSG_FRAME_SCROLL_NO_DATA_FOUND_TITLE"));
                                if (result == 0) {
                                    if (reverse) {
                                        found = this.baseScrollList.previousSmaller(this.orderColName.toUpperCase(), (Object)(this.scrollValue != null ? this.scrollValue : ""));
                                        break;
                                    }
                                    found = this.baseScrollList.nextGreater(this.orderColName.toUpperCase(), (Object)(this.scrollValue != null ? this.scrollValue : ""));
                                    break;
                                }
                                this.baseScrollList = null;
                                break;
                            }
                            case DO_NOTHING: {
                                this.baseScrollList.setPosition(current);
                                break;
                            }
                        }
                    }
                }
            } else if (reverse) {
                this.baseScrollList.last();
            } else {
                this.baseScrollList.first();
            }
            this.onScrollFinished(reverse);
        }
        catch (Throwable ex) {
            this.handleException(ex);
            ex.printStackTrace();
        }
    }

    protected abstract void onScrollStart(boolean var1) throws ActionNotAllowedException;

    protected abstract void onScrollFinished(boolean var1);

    protected void onWindowModeSwitched() {
    }

    protected void putValueInObject(String domain, Object value) {
        logger.debug("EFCController.putValueInObject(" + domain + ")");
        if (this.getBusObj() != null) {
            try {
                if (!this.getElementManager().isKeyField(domain) || !this.getBusObj()._isStored()) {
                    this.businessObjectModel.setValueInObject(domain, value);
                }
                if (!(this.isModified() || this.getWindowMode() != EFCWindowMode.MODE_EDIT && this.getWindowMode() != EFCWindowMode.MODE_NEW)) {
                    this.setModified(true);
                }
            }
            catch (InvalidTableSelectionException sel) {
                logger.error(sel.getMessage());
                this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_ROW_SELECTED"));
            }
            catch (Throwable th) {
                this.handleException(th);
            }
            this.refreshFields(domain);
        } else {
            logger.warn("could not store value in null object");
        }
    }

    public void refreshFields() {
        this.refreshFields("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshFields(String prefix) {
        this.mainEventHandler.setTableSelectionHandled(false);
        String tablePrefix = prefix;
        if (tablePrefix.indexOf(".") != -1) {
            tablePrefix = tablePrefix.substring(0, tablePrefix.indexOf("."));
        }
        CopyOnWriteArrayList<EFCPanel> panels = this.getElementManager().getAllPanels(tablePrefix);
        for (JComponent jComponent : panels) {
            if (!(jComponent instanceof EFCBOTablePanel)) continue;
            EFCBOTablePanel table = (EFCBOTablePanel)jComponent;
            String tableIdent = table.getIdent();
            try {
                int counter = 0;
                for (char c : ((EFCBOTablePanel)jComponent).getIdent().toCharArray()) {
                    if (c != '.') continue;
                    ++counter;
                }
                int oldIndex = 0;
                oldIndex = table.getSelectedIndex();
                List data = (List)this.businessObjectModel.getValueFromObject(tableIdent);
                if (tableIdent.contains("scbbasList") && data instanceof List) {
                    this.refreshScbBasList(tableIdent, data);
                }
                if (counter > 0) {
                    table.setData(data);
                    if (!table.isEmptySelectionAllowed() && oldIndex == -1) {
                        oldIndex = 0;
                    }
                    table.setSelectedIndex(oldIndex);
                } else {
                    table.refreshTable();
                }
                table.scrollToVisible(table.getTable(), table.getTable().getSelectedRow(), table.getTable().getSelectedColumn());
                BusinessObject selBo = table.getSelectedObject();
                if (this.getWindowMode() != EFCWindowMode.MODE_EDIT || selBo == null) continue;
                if (selBo._isStored()) {
                    this.viewManager.setSubKeyFieldsEnabled(table.getIdent(), false);
                    continue;
                }
                this.viewManager.setSubKeyFieldsEnabled(table.getIdent(), true);
            }
            catch (InvalidTableSelectionException ex) {
                logger.debug("could not update, parent list has no selection");
                table.setData(null);
            }
            finally {
                try {
                    this.refreshView(tableIdent);
                }
                catch (InvalidTableSelectionException ex) {
                    logger.debug("could not update, parent list has no selection");
                    table.setData(null);
                }
            }
        }
        logger.debug("EFCController.updateFieldContent(): {}", (Object)"");
        Map<String, CopyOnWriteArrayList<WeakReference<JComponent>>> reloadFieldList = this.getElementManager().getAllFieldsForReload("");
        for (Map.Entry<String, CopyOnWriteArrayList<WeakReference<JComponent>>> mapEntry : reloadFieldList.entrySet()) {
            try {
                Object value = this.businessObjectModel.getValueFromObject(mapEntry.getKey());
                for (WeakReference<JComponent> ref : mapEntry.getValue()) {
                    JComponent jComponent = (JComponent)ref.get();
                    if (jComponent == null) continue;
                    if (jComponent instanceof EditorComponent) {
                        ((EditorComponent)((Object)jComponent)).setValue(value);
                        ((EditorComponent)((Object)jComponent)).setLinkedWithObject(true);
                        logger.debug("{} now linked with Object {}", (Object)jComponent.getClass().getSimpleName(), (Object)tablePrefix);
                        continue;
                    }
                    if (!(jComponent instanceof EFCLabel)) continue;
                    EFCLabel label = (EFCLabel)jComponent;
                    label.setText(value == null ? "" : value.toString());
                    label.setToolTipText(value == null ? "" : value.toString());
                }
            }
            catch (InvalidTableSelectionException ex) {
                logger.debug("could not update, table has no selection");
            }
        }
        logger.debug("activating table selection handling");
        this.mainEventHandler.setTableSelectionHandled(true);
        this.refreshView(tablePrefix);
    }

    @Override
    public void setBusObj(BusinessObject bo) {
        this.businessObjectModel.setObject(bo);
    }

    @Override
    public BusinessObject getBusObj() {
        return this.businessObjectModel.getObject();
    }

    public BusinessObject getBusObj(String domain) {
        Object obj = this.businessObjectModel.getValueFromObject(domain);
        if (obj instanceof BusinessObject) {
            return (BusinessObject)obj;
        }
        return null;
    }

    public Key getBusObjKey() {
        return this.getBusObjKey(this.getBusObj());
    }

    public Key getBusObjKey(BusinessObject bo) {
        if (bo != null) {
            return bo._getKey();
        }
        return null;
    }

    protected void updateBOContent(String domain) {
        logger.debug("EFCController.updateBOContent(): {}", (Object)domain);
        Object value = this.businessObjectModel.getValueFromObject(domain);
        CopyOnWriteArrayList<JComponent> components = this.getElementManager().getFields(domain);
        if (components.size() > 0) {
            for (JComponent component : components) {
                if (!(component instanceof EditorComponent)) continue;
                ((EditorComponent)((Object)component)).setValue(value);
            }
        }
    }

    protected void updateFieldContent(String domain) {
        logger.debug("EFCController.updateFieldContent(): {}", (Object)domain);
        try {
            Object value = this.businessObjectModel.getValueFromObject(domain);
            CopyOnWriteArrayList<JComponent> components = this.getElementManager().getFields(domain);
            for (JComponent component : components) {
                if (component instanceof EditorComponent) {
                    ((EditorComponent)((Object)component)).setValue(value);
                    ((EditorComponent)((Object)component)).setLinkedWithObject(true);
                    logger.debug("{} now linked with Object {}", (Object)component.getClass().getSimpleName(), (Object)domain);
                    continue;
                }
                if (!(component instanceof EFCLabel)) continue;
                EFCLabel label = (EFCLabel)component;
                label.setText(value == null ? "" : value.toString());
            }
        }
        catch (InvalidTableSelectionException ex) {
            logger.debug("could not update, table has no selection");
        }
    }

    @Override
    public final void loadFields() {
        EFCThreadUtil.doLater(() -> this.loadFields(""));
    }

    public final void loadFieldsForListAdd(String prefix) {
        EFCThreadUtil.doLater(() -> {
            logger.debug("loadFieldsForListAdd({})", (Object)prefix);
            String tablePrefix = prefix;
            String sPrefix = prefix;
            if (prefix.endsWith(".")) {
                sPrefix = prefix.substring(0, prefix.length() - 1);
            }
            logger.debug("deactivating table selection handling");
            this.mainEventHandler.setTableSelectionHandled(false);
            CopyOnWriteArrayList<EFCPanel> panels = this.getElementManager().getAllPanels(tablePrefix);
            for (JComponent jComponent : panels) {
                if (!(jComponent instanceof EFCBOTablePanel)) continue;
                EFCBOTablePanel table = (EFCBOTablePanel)jComponent;
                String tableIdent = table.getIdent();
                try {
                    Iterator<WeakReference<JComponent>> data;
                    List listData = null;
                    if (!table.isEmptySelectionAllowed() && this.businessObjectModel.getSelectedListItemIndex(tableIdent) == -1) {
                        this.businessObjectModel.setSelectedListItemIndex(tableIdent, 0);
                    }
                    if (!table.isEmptySelectionAllowed() && this.businessObjectModel.getLastSelectedListItemIndex(tableIdent) == -1) {
                        this.businessObjectModel.setLastSelectedListItemIndex(tableIdent, 0);
                    }
                    if ((data = this.businessObjectModel.getValueFromObject(tableIdent)) instanceof List) {
                        listData = (List)((Object)data);
                        if (tableIdent.contains("scbbasList")) {
                            this.refreshScbBasList(tableIdent, listData);
                        }
                    }
                    table.setDataForListAdd(listData);
                    BusinessObject selBo = table.getSelectedObject();
                    if (this.getWindowMode() != EFCWindowMode.MODE_EDIT || selBo == null) continue;
                    if (selBo._isStored()) {
                        this.viewManager.setSubKeyFieldsEnabled(tableIdent, false);
                        continue;
                    }
                    this.viewManager.setSubKeyFieldsEnabled(tableIdent, true);
                }
                catch (InvalidTableSelectionException ex) {
                    logger.debug("could not update, parent list has no selection");
                    table.setData(null);
                }
                finally {
                    try {
                        this.refreshView(tableIdent);
                    }
                    catch (InvalidTableSelectionException ex) {
                        logger.debug("could not update, parent list has no selection");
                        table.setData(null);
                    }
                }
            }
            logger.debug("loadFieldsForListAdd(): {}", (Object)sPrefix);
            Map<String, CopyOnWriteArrayList<WeakReference<JComponent>>> reloadFieldList = this.getElementManager().getAllFieldsForReload(sPrefix);
            for (Map.Entry<String, CopyOnWriteArrayList<WeakReference<JComponent>>> mapEntry : reloadFieldList.entrySet()) {
                try {
                    Object value = this.businessObjectModel.getValueFromObject(mapEntry.getKey());
                    for (WeakReference<JComponent> ref : mapEntry.getValue()) {
                        JComponent jComponent = (JComponent)ref.get();
                        if (jComponent == null) continue;
                        if (jComponent instanceof EditorComponent) {
                            ((EditorComponent)((Object)jComponent)).setValue(value);
                            ((EditorComponent)((Object)jComponent)).setLinkedWithObject(true);
                            logger.debug("{} now linked with Object {}", (Object)jComponent.getClass().getSimpleName(), (Object)sPrefix);
                            continue;
                        }
                        if (!(jComponent instanceof EFCLabel)) continue;
                        EFCLabel label = (EFCLabel)jComponent;
                        label.setText(value == null ? "" : value.toString());
                    }
                }
                catch (InvalidTableSelectionException ex) {
                    logger.debug("could not update, table has no selection");
                }
            }
            logger.debug("activating table selection handling");
            this.mainEventHandler.setTableSelectionHandled(true);
            this.refreshView(sPrefix);
        });
    }

    private void refreshScbBasList(String tableIdent, List<BusinessObject> listData) {
        for (BusinessObject listDataObject : listData) {
            BoScbBas boScbBas;
            if (!(listDataObject instanceof BoScbBas) || (boScbBas = (BoScbBas)listDataObject) == null || boScbBas.getScbchr() == null || boScbBas.getCompleteMsgList().getMsgList().stream().filter(msg -> msg != null && msg.getMsg() instanceof Msg1033).findFirst().isPresent()) continue;
            block0 : switch (boScbBas.getScbchr().getScbchrtype().getData()) {
                case 0: 
                case 20: {
                    switch (boScbBas.getScbchr().getScbchrformat().toInteger()) {
                        case 5: {
                            boScbBas.setView_scbvalue(EUFieldStyler.getObjectAsString(boScbBas.getScb_integervalue()));
                            break block0;
                        }
                        case 0: {
                            boScbBas.setView_scbvalue(boScbBas.getScb_stringvalue());
                            break block0;
                        }
                        case 2: {
                            boScbBas.setView_scbvalue(EUFieldStyler.getObjectAsString(boScbBas.getScb_moneyvalue()));
                            break block0;
                        }
                        case 1: {
                            boScbBas.setView_scbvalue(EUFieldStyler.getObjectAsString(boScbBas.getScb_quantityvalue()));
                            break block0;
                        }
                        case 3: {
                            boScbBas.setView_scbvalue(EUFieldStyler.getObjectAsString(boScbBas.getScb_percentvalue()));
                            break block0;
                        }
                        case 4: {
                            boScbBas.setView_scbvalue(EUFieldStyler.getObjectAsString(boScbBas.getScb_factorvalue()));
                            break block0;
                        }
                        case 10: {
                            boScbBas.setView_scbvalue(EUFieldStyler.getObjectAsString(boScbBas.getScb_datevalue()));
                            break block0;
                        }
                        case 11: {
                            boScbBas.setView_scbvalue(EUFieldStyler.getObjectAsString(boScbBas.getScb_datetimevalue()));
                            break block0;
                        }
                        case 20: {
                            boScbBas.setView_scbvalue(EUFieldStyler.getObjectAsString(boScbBas.getScb_booleanvalue()));
                        }
                    }
                    break;
                }
                case 10: {
                    if (boScbBas.getScb_scbchrdetvalue() != null) {
                        boScbBas.setView_scbvalue(boScbBas.getScb_scbchrdetvalue().getScbvalue());
                        break;
                    }
                    boScbBas.setView_scbvalue((String)null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadFields(String prefix) {
        logger.debug("loadFields({})", (Object)prefix);
        String tablePrefix = prefix;
        String sPrefix = prefix;
        if (prefix.endsWith(".")) {
            sPrefix = prefix.substring(0, prefix.length() - 1);
        }
        logger.debug("deactivating table selection handling");
        this.mainEventHandler.setTableSelectionHandled(false);
        CopyOnWriteArrayList<EFCBOTablePanel> panels = this.getElementManager().getAllBOTablePanels(tablePrefix);
        for (EFCBOTablePanel table : panels) {
            String tableIdent = table.getIdent();
            try {
                Object data;
                List listData = null;
                if (!table.isEmptySelectionAllowed() && this.businessObjectModel.getSelectedListItemIndex(tableIdent) == -1) {
                    this.businessObjectModel.setSelectedListItemIndex(tableIdent, 0);
                }
                if (!table.isEmptySelectionAllowed() && this.businessObjectModel.getLastSelectedListItemIndex(tableIdent) == -1) {
                    this.businessObjectModel.setLastSelectedListItemIndex(tableIdent, 0);
                }
                if ((data = this.businessObjectModel.getValueFromObject(tableIdent)) instanceof List) {
                    listData = (List)data;
                    if (tableIdent.contains("scbbasList")) {
                        this.refreshScbBasList(tableIdent, listData);
                    }
                }
                table.setData(listData);
                BusinessObject selBo = table.getSelectedObject();
                if (this.getWindowMode() != EFCWindowMode.MODE_EDIT || selBo == null) continue;
                if (selBo._isStored()) {
                    this.viewManager.setSubKeyFieldsEnabled(tableIdent, false);
                    continue;
                }
                this.viewManager.setSubKeyFieldsEnabled(tableIdent, true);
            }
            catch (InvalidTableSelectionException ex) {
                logger.debug("could not update, parent list has no selection");
                table.setData(null);
            }
            finally {
                try {
                    this.refreshView(tableIdent);
                }
                catch (InvalidTableSelectionException ex) {
                    logger.debug("could not update, parent list has no selection");
                    table.setData(null);
                }
                catch (Throwable e) {
                    this.handleException(e);
                }
            }
        }
        logger.debug("loadFields(): {}", (Object)sPrefix);
        Map<String, CopyOnWriteArrayList<WeakReference<JComponent>>> reloadFieldList = this.getElementManager().getAllFieldsForReload(sPrefix);
        for (Map.Entry<String, CopyOnWriteArrayList<WeakReference<JComponent>>> mapEntry : reloadFieldList.entrySet()) {
            try {
                Object value = this.businessObjectModel.getValueFromObject(mapEntry.getKey());
                for (WeakReference weakReference : mapEntry.getValue()) {
                    JComponent component = (JComponent)weakReference.get();
                    if (component == null) continue;
                    if (component instanceof EditorComponent) {
                        if (((EditorComponent)((Object)component)).getIdent().contains(".scbbasList")) {
                            String scbIdent = ((EditorComponent)((Object)component)).getIdent();
                            scbIdent = scbIdent.substring(0, scbIdent.indexOf(".scbbasList"));
                            continue;
                        }
                        ((EditorComponent)((Object)component)).setValue(value);
                        ((EditorComponent)((Object)component)).setLinkedWithObject(true);
                        logger.debug("{} now linked with Object {}", (Object)component.getClass().getSimpleName(), (Object)sPrefix);
                        continue;
                    }
                    if (!(component instanceof EFCLabel)) continue;
                    EFCLabel label = (EFCLabel)component;
                    label.setText(value == null ? "" : value.toString());
                    label.setToolTipText(value == null ? "" : value.toString());
                }
            }
            catch (InvalidTableSelectionException ex) {
                logger.debug("could not update, table has no selection");
            }
        }
        logger.debug("loadFields(): {} end", (Object)sPrefix);
        logger.debug("activating table selection handling");
        this.mainEventHandler.setTableSelectionHandled(true);
        this.refreshView(sPrefix);
    }

    public void putValueInField(String ident, Object value) {
        this.putValueInField(ident, value, false);
    }

    public void putValueInField(String ident, Object value, boolean doInBackground) {
        Object oldValue = this.viewManager.getFieldValue(ident);
        this.viewManager.setFieldValue(ident, value);
        Object newValue = this.viewManager.getFieldValue(ident);
        this.handleElementDataChanged(ident, oldValue, newValue, doInBackground);
    }

    public void updateFields(Key key) {
        EFCThreadUtil.doLater(() -> {
            try {
                long start = System.currentTimeMillis();
                if (key.isEmpty()) {
                    this.setBusObj(null);
                } else {
                    this.setBusObj(this.guiService.getObj(key));
                }
                long end = System.currentTimeMillis();
                logger.debug("setBusObj(guiService.getObj(key)) benoetigt " + (end - start) + " ms");
                this.setModified(false);
                this.loadFields("");
                this.onFieldsUpdated();
            }
            catch (Throwable e) {
                this.handleException(e);
            }
        });
    }

    public void updateFields(BusinessObject value) {
        this.setBusObj(value);
        EFCThreadUtil.doLater(() -> {
            try {
                this.loadFields("");
                this.onFieldsUpdated();
            }
            catch (Throwable e) {
                this.handleException(e);
            }
        });
    }

    protected void handleException(Throwable e) {
        logger.error(e.getMessage());
        EFCDesktop.reportError(e);
    }

    protected abstract void onFieldsUpdated();

    public final void updateBusObj(BusinessObject value) {
        logger.debug("updateBusObj(BusinessObject)");
        this.setBusObj(value);
        EFCThreadUtil.doLater(() -> {
            try {
                this.loadFields("");
                this.onBusObjUpdated();
            }
            catch (Throwable e) {
                this.handleException(e);
            }
        });
    }

    protected abstract void onBusObjUpdated();

    public void updateBusObj(Key key) {
        logger.debug("updateBusObj(Key)");
        try {
            if (key.isEmpty()) {
                this.setBusObj(null);
            } else {
                for (Map.Entry<String, Object> entry : this.launchParam.entrySet()) {
                    if (key.containsKey((Object)entry.getKey())) continue;
                    key.addKeyValue(entry.getKey(), entry.getValue() != null ? entry.getValue().toString() : "");
                }
                this.setBusObj(this.guiService.getObj(key));
            }
        }
        catch (Throwable e) {
            this.handleException(e);
        }
        EFCThreadUtil.doLater(() -> {
            try {
                this.setModified(false);
                this.loadFields("");
                this.onBusObjUpdated();
                if (this.getBusObj() == null && this.newOrderField != null && this.scrollValue != null) {
                    logger.info("updateBusObj(Key): setzte Eingabe " + this.scrollValue + " nach nicht erfolgtem Scrollen");
                    if (this.getElementManager().getField(this.newOrderField) instanceof EditorComponent) {
                        EditorComponent ec = (EditorComponent)((Object)this.getElementManager().getField(this.newOrderField));
                        ec.setValue(this.scrollValue);
                    }
                }
            }
            catch (Throwable e) {
                this.handleException(e);
            }
        });
    }

    protected abstract boolean isObjSaved();

    protected abstract boolean isObjLoaded();

    protected Boolean isWarnMsg() {
        return EFCPanelSingleton.getInstance().getIsShowWarnMsg();
    }

    protected Boolean isInfoMsg() {
        return EFCPanelSingleton.getInstance().getIsShowInfoMsg();
    }

    @Override
    public void actionNext() {
        if (!this.isObjSaved()) {
            return;
        }
        if (this.getWindowMode() == EFCWindowMode.MODE_EDIT) {
            this.setWindowMode(EFCWindowMode.MODE_SCROLL);
        }
        this.handleOutside(new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                EFCController.this.onActionNext();
                return sb;
            }
        });
    }

    public void onActionNext() {
        if (!this.prepareForScroll()) {
            return;
        }
        this.scroll(false);
        if (this.baseScrollList != null && this.baseScrollList.get() != null) {
            this.updateBusObj(this.baseScrollList.get().getKey());
        } else {
            this.updateBusObj(new Key());
        }
    }

    public void onActionPrevious() {
        if (!this.prepareForScroll()) {
            return;
        }
        this.scroll(true);
        if (this.baseScrollList != null && this.baseScrollList.get() != null) {
            this.updateBusObj(this.baseScrollList.get().getKey());
        } else {
            this.updateBusObj(new Key());
        }
    }

    protected abstract void onActionSearch();

    @Override
    public void actionSearch() {
        this.onActionSearch();
    }

    public void onDialogButtonClicked(int buttonNumber) {
        this.parentController.handleDialogClosed(new EFCFrDlgResultObject(buttonNumber, this.getBusObj()));
    }

    @Override
    public void actionLoadObject() throws ActionNotAllowedException {
        throw new ActionNotAllowedException(Translator.tr((String)"MSG_FRAME_ACTION_NOT_IMPLEMENTED"));
    }

    @Override
    public void actionPrevious() {
        if (!this.isObjSaved()) {
            return;
        }
        if (this.getWindowMode() == EFCWindowMode.MODE_EDIT) {
            this.setWindowMode(EFCWindowMode.MODE_SCROLL);
        }
        this.handleOutside(new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                EFCController.this.onActionPrevious();
                return sb;
            }
        });
    }

    public abstract void onCreateMailViewer(EFCMap<EFCString, EFCString> var1, EFCBlob var2);

    public abstract void onCreateMailDialog(EFCMap<EFCString, EFCString> var1, EFCMap<EFCString, EFCBlob> var2, EFCString var3, EFCList<String> var4, EFCList<String> var5);

    protected abstract void onCreateMailDialogForPrint(EFCReportContainer var1, EFCString var2, List<String> var3, List<String> var4);

    @Override
    public void actionExit() {
        ((Component)this.view).requestFocus();
        String fieldIdent = this.getLastActiveIdent();
        JComponent editorComponent = this.viewManager.getField(fieldIdent);
        if (editorComponent != null && editorComponent instanceof EFCAbstractEditor) {
            ((EFCAbstractEditor)editorComponent).fireFocusLostEvent(fieldIdent);
        }
        this.terminate();
    }

    @Override
    public void actionPrint() {
        if (this.defaultReport == null) {
            this.showInfoDlg(Translator.tr((String)"MSG_FRAME_NO_REPORT_STANDARD_FOUND"));
            return;
        }
        this.printReport(this.defaultReport);
    }

    @Override
    public void printReport(EFCReportSelectionListEntry actualReport) {
        this.printReport(actualReport, this);
    }

    public void printReport(final EFCReportSelectionListEntry actualReport, final ReportInfoVerifier verifier) {
        if (actualReport == null) {
            this.showInfoDlg(Translator.tr((String)"MSG_FRAME_NO_REPORT_STANDARD_FOUND"));
            return;
        }
        if (this.printSelectionDialog != null) {
            this.printSelectionDialog.setLocked(true);
        } else {
            this.lockFrame();
        }
        final AtomicReference<Object> reportRef = new AtomicReference<Object>(null);
        this.handleOutside(false, new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                try {
                    reportRef.set(EFCReportSingleton.getInstance().buildReport(actualReport, verifier));
                }
                catch (RuntimeException th) {
                    EFCController.this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_REPORT_DATA_FOUND"));
                }
                catch (Throwable th) {
                    EFCDesktop.reportError(th);
                }
                return sb;
            }
        }, new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                sb.edt(new EFCClosure((Object)this){
                    private static final long serialVersionUID = 1L;

                    public EFCThreadUtil call(Object arguments) {
                        EFCThreadUtil sb = (EFCThreadUtil)((Object)arguments);
                        if (reportRef.get() != null) {
                            EFCReportContainer efcReportContainer = (EFCReportContainer)reportRef.get();
                            boolean sendMail = false;
                            try {
                                int selection = efcReportContainer.getClSysPrnSrv().getPrnpreviewtype().getData() == 0 ? 1 : (efcReportContainer.getClSysPrnSrv().getPrnpreviewtype().getData() == 2 ? 0 : new EFCPrintPreviewDialog().getSelection());
                                if (selection != 2 && (efcReportContainer.getClSysPrnSrv().getPrntype().getData() == 11 || efcReportContainer.getClSysPrnSrv().getPrntype().getData() == 12)) {
                                    sendMail = true;
                                }
                                if (selection == 0) {
                                    EFCPDFViewer viewer = new EFCPDFViewer(efcReportContainer, Translator.tr((String)"DLG_TITLE_REPORT_PREVIEW"));
                                    EFCDesktop.getInstance().add(viewer);
                                } else if (selection == 1 && !sendMail) {
                                    new EFCPrintFactory().print(efcReportContainer);
                                    efcReportContainer.closeDocument();
                                }
                                if (sendMail) {
                                    EFCController.this.onCreateMailDialogForPrint(efcReportContainer, null, new ArrayList<String>(), new ArrayList<String>());
                                }
                            }
                            catch (Throwable t) {
                                EFCController.this.handleException(t);
                            }
                        } else {
                            logger.error("cannot display report: report document is null");
                        }
                        if (EFCController.this.printSelectionDialog != null) {
                            EFCController.this.printSelectionDialog.setLocked(false);
                            EFCController.this.printSelectionDialog.getActionHandler().handleAction("exit", null);
                        } else if (EFCController.this.isControlLocked()) {
                            EFCController.this.unLockFrame();
                        }
                        return sb;
                    }
                });
                return sb;
            }
        });
    }

    public void printReport(final EFCReportContainer efcReportContainer) {
        this.lockControl();
        this.handleOutside(false, new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                boolean sendMail = false;
                try {
                    int selection = efcReportContainer.getClSysPrnSrv().getPrnpreviewtype().getData() == 0 ? 1 : (efcReportContainer.getClSysPrnSrv().getPrnpreviewtype().getData() == 2 ? 0 : new EFCPrintPreviewDialog().getSelection());
                    if (selection != 2 && (efcReportContainer.getClSysPrnSrv().getPrntype().getData() == 11 || efcReportContainer.getClSysPrnSrv().getPrntype().getData() == 12)) {
                        sendMail = true;
                    }
                    if (selection == 0) {
                        EFCPDFViewer viewer = new EFCPDFViewer(efcReportContainer, Translator.tr((String)"DLG_TITLE_REPORT_PREVIEW"));
                        EFCDesktop.getInstance().add(viewer);
                    } else if (selection == 1 && !sendMail) {
                        new EFCPrintFactory().print(efcReportContainer);
                        efcReportContainer.closeDocument();
                    }
                    if (sendMail) {
                        EFCController.this.onCreateMailDialogForPrint(efcReportContainer, null, new ArrayList<String>(), new ArrayList<String>());
                    }
                }
                catch (Throwable t) {
                    EFCController.this.handleException(t);
                }
                return sb.edt(new EFCClosure((Object)sb){
                    private static final long serialVersionUID = 1L;

                    public EFCThreadUtil call(Object arguments) {
                        EFCThreadUtil sb = (EFCThreadUtil)((Object)arguments);
                        EFCController.this.unLockFrame();
                        return sb;
                    }
                });
            }
        });
    }

    @Override
    public void actionPrintDoc() {
        this.showPrintSelectionDialog(Translator.tr((String)"DLG_TITLE_REPORTLIST_DOCUMENT"), this.availableDocReports, EFCPrintBatchMode.NO_BATCH);
    }

    @Override
    public void actionPrintList() {
        this.showPrintSelectionDialog(Translator.tr((String)"DLG_TITLE_REPORTLIST_LISTING"), this.availableListReports, EFCPrintBatchMode.NO_BATCH);
    }

    @Override
    public void actionPrintLabel() {
        this.showPrintSelectionDialog(Translator.tr((String)"DLG_TITLE_REPORTLIST_LABEL"), this.availableLabelReports, EFCPrintBatchMode.NO_BATCH);
    }

    @Override
    public void actionPrintBatch() {
        this.showPrintSelectionDialog(Translator.tr((String)"DLG_TITLE_REPORTLIST_BATCH"), this.availableBatchReports, EFCPrintBatchMode.MODE_BATCH_BY_SEARCH);
    }

    private void showPrintSelectionDialog(String dialogTitle, List<EFCReportSelectionListEntry> datalist, EFCPrintBatchMode batchMode) {
        if (datalist == null || datalist.size() == 0) {
            this.showInfoDlg(Translator.tr((String)"MSG_FRAME_NO_REPORTS_IN_LIST"), dialogTitle);
            return;
        }
        if (this.printSelectionDialog != null) {
            this.printSelectionDialog.getActionHandler().handleAction("exit", null);
        }
        this.printSelectionDialog = new EFCPrintSelectionDialog(this, dialogTitle, datalist, this, batchMode);
        EFCDesktop.getInstance().add(this.printSelectionDialog);
        this.printSelectionDialog.setVisible(true);
    }

    public void openPrintSelectionDialogForBatchPrint() {
        this.showPrintSelectionDialog(Translator.tr((String)"DLG_TITLE_REPORTLIST_BATCH"), this.availableBatchReports, EFCPrintBatchMode.MODE_BATCH_BY_FRAME_LIST);
    }

    public void actionPrintDirect() {
        logger.debug("actionPrintDirect()");
        if (this.printSelectionDialog != null) {
            this.printSelectionDialog.setLocked(true);
        }
        final AtomicReference<Object> reportRef = new AtomicReference<Object>(null);
        this.handleOutside(false, new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                JComponent panel;
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                String ident = EFCController.this.viewManager.getActiveIdent(true);
                if (ident == null) {
                    EFCController.this.showWarningDlg(Translator.tr((String)"MSG_FRAME_NO_LIST_SELECTED"));
                    return null;
                }
                ElementManager activeElementManager = EFCController.this.viewManager;
                while (ident.indexOf(":") != -1) {
                    String baseIdent = ident.substring(0, ident.indexOf(":"));
                    panel = activeElementManager.getPanel(baseIdent);
                    if (!(panel instanceof EFCSubPanel)) {
                        throw new IllegalArgumentException("found : in ident, but no subpanel for " + ident);
                    }
                    activeElementManager = ((EFCSubPanel)panel).getElementManager();
                    ident = ident.substring(ident.indexOf(":") + 1);
                }
                panel = activeElementManager.getPanel(ident);
                if (!(panel instanceof TablePanel)) {
                    logger.error("ident {} is not a table", (Object)ident);
                    EFCController.this.showWarningDlg(Translator.tr((String)"MSG_FRAME_NO_LIST_SELECTED"));
                    return null;
                }
                reportRef.set(EFCReportSingleton.getInstance().buildReport((JTable)((TablePanel)((Object)panel)).getTable()));
                return sb;
            }
        }, new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                sb.edt(new EFCClosure((Object)sb){
                    private static final long serialVersionUID = 1L;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public EFCThreadUtil call(Object arguments) {
                        EFCThreadUtil sb = (EFCThreadUtil)((Object)arguments);
                        try {
                            if (reportRef.get() != null) {
                                EFCReportContainer efcReportContainer = (EFCReportContainer)reportRef.get();
                                int selection = new EFCPrintPreviewDialog().getSelection();
                                if (selection == 0) {
                                    EFCPDFViewer viewer = new EFCPDFViewer(efcReportContainer, Translator.tr((String)"DLG_TITLE_REPORT_PREVIEW_PRINT_DIRECT"));
                                    EFCDesktop.getInstance().add(viewer);
                                } else if (selection == 1) {
                                    new EFCPrintFactory().print(efcReportContainer);
                                }
                            } else {
                                logger.error("null report !!!");
                            }
                        }
                        catch (Exception e) {
                            EFCController.this.handleException(e);
                        }
                        finally {
                            if (EFCController.this.printSelectionDialog != null) {
                                EFCController.this.printSelectionDialog.setLocked(false);
                                EFCController.this.printSelectionDialog.getActionHandler().handleAction("exit", null);
                            }
                        }
                        return sb;
                    }
                });
                return sb;
            }
        });
    }

    public void actionExport() {
        JPanel component = this.viewManager.getPanel(this.viewManager.getLastActiveIdent());
        if (component instanceof TablePanel) {
            TablePanel tablePanel = (TablePanel)((Object)component);
            EFCTableExportDialog dlg = new EFCTableExportDialog((JTable)tablePanel.getTable());
            dlg.setLocationRelativeTo(this.view);
            dlg.setVisible(true);
        } else {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_LIST_SELECTED"));
        }
    }

    private EFCClosure getDeleteTableLayout(final TablePanel tablePanel) {
        return new EFCClosure(this){
            private static final long serialVersionUID = 1L;
            final EFCList<MdSysXml> tabLayoutList;
            {
                super(owner);
                this.tabLayoutList = new EFCList();
            }

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                this.tabLayoutList.addAll(EFCPanelSingleton.getInstance().getFrameTableModelList(tablePanel.getLayoutFileName(), tablePanel.getIdent()));
                boolean forAllUsers = false;
                if (EFCPanelSingleton.getInstance().getUsrIsAdmin().booleanValue() && this.tabLayoutList.stream().filter(mdSysXml -> !mdSysXml.getUsername().getData().equals("*")).findFirst() != null) {
                    forAllUsers = EFCController.this.showYesNoDlg(Translator.tr((String)"MSG_FRAME_OPTIONDLG_TABLELAYOUT_DELETE_FOR_ALL"), Translator.tr((String)"MSG_FRAME_OPTIONDLG_ADMINUSER")) == 0;
                }
                EFCPanelSingleton.getInstance().removeFrameTableModel(forAllUsers, (List<MdSysXml>)this.tabLayoutList);
                tablePanel.clearTableColums();
                tablePanel.reloadColumnModel();
                EFCColumnResizer.adjustColumnPreferredWidthsByType((JTable)tablePanel.getTable());
                tablePanel.getTable().getColumnControl().setForeground(Color.BLACK);
                return sb;
            }
        };
    }

    protected void actionDeleteTabLayout() {
        this.lockFrame();
        final String tablePanelIdent = this.viewManager.getSelectedTablePanelId();
        final String listTablePanelIdent = this.viewManager.getSelectedListTablePanelId();
        this.handleOutside(new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                try {
                    if (tablePanelIdent != null) {
                        EFCBOTablePanel boTablePanel = EFCController.this.viewManager.getTablePanel(tablePanelIdent);
                        sb = sb.doOutside(EFCController.this.getDeleteTableLayout(boTablePanel));
                    } else if (listTablePanelIdent != null) {
                        EFCListTablePanel listTablePanel = EFCController.this.viewManager.getListTablePanel(listTablePanelIdent);
                        sb = sb.doOutside(EFCController.this.getDeleteTableLayout(listTablePanel));
                    } else {
                        EFCController.this.unLockFrame();
                        EFCController.this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_LIST_SELECTED"), Translator.tr((String)"MSG_FRAME_ACTION_DELETE_ERROR_TITLE"));
                    }
                }
                catch (ApplicationException e) {
                    EFCController.this.showMessageDlg(e.getMsgList());
                    logger.error("actionDeleteTabLayout() gescheitert!", (Throwable)e);
                }
                catch (Throwable ex) {
                    EFCController.this.handleException(ex);
                }
                sb.edt(new EFCClosure((Object)sb){
                    private static final long serialVersionUID = 1L;

                    public EFCThreadUtil call(Object args) {
                        EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                        EFCController.this.loadFields();
                        return sb;
                    }
                });
                return sb;
            }
        });
    }

    private EFCClosure getSaveTabLayout(final TablePanel tablePanel) {
        return new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                boolean forAllUsers = false;
                if (EFCPanelSingleton.getInstance().getIsUsrRgtTableLayoutAll().booleanValue()) {
                    forAllUsers = EFCController.this.showYesNoDlg(Translator.tr((String)"MSG_FRAME_OPTIONDLG_TABLELAYOUT_SAVE_FOR_ALL"), Translator.tr((String)"MSG_FRAME_OPTIONDLG_ADMINUSER")) == 0;
                }
                EFCPanelSingleton.getInstance().setFrameTableModel(tablePanel.getLayoutFileName(), tablePanel.getIdent(), tablePanel.getColumnModelXML(), forAllUsers);
                if (forAllUsers) {
                    tablePanel.getTable().getColumnControl().setForeground(Color.RED);
                } else {
                    tablePanel.getTable().getColumnControl().setForeground(Color.BLUE);
                }
                return sb;
            }
        };
    }

    protected void actionSaveTabLayout() {
        final String tablePanelIdent = this.viewManager.getSelectedTablePanelId();
        final String listTablePanelIdent = this.viewManager.getSelectedListTablePanelId();
        this.handleOutside(new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                if (tablePanelIdent != null) {
                    EFCBOTablePanel boTablePanel = EFCController.this.viewManager.getTablePanel(tablePanelIdent);
                    sb = sb.doOutside(EFCController.this.getSaveTabLayout(boTablePanel));
                } else if (listTablePanelIdent != null) {
                    EFCListTablePanel listTablePanel = EFCController.this.viewManager.getListTablePanel(listTablePanelIdent);
                    sb = sb.doOutside(EFCController.this.getSaveTabLayout(listTablePanel));
                } else {
                    EFCController.this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_LIST_SELECTED"), Translator.tr((String)"MSG_FRAME_ACTION_SAVE_ERROR_TITLE"));
                }
                return sb;
            }
        });
    }

    @Override
    public void handleAction(String ident, Object param) {
        try {
            if ("new".equals(ident)) {
                this.actionNewObject();
            } else if ("copy".equals(ident)) {
                this.actionCopyObject();
            } else if ("load".equals(ident)) {
                this.actionLoadObject();
            } else if ("saveshortcut".equals(ident) || "save".equals(ident)) {
                this.checkLastInput();
                if (this.checkLastInputValueChanged.booleanValue()) {
                    this.handleOutside(new EFCClosure(this){
                        private static final long serialVersionUID = 1L;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public EFCThreadUtil call(Object args) {
                            EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                            Boolean bl = EFCController.this.checkLastInputValueChanged;
                            synchronized (bl) {
                                if (EFCController.this.checkLastInputValueChanged.booleanValue()) {
                                    try {
                                        EFCController.this.checkLastInputValueChanged.wait();
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }
                            return sb;
                        }
                    }, new EFCClosure(this){
                        private static final long serialVersionUID = 1L;

                        public EFCThreadUtil call(Object args) {
                            EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                            sb.edt(new EFCClosure((Object)sb){
                                private static final long serialVersionUID = 1L;

                                public EFCThreadUtil call(Object arguments) {
                                    EFCThreadUtil sb = (EFCThreadUtil)((Object)arguments);
                                    EFCController.this.checkLastInputValueChanged = false;
                                    EFCController.this.actionSaveObject();
                                    return sb;
                                }
                            });
                            return sb;
                        }
                    });
                } else {
                    this.actionSaveObject();
                }
            } else if ("cancel".equals(ident)) {
                this.actionCancel();
            } else if ("delete".equals(ident)) {
                this.actionDeleteObject();
            } else if ("open".equals(ident)) {
                this.actionOpenObject();
            } else if ("go_next".equals(ident)) {
                this.actionNext();
            } else if ("go_previous".equals(ident)) {
                this.actionPrevious();
            } else if ("print_default".equals(ident)) {
                this.actionPrint();
            } else if ("print_doc".equals(ident)) {
                this.actionPrintDoc();
            } else if ("print_list".equals(ident)) {
                this.actionPrintList();
            } else if ("print_label".equals(ident)) {
                this.actionPrintLabel();
            } else if ("print_batch".equals(ident)) {
                this.actionPrintBatch();
            } else if ("print_direct".equals(ident)) {
                this.actionPrintDirect();
            } else if ("list_add".equals(ident)) {
                this.actionListAdd();
            } else if ("savetablayout".equals(ident)) {
                this.actionSaveTabLayout();
            } else if ("deletetablayout".equals(ident)) {
                this.actionDeleteTabLayout();
            } else if ("list_remove".equals(ident)) {
                this.actionListRemove();
            } else if ("search".equals(ident)) {
                this.actionSearch();
            } else if ("exit".equals(ident)) {
                if (!this.view.isDialogView()) {
                    this.actionExit();
                }
            } else if ("calc".equals(ident)) {
                this.actionCalc();
            } else if ("data_export".equals(ident)) {
                this.actionExport();
            } else if ("actualize".equals(ident)) {
                this.actionActualizeObject();
            } else if ("docflow_continue".equals(ident)) {
                this.actionDocFlowContinue();
            } else if ("docflow_takeover".equals(ident)) {
                this.actionDocFlowTakeOver();
            } else if ("docflow_close".equals(ident)) {
                this.actionDocFlowClose();
            } else if ("frameinfo".equals(ident)) {
                this.businessObjectModel.printDebugInfo();
                if (this.infoBox == null) {
                    this.infoBox = new EFCFrameInfo(this);
                    EFCDesktop.getInstance().add(this.infoBox);
                } else {
                    this.infoBox.setVisible(true);
                    this.infoBox.toFront();
                }
            } else if ("windowlock".equals(ident)) {
                this.lockWindowPosition((Boolean)param);
            } else if ("help".equals(ident)) {
                EFCDesktop.getInstance().add(new EFCHelp());
            } else if (EFCAdditionalActionInfo.FUNCTION_MARKALLTRUE.getIdent().equals(ident)) {
                this.actionMarkAllTrue();
            } else if (EFCAdditionalActionInfo.FUNCTION_MARKALLFALSE.getIdent().equals(ident)) {
                this.actionMarkAllFalse();
            } else if (EFCAdditionalActionInfo.FUNCTION_MARKALLINVERT.getIdent().equals(ident)) {
                this.actionMarkAllInvert();
            } else if (EFCAdditionalActionInfo.FUNCTION_MARKSELECTION.getIdent().equals(ident)) {
                this.actionMarkSelection();
            }
        }
        catch (ActionNotAllowedException ex) {
            if (!ex.isNotified()) {
                this.showWarningDlg(ex.getMessage(), Translator.tr((String)"MSG_FRAME_ERROR_ACTION_NOT_ALLOWED_TITLE"));
                ex.notified();
            }
        }
        catch (UnsupportedOperationException e) {
            logger.error("handleAction() [UnsupportedOperationException] gescheitert!", (Throwable)e);
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED"), Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED_TITLE"));
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    protected void checkLastInput() {
        String text;
        JComponent comp;
        if ((this.getWindowMode().equals((Object)EFCWindowMode.MODE_EDIT) || this.getWindowMode().equals((Object)EFCWindowMode.MODE_NEW)) && (comp = this.viewManager.getField(this.viewManager.getLastActiveIdent())) != null && comp instanceof EFCAbstractEditor && !(text = ((EFCAbstractEditor)comp).getValue() != null ? ((EFCAbstractEditor)comp).getValue().toString() : "").equals(((EFCAbstractEditor)comp).getOriginalValue() != null ? ((EFCAbstractEditor)comp).getOriginalValue().toString() : "")) {
            if (this.handleChangedFields.contains(((EFCAbstractEditor)comp).getIdent())) {
                this.checkLastInputValueChanged = true;
            }
            ((EFCAbstractEditor)comp).fireValueChangeEvent(((EFCAbstractEditor)comp).getIdent(), ((EFCAbstractEditor)comp).getOriginalValue(), ((EFCAbstractEditor)comp).getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyCheckLastInputValueChanged() {
        if (this.checkLastInputValueChanged.booleanValue()) {
            Boolean bl = this.checkLastInputValueChanged;
            synchronized (bl) {
                this.checkLastInputValueChanged.notify();
            }
        }
    }

    protected void lockWindowPosition(Boolean isLocked) {
        String frameName = this.getClass().getSimpleName();
        if (!isLocked.booleanValue()) {
            Dimension preferredSize = this.view.getSize();
            Point location = this.view.getLocation();
            boolean isMaximized = this.view.isMaximum();
            EFCFrameLayoutInfo layoutInfo = new EFCFrameLayoutInfo(this.getLayoutFileName(), preferredSize.getSize().width, preferredSize.getSize().height, location.x, location.y, isMaximized);
            EFCPanelSingleton.getInstance().setFramePosition(frameName, this.getParentController() != null ? this.getParentController().getClass().getSimpleName() : null, layoutInfo);
        } else {
            EFCPanelSingleton.getInstance().removeFramePosition(frameName, this.getParentController() != null ? this.getParentController().getClass().getSimpleName() : null);
        }
    }

    public EFCThreadUtil handleSearchUpdate(Key selectedObjectKey, String callingField, String searchServiceId, Filter usedSearchFilter) {
        return this.handleSearchUpdate(selectedObjectKey, callingField, searchServiceId, usedSearchFilter, null);
    }

    public EFCThreadUtil handleSearchUpdate(Key selectedObjectKey, String callingField, String searchServiceId, Filter usedSearchFilter, Consumer<EFCThreadUtil> callback) {
        this.lockControl();
        return EFCThreadUtil.edtBuilder(th -> th.doOutside(() -> {
            this.onSearchSync(searchServiceId, callingField, selectedObjectKey, usedSearchFilter);
            th.edt(() -> {
                this.unLockFrame();
                if (callback != null) {
                    th.edt(callback);
                }
            });
        }));
    }

    public EFCThreadUtil handleSearchFieldUpdate(EFCAbstractPrimaryEditor editor, Object oldValue, String newValue, Map<String, String> valueMap) {
        this.lockControl();
        return EFCThreadUtil.edtBuilder(th -> th.doOutside(() -> {
            this.onSearchFieldUpdate(editor, oldValue, newValue, valueMap);
            th.edt(() -> this.unLockFrame());
        }));
    }

    public void handleSearchBatch(final List<Key> keyList, final String callingField) {
        this.lockControl();
        this.handleOutside(false, new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                EFCController.this.onSearchBatch(callingField, keyList);
                return sb.edt(new EFCClosure((Object)sb){
                    private static final long serialVersionUID = 1L;

                    public EFCThreadUtil call(Object arguments) {
                        EFCThreadUtil sb = (EFCThreadUtil)((Object)arguments);
                        EFCController.this.unLockFrame();
                        return sb;
                    }
                });
            }
        });
    }

    @Override
    public void printBatch(List<Key> keyList, EFCReportSelectionListEntry tmpCallingReport) {
        if (tmpCallingReport == null) {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_LISTENTRY_SELECTED"));
            return;
        }
        if (keyList == null || keyList.size() == 0) {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_LISTENTRY_SELECTED"));
            return;
        }
        if (this.printSelectionDialog != null) {
            this.printSelectionDialog.setLocked(true);
        }
        final EFCString oldPrintername = new EFCString();
        final EFCBoolean oldIsprnselect = new EFCBoolean();
        oldPrintername.putValue((Object)tmpCallingReport.getClSysPrnSrv().getPrnprintername());
        oldIsprnselect.putValue((Object)tmpCallingReport.getClSysPrnSrv().getIsprnselect());
        if (tmpCallingReport.getClSysPrnSrv().getIsprnselect().getData().booleanValue()) {
            PrintService service;
            PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
            HashPrintRequestAttributeSet attrSet = new HashPrintRequestAttributeSet();
            Integer copycount = tmpCallingReport.getClSysPrnSrv().getPrncopy().getData();
            if (copycount == null || copycount == 0) {
                copycount = 1;
            }
            attrSet.add(new Copies(copycount));
            PrintService defPrintService = PrintServiceLookup.lookupDefaultPrintService();
            if (oldPrintername.getData() != null && !oldPrintername.getData().isEmpty()) {
                for (PrintService ps : services) {
                    if (ps.getName().indexOf(oldPrintername.getData()) == -1) continue;
                    defPrintService = ps;
                    break;
                }
            }
            if ((service = ServiceUI.printDialog(null, 50, 50, services, defPrintService, null, attrSet)) != null) {
                logger.info("Setze Drucker fuer Batchdruck: " + service.getName());
                if (service.getName() != null) {
                    tmpCallingReport.getClSysPrnSrv().setPrnprintername(service.getName());
                }
                logger.info("Setze Kopienzahl fuer Batchdruck: " + attrSet.get(Copies.class));
                tmpCallingReport.getClSysPrnSrv().setPrncopy(Integer.valueOf(attrSet.get(Copies.class).toString()));
                if (attrSet.get(MediaTray.class) != null) {
                    tmpCallingReport.getClSysPrnSrv().setPrnprintersrc(new EFCString(attrSet.get(MediaTray.class).toString()));
                }
            } else {
                this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_PRINTER_SELECTED"));
                if (this.printSelectionDialog != null) {
                    this.printSelectionDialog.setLocked(false);
                }
                return;
            }
        }
        tmpCallingReport.getClSysPrnSrv().setIsprnselect(Boolean.valueOf(false));
        new EFCPrintTask(keyList, tmpCallingReport, this){

            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (InterruptedException | ExecutionException ex) {
                    logger.error(Translator.tr((String)"MSG_FRAME_EXCEPTION"), (Throwable)ex);
                }
                if (EFCController.this.printSelectionDialog != null) {
                    EFCController.this.printSelectionDialog.setLocked(false);
                    EFCController.this.printSelectionDialog.getActionHandler().handleAction("exit", null);
                }
                this.getEntry().getClSysPrnSrv().setPrnprintername(oldPrintername);
                this.getEntry().getClSysPrnSrv().setIsprnselect(oldIsprnselect);
            }
        }.execute();
    }

    @Override
    public void printBatch(final List<EFCReportBatchListEntry> batchList) {
        if (this.printSelectionDialog != null) {
            this.printSelectionDialog.setLocked(true);
        }
        this.handleOutside(false, new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                for (EFCReportBatchListEntry batchEntry : batchList) {
                    EFCReportContainer efcReportContainer = null;
                    efcReportContainer = EFCReportSingleton.getInstance().buildReport(batchEntry.getReportEntry(), EFCController.this, batchEntry.getKey());
                    if (efcReportContainer != null) {
                        EFCReportContainer finalEfcReportContainer = efcReportContainer;
                        EFCThreadUtil.doLater(() -> {
                            boolean selection = true;
                            if (finalEfcReportContainer.getClSysPrnSrv().getPrnpreviewtype().getData() == 2) {
                                selection = false;
                            }
                            if (!selection) {
                                EFCPDFViewer viewer = new EFCPDFViewer(finalEfcReportContainer, Translator.tr((String)"DLG_TITLE_REPORT_PREVIEW"));
                                EFCDesktop.getInstance().add(viewer);
                            } else if (selection) {
                                new EFCPrintFactory().print(finalEfcReportContainer);
                            }
                        });
                        continue;
                    }
                    logger.error("cannot display report: report document is null");
                }
                return sb;
            }
        }, new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                sb.edt(new EFCClosure(args){
                    private static final long serialVersionUID = 1L;

                    public EFCThreadUtil call(Object arguments) {
                        EFCThreadUtil sb = (EFCThreadUtil)((Object)arguments);
                        if (EFCController.this.printSelectionDialog != null) {
                            EFCController.this.printSelectionDialog.setLocked(false);
                            EFCController.this.printSelectionDialog.getActionHandler().handleAction("exit", null);
                        }
                        return sb;
                    }
                });
                return sb;
            }
        });
    }

    @Override
    public void printBatch(EFCReportSelectionListEntry callingReport) {
        if (callingReport == null) {
            this.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_LISTENTRY_SELECTED"));
            return;
        }
        if (this.printSelectionDialog != null) {
            this.printSelectionDialog.setLocked(true);
        }
        new EFCPrintBatchTask(callingReport){

            @Override
            protected List<Key> doInBackground() throws Exception {
                List<Key> keyList = null;
                keyList = EFCController.this.onPrintBatch(this.getEntry());
                return keyList;
            }

            @Override
            protected void done() {
                if (EFCController.this.printSelectionDialog != null) {
                    EFCController.this.printSelectionDialog.setLocked(false);
                    EFCController.this.printSelectionDialog.getActionHandler().handleAction("exit", null);
                }
                try {
                    EFCController.this.printBatch((List)this.get(), this.getEntry());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
        }.execute();
    }

    protected List<Key> onPrintBatch(EFCReportSelectionListEntry callingReport) {
        this.showErrorDlg(Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED"), Translator.tr((String)"MSG_FRAME_METHOD_NOT_IMPLEMENTED_TITLE"));
        return null;
    }

    public void handleDialogClosed(final EFCFrDlgResultObject result) {
        this.dialogFrame.setViewInvisible();
        this.handleOutside(false, new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                EFCController.this.onDialogClosed(result);
                return sb;
            }
        }, new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object arguments) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)arguments);
                sb.edt(new EFCClosure((Object)sb){
                    private static final long serialVersionUID = 1L;

                    public EFCThreadUtil call(Object args) {
                        EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                        EFCController.this.dialogFrame.closeDialog();
                        EFCController.this.dialogFrame = null;
                        EFCController.this.unLockFrameForDialog();
                        return sb;
                    }
                });
                return sb;
            }
        });
    }

    protected void onDialogClosed(EFCFrDlgResultObject result) {
    }

    @Override
    public void handleElementPopupOpen(String ident) {
        logger.debug("handleElementPopupOpen({})", (Object)ident);
        JComponent jComponent = this.getElementManager().getField(ident);
        if (jComponent instanceof EFCObjectListEditor) {
            EFCObjectListEditor ole = (EFCObjectListEditor)jComponent;
            ole.reloadList((Map<String, String>)this.getPopupParam(ident));
        } else if (jComponent instanceof EFCAbstractPrimaryEditor.EFCUnitFieldSubEditor) {
            EFCAbstractPrimaryEditor.EFCUnitFieldSubEditor editorDummy = (EFCAbstractPrimaryEditor.EFCUnitFieldSubEditor)jComponent;
            editorDummy.reloadPopupServiceData((Map<String, String>)this.getPopupParam(editorDummy.getIdent()));
        }
    }

    @Override
    public void handleElementPopupClose(String ident) {
        logger.debug("handleElementPopupClose({})", (Object)ident);
        try {
            JComponent component = this.viewManager.getField(ident);
            if (component instanceof EditorComponent) {
                EditorComponent editor = (EditorComponent)((Object)component);
                Object newVal = editor.getValue();
                Object oldVal = editor.getOriginalValue();
                if (newVal != null) {
                    if (oldVal != null && oldVal.toString().equals(newVal.toString())) {
                        editor.fireValueChangeEvent(ident, oldVal, newVal);
                    }
                } else {
                    editor.fireValueChangeEvent(ident, oldVal, newVal);
                }
            } else {
                logger.debug("{} is not an editor component, new value ignored", (Object)ident);
            }
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    @Override
    public void handleElementGainedFocus(String ident) {
        logger.debug("handleElementGainedFocus({})", (Object)ident);
        if (ident.indexOf(":") == -1) {
            JComponent component = this.getElementManager().getField(ident);
            if (component instanceof EFCObjectListEditor) {
                EFCObjectListEditor ole = (EFCObjectListEditor)component;
                ole.setDefaultPopupParams(this.getPopupParam(ident));
            }
            if ((component = this.viewManager.getField(ident)) instanceof EditorComponent) {
                this.viewManager.setLastActiveField(ident);
                this.viewManager.setActiveField(ident);
                component = ((EditorComponent)((Object)component)).getEditorComponent();
                if (component instanceof JTextField) {
                    ((JTextField)component).selectAll();
                }
            }
        }
        String oldIdent = this.getLastActiveIdent();
        this.setLastActiveIdent(ident);
        this.view.fireChangeEvent("lastfield", oldIdent, this.viewManager.getLastActiveIdent());
    }

    @Override
    public void handleElementLostFocus(String ident) {
        logger.debug("handleElementLostFocus({})", (Object)ident);
    }

    protected void onElementDataChangedFinished(String ident, Object oldval, Object newval) {
    }

    protected void onElementDataChanged(String ident, Object oldval, Object newval) {
        throw new UnsupportedOperationException("this event is not implemented by the gui service!");
    }

    protected void refreshView(String ident, Object oldval, Object newval) {
    }

    protected void refreshView(String ident) {
    }

    @Override
    public void handleKey(int keyCode, String elementIdent, int modifier) {
        logger.debug("handleKey(" + keyCode + "," + elementIdent + ",...)");
        if (keyCode == 123) {
            logger.debug("current ident: " + this.viewManager.getLastActiveIdent());
            logger.debug("current editor value: " + this.getElementManager().getFieldValue(this.viewManager.getLastActiveIdent()));
            logger.debug("current bo value: " + this.businessObjectModel.getValueFromObject(this.viewManager.getLastActiveIdent()));
        }
        if (keyCode == 10) {
            JComponent component = this.viewManager.getField(elementIdent);
            EFCWindowMode windowMode = this.getWindowMode();
            EFCAbstractEditor editor = null;
            if (component instanceof EFCAbstractEditor) {
                editor = (EFCAbstractEditor)component;
            }
            if (!(component instanceof EFCTextHtmlEditor || component instanceof EFCBooleanEditor || component instanceof EFCAbstractTextEditor || editor == null || windowMode == null || (windowMode.equals((Object)EFCWindowMode.MODE_INFO_SCROLL) || windowMode.equals((Object)EFCWindowMode.MODE_SCROLL)) && editor.getMetadata().isScroll())) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        }
    }

    @Override
    public void handleTableSelectionChanged(String tableIdent, String columnName, BusinessObject selectedObject) {
        logger.debug("handleTableSelectionChanged(" + tableIdent + "," + columnName + ")");
        this.tableSelectFocusWorkaround();
        this.refreshFields(tableIdent + ".");
        String oldIdent = this.getLastActiveIdent();
        this.setLastActiveIdent(tableIdent);
        this.view.fireChangeEvent("lastfield", oldIdent, this.viewManager.getLastActiveIdent());
    }

    @Override
    public void handleListTableSelectionChanged(String tableIdent, String columnName, BusinessObject selectedObject) {
        logger.debug("handleListTableSelectionChanged(" + tableIdent + "," + columnName + ")");
        this.tableSelectFocusWorkaround();
        String oldIdent = this.getLastActiveIdent();
        this.setLastActiveIdent(tableIdent);
        this.view.fireChangeEvent("lastfield", oldIdent, this.viewManager.getLastActiveIdent());
    }

    @Override
    public void handleListTableDataLoaded(String tableIdent) {
    }

    private void tableSelectFocusWorkaround() {
        String activeIdent = this.viewManager.getActiveIdent();
        JComponent object = this.getElementManager().getField(activeIdent);
        if (object instanceof EFCAbstractEditor && !(object instanceof EFCBooleanEditor)) {
            EFCAbstractEditor editor = (EFCAbstractEditor)object;
            if (editor.isModified() && (editor.getSimpleOriginalValue() == null || !editor.getSimpleOriginalValue().equals(editor.getSimpleValue()))) {
                this.handleElementDataChanged(activeIdent, editor.getOriginalValue(), editor.getValue(), false);
            }
        } else {
            this.businessObjectModel.setLastSelectedListItemIndex();
        }
    }

    @Override
    public void handleTabSelectionChanged(String registerIdent, String oldTabIdent, String newTabIdent) {
        logger.debug("handleTabSelectionChanged(" + registerIdent + "," + oldTabIdent + "," + newTabIdent + ")");
        this.viewManager.setActiveTableSelectionFocusIdent(null);
        String oldIdent = this.getLastActiveIdent();
        this.setLastActiveIdent(newTabIdent);
        this.view.fireChangeEvent("lastfield", oldIdent, this.viewManager.getLastActiveIdent());
    }

    @Override
    public void handleGraphActualizeAction(String ident) {
        this.onActionActualizeObject();
    }

    @Override
    public void handleGanttSelectionChanged(BusinessObject businessObject) {
    }

    @Override
    public void handleGanttElementDragEnd(BusinessObject businessObject, String label, Date start, Date end, Date min, Date max, Map<BusinessObject, List<Date>> listMovedElements) {
    }

    @Override
    public void handleGridSelectionChanged(String gridIdent, BusinessObject selectedObject) {
    }

    @Override
    public void handleChartSelectionChanged(BusinessObject businessObject) {
    }

    @Override
    public void handleGraphSelectionChanged(BusinessObject businessObject) {
    }

    @Override
    public void handleGraphBpmSelectionAction(BusinessObject businessObject) {
    }

    @Override
    public void handleDiagramOpenPopupAction() {
        this.view.lockFrame();
    }

    @Override
    public void handleDiagramClosePopupAction() {
        this.view.unlockFrame();
    }

    @Override
    public void handleBusinessTableDragAndDrop(Integer targetRow, Integer startColumn, ArrayList<BusinessObject> copyList) {
    }

    @Override
    public void handleExplorerSelectionChanged(String ident, ETreeElement selected) {
        logger.debug("handleExplorerSelectionChanged(" + ident + ")");
    }

    protected abstract void onSync(SysParam var1, Map<String, Object> var2, CountDownLatch var3, ExecutorService var4);

    protected abstract void onSync(Key var1, Map<String, Object> var2, CountDownLatch var3, ExecutorService var4);

    public void sync(SysParam valueObj, Map<String, Object> valueList) {
        CountDownLatch latch = new CountDownLatch(1);
        ExecutorService executor = Executors.newFixedThreadPool(1);
        new EFCMainSyncSwingWorker(this, this.parentController, latch, executor).execute();
        this.sync(valueObj, valueList, latch, executor);
    }

    public void sync(SysParam valueObj, Map<String, Object> valueList, CountDownLatch latch, ExecutorService executor) {
        this.onSync(valueObj, valueList, latch, executor);
    }

    public void sync(Key key, Map<String, Object> valueList, CountDownLatch latch, ExecutorService executor) {
        this.onSync(key, valueList, latch, executor);
    }

    public void sync(Key key, Map<String, Object> valueList) {
        CountDownLatch latch = new CountDownLatch(1);
        ExecutorService executor = Executors.newFixedThreadPool(1);
        new EFCMainSyncSwingWorker(this, this.parentController, latch, executor).execute();
        this.sync(key, valueList, latch, executor);
    }

    protected abstract void onSearchSync(String var1, String var2, Key var3, Filter var4);

    protected abstract void onSearchFieldUpdate(EFCAbstractPrimaryEditor var1, Object var2, String var3, Map<String, String> var4);

    protected abstract void onSearchBatch(String var1, List<Key> var2);

    protected abstract void onActionCancel();

    protected abstract void onActionOpenObject();

    public abstract void onActionSaveObject(EFCThreadUtil var1);

    protected abstract void onActionActualizeObject();

    @Override
    public void actionCalc() {
        try {
            Runtime.getRuntime().exec("calc");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionActualizeObject() {
        this.handleOutside(new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                EFCController.this.onActionActualizeObject();
                return sb;
            }
        });
    }

    public void actionDocFlowContinue() {
        this.handleOutside(new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                EFCController.this.onActionDocFlowContinue();
                return sb;
            }
        });
    }

    protected abstract void onActionDocFlowContinue();

    public void actionDocFlowTakeOver() {
        this.handleOutside(new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                EFCController.this.onActionDocFlowTakeOver();
                return sb;
            }
        });
    }

    protected abstract void onActionDocFlowTakeOver();

    protected abstract void onActionDocFlowClose();

    public void actionDocFlowClose() {
        this.handleOutside(new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                EFCController.this.onActionDocFlowClose();
                return sb;
            }
        });
    }

    protected abstract void onActionCopyObject();

    @Override
    public void actionCopyObject() {
        this.handleOutside(new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                EFCController.this.onActionCopyObject();
                return sb;
            }
        });
    }

    protected abstract void onActionDeleteObject();

    @Override
    public void actionDeleteObject() {
        this.handleOutside(new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                EFCController.this.onActionDeleteObject();
                return sb;
            }
        });
    }

    protected abstract void onActionListAdd();

    protected abstract void onActionListAdd(String var1);

    protected void onActionListAddFinished() {
    }

    @Override
    public void actionListAdd() {
        this.handleOutside(new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                EFCController.this.onActionListAdd();
                return sb;
            }
        }, new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(final Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                sb.edt(new EFCClosure((Object)sb){
                    private static final long serialVersionUID = 1L;

                    public EFCThreadUtil call(Object arguments) {
                        EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                        EFCController.this.businessObjectModel.setLastSelectedListItemIndex();
                        EFCController.this.onActionListAddFinished();
                        return sb;
                    }
                });
                return sb;
            }
        });
    }

    @Override
    public void actionListAdd(final String tableIdent) {
        this.handleOutside(new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                EFCController.this.onActionListAdd(tableIdent);
                return sb;
            }
        }, new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(final Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                sb.edt(new EFCClosure((Object)sb){
                    private static final long serialVersionUID = 1L;

                    public EFCThreadUtil call(Object arguments) {
                        EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                        EFCController.this.businessObjectModel.setLastSelectedListItemIndex();
                        EFCController.this.onActionListAddFinished();
                        return sb;
                    }
                });
                return sb;
            }
        });
    }

    protected abstract void onActionListRemove();

    @Override
    public void actionListRemove() {
        this.handleOutside(new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                EFCController.this.onActionListRemove();
                return sb;
            }
        });
    }

    protected abstract void onActionNewObject() throws ActionNotAllowedException;

    @Override
    public void actionNewObject() {
        this.handleOutside(new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                try {
                    EFCController.this.onActionNewObject();
                }
                catch (ActionNotAllowedException e) {
                    e.printStackTrace();
                }
                return sb;
            }
        }, new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                sb.edt(new EFCClosure((Object)sb){
                    private static final long serialVersionUID = 1L;

                    public EFCThreadUtil call(Object args) {
                        EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                        EFCController.this.loadFields();
                        return sb;
                    }
                });
                return sb;
            }
        });
    }

    @Override
    public void actionCancel() {
        this.handleOutside(new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                EFCController.this.onActionCancel();
                return sb;
            }
        });
    }

    @Override
    public void actionOpenObject() {
        this.handleOutside(new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                EFCController.this.onActionOpenObject();
                return sb;
            }
        });
    }

    @Override
    public void actionSaveObject() {
        if (this.saveThreadUtil == null) {
            this.saveThreadUtil = EFCThreadUtil.builder();
        }
        if (this.getSaveWorker() == null || this.getSaveWorker().getState().equals((Object)Thread.State.TERMINATED)) {
            if (this.isObjSavingAllowed().booleanValue()) {
                this.handleOutside(this.saveThreadUtil, new EFCClosure(this){
                    private static final long serialVersionUID = 1L;

                    public EFCThreadUtil call(Object args) {
                        EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                        EFCController.this.onActionSaveObject(sb);
                        return sb;
                    }
                }, new EFCClosure(this){
                    private static final long serialVersionUID = 1L;

                    public EFCThreadUtil call(Object args) {
                        EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                        sb.edt(new EFCClosure((Object)sb){
                            private static final long serialVersionUID = 1L;

                            public EFCThreadUtil call(Object arguments) {
                                EFCThreadUtil sb = (EFCThreadUtil)((Object)arguments);
                                EFCController.this.loadFields();
                                return sb;
                            }
                        });
                        return sb;
                    }
                });
            } else {
                this.showErrorDlg(Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE"), Translator.tr((String)"MSG_FRAME_SAVEDATA_NOT_DONE_TITLE"));
            }
        }
    }

    protected abstract void onActionMarkAllFalse();

    public void actionMarkAllFalse() {
        this.handleOutside(new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                EFCController.this.onActionMarkAllFalse();
                return sb;
            }
        });
    }

    protected abstract void onActionMarkAllTrue();

    public void actionMarkAllTrue() {
        this.handleOutside(new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                EFCController.this.onActionMarkAllTrue();
                return sb;
            }
        });
    }

    protected abstract void onActionMarkAllInvert();

    public void actionMarkAllInvert() {
        this.handleOutside(new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                EFCController.this.onActionMarkAllInvert();
                return sb;
            }
        });
    }

    protected abstract void onActionMarkSelection();

    public void actionMarkSelection() {
        this.handleOutside(new EFCClosure(this){
            private static final long serialVersionUID = 1L;

            public EFCThreadUtil call(Object args) {
                EFCThreadUtil sb = (EFCThreadUtil)((Object)args);
                EFCController.this.onActionMarkSelection();
                return sb;
            }
        });
    }

    protected Boolean isObjSavingAllowed() {
        return true;
    }

    public void openChildWindow(Class<? extends EFCController> clazz, Map<String, Object> param) {
        Class<? extends EFCController> loadclass = clazz;
        try {
            Constructor<? extends EFCController> con = loadclass.getConstructor(EFCController.class, Map.class);
            EFCController result = con.newInstance(this, param);
            result.sync(this.sysParam, this.paramList);
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }

    public void openChildWindow(Class<? extends EFCController> clazz) {
        this.openChildWindow(clazz, null);
    }

    public void openChildWindowForEdit(Class<? extends EFCController> clazz, Map<String, Object> param) {
        Class<? extends EFCController> loadclass = clazz;
        try {
            if (param == null) {
                param = new HashMap<String, Object>();
            }
            param.put("SCROLL", null);
            Constructor<? extends EFCController> con = loadclass.getConstructor(EFCController.class, Map.class);
            EFCController result = con.newInstance(this, param);
            result.sync(this.sysParam, this.paramList);
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }

    public void openChildWindowForEdit(Class<? extends EFCController> clazz) {
        this.openChildWindowForEdit(clazz, null);
    }

    public void openWindow(Class<? extends EFCController> clazz, Map<String, Object> param) {
        Class<? extends EFCController> loadclass = clazz;
        try {
            Constructor<? extends EFCController> con = loadclass.getConstructor(Map.class);
            EFCController result = con.newInstance(param);
            result.sync(this.sysParam, this.paramList);
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }

    public void openWindow(Class<? extends EFCController> clazz) {
        this.openWindow(clazz, null);
    }

    public void fireChildWindowSync(SysParam valueObj, Map<String, Object> valueList) {
        logger.debug("fireChildWindowSync()");
        this.viewManager.setLastFocusOwner(this.getFocusOwner());
        List childList = this.childs.stream().filter(cont -> cont.view instanceof EFCInternalFrameView && !cont.view.isDialogView()).collect(Collectors.toList());
        if (!childList.isEmpty()) {
            CountDownLatch latch = new CountDownLatch(childList.size());
            ExecutorService executor = Executors.newFixedThreadPool(childList.size());
            new EFCMainSyncSwingWorker(this, this, latch, executor).execute();
            for (EFCController controller : childList) {
                controller.sync(valueObj, valueList, latch, executor);
            }
        }
    }

    public void fireChildWindowActionActualizeObject() {
        logger.debug("fireChildWindowActionActualizeObject()");
        this.viewManager.setLastFocusOwner(this.getFocusOwner());
        if (this.childs != null && !this.childs.isEmpty()) {
            for (EFCController controller : this.childs) {
                if (!(controller.getView() instanceof EFCInternalFrameView)) continue;
                controller.actionActualizeObject();
            }
        }
    }

    public void fireParentWindowSync(SysParam valueObj, Map<String, Object> valueList) {
        this.viewManager.setLastFocusOwner(this.getFocusOwner());
        if (this.parentController != null) {
            this.parentController.sync(valueObj, valueList);
        }
    }

    @Override
    public boolean isClosingAllowed() throws ActionNotAllowedException {
        if (this.view.isDialogView()) {
            return true;
        }
        return this.isObjSaved();
    }

    public boolean isObjEditable() {
        return true;
    }

    protected boolean isListAddAllowed(String tableIdent) {
        return true;
    }

    protected boolean isListRemoveAllowed(String tableIdent) {
        return true;
    }

    public void showWarningDlg(String message) {
        this.showWarningDlg(message, Translator.tr((String)"DLG_TITLE_WARNING"));
    }

    public void showWarningDlg(String message, String title) {
        EFCDesktop.showWarningDlg(message, title);
    }

    public void showErrorDlg(String message) {
        this.showErrorDlg(message, Translator.tr((String)"DLG_TITLE_ERROR"));
    }

    public void showErrorDlg(String message, String title) {
        EFCDesktop.showErrorDlg(message, title);
    }

    public void showExceptionDlg(Throwable e) {
        EFCDesktop.reportError(e);
    }

    public void showExceptionDlg(String message, Throwable e) {
        EFCDesktop.reportError(message, e);
    }

    public int showYesNoDlg(Object message, String title, int defaultButton) {
        return EFCDesktop.showYesNoDlg(message, title, defaultButton);
    }

    public int showYesNoDlg(Object message, String title) {
        return EFCDesktop.showYesNoDlg(message, title);
    }

    public void showInfoDlg(Object message) {
        this.showInfoDlg(message, Translator.tr((String)"DLG_TITLE_INFO"));
    }

    public void showInfoDlg(Object message, String title) {
        this.showInfoDlg(message, title, this.showInfoForSeconds);
    }

    public void showInfoDlg(Object message, String title, Integer showForSeconds) {
        EFCDesktop.showInfoDlg(message, title, showForSeconds);
    }

    public void showInfoDlg(Object message, String title, Integer showForSeconds, Integer disableCloseForSeconds) {
        EFCDesktop.showInfoDlg(message, title, showForSeconds, disableCloseForSeconds);
    }

    public String showInputDlg(String label, String title) {
        return JOptionPane.showInputDialog(EFCDesktop.getInstance(), label, title, 3);
    }

    public int showYesNoCancelDlg(String message, String title, int defaultButton) {
        return EFCDesktop.showYesNoCancelDlg(message, title, defaultButton);
    }

    public int showYesNoCancelDlg(String message, String title) {
        return EFCDesktop.showYesNoCancelDlg(message, title);
    }

    public int showOkCancelDlg(String message, String title, int defaultButton) {
        return EFCDesktop.showOkCancelDlg(message, title, defaultButton);
    }

    public int showOkCancelDlg(String message, String title) {
        return EFCDesktop.showOkCancelDlg(message, title);
    }

    public int showOptionDlg(String message, String title, Object[] options, int defaultButton) {
        return EFCDesktop.showOptionDlg(message, title, options, defaultButton);
    }

    public int showOptionDlg(String message, String title, Object[] options) {
        return EFCDesktop.showOptionDlg(message, title, options);
    }

    public void showMessageDlg(Msg message) {
        if (message == null) {
            return;
        }
        String title = Translator.tr((String)"DLG_TITLE_INFO");
        switch (message.getType()) {
            case WARNING: {
                title = Translator.tr((String)"DLG_TITLE_WARNING");
                EFCDesktop.showWarningDlg(message.getMsg(), title);
                break;
            }
            case ERROR: {
                title = Translator.tr((String)"DLG_TITLE_ERROR");
                EFCDesktop.showErrorDlg(message.getMsg(), title);
                break;
            }
            case FATAL: {
                title = Translator.tr((String)"DLG_TITLE_FATAL");
                EFCDesktop.showErrorDlg(message.getMsg(), title);
                break;
            }
            default: {
                EFCDesktop.showInfoDlg(message.getMsg(), title);
            }
        }
    }

    public void showMessageDlg(List<Msg> messages) {
        if (messages == null || messages.size() == 0) {
            return;
        }
        if (!this.isInfoMsg().booleanValue() && messages.stream().allMatch(msg -> msg.getType() == MsgType.INFO)) {
            return;
        }
        if (!this.isWarnMsg().booleanValue() && messages.stream().noneMatch(msg -> msg.getType() == MsgType.ERROR || msg.getType() == MsgType.FATAL) && messages.stream().anyMatch(msg -> msg.getType() == MsgType.WARNING)) {
            return;
        }
        EFCMessageListDialog messageDlg = new EFCMessageListDialog((Frame)EFCMainFrame.getInstance(), true);
        messageDlg.show(messages);
    }

    public void showMessageDlg(MsgList messages) {
        if (messages == null) {
            return;
        }
        this.showMessageDlg(messages.getMsgList());
    }

    public void reportError(Throwable e) {
        EFCDesktop.reportError(e.getClass().getSimpleName() + ": " + e.getMessage(), e);
    }

    public void reportError(String message, Throwable e) {
        EFCDesktop.reportError(message, e);
    }

    public String getPrintListId() {
        return this.printListId;
    }

    public void setPrintListId(String printListId) {
        this.printListId = printListId;
    }

    public void setObjectState(EFCObjectState state) {
        this.objectState = state;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!EFCController.this.view.isDialogView()) {
                    Label statusLabel = EFCController.this.getEfcStatusBar().getTextField(1);
                    switch (EFCController.this.objectState) {
                        case DEFAULT: {
                            statusLabel.setText("");
                            break;
                        }
                        case DELETED: {
                            statusLabel.setText(Translator.tr((String)"DLG_OBJECT_STATE_DELETED"));
                            statusLabel.setTextFill((Paint)javafx.scene.paint.Color.RED);
                            break;
                        }
                        case NEW: {
                            statusLabel.setText(Translator.tr((String)"DLG_OBJECT_STATE_NEW"));
                            statusLabel.setTextFill((Paint)javafx.scene.paint.Color.BLACK);
                            break;
                        }
                        case TIMER: {
                            statusLabel.setText(Translator.tr((String)"DLG_OBJECT_STATE_TIMER"));
                            statusLabel.setTextFill((Paint)javafx.scene.paint.Color.RED);
                        }
                    }
                }
            }
        });
    }

    public EFCObjectState getObjectState() {
        return this.objectState;
    }

    @Override
    public EFCMainMenu getMainMenu() {
        return this.viewManager.getMainMenu();
    }

    @Override
    public EFCToolBar getMainToolbar() {
        return this.viewManager.getMainMenu().getToolBar();
    }

    public void lockControl() {
        this.lockControl(true);
    }

    public void lockControl(boolean lockChilds) {
        this.view.lockFrame();
        if (lockChilds && !this.childs.isEmpty()) {
            logger.debug("Locking childs");
            for (EFCController child : this.childs) {
                child.getView().lockFrame();
            }
        }
        logger.debug("Lock " + this.toString());
    }

    public void unlockControl() {
        this.unlockControl(true);
    }

    public void unlockControl(boolean unlockParent) {
        for (EFCController controller : this.childs) {
            if (!controller.isControlLocked()) continue;
            controller.getView().unlockFrame();
        }
        this.view.unlockFrame();
        if (unlockParent && this.parentController != null && this.parentController.dialogFrame == null) {
            this.parentController.getView().unlockFrame();
            logger.debug("unLock parent " + this.parentController.toString());
        }
        logger.debug("unLock " + this.toString());
    }

    public boolean isControlLocked() {
        return this.controlLocked;
    }

    public void setControlLocked(boolean controlLocked) {
        this.controlLocked = controlLocked;
    }

    protected EFCStatusBar getEfcStatusBar() {
        return this.view.getEFCStatusBar();
    }

    public void setStatusText(String text) {
        this.view.getEFCStatusBar().setStatusText(text);
    }

    public String getStatusText() {
        return this.view.getEFCStatusBar().getText();
    }

    public void setActualTitleText(String text) {
        if (text == null) {
            this.view.setTitle(this.title);
        } else {
            this.view.setTitle(this.title + " " + text);
        }
    }

    public void setTitle(String title) {
        this.title = title;
        this.view.setTitle(title);
    }

    public EFCController[] getChilds() {
        return this.childs.toArray(new EFCController[0]);
    }

    public Component getFocusOwner() {
        if (this.view == null) {
            return null;
        }
        return this.view.getFocusOwner();
    }

    public void addChild(EFCController child) {
        this.childs.add(child);
    }

    public boolean removeChild(EFCController child) {
        return this.childs.remove(child);
    }

    public void addSearchFrame(EFCSearchFrame searchFrame) {
        this.searchFrames.add(searchFrame);
    }

    public void removeSearchFrame(EFCSearchFrame searchFrame) {
        this.searchFrames.remove(searchFrame);
    }

    public void setFrameIcon(Icon icon) {
        this.view.setFrameIcon(icon);
    }

    public void setFrameIcon(boolean hasIcon) {
        for (EFCController controller : this.childs) {
            EFCInternalFrameView cView = controller.getView();
            try {
                cView.setIcon(hasIcon);
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        }
        if (this.parentController != null) {
            try {
                this.parentController.getView().setIcon(hasIcon);
            }
            catch (PropertyVetoException ex) {
                ex.printStackTrace();
            }
        }
    }

    public boolean isHandlingEvents() {
        return this.handlingEvents;
    }

    public void setHandlingEvents(boolean handlingEvents) {
        this.handlingEvents = handlingEvents;
    }

    public EFCController getParentController() {
        return this.parentController;
    }

    public EFCInternalFrameView getView() {
        return this.view;
    }

    public EnumSet<EFCAction> getMenu() {
        return this.menu;
    }

    protected void addHandleChangedFields(String ... fieldIdents) {
        for (String ident : fieldIdents) {
            this.handleChangedFields.add(ident);
        }
    }

    protected void terminate() {
        block17: {
            boolean allowed = true;
            while (this.searchFrames.size() > 0) {
                this.searchFrames.get(0).dispose();
            }
            if (this.parentController != null) {
                this.parentController.removeChild(this);
            }
            try {
                for (EFCController controller : this.childs) {
                    allowed = allowed && controller.isClosingAllowed();
                }
            }
            catch (ActionNotAllowedException anae) {
                if (!anae.isNotified()) {
                    this.showWarningDlg(anae.getMessage(), Translator.tr((String)"MSG_FRAME_ACTION_NOT_ALLOWED_TITLE"));
                    anae.notified();
                }
                return;
            }
            if (allowed) {
                for (int i = 0; i < this.childs.size(); ++i) {
                    try {
                        EFCInternalFrameView efcView;
                        EFCController controller;
                        controller = this.childs.get(i);
                        if (controller.getChilds().length != 0) {
                            for (EFCController childController : controller.getChilds()) {
                                childController.closeDialog();
                            }
                        }
                        if (!((efcView = controller.getView()) instanceof EFCInternalFrameView)) continue;
                        efcView.dispose();
                        controller.getViewManager().terminate();
                        this.childs.remove(i);
                        controller = null;
                        --i;
                        continue;
                    }
                    catch (Exception ex) {
                        logger.error("closing error: " + ex.getMessage());
                        allowed = false;
                    }
                }
            }
            if (allowed) {
                try {
                    if (this.isClosingAllowed()) {
                        if (this.printSelectionDialog != null) {
                            this.printSelectionDialog.getActionHandler().handleAction("exit", null);
                            this.printSelectionDialog = null;
                        }
                        this.view.dispose();
                        EFCDesktop.getInstance().remove(this.view);
                        this.viewManager.terminate();
                        this.view = null;
                        this.panel.removeAll();
                        this.parentController = null;
                        this.dialogFrame = null;
                        this.terminateDataChangeManager();
                        this.mainEventHandler.terminate();
                    }
                }
                catch (ActionNotAllowedException ex) {
                    if (ex.isNotified()) break block17;
                    this.showWarningDlg(ex.getMessage(), Translator.tr((String)"MSG_FRAME_ERROR_ACTION_NOT_ALLOWED_TITLE"));
                    ex.notified();
                }
            }
        }
    }

    public EFCBaseViewManager getViewManager() {
        return this.viewManager;
    }

    public EFCPrintSelectionDialog getPrintSelectionDialog() {
        return this.printSelectionDialog;
    }

    public void setPrintSelectionDialog(EFCPrintSelectionDialog printSelectionDialog) {
        this.printSelectionDialog = printSelectionDialog;
    }

    @Override
    public void handleBusinessTableSelectionChanged(String tableIdent, String columnName, BusinessObject selectedObject) {
        logger.debug("handleBusinessTableSelectionChanged(" + tableIdent + "," + columnName + ")");
        this.tableSelectFocusWorkaround();
        this.refreshFields(tableIdent + ".");
        String oldIdent = this.getLastActiveIdent();
        this.setLastActiveIdent(tableIdent);
        this.view.fireChangeEvent("lastfield", oldIdent, this.viewManager.getLastActiveIdent());
    }

    public abstract void onSubPanelDataLoading(String var1);

    public abstract void onSubPanelDataLoadFinished(String var1);

    public abstract void resetPanels();

    @Override
    public void handleFrameScrollSearchAction(String ident, String value) {
        this.newOrderField = ident.toUpperCase();
        this.scrollValue = value;
        this.actionNext();
    }

    public Thread getSaveWorker() {
        return this.saveThreadUtil != null ? this.saveThreadUtil.getActiveWorker() : null;
    }

    public Thread getActiveWorker() {
        return this.activeThreadUtil != null ? this.activeThreadUtil.getActiveWorker() : null;
    }

    public EFCMap<String, Boolean> getMenuBlackListMap() {
        return this.menuBlackListMap;
    }

    public void setMenuBlackListMap(EFCMap<String, Boolean> menuBlackListMap) {
        this.menuBlackListMap = menuBlackListMap;
    }

    public List<String> getHandleChangedFields() {
        return this.handleChangedFields;
    }

    public EFCThreadUtil handleOutside(Closure<?> ... closures) {
        return this.handleOutside(true, (EFCGraphPanel)null, closures);
    }

    public BusinessObjectModel getBusinessObjectModel() {
        return this.businessObjectModel;
    }

    public EFCThreadUtil handleOutside(boolean autolockFrame, Closure<?> ... closures) {
        return this.handleOutside(EFCThreadUtil.builder(), autolockFrame, null, closures);
    }

    public EFCThreadUtil handleOutside(boolean autolockFrame, EFCGraphPanel graph, Closure<?> ... closures) {
        return this.handleOutside(EFCThreadUtil.builder(), true, graph, closures);
    }

    public EFCThreadUtil handleOutside(EFCGraphPanel graph, Closure<?> ... closures) {
        return this.handleOutside(EFCThreadUtil.builder(), true, graph, closures);
    }

    public EFCThreadUtil handleOutside(EFCThreadUtil th, Closure<?> ... closures) {
        return this.handleOutside(th, true, null, closures);
    }

    public EFCThreadUtil handleOutside(EFCThreadUtil th, boolean autolockFrame, EFCGraphPanel graph, Closure<?> ... closures) {
        return th.doOutside(() -> {
            try {
                th.edt(() -> {
                    if (autolockFrame && !this.checkLastInputValueChanged.booleanValue()) {
                        if (graph != null) {
                            graph.setLocked(true);
                        }
                        this.lockFrame();
                    }
                });
                for (int index = 0; index < closures.length; ++index) {
                    closures[index].call((Object)th);
                }
            }
            catch (ApplicationException aex) {
                this.showMessageDlg(aex.getMsgList());
                logger.error("", (Throwable)aex);
            }
            catch (Throwable t) {
                EFCDesktop.reportError(t);
            }
            finally {
                th.edt(() -> {
                    if (autolockFrame && !this.checkLastInputValueChanged.booleanValue()) {
                        if (graph != null) {
                            graph.setLocked(false);
                        }
                        this.unLockFrame();
                    }
                    this.notifyCheckLastInputValueChanged();
                });
            }
        });
    }

    public void onParamContextChanged(String elementIdent, String tableIdent, String tableColName, BusinessObject selectedTableObject, String tabIdent) {
    }
}

