/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components;

import de.effectivecompany.gui.components.EFCController;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import javax.swing.SwingWorker;

public class EFCMainSyncSwingWorker
extends SwingWorker<Object, Object> {
    private CountDownLatch latch;
    private EFCController parent;
    private EFCController root;
    private ExecutorService executorService;

    public EFCMainSyncSwingWorker(EFCController root, EFCController parent, CountDownLatch latch, ExecutorService executorService) {
        this.latch = latch;
        this.parent = parent;
        this.root = root;
        this.executorService = executorService;
        if (this.parent != null) {
            this.parent.lockFrame();
        }
        if (root != null) {
            this.root.lockFrame();
        }
    }

    @Override
    protected Void doInBackground() throws Exception {
        this.latch.await();
        return null;
    }

    @Override
    protected void done() {
        try {
            this.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.parent.handleException(e);
        }
        finally {
            if (this.parent != null) {
                this.parent.unLockFrame();
            }
            if (this.root != null && (this.root.childs == null || this.root.childs.isEmpty())) {
                this.root.unLockFrame(true, false);
            }
            this.latch = null;
            this.executorService.shutdown();
            this.executorService = null;
        }
    }
}

