/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.EFCStatusBar;
import de.effectivecompany.gui.components.ProgressTask;
import de.effectivecompany.gui.components.TaskViewPanel;
import de.effectivecompany.gui.components.root.EFCMainFrame;
import de.effectivecompany.gui.events.ProgressEvent;
import de.effectivecompany.gui.events.util.EFCEventBus;
import de.effectivecompany.progress.ProgressService;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.application.Platform;
import javafx.collections.ListChangeListener;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.stage.Popup;
import javafx.stage.Window;
import org.controlsfx.control.TaskProgressView;

public class EFCTaskProgressView
extends Popup {
    private EFCMap<Long, ProgressTask> runningProgs = new EFCMap();
    private TaskProgressView<ProgressTask> taskView = new TaskProgressView<ProgressTask>(){

        protected Skin<?> createDefaultSkin() {
            return new TaskViewPanel<ProgressTask>(this);
        }
    };
    private static EFCTaskProgressView instance;
    private CheckProgressTask checkProgressTask = new CheckProgressTask(this);
    private ProgressService progressService = (ProgressService)SpringHelper.getService(ProgressService.class);
    private ExecutorService exec = Executors.newCachedThreadPool(r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        return t;
    });

    private EFCTaskProgressView() {
        this.setAutoHide(true);
        this.setHideOnEscape(true);
        this.setAutoFix(true);
        Timer timer = new Timer("check-progress-timer");
        timer.scheduleAtFixedRate((TimerTask)this.checkProgressTask, 60000L, 300000L);
        this.taskView.getTasks().addListener((ListChangeListener)new ListChangeListener<ProgressTask>(){

            public void onChanged(ListChangeListener.Change<? extends ProgressTask> c) {
                if (c.getList().isEmpty()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            EFCMainFrame.getInstance().getPanel().getStatusBar().setProgress(0.0);
                        }
                    });
                } else {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            EFCMainFrame.getInstance().getPanel().getStatusBar().setProgress(-1.0);
                        }
                    });
                }
            }
        });
        this.getContent().add(this.taskView);
        EFCEventBus.getInstance().register((Object)this);
    }

    public static EFCTaskProgressView getInstance() {
        if (instance == null) {
            instance = new EFCTaskProgressView();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    @AllowConcurrentEvents
    public void onProgressEvent(ProgressEvent event) {
        if (this.runningProgs.containsKey((Object)event.getProgress().getMsgId())) {
            ProgressTask taskProg = (ProgressTask)((Object)this.runningProgs.get((Object)event.getProgress().getMsgId()));
            if (taskProg != null) {
                taskProg.setProgress(event.getProgress());
                if (event.getProgress().isFinished()) {
                    ProgressTask progressTask = taskProg;
                    synchronized (progressTask) {
                        ((Object)((Object)taskProg)).notify();
                        this.runningProgs.remove((Object)event.getProgress().getMsgId());
                    }
                }
            }
        } else {
            final ProgressTask task = new ProgressTask(event.getProgress());
            this.runningProgs.put((Object)event.getProgress().getMsgId(), (Object)task);
            this.exec.submit((Runnable)((Object)task));
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    EFCTaskProgressView.this.taskView.getTasks().add((Object)task);
                }
            });
        }
    }

    public EFCMap<Long, ProgressTask> getRunningProgs() {
        return this.runningProgs;
    }

    public void toggleIsVisible(Event event) {
        if (!this.isShowing()) {
            EFCStatusBar statusBar = EFCMainFrame.getInstance().getPanel().getStatusBar();
            Window window = ((Node)event.getSource()).getScene().getWindow();
            double posX = window.getWidth() - this.getWidth();
            double posY = window.getY() - this.getHeight();
            this.show((Node)statusBar, posX, posY);
        } else {
            this.hide();
        }
    }

    private class CheckProgressTask
    extends TimerTask {
        private EFCTaskProgressView tpv;

        public CheckProgressTask(EFCTaskProgressView tpv) {
            this.tpv = tpv;
        }

        @Override
        public void run() {
            this.tpv.getRunningProgs().entrySet().forEach(entry -> {
                double progress = EFCTaskProgressView.this.progressService.getProgressPercent(((Long)entry.getKey()).longValue());
                if (progress == 0.0) {
                    EFCTaskProgressView.this.runningProgs.remove(entry.getKey());
                    ((ProgressTask)((Object)((Object)entry.getValue()))).cancel();
                }
            });
        }
    }
}

