/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.edgeicon;

import de.effectivecompany.gui.components.edgeicon.EIDrawer;
import de.effectivecompany.gui.interfaces.element.EdgeIconComponent;
import java.awt.Graphics;
import java.text.Format;
import javax.swing.ImageIcon;
import javax.swing.JFormattedTextField;

public class EIFormattedTextField
extends JFormattedTextField
implements EdgeIconComponent {
    private static final long serialVersionUID = -3146545175048225665L;
    private ImageIcon[] edgeIcons = new ImageIcon[4];
    private boolean edgeIconsVisible = true;

    public EIFormattedTextField() {
    }

    public EIFormattedTextField(Object value) {
        super(value);
    }

    public EIFormattedTextField(Format format) {
        super(format);
    }

    public EIFormattedTextField(JFormattedTextField.AbstractFormatter formatter) {
        super(formatter);
    }

    public EIFormattedTextField(JFormattedTextField.AbstractFormatterFactory factory) {
        super(factory);
    }

    public EIFormattedTextField(JFormattedTextField.AbstractFormatterFactory factory, Object currentValue) {
        super(factory, currentValue);
    }

    @Override
    public ImageIcon getEdgeIcon(int edge) {
        return this.edgeIcons[edge - 1];
    }

    @Override
    public void setEdgeIcon(ImageIcon icon, int edge) {
        this.edgeIcons[edge - 1] = icon;
    }

    @Override
    public boolean isEdgeIconVisible() {
        return this.edgeIconsVisible;
    }

    @Override
    public void setEdgeIconVisible(boolean visible) {
        this.edgeIconsVisible = visible;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.edgeIconsVisible) {
            g.translate(0, 0);
            EIDrawer.drawEdgeIcons(this.edgeIcons, g, this, this);
        }
    }
}

