/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor;

import de.effectivecompany.gui.actions.EFCActionSave;
import de.effectivecompany.gui.components.editor.interfaces.EditorMetaData;
import de.effectivecompany.gui.components.editor.metadata.EdMetaData;
import de.effectivecompany.gui.data.BusinessObjectModel;
import de.effectivecompany.gui.events.FocusChangeEvent;
import de.effectivecompany.gui.events.UserInputEvent;
import de.effectivecompany.gui.events.ValueChangeEvent;
import de.effectivecompany.gui.interfaces.element.EditorComponent;
import de.effectivecompany.gui.interfaces.listeners.FocusChangeListener;
import de.effectivecompany.gui.interfaces.listeners.UserInputListener;
import de.effectivecompany.gui.interfaces.listeners.UserInteractionListener;
import de.effectivecompany.gui.interfaces.listeners.ValueChangeListener;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EFCAbstractEditor
extends JPanel
implements EditorComponent {
    private static Logger logger = LoggerFactory.getLogger(EFCAbstractEditor.class);
    private static final long serialVersionUID = -7725782435966821666L;
    private String ident;
    private Class<?> returnTypeClass;
    private BusinessObjectModel businessObjectModel;
    private boolean modified;
    private Vector<FocusChangeListener> focusChangeListener = new Vector(3);
    private Vector<ValueChangeListener> valueChangeListener = new Vector(3);
    private Vector<UserInputListener> userInputListener = new Vector(3);
    private Vector<UserInteractionListener> userActionListener = new Vector(3);
    protected boolean doFocusHandling = true;
    protected int emptyStrategy = -1;
    protected JLabel linkedLabel;
    protected EditorMetaData.EditorMetadata metaData;
    protected int editorSizing;
    private boolean linkedWithObject;
    protected Object originalValue;
    protected String simpleOriginalValue;
    protected boolean isScrollMode;
    protected String scbchrkey;

    public boolean handleDataChange() {
        String text = this.getValue() != null ? this.getValue().toString() : "";
        if (!text.equals(this.getOriginalValue() != null ? this.getOriginalValue().toString() : "")) {
            if (this.businessObjectModel != null) {
                this.businessObjectModel.setLastSelectedListItemIndex();
            }
            this.fireValueChangeEvent(this.getIdent(), this.getOriginalValue(), this.getValue());
            logger.debug("content changed in field: {} value: {}", (Object)this.getIdent(), (Object)text);
            return true;
        }
        return false;
    }

    public EFCAbstractEditor(String ident, String scbchrkey) {
        this(ident);
        this.scbchrkey = scbchrkey;
    }

    public EFCAbstractEditor(String ident) {
        this.ident = ident;
        this.metaData = new EdMetaData(this);
    }

    protected void initComponents() {
    }

    @Override
    public void setReturnTypeClass(Class<?> typeClass) {
        this.returnTypeClass = typeClass;
    }

    @Override
    public Class<?> getReturnTypeClass() {
        return this.returnTypeClass;
    }

    @Override
    public void addValueChangeListener(ValueChangeListener listener) {
        this.valueChangeListener.add(listener);
    }

    @Override
    public ValueChangeListener[] getValueChangeListeners() {
        return this.valueChangeListener.toArray(new ValueChangeListener[0]);
    }

    @Override
    public void removeValueChangeListener(ValueChangeListener listener) {
        this.valueChangeListener.remove(listener);
    }

    @Override
    public void fireValueChangeEvent(String srcIdent, Object oldValue, Object newValue) {
        this.changeEvent(srcIdent, oldValue, newValue, 2019);
    }

    @Override
    public void fireValueResetEvent(String srcIdent, Object oldValue, Object newValue) {
        this.changeEvent(srcIdent, oldValue, newValue, 2020);
    }

    private void changeEvent(String srcIdent, Object oldValue, Object newValue, int eventID) {
        ValueChangeEvent event = new ValueChangeEvent(this, eventID, srcIdent, oldValue, newValue, this.scbchrkey);
        for (ValueChangeListener l : this.getValueChangeListeners()) {
            l.onValueChanged(event);
        }
    }

    @Override
    public void addFocusChangeListener(FocusChangeListener listener) {
        this.focusChangeListener.add(listener);
    }

    @Override
    public FocusChangeListener[] getFocusChangeListeners() {
        return this.focusChangeListener.toArray(new FocusChangeListener[0]);
    }

    @Override
    public void removeFocusChangeListener(FocusChangeListener listener) {
        this.focusChangeListener.remove(listener);
    }

    @Override
    public void fireFocusGainedEvent(String srcIdent) {
        this.changeFocusEvent(srcIdent, 2030);
    }

    @Override
    public void fireFocusLostEvent(String srcIdent) {
        this.changeFocusEvent(srcIdent, 2029);
    }

    private void changeFocusEvent(String srcIdent, int eventID) {
        FocusChangeEvent event = new FocusChangeEvent(this, eventID, srcIdent);
        for (FocusChangeListener l : this.getFocusChangeListeners()) {
            l.onFocusChanged(event);
        }
    }

    @Override
    public void addUserInputListener(UserInputListener listener) {
        this.userInputListener.add(listener);
    }

    @Override
    public UserInputListener[] getUserInputListeners() {
        return this.userInputListener.toArray(new UserInputListener[0]);
    }

    @Override
    public void removeUserInputListener(UserInputListener listener) {
        this.userInputListener.remove(listener);
    }

    @Override
    public void fireUserInputEvent(String srcIdent, InputEvent event) {
        UserInputListener[] listeners;
        int type = 0;
        switch (event.getID()) {
            case 500: {
                type = 2059;
                break;
            }
            case 507: {
                type = 2060;
                break;
            }
            case 401: {
                type = 2061;
                break;
            }
            case 400: {
                type = 2062;
                break;
            }
            case 402: {
                type = 2063;
            }
        }
        if (type == 0) {
            return;
        }
        UserInputEvent uie = new UserInputEvent(this, type, event, srcIdent);
        for (UserInputListener listener : listeners = this.getUserInputListeners()) {
            listener.onUserInput(uie);
        }
    }

    @Override
    public void addUserInteractionListener(UserInteractionListener listener) {
        this.userActionListener.add(listener);
    }

    @Override
    public UserInteractionListener[] getUserInteractionListeners() {
        return this.userActionListener.toArray(new UserInteractionListener[0]);
    }

    @Override
    public void removeUserInteractionListener(UserInteractionListener l) {
        this.userActionListener.remove(l);
    }

    public BusinessObjectModel getBusinessObjectModel() {
        return this.businessObjectModel;
    }

    public void setBusinessObjectModel(BusinessObjectModel boModel) {
        this.businessObjectModel = boModel;
    }

    public void setEditorSizing(int sizeing) {
        this.editorSizing = sizeing;
    }

    public int getEditorSizing() {
        return this.editorSizing;
    }

    @Override
    public EditorMetaData.EditorMetadata getMetadata() {
        return this.metaData;
    }

    @Override
    public String getIdent() {
        return this.ident;
    }

    @Override
    public void setIdent(String ident) {
        this.ident = ident;
    }

    @Override
    public void setEmptyStrategy(int emptyStrategy) {
        this.emptyStrategy = emptyStrategy;
    }

    @Override
    public int getEmptyStrategy() {
        return this.emptyStrategy;
    }

    @Override
    public void setLinkedLabel(JLabel linkedlabel) {
        this.linkedLabel = linkedlabel;
    }

    @Override
    public JLabel getLinkedLabel() {
        return this.linkedLabel;
    }

    @Override
    public void setEditable(boolean editable) {
        JComponent editor = this.getEditorComponent();
        if (editor instanceof JTextComponent) {
            ((JTextComponent)editor).setEditable(editable);
        }
    }

    @Override
    public boolean isEditable() {
        JComponent editor = this.getEditorComponent();
        if (editor instanceof JTextComponent) {
            return ((JTextComponent)editor).isEditable();
        }
        return true;
    }

    @Override
    public void setEnabled(boolean enabled) {
        JComponent editor = this.getEditorComponent();
        if (this.getMetadata().isReadOnly()) {
            return;
        }
        this.setEditable(enabled);
        if (editor instanceof JTextComponent) {
            ((JTextComponent)editor).setEditable(enabled);
        } else if (editor instanceof JComponent) {
            editor.setEnabled(enabled);
        }
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (this.linkedLabel != null) {
            this.linkedLabel.setVisible(aFlag);
        }
        super.setVisible(aFlag);
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void setModified(boolean modified) {
        this.modified = modified;
    }

    protected void setComponentStyle(JComponent component) {
        if (this.isEditable() && !this.getMetadata().isReadOnly()) {
            component.setForeground(SystemColor.BLACK);
            component.setBackground(SystemColor.window);
        } else {
            component.setForeground(SystemColor.GRAY);
            component.setBackground(SystemColor.control);
        }
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).setDisabledTextColor(component.getForeground());
        }
    }

    public void undo() {
        throw new UnsupportedOperationException("undo not implemented for " + this.getClass().getSimpleName());
    }

    public void redo() {
        throw new UnsupportedOperationException("redo not implemented for " + this.getClass().getSimpleName());
    }

    @Override
    public void setEdgeImage(ImageIcon img, int edge) {
        throw new UnsupportedOperationException("no edge image support for " + this.getClass().getSimpleName());
    }

    public boolean isFocusHandling() {
        return this.doFocusHandling;
    }

    public void setFocusHandling(boolean handle) {
        this.doFocusHandling = handle;
    }

    @Override
    public abstract JComponent getEditorComponent();

    public void setEditorComponent() {
    }

    @Override
    public boolean isLinkedWithObject() {
        return this.linkedWithObject;
    }

    @Override
    public void setLinkedWithObject(boolean linkedWithObject) {
        this.linkedWithObject = linkedWithObject;
    }

    public String getSimpleOriginalValue() {
        return this.simpleOriginalValue;
    }

    @Override
    public Object getOriginalValue() {
        return this.originalValue;
    }

    @Override
    public void terminate() {
        this.removeAll();
        this.metaData = null;
        this.linkedLabel = null;
        this.businessObjectModel = null;
        this.originalValue = null;
        this.simpleOriginalValue = null;
    }

    public static Logger getLogger() {
        return logger;
    }

    public boolean isScrollMode() {
        return this.isScrollMode;
    }

    public void setScrollMode(boolean isScrollMode) {
        this.isScrollMode = isScrollMode;
    }

    protected class TextFieldFocusChangeHandler
    extends FocusChangeHandler {
        protected TextFieldFocusChangeHandler() {
        }

        @Override
        public void focusGained(FocusEvent event) {
            if (!EFCAbstractEditor.this.doFocusHandling) {
                return;
            }
            super.focusGained(event);
        }

        @Override
        public void focusLost(FocusEvent event) {
            if (!EFCAbstractEditor.this.doFocusHandling || event.getOppositeComponent() instanceof JButton && ((JButton)event.getOppositeComponent()).getAction() instanceof EFCActionSave) {
                return;
            }
            EFCAbstractEditor.this.handleDataChange();
            super.focusLost(event);
        }
    }

    protected class FocusChangeHandler
    implements FocusListener {
        protected FocusChangeHandler() {
        }

        @Override
        public void focusGained(FocusEvent event) {
            if (!EFCAbstractEditor.this.doFocusHandling) {
                return;
            }
            EFCAbstractEditor.this.fireFocusGainedEvent(EFCAbstractEditor.this.getIdent());
            if (EFCAbstractEditor.this.businessObjectModel != null) {
                EFCAbstractEditor.this.businessObjectModel.setLastSelectedListItemIndex();
            }
        }

        @Override
        public void focusLost(FocusEvent event) {
            if (!EFCAbstractEditor.this.doFocusHandling) {
                return;
            }
            EFCAbstractEditor.this.fireFocusLostEvent(EFCAbstractEditor.this.getIdent());
            if (EFCAbstractEditor.this.businessObjectModel != null) {
                EFCAbstractEditor.this.businessObjectModel.setLastSelectedListItemIndex();
            }
        }
    }

    protected class UserInputHandler
    extends MouseAdapter
    implements KeyListener {
        private String ident;

        public UserInputHandler(String ident) {
            this.ident = ident;
        }

        @Override
        public void keyTyped(KeyEvent event) {
            EFCAbstractEditor.this.fireUserInputEvent(this.ident, event);
        }

        @Override
        public void keyPressed(KeyEvent event) {
            EFCAbstractEditor.this.fireUserInputEvent(this.ident, event);
        }

        @Override
        public void keyReleased(KeyEvent event) {
            EFCAbstractEditor.this.fireUserInputEvent(this.ident, event);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            EFCAbstractEditor.this.fireUserInputEvent(this.ident, event);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent event) {
            EFCAbstractEditor.this.fireUserInputEvent(this.ident, event);
        }
    }
}

