/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor;

import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.gui.components.edgeicon.EITextField;
import de.effectivecompany.gui.components.editor.EFCAbstractEditor;
import de.effectivecompany.gui.components.editor.EFCAbstractPrimaryEditor;
import de.effectivecompany.gui.components.editor.interfaces.EFCColumnEditor;
import de.effectivecompany.gui.data.BusinessObjectModel;
import de.effectivecompany.gui.factory.EFCPanelSingleton;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.UnitConverter;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelListener;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.EventListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EFCAbstractNumberEditor
extends EFCAbstractPrimaryEditor
implements EFCColumnEditor {
    private static Logger logger = LoggerFactory.getLogger(EFCAbstractNumberEditor.class);
    private static final long serialVersionUID = -15223L;
    private DecimalFormat format;
    protected EITextField textField;

    public EFCAbstractNumberEditor(String ident, boolean info, boolean dropDownButtonEnabled) {
        super(ident, info, dropDownButtonEnabled, null, true);
    }

    public EFCAbstractNumberEditor(String ident, BusinessObjectModel boModel, boolean info, boolean dropDownButtonEnabled, int size, int width, String label, boolean withLabel) {
        this(ident, boModel, info, dropDownButtonEnabled, size, width, label, withLabel, null);
    }

    public EFCAbstractNumberEditor(String ident, BusinessObjectModel boModel, boolean info, boolean dropDownButtonEnabled, int size, int width, String label, boolean withLabel, String scbchrkey) {
        super(ident, info, dropDownButtonEnabled, label, withLabel, scbchrkey);
        this.setBusinessObjectModel(boModel);
        this.initColumns(width, size);
    }

    @Override
    public void initColumns(int width, int size) {
        if (size > 0) {
            this.setColumns(size);
        }
        int charSize = 3 + (width - 1) * 14;
        charSize = this.setCharsize(width, charSize);
        if (this.getColumns() > charSize) {
            this.setColumns(charSize);
        }
    }

    @Override
    protected void initComponents() {
        DecimalFormatSymbols formatSymbols;
        super.initComponents();
        EFCAbstractEditor.TextFieldFocusChangeHandler focusListener = new EFCAbstractEditor.TextFieldFocusChangeHandler();
        NumberUserInputHandler userInputHandler = new NumberUserInputHandler(this.getIdent());
        this.format = new DecimalFormat();
        EFCPanelSingleton.getInstance();
        if (EFCPanelSingleton.DECIMAL_SEPARATOR != null) {
            formatSymbols = this.format.getDecimalFormatSymbols();
            formatSymbols.setDecimalSeparator(EFCPanelSingleton.DECIMAL_SEPARATOR.charValue());
            this.format.setDecimalFormatSymbols(formatSymbols);
        }
        if (EFCPanelSingleton.GROUPING_SEPARATOR != null) {
            formatSymbols = this.format.getDecimalFormatSymbols();
            formatSymbols.setGroupingSeparator(EFCPanelSingleton.GROUPING_SEPARATOR.charValue());
            this.format.setDecimalFormatSymbols(formatSymbols);
        }
        this.format.setParseIntegerOnly(false);
        this.format.setRoundingMode(RoundingMode.HALF_UP);
        this.initFormat(this.format);
        this.initTextField(focusListener, userInputHandler);
        this.setEditorSizing(0);
    }

    private void initTextField(EFCAbstractEditor.TextFieldFocusChangeHandler focusListener, NumberUserInputHandler userInputHandler) {
        this.textField = new EITextField(){

            @Override
            public void setTransferHandler(TransferHandler newHandler) {
                super.setTransferHandler(new TransferHandler("text"){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
                        try {
                            String content;
                            String oldContent = content = ((JTextField)comp).getText();
                            if (EFCAbstractNumberEditor.this.format != null && EFCAbstractNumberEditor.this.format.getDecimalFormatSymbols() != null) {
                                content = content.replace(String.valueOf(EFCAbstractNumberEditor.this.format.getDecimalFormatSymbols().getGroupingSeparator()), "");
                            }
                            StringSelection stringSelection = new StringSelection(content);
                            clip.setContents(stringSelection, null);
                            logger.info("Clipboard transferable changed from: " + oldContent + " to: " + content);
                        }
                        catch (Throwable th) {
                            logger.error("", th);
                        }
                    }
                });
            }
        };
        this.textField.setHorizontalAlignment(4);
        this.textField.addFocusListener(focusListener);
        this.textField.addMouseListener(userInputHandler);
        this.textField.addMouseWheelListener(userInputHandler);
        this.textField.addKeyListener(userInputHandler);
        this.textField.setFont(EFCLookAndFeelManager.FONT_FORM);
        this.textField.setSize(this.textField.getPreferredSize());
        this.textField.setMargin(UnitConverter.createPixelFromDLUInsets(EFCLookAndFeelManager.SIZE_TEXTFIELD_INSETS, this.textField));
    }

    protected boolean isCharValid(char ch) {
        return ch == '\b' || ch == '\u007f' || ch == '\n' || ch == '\t' || Character.isDigit(ch) || ch == ',' || ch == '.' || ch == '-';
    }

    protected void initFormat(NumberFormat format) {
        format.setGroupingUsed(true);
    }

    @Override
    public void setEdgeImage(ImageIcon img, int edge) {
        this.textField.setEdgeIcon(img, edge);
    }

    protected JTextField getComponent() {
        return this.textField;
    }

    @Override
    public void setValue(Object value) {
        Double num = null;
        if (value instanceof Type) {
            value = ((Type)value).optainValue();
        }
        if (value instanceof String) {
            try {
                value = this.format.parse((String)value);
            }
            catch (ParseException ex) {
                Object object = value = "".equals(value) ? null : Double.valueOf(Double.parseDouble((String)value));
            }
        }
        if (value != null) {
            if (value instanceof Number) {
                num = ((Number)value).doubleValue();
            } else {
                try {
                    num = Double.parseDouble(value.toString());
                }
                catch (NumberFormatException e) {
                    if (this.textField != null) {
                        this.textField.setText("ERR");
                    }
                    return;
                }
            }
        }
        if (this.textField != null) {
            this.textField.setText(num == null ? "" : this.format.format(num));
        }
        this.setModified(false);
        this.fireValueResetEvent(this.getIdent(), this.getValue(), value);
        this.originalValue = this.getValue();
        this.simpleOriginalValue = this.getSimpleValue();
    }

    @Override
    public Object getValue() {
        try {
            if (this.textField != null) {
                String text = this.textField.getText().trim();
                if ("".equals(text)) {
                    return null;
                }
                return this.format.parse(text);
            }
            return null;
        }
        catch (ParseException ex) {
            logger.warn("Parse error in '{}': {}", (Object)this.getIdent(), (Object)ex.getMessage());
            return null;
        }
    }

    @Override
    public String getSimpleValue() {
        if (this.textField != null) {
            return this.textField.getText();
        }
        return "";
    }

    @Override
    public void setEditable(boolean aFlag) {
        super.setEditable(aFlag);
        this.setComponentStyle(this.textField);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setEditable(enabled && !this.getMetadata().isReadOnly());
        this.setComponentStyle(this.textField);
    }

    @Override
    public void setColumns(int columns) {
        this.textField.setColumns(columns);
    }

    @Override
    public int getColumns() {
        return this.textField.getColumns();
    }

    @Override
    public JComponent getEditorComponent() {
        return this.textField;
    }

    @Override
    public void setEditorComponent(JComponent component) {
        this.textField = (EITextField)component;
    }

    @Override
    public void terminate() {
        for (FocusListener focusListener : this.textField.getFocusListeners()) {
            this.textField.removeFocusListener(focusListener);
        }
        for (EventListener eventListener : this.textField.getMouseListeners()) {
            this.textField.removeMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : this.textField.getMouseWheelListeners()) {
            this.textField.removeMouseWheelListener((MouseWheelListener)eventListener);
        }
        for (EventListener eventListener : this.textField.getKeyListeners()) {
            this.textField.removeKeyListener((KeyListener)eventListener);
        }
        this.removeAll();
        this.textField = null;
        this.format = null;
        super.terminate();
    }

    public DecimalFormat getFormat() {
        return this.format;
    }

    protected class NumberUserInputHandler
    extends EFCAbstractEditor.UserInputHandler {
        public NumberUserInputHandler(String ident) {
            super(ident);
        }

        @Override
        public void keyPressed(KeyEvent event) {
            super.keyPressed(event);
            if (event.getKeyCode() == 40 && EFCAbstractNumberEditor.this.secondaryEditor != null && EFCAbstractNumberEditor.this.secondaryEditor.getKeyAttr() != null) {
                for (KeyListener listener : EFCAbstractNumberEditor.this.dropDownButton.getKeyListeners()) {
                    listener.keyPressed(event);
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent event) {
            if (!event.isActionKey()) {
                if (!EFCAbstractNumberEditor.this.isCharValid(event.getKeyChar())) {
                    event.consume();
                } else {
                    EFCAbstractNumberEditor.this.setModified(true);
                }
            }
            super.keyTyped(event);
        }
    }
}

