/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor;

import de.effectivecompany.base.datatypes.EFCText;
import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.gui.components.edgeicon.EITextArea;
import de.effectivecompany.gui.components.editor.EFCAbstractEditor;
import de.effectivecompany.gui.components.editor.EFCAbstractPrimaryEditor;
import de.effectivecompany.gui.components.editor.interfaces.EFCColumnEditor;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelListener;
import java.util.EventListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public abstract class EFCAbstractTextEditor
extends EFCAbstractPrimaryEditor
implements EFCColumnEditor {
    private static final long serialVersionUID = -6354L;
    protected EITextArea textArea = new EITextArea(3, 15);
    private boolean isPopup = false;

    public EFCAbstractTextEditor(String ident, boolean info, boolean dropDownButtonEnabled, String label, boolean withLabel) {
        super(ident, info, dropDownButtonEnabled, label, withLabel);
        this.setLayout(new BorderLayout());
        this.initTextArea(new EFCAbstractEditor.TextFieldFocusChangeHandler(), new TextEditorInputHandler(ident));
        this.add((Component)new JScrollPane(this.textArea), "Center");
        this.setBackground(Color.blue);
    }

    private void initTextArea(EFCAbstractEditor.TextFieldFocusChangeHandler focusListener, EFCAbstractEditor.UserInputHandler userInputHandler) {
        this.textArea.setFont(EFCLookAndFeelManager.FONT_FORM);
        this.textArea.addFocusListener(focusListener);
        this.textArea.addMouseListener(userInputHandler);
        this.textArea.addMouseWheelListener(userInputHandler);
        this.textArea.addKeyListener(userInputHandler);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.textArea.setText("");
        } else if (value instanceof Type) {
            this.textArea.setText((String)((EFCText)value).optainValue());
        } else {
            this.textArea.setText(value.toString());
        }
        this.setVisible(true);
        this.textArea.setCaretPosition(0);
        if (this.textArea.getText().trim().equals("")) {
            if (this.getEmptyStrategy() == 1) {
                this.setVisible(true);
                this.textArea.setEditable(false);
            }
            if (this.getEmptyStrategy() == 2) {
                this.setVisible(false);
                this.textArea.setEditable(false);
            }
        }
        this.originalValue = this.getValue();
        this.simpleOriginalValue = this.getSimpleValue();
    }

    @Override
    public String getSimpleValue() {
        return this.textArea.getText();
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.textArea != null) {
            this.textArea.setFont(font);
        }
    }

    @Override
    public void setEditable(boolean aFlag) {
        this.textArea.setEditable(aFlag);
        this.setComponentStyle(this.textArea);
    }

    @Override
    public boolean isEditable() {
        return this.textArea.isEditable();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setEditable(enabled && !this.getMetadata().isReadOnly());
        this.setComponentStyle(this.textArea);
    }

    @Override
    public boolean isEnabled() {
        return this.textArea.isEnabled();
    }

    @Override
    public void setEdgeImage(ImageIcon img, int edge) {
        this.textArea.setEdgeIcon(img, edge);
    }

    @Override
    public JComponent getEditorComponent() {
        return this.textArea;
    }

    @Override
    public void setEditorComponent(JComponent component) {
        this.textArea = (EITextArea)component;
    }

    @Override
    public void terminate() {
        if (this.textArea != null) {
            for (FocusListener focusListener : this.textArea.getFocusListeners()) {
                this.textArea.removeFocusListener(focusListener);
            }
            for (EventListener eventListener : this.textArea.getMouseListeners()) {
                this.textArea.removeMouseListener((MouseListener)eventListener);
            }
            for (EventListener eventListener : this.textArea.getMouseWheelListeners()) {
                this.textArea.removeMouseWheelListener((MouseWheelListener)eventListener);
            }
            for (EventListener eventListener : this.textArea.getKeyListeners()) {
                this.textArea.removeKeyListener((KeyListener)eventListener);
            }
        }
        this.removeAll();
        this.textArea = null;
        super.terminate();
    }

    public boolean isPopup() {
        return this.isPopup;
    }

    public void setPopup(boolean isPopup) {
        this.isPopup = isPopup;
    }

    @Override
    public void setColumns(int columns) {
        this.textArea.setColumns(columns);
    }

    @Override
    public int getColumns() {
        return this.textArea.getColumns();
    }

    public int getRows() {
        return this.textArea.getRows();
    }

    public void setRows(int rows) {
        this.textArea.setRows(rows);
    }

    @Override
    public void initColumns(int width, int size) {
        if (size > 0) {
            this.setColumns(size);
        }
        int charSize = 3 + (width - 1) * 14;
        charSize = this.setCharsize(width, charSize);
        if (this.getColumns() > charSize) {
            this.setColumns(charSize);
        }
        if (size > 0) {
            this.setPreferredSize((Dimension)this.getMinimumSize().clone());
        }
    }

    protected class TextEditorInputHandler
    extends EFCAbstractEditor.UserInputHandler {
        public TextEditorInputHandler(String ident) {
            super(ident);
        }

        @Override
        public void keyTyped(KeyEvent event) {
            if (event.getKeyChar() != '\t' && !event.isActionKey()) {
                EFCAbstractTextEditor.this.setModified(true);
            }
            super.keyTyped(event);
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (!EFCAbstractTextEditor.this.isPopup() && event.getKeyChar() == '\t') {
                event.consume();
                if (!event.isShiftDown()) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                } else {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
                }
            } else if (!EFCAbstractTextEditor.this.isPopup() && event.getKeyCode() == 10 && !event.isControlDown()) {
                event.consume();
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            } else if (!EFCAbstractTextEditor.this.isPopup() && event.getKeyCode() == 10 && event.isControlDown()) {
                event.setModifiers(0);
                super.keyPressed(event);
            } else {
                super.keyPressed(event);
            }
        }
    }
}

