/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor;

import com.google.gson.JsonObject;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.EFCText;
import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.gui.components.editor.EFCAbstractPrimaryEditor;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.manager.EFCPropertyManager;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefMenuModel;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefContextMenuHandlerAdapter;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefFocusHandlerAdapter;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefMessageRouterHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.HtmlUtils;

public abstract class EFCAbstractTextHtmlEditor
extends EFCAbstractPrimaryEditor {
    private static final long serialVersionUID = -3614843043082632945L;
    private static Logger logger = LoggerFactory.getLogger(EFCAbstractTextHtmlEditor.class);
    private CefClient client;
    private CefBrowser browser;
    private CefMessageRouter msgRouter;
    private boolean isLoaded = false;
    private String html;
    private boolean editable = false;
    private boolean edited = false;
    private boolean dataModified = false;

    public EFCAbstractTextHtmlEditor(String ident, boolean info, boolean dropDownButtonEnabled, String label, boolean withLabel, boolean isViewer) {
        super(ident, info, dropDownButtonEnabled, label, withLabel);
        this.setLayout(new BorderLayout());
        try {
            this.client = CefApp.getInstance().createClient();
            this.client.addDisplayHandler((CefDisplayHandler)new CefDisplayHandlerAdapter(){

                public boolean onConsoleMessage(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line) {
                    switch (level) {
                        case LOGSEVERITY_DEFAULT: 
                        case LOGSEVERITY_INFO: {
                            logger.info(message);
                            break;
                        }
                        case LOGSEVERITY_ERROR: 
                        case LOGSEVERITY_FATAL: {
                            if (message != null && !message.contains("setData is not defined")) {
                                EFCDesktop.reportError(message, null);
                                break;
                            }
                            logger.error(message);
                            break;
                        }
                        case LOGSEVERITY_WARNING: {
                            logger.warn(message);
                        }
                    }
                    return false;
                }
            });
            this.client.addLifeSpanHandler((CefLifeSpanHandler)new CefLifeSpanHandlerAdapter(){

                public boolean doClose(CefBrowser browser) {
                    browser.doClose();
                    return false;
                }
            });
            this.msgRouter = CefMessageRouter.create();
            this.msgRouter.addHandler((CefMessageRouterHandler)new CefMessageRouterHandlerAdapter(){

                public boolean onQuery(CefBrowser browser, CefFrame frame, long queryId, String request, boolean persistent, CefQueryCallback callback) {
                    logger.debug(request);
                    if (request != null && !request.isEmpty()) {
                        if (request.equals("complete")) {
                            EFCAbstractTextHtmlEditor.this.isLoaded = true;
                            EFCAbstractTextHtmlEditor.this.setLocked(false);
                            EFCAbstractTextHtmlEditor.this.fillEditor(EFCAbstractTextHtmlEditor.this.html);
                        } else {
                            EFCAbstractTextHtmlEditor.this.edited = true;
                            if (EFCAbstractTextHtmlEditor.this.getBusinessObjectModel() != null) {
                                EFCAbstractTextHtmlEditor.this.getBusinessObjectModel().setLastSelectedListItemIndex();
                            }
                            EFCAbstractTextHtmlEditor.this.fireValueChangeEvent(EFCAbstractTextHtmlEditor.this.getIdent(), new EFCText(EFCAbstractTextHtmlEditor.this.html), new EFCText(request));
                        }
                    }
                    return true;
                }
            }, true);
            this.client.addMessageRouter(this.msgRouter);
            this.client.addFocusHandler((CefFocusHandler)new CefFocusHandlerAdapter(){});
            this.client.addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

                public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                    EFCAbstractTextHtmlEditor.this.setLocked(false);
                }

                public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                    super.onLoadError(browser, frame, errorCode, errorText, failedUrl);
                    EFCAbstractTextHtmlEditor.this.setLocked(false);
                    SwingUtilities.windowForComponent(browser.getUIComponent()).validate();
                }
            });
            this.browser = this.client.createBrowser(this.getURL(), true, false);
            this.client.addContextMenuHandler((CefContextMenuHandler)new CefContextMenuHandlerAdapter(){

                public void onBeforeContextMenu(CefBrowser browser, CefFrame frame, CefContextMenuParams params, CefMenuModel model) {
                    model.clear();
                }
            });
            this.browser.createImmediately();
            this.add(this.browser.getUIComponent(), "Center");
        }
        catch (Throwable th) {
            logger.error("", th);
        }
        this.browser.loadURL(this.getURL());
    }

    public void setLocked(boolean isLocked) {
        if (isLocked) {
            this.setCursor(new Cursor(3));
        } else {
            this.setCursor(new Cursor(0));
        }
        this.browser.getUIComponent().setEnabled(!isLocked);
    }

    @Override
    public void setValue(Object value) {
        this.originalValue = this.getValue();
        this.simpleOriginalValue = this.getSimpleValue();
        if (value == null) {
            value = "";
        } else if (value instanceof Type && (value = (String)((EFCString)value).optainValue()) == null) {
            value = "";
        }
        this.html = (String)value;
        this.dataModified = true;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        if (this.dataModified && this.isLoaded && !this.edited) {
            this.fillEditor(this.html);
        }
        this.edited = false;
        super.paint(g);
    }

    private void fillEditor(String value) {
        if (this.browser != null) {
            JsonObject jsonDataEditable = new JsonObject();
            jsonDataEditable.addProperty("editable", Boolean.valueOf(this.isEditable() && !this.getMetadata().isReadOnly()));
            this.browser.executeJavaScript("setEditable(" + jsonDataEditable + ")", "", 0);
            JsonObject jsonDataObject = new JsonObject();
            jsonDataObject.addProperty("html", HtmlUtils.htmlUnescape((String)value));
            this.browser.executeJavaScript("setData(" + jsonDataObject + ")", "", 0);
            this.dataModified = false;
        }
    }

    private String getURL() {
        return EFCPropertyManager.getClientProperties().getProperty("efcserver.protocol") + "://" + EFCPropertyManager.getClientProperties().getProperty("efcserver.serverName") + ":" + EFCPropertyManager.getClientProperties().getProperty("efcserver.httpPort") + EFCPropertyManager.getClientProperties().getProperty("efcserver.contextPath") + "/resources/editor.html";
    }

    @Override
    public void terminate() {
        this.removeAll();
        this.client.removeMessageRouter(this.msgRouter);
        this.client.dispose();
    }

    public EFCText getValue() {
        return new EFCText(this.html);
    }

    @Override
    public String getSimpleValue() {
        return this.html;
    }

    @Override
    public JComponent getEditorComponent() {
        return null;
    }

    @Override
    public void setEditorComponent(JComponent component) {
    }

    @Override
    public void setEditable(boolean aFlag) {
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.editable = enabled;
        if (this.isLoaded) {
            JsonObject jsonDataObject = new JsonObject();
            jsonDataObject.addProperty("editable", Boolean.valueOf(this.isEditable() && !this.getMetadata().isReadOnly()));
            this.browser.executeJavaScript("setEditable(" + jsonDataObject + ")", "", 0);
        }
        if (this.getMetadata().isReadOnly()) {
            return;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.browser.getUIComponent().isEnabled();
    }

    public EFCText getOriginalValue() {
        return (EFCText)super.getOriginalValue();
    }
}

