/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor;

import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.EFCText;
import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.gui.components.editor.EFCAbstractEditor;
import de.effectivecompany.gui.components.editor.EFCAbstractPrimaryEditor;
import de.effectivecompany.gui.components.editor.EFCDefaultStyledDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;

public abstract class EFCAbstractTextRtfEditor
extends EFCAbstractPrimaryEditor {
    private static final long serialVersionUID = -3614843043082632945L;
    protected JTextPane textPane = new JTextPane();
    private RTFEditorKit rtfKit = new RTFEditorKit();
    private EFCDefaultStyledDocument document;
    protected boolean isChanged;

    public EFCAbstractTextRtfEditor(String ident, boolean info, boolean dropDownButtonEnabled, String label, boolean withLabel) {
        super(ident, info, dropDownButtonEnabled, label, withLabel);
        this.textPane.setEditorKit(this.rtfKit);
        this.document = new EFCDefaultStyledDocument();
        this.textPane.setDocument(this.document);
        this.setLayout(new BorderLayout());
        this.initTextPane(new EFCAbstractEditor.TextFieldFocusChangeHandler(), new TextEditorInputHandler(ident));
        JScrollPane scrollPane = new JScrollPane(this.textPane);
        scrollPane.setWheelScrollingEnabled(true);
        this.add((Component)scrollPane, "Center");
    }

    public void setDefaultFont(String fontName, int fontStyle, int fontSize) {
        this.textPane.setFont(new Font(fontName, fontStyle, fontSize));
    }

    public Font getDefaultFont() {
        return this.textPane.getFont();
    }

    private void initTextPane(EFCAbstractEditor.TextFieldFocusChangeHandler focusListener, EFCAbstractEditor.UserInputHandler userInputHandler) {
        this.textPane.addFocusListener(focusListener);
        this.textPane.addMouseListener(userInputHandler);
        this.textPane.addMouseWheelListener(userInputHandler);
        this.textPane.addKeyListener(userInputHandler);
    }

    @Override
    public void setValue(Object value) {
        this.originalValue = this.getValue();
        this.simpleOriginalValue = this.getSimpleValue();
        if (value == null) {
            value = "";
        } else if (value instanceof Type && (value = (String)((EFCString)value).optainValue()) == null) {
            value = "";
        }
        this.document = new EFCDefaultStyledDocument();
        if (value.toString().startsWith("{\\rtf1")) {
            try {
                this.rtfKit.read(new StringReader(value.toString()), (Document)this.document, this.document.getStartPosition().getOffset());
                for (int i = this.document.getLength() - 1; i >= 0 && this.document.getData().getString(i, 1).equals("\n"); --i) {
                    this.document.remove(i, 1);
                }
                this.textPane.setDocument(this.document);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.document.insertString(0, value.toString(), null);
                this.textPane.setDocument(this.document);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void fireValueChangeEvent(String srcIdent, Object oldValue, Object newValue) {
        if (this.isChanged) {
            super.fireValueChangeEvent(srcIdent, oldValue, newValue);
        }
        this.isChanged = false;
    }

    public EFCText getValue() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            for (int i = this.document.getLength() - 1; i >= 0 && this.document.getData().getString(i, 1).equals("\n"); --i) {
                this.document.remove(i, 1);
            }
            this.rtfKit.write(out, (Document)this.document, this.document.getStartPosition().getOffset(), this.document.getLength());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return new EFCText(out.toString());
    }

    @Override
    public String getSimpleValue() {
        return this.textPane.getText();
    }

    @Override
    public JComponent getEditorComponent() {
        return this.textPane;
    }

    @Override
    public void setEditorComponent(JComponent component) {
        this.textPane = (JTextPane)component;
    }

    @Override
    public void setEditable(boolean aFlag) {
        this.textPane.setEditable(aFlag);
        this.setComponentStyle(this.textPane);
    }

    @Override
    public boolean isEditable() {
        return this.textPane.isEditable();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setEditable(enabled && !this.getMetadata().isReadOnly());
        this.setComponentStyle(this.textPane);
    }

    @Override
    public boolean isEnabled() {
        return this.textPane.isEnabled();
    }

    public EFCText getOriginalValue() {
        return (EFCText)super.getOriginalValue();
    }

    protected class TextEditorInputHandler
    extends EFCAbstractEditor.UserInputHandler {
        public TextEditorInputHandler(String ident) {
            super(ident);
        }

        @Override
        public void keyTyped(KeyEvent event) {
            if (!event.isActionKey()) {
                EFCAbstractTextRtfEditor.this.setModified(true);
            }
            super.keyTyped(event);
        }
    }
}

