/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor;

import de.effectivecompany.base.datatypes.EFCAutoNum;
import de.effectivecompany.gui.components.editor.EFCAbstractNumberEditor;
import de.effectivecompany.gui.data.BusinessObjectModel;
import java.text.NumberFormat;

public class EFCAutoNumEditor
extends EFCAbstractNumberEditor {
    private static final long serialVersionUID = -8624899961058269927L;

    public EFCAutoNumEditor(String ident) {
        super(ident, false, false);
        this.setColumns(8);
    }

    public EFCAutoNumEditor(String ident, BusinessObjectModel boModel, boolean info, boolean dropDownButtonEnabled, int size, int width, String label, boolean withLabel) {
        super(ident, boModel, info, dropDownButtonEnabled, size, width, label, withLabel);
        this.setColumns(8);
    }

    @Override
    protected void initComponents() {
        super.initComponents();
    }

    @Override
    protected void initFormat(NumberFormat format) {
        super.initFormat(format);
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(0);
    }

    @Override
    protected boolean isCharValid(char ch) {
        boolean ok = super.isCharValid(ch);
        if (ch == ',' || ch == '.') {
            ok = false;
        }
        return ok;
    }

    public EFCAutoNum getValue() {
        Object object = super.getValue();
        if (object instanceof Number) {
            Integer intVal = ((Number)object).intValue();
            return new EFCAutoNum(intVal);
        }
        return new EFCAutoNum();
    }

    public EFCAutoNum getOriginalValue() {
        return (EFCAutoNum)super.getOriginalValue();
    }

    @Override
    public void terminate() {
        this.removeAll();
        super.terminate();
    }
}

