/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor;

import de.effectivecompany.base.datatypes.EFCDate;
import de.effectivecompany.base.datatypes.EFCDateTime;
import de.effectivecompany.gui.components.edgeicon.EITextField;
import de.effectivecompany.gui.components.editor.EFCAbstractEditor;
import de.effectivecompany.gui.components.editor.EFCAbstractPrimaryEditor;
import de.effectivecompany.gui.components.editor.util.DateTimeFormatter;
import de.effectivecompany.gui.data.BusinessObjectModel;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.FlowLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Date;
import java.util.EventListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class EFCDateTimeEditor
extends EFCAbstractPrimaryEditor {
    private static final long serialVersionUID = -6354L;
    private EITextField dateField;
    private boolean enabled = true;
    private boolean editable = true;
    private EITextField dayNameField;

    public EFCDateTimeEditor(String ident, boolean info, boolean dropDownButtonEnabled, String label, boolean withLabel) {
        this(ident, info, dropDownButtonEnabled, label, withLabel, null);
    }

    public EFCDateTimeEditor(String ident, boolean info, boolean dropDownButtonEnabled, String label, boolean withLabel, String scbchrkey) {
        super(ident, info, dropDownButtonEnabled, label, withLabel, scbchrkey);
        FocusHandler focusHandler = new FocusHandler();
        DateTimeInputHandler inputHandler = new DateTimeInputHandler(this.getIdent());
        EFCAbstractEditor.UserInputHandler userInputHandler = new EFCAbstractEditor.UserInputHandler(this.getIdent());
        this.dayNameField = new EITextField(2);
        this.dayNameField.setMargin(EFCLookAndFeelManager.SIZE_TEXTFIELD_INSETS);
        this.dayNameField.setHorizontalAlignment(0);
        this.dayNameField.setFont(EFCLookAndFeelManager.FONT_FORM);
        this.dayNameField.setEditable(false);
        this.dayNameField.setEnabled(false);
        this.dateField = new EITextField(10);
        this.dateField.setMargin(EFCLookAndFeelManager.SIZE_TEXTFIELD_INSETS);
        this.dateField.setHorizontalAlignment(0);
        this.dateField.setFont(EFCLookAndFeelManager.FONT_FORM);
        this.dateField.addFocusListener(focusHandler);
        this.dateField.addKeyListener(inputHandler);
        this.dateField.addMouseListener(userInputHandler);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(this.dayNameField);
        this.add(this.dateField);
    }

    @Override
    protected void initComponents() {
        super.initComponents();
    }

    public EFCDateTimeEditor(String ident, BusinessObjectModel boModel, boolean info, boolean dropDownButtonEnabled, String label, boolean withLabel) {
        this(ident, info, dropDownButtonEnabled, label, withLabel, null);
    }

    public EFCDateTimeEditor(String ident, BusinessObjectModel boModel, boolean info, boolean dropDownButtonEnabled, String label, boolean withLabel, String scbchrkey) {
        this(ident, info, dropDownButtonEnabled, label, withLabel, scbchrkey);
        this.setBusinessObjectModel(boModel);
    }

    public void setDate(Date date) {
        if (date != null) {
            this.dateField.setText(DateTimeFormatter.getDefaultDateFormat().format(date));
            this.dayNameField.setText(DateTimeFormatter.getDefaultDaynameFormat().format(date));
        } else {
            this.dateField.setText("");
            this.dayNameField.setText("");
        }
    }

    public String getDateFieldText() {
        return this.dateField.getText();
    }

    public boolean isDateStringValid() {
        return DateTimeFormatter.convertDate(this.dateField.getText()) != null;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setDate(null);
        } else if (value instanceof EFCDateTime) {
            this.setDate(((EFCDateTime)value).getDate());
        } else if (value instanceof EFCDate) {
            this.setDate(((EFCDate)value).getDate());
        } else if (value instanceof Date) {
            this.setDate((Date)value);
        } else {
            throw new IllegalArgumentException("unsupported value for editor: " + value.getClass().getName());
        }
        this.originalValue = this.getValue();
        this.simpleOriginalValue = this.dateField.getText();
    }

    public EFCDateTime getValue() {
        Date value = DateTimeFormatter.convertDate(this.dateField.getText());
        if (value == null) {
            return new EFCDateTime();
        }
        return new EFCDateTime(value);
    }

    @Override
    public Date getSimpleValue() {
        return DateTimeFormatter.convertDate(this.dateField.getText());
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
        if (this.dateField != null) {
            this.dateField.setEditable(editable);
            this.setComponentStyle(this.dateField);
        }
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.setEditable(enabled && !this.getMetadata().isReadOnly());
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.dateField != null) {
            this.dateField.setVisible(visible);
        }
        if (this.dayNameField != null) {
            this.dayNameField.setVisible(visible);
        }
        super.setVisible(visible);
    }

    @Override
    public JComponent getEditorComponent() {
        return this.dateField;
    }

    @Override
    public void setEditorComponent(JComponent component) {
        this.dateField = (EITextField)component;
    }

    @Override
    public void setEdgeImage(ImageIcon img, int edge) {
        this.dateField.setEdgeIcon(img, edge);
    }

    @Override
    public void terminate() {
        for (FocusListener focusListener : this.dateField.getFocusListeners()) {
            this.dateField.removeFocusListener(focusListener);
        }
        for (EventListener eventListener : this.dateField.getKeyListeners()) {
            this.dateField.removeKeyListener((KeyListener)eventListener);
        }
        this.removeAll();
        this.dateField = null;
        this.dayNameField = null;
        super.terminate();
    }

    public EFCDateTime getOriginalValue() {
        return (EFCDateTime)super.getOriginalValue();
    }

    public EITextField getDateField() {
        return this.dateField;
    }

    public EITextField getDayNameField() {
        return this.dayNameField;
    }

    private class DateTimeInputHandler
    extends EFCAbstractEditor.UserInputHandler {
        public DateTimeInputHandler(String ident) {
            super(ident);
        }

        @Override
        public void keyTyped(KeyEvent event) {
            if (Character.isLetter(event.getKeyChar()) || EFCDateTimeEditor.this.dateField.getText().length() > 19) {
                event.consume();
            }
            super.keyTyped(event);
        }
    }

    private class FocusHandler
    extends EFCAbstractEditor.FocusChangeHandler {
        private Date onFocusValue;

        private FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            super.focusGained(e);
            this.onFocusValue = EFCDateTimeEditor.this.getSimpleValue();
        }

        @Override
        public void focusLost(FocusEvent event) {
            Date d = DateTimeFormatter.convertDate(EFCDateTimeEditor.this.dateField.getText());
            if (d == null && !EFCDateTimeEditor.this.dateField.getText().trim().equals("")) {
                EFCDateTimeEditor.this.dateField.setEdgeIcon(EFCLookAndFeelManager.ICON_BUTTON_POPUP_CALENDAR, 3);
            } else {
                EFCDateTimeEditor.this.dateField.setEdgeIcon(null, 3);
            }
            Date oldVal = this.onFocusValue;
            Date newVal = EFCDateTimeEditor.this.getSimpleValue();
            if (newVal == null || oldVal == null) {
                if (newVal != oldVal) {
                    EFCDateTimeEditor.this.fireValueChangeEvent(EFCDateTimeEditor.this.getIdent(), new EFCDateTime(oldVal), new EFCDateTime(newVal));
                }
            } else if (oldVal.getTime() != newVal.getTime()) {
                EFCDateTimeEditor.this.fireValueChangeEvent(EFCDateTimeEditor.this.getIdent(), new EFCDateTime(oldVal), new EFCDateTime(newVal));
            }
            super.focusLost(event);
        }
    }
}

