/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor;

import de.effectivecompany.base.datatypes.EFCPassword;
import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.base.meta.TypeInfo;
import de.effectivecompany.gui.components.edgeicon.EIPasswordField;
import de.effectivecompany.gui.components.editor.EFCAbstractEditor;
import de.effectivecompany.gui.components.editor.EFCAbstractPrimaryEditor;
import de.effectivecompany.gui.data.BusinessObjectModel;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.UnitConverter;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelListener;
import java.util.EventListener;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCPasswordEditor
extends EFCAbstractPrimaryEditor {
    private static Logger logger = LoggerFactory.getLogger(EFCPasswordEditor.class);
    static final long serialVersionUID = -6354L;
    protected EIPasswordField passwordField = new EIPasswordField(4);
    protected String originalData = "";
    protected int maxchar = 255;
    private String redoString = null;

    public EFCPasswordEditor(String ident) {
        super(ident, false, false, null, true);
    }

    public EFCPasswordEditor(String ident, BusinessObjectModel boModel, boolean info, boolean dropDownButtonEnabled, String label, boolean withLabel) {
        super(ident, info, dropDownButtonEnabled, label, withLabel);
        this.setBusinessObjectModel(boModel);
        this.setLayout(new BorderLayout());
        EFCAbstractEditor.TextFieldFocusChangeHandler focusListener = new EFCAbstractEditor.TextFieldFocusChangeHandler();
        StringUserInputHandler userInputHandler = new StringUserInputHandler(this.getIdent());
        this.passwordField.addKeyListener(userInputHandler);
        this.passwordField.addMouseListener(userInputHandler);
        this.passwordField.addMouseWheelListener(userInputHandler);
        this.passwordField.addFocusListener(focusListener);
        this.passwordField.setFont(EFCLookAndFeelManager.FONT_FORM);
        this.passwordField.setSize((Dimension)this.passwordField.getPreferredSize().clone());
        this.passwordField.setMargin(UnitConverter.createPixelFromDLUInsets(EFCLookAndFeelManager.SIZE_TEXTFIELD_INSETS, this.passwordField));
        this.setEditorSizing(0);
        this.reorganize();
        TypeInfo typeInfo = boModel.getAttributeInfo(ident);
        if (typeInfo.getMaxSize() > 0) {
            this.setColumns(typeInfo.getMaxSize());
            this.setMaxChars(typeInfo.getMaxSize());
        }
    }

    @Override
    protected void initComponents() {
        super.initComponents();
    }

    protected boolean isCharValid(char ch) {
        return this.passwordField.getPassword().length < this.maxchar || this.passwordField.getSelectionStart() != this.passwordField.getSelectionEnd();
    }

    @Override
    public void setValue(Object value) {
        EFCPassword oldValue = this.getValue();
        if (value == null) {
            this.passwordField.setText("");
        } else if (value instanceof Type) {
            Object tval = ((Type)value).optainValue();
            if (tval != null) {
                this.passwordField.setText(tval.toString());
            } else {
                this.passwordField.setText(null);
            }
        } else {
            this.passwordField.setText(value.toString());
        }
        if (this.getEmptyStrategy() != -1) {
            this.setVisible(true);
            this.passwordField.setEditable(true);
            if (new String(this.passwordField.getPassword()).trim().equals("")) {
                if (this.getEmptyStrategy() == 1) {
                    this.setVisible(true);
                    this.passwordField.setEditable(false);
                }
                if (this.getEmptyStrategy() == 2) {
                    this.setVisible(false);
                    this.passwordField.setEditable(false);
                }
            }
        }
        this.setModified(false);
        this.fireValueResetEvent(this.getIdent(), oldValue, value);
        this.originalData = new String(this.passwordField.getPassword());
        if (!this.isEnabled() || !this.isEditable()) {
            this.passwordField.setCaretPosition(0);
        }
        this.originalValue = this.getValue();
        this.simpleOriginalValue = this.getSimpleValue();
    }

    public EFCPassword getValue() {
        return new EFCPassword(new String(this.passwordField.getPassword()));
    }

    @Override
    public String getSimpleValue() {
        return new String(this.passwordField.getPassword());
    }

    @Override
    public void undo() {
        logger.debug("StringEditor: undo");
        this.setModified(false);
        this.redoString = new String(this.passwordField.getPassword());
        this.passwordField.setText(this.originalData);
    }

    @Override
    public void redo() {
        logger.debug("StringEditor: redo");
        if (this.redoString != null) {
            this.passwordField.setText(this.redoString);
            this.setModified(true);
        }
    }

    @Override
    public void setVisible(boolean aFlag) {
        this.passwordField.setVisible(aFlag);
        super.setVisible(aFlag);
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.passwordField.setEditable(editable);
        if (!editable) {
            this.passwordField.setCaretPosition(0);
        }
        this.setComponentStyle(this.passwordField);
    }

    @Override
    public boolean isEditable() {
        return this.passwordField.isEditable();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.dropDownButton != null) {
            this.dropDownButton.setEnabled(enabled);
        }
        this.setEditable(enabled && !this.getMetadata().isReadOnly());
    }

    @Override
    public boolean isEnabled() {
        return this.passwordField.isEnabled();
    }

    @Override
    public void setEdgeImage(ImageIcon img, int edge) {
        this.passwordField.setEdgeIcon(img, edge);
    }

    public void setColumns(int columns) {
        this.passwordField.setColumns(columns);
        if (columns > 0) {
            this.setEditorSizing(2);
        } else {
            this.setEditorSizing(1);
        }
        this.reorganize();
    }

    public int getColumns() {
        return this.passwordField.getColumns();
    }

    public void setMaxChars(int chars) {
        this.maxchar = chars;
    }

    public int getMaxChars() {
        return this.maxchar;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.passwordField;
    }

    @Override
    public void setEditorComponent(JComponent component) {
        this.passwordField = (EIPasswordField)component;
    }

    @Override
    public void terminate() {
        for (KeyListener keyListener : this.passwordField.getKeyListeners()) {
            this.passwordField.removeKeyListener(keyListener);
        }
        for (EventListener eventListener : this.passwordField.getMouseListeners()) {
            this.passwordField.removeMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : this.passwordField.getMouseWheelListeners()) {
            this.passwordField.removeMouseWheelListener((MouseWheelListener)eventListener);
        }
        for (EventListener eventListener : this.passwordField.getFocusListeners()) {
            this.passwordField.removeFocusListener((FocusListener)eventListener);
        }
        this.removeAll();
        this.passwordField = null;
        super.terminate();
    }

    public EFCPassword getOriginalValue() {
        return (EFCPassword)super.getOriginalValue();
    }

    protected class StringUserInputHandler
    extends EFCAbstractEditor.UserInputHandler {
        public StringUserInputHandler(String ident) {
            super(ident);
        }

        @Override
        public void keyTyped(KeyEvent event) {
            if (!event.isActionKey()) {
                if (!EFCPasswordEditor.this.isCharValid(event.getKeyChar())) {
                    event.consume();
                } else {
                    EFCPasswordEditor.this.setModified(true);
                }
            }
            super.keyTyped(event);
        }
    }
}

