/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor;

import de.effectivecompany.base.datatypes.EFCText;
import de.effectivecompany.gui.components.editor.EFCAbstractTextRtfEditor;
import de.effectivecompany.gui.components.root.EFCMainFrame;
import de.effectivecompany.gui.components.styleeditor.StyleEditor;
import de.effectivecompany.gui.data.BusinessObjectModel;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class EFCTextRtfEditor
extends EFCAbstractTextRtfEditor {
    private static final long serialVersionUID = -1487905329697637764L;
    private boolean rtfChangeFontSize;
    private boolean rtfChangeFont;
    private boolean rtfChangeFontStyle;

    public EFCTextRtfEditor(String ident, boolean info, boolean dropDownButtonEnabled, int rtfFontSize, int rtfFontStyleValue, String rtfFontName, boolean isFontSizeChangeable, boolean isFontChangeable, boolean isFontStyleChangeable, String label, boolean withLabel) {
        super(ident, info, dropDownButtonEnabled, label, withLabel);
        this.textPane.addMouseListener(new DoubleClickListener());
        this.setDefaultFont(rtfFontName, rtfFontStyleValue, rtfFontSize);
        this.setRtfChangeFont(isFontChangeable);
        this.setRtfChangeFontSize(isFontSizeChangeable);
        this.setRtfChangeFontStyle(isFontStyleChangeable);
    }

    public EFCTextRtfEditor(String ident, BusinessObjectModel boModel, boolean info, boolean dropDownButtonEnabled, int rtfFontSize, int rtfFontStyleValue, String rtfFontName, boolean isFontSizeChangeable, boolean isFontChangeable, boolean isFontStyleChangeable, String label, boolean withLabel) {
        this(ident, info, dropDownButtonEnabled, rtfFontSize, rtfFontStyleValue, rtfFontName, isFontSizeChangeable, isFontChangeable, isFontStyleChangeable, label, withLabel);
        this.setBusinessObjectModel(boModel);
    }

    public void setRtfChangeFontSize(boolean isVisible) {
        this.rtfChangeFontSize = isVisible;
    }

    public boolean getRtfChangeFontSize() {
        return this.rtfChangeFontSize;
    }

    public void setRtfChangeFont(boolean isVisible) {
        this.rtfChangeFont = isVisible;
    }

    public boolean getRtfChangeFont() {
        return this.rtfChangeFont;
    }

    public void setRtfChangeFontStyle(boolean isVisible) {
        this.rtfChangeFontStyle = isVisible;
    }

    public boolean getRtfChangeFontStyle() {
        return this.rtfChangeFontStyle;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.getMetadata().isReadOnly()) {
            return;
        }
        super.setEnabled(enabled);
    }

    @Override
    public void terminate() {
        for (MouseListener mouseListener : this.textPane.getMouseListeners()) {
            this.textPane.removeMouseListener(mouseListener);
        }
        super.terminate();
    }

    private class DoubleClickListener
    extends MouseAdapter {
        private DoubleClickListener() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.getClickCount() == 2) {
                EFCText code = EFCTextRtfEditor.this.getValue();
                StyleEditor styleEditor = StyleEditor.getInstance();
                styleEditor.setDefaultFont(EFCTextRtfEditor.this.getDefaultFont());
                styleEditor.setText(code.getData());
                styleEditor.enableCbFonts(EFCTextRtfEditor.this.rtfChangeFont);
                styleEditor.enableCbFontSize(EFCTextRtfEditor.this.rtfChangeFontSize);
                styleEditor.enableFontStyleButtons(EFCTextRtfEditor.this.rtfChangeFontStyle);
                styleEditor.setEditable(EFCTextRtfEditor.this.isEditable());
                styleEditor.setEnabled(EFCTextRtfEditor.this.isEnabled());
                Object[] message = new Object[]{styleEditor};
                JOptionPane pane = new JOptionPane(message, -1, 2);
                JDialog dialog = pane.createDialog("Rtf Editor");
                dialog.setLocationRelativeTo(EFCMainFrame.getInstance());
                dialog.setSize(EFCLookAndFeelManager.SIZE_FRAME_CODE_EDITOR);
                dialog.setDefaultCloseOperation(0);
                dialog.setIconImage(EFCLookAndFeelManager.ICON_APP_TEXT_EDITOR.getImage());
                dialog.setVisible(true);
                Object selectedButton = pane.getValue();
                if (selectedButton != null && (Integer)selectedButton == 0 && EFCTextRtfEditor.this.textPane.isEnabled()) {
                    String text = styleEditor.getText();
                    EFCTextRtfEditor.this.setValue(text);
                    EFCTextRtfEditor.this.isChanged = true;
                    EFCTextRtfEditor.this.fireValueChangeEvent(EFCTextRtfEditor.this.getIdent(), code, new EFCText(text));
                }
            }
        }
    }
}

