/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor.table;

import de.effectivecompany.base.datatypes.EFCBoolean;
import de.effectivecompany.base.datatypes.EFCInteger;
import de.effectivecompany.gui.components.editor.table.EFCAbstractCellEditor;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JComboBox;
import javax.swing.border.Border;

public class EFCBooleanCellEditor
extends EFCAbstractCellEditor {
    protected JComboBox comboBox = new JComboBox();
    protected boolean emptyAllowed;

    public EFCBooleanCellEditor(boolean allowEmpty) {
        this.styleComponent(this.comboBox);
        this.comboBox.addItem("Ja");
        this.comboBox.addItem("Nein");
        this.comboBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyChar() == ' ') {
                    EFCBooleanCellEditor.this.comboBox.showPopup();
                }
                super.keyPressed(event);
            }
        });
        this.emptyAllowed = allowEmpty;
        if (this.emptyAllowed) {
            this.comboBox.addItem("Egal");
        }
    }

    @Override
    public void setBorder(Border b) {
    }

    @Override
    public Component getComponent() {
        return this.comboBox;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.comboBox.setSelectedIndex(2);
        } else if (value instanceof Boolean) {
            this.comboBox.setSelectedIndex((Boolean)value != false ? 0 : 1);
        } else if (value instanceof EFCBoolean) {
            this.comboBox.setSelectedIndex(((EFCBoolean)value).getBoolean() != false ? 0 : 1);
        } else if (value instanceof Integer) {
            this.comboBox.setSelectedIndex((Integer)value == 1 ? 0 : 1);
        } else if (value instanceof EFCInteger) {
            this.comboBox.setSelectedIndex(((EFCInteger)value).getIntValue() == 1 ? 0 : 1);
        }
    }

    @Override
    public Object getValue() {
        switch (this.comboBox.getSelectedIndex()) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return null;
    }
}

