/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor.table;

import de.effectivecompany.gui.components.editor.table.EFCGenericCellEditor;
import de.effectivecompany.gui.factory.EFCPanelSingleton;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;

public class EFCIntegerCellEditor
extends EFCGenericCellEditor {
    protected DecimalFormat format;
    private static KeyListener numberKeyFilter = new KeyAdapter(){

        @Override
        public void keyTyped(KeyEvent e) {
            char c;
            if (!e.isConsumed() && (c = e.getKeyChar()) != '\b' && c != '\u007f' && c != '\n' && c != '\t' && !Character.isDigit(c) && c != ',' && c != '.' && c != '-') {
                e.consume();
            }
        }
    };

    public EFCIntegerCellEditor() {
        this.component.addKeyListener(numberKeyFilter);
        this.format = new DecimalFormat();
        this.format.setDecimalSeparatorAlwaysShown(false);
        this.format.setParseIntegerOnly(true);
        if (EFCPanelSingleton.GROUPING_SEPARATOR != null) {
            DecimalFormatSymbols formatSymbols = this.format.getDecimalFormatSymbols();
            formatSymbols.setGroupingSeparator(EFCPanelSingleton.GROUPING_SEPARATOR.charValue());
            this.format.setDecimalFormatSymbols(formatSymbols);
        }
    }

    @Override
    public Object getValue() {
        try {
            return this.format.parse(this.component.getText());
        }
        catch (ParseException e) {
            return null;
        }
    }
}

