/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateFormatter {
    private static Logger logger = LoggerFactory.getLogger(DateFormatter.class);
    private static List<DateFormat> dateFormats = new ArrayList<DateFormat>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(new SimpleDateFormat("ddMMyyyy"));
            this.add(new SimpleDateFormat("ddMMyy"));
            this.add(new SimpleDateFormat("dd.MM.yyyy"));
            this.add(new SimpleDateFormat("dd.MM.yy"));
            this.add(new SimpleDateFormat("dd-MM-yyyy"));
            this.add(new SimpleDateFormat("dd-MM-yy"));
            this.add(new SimpleDateFormat("MM/dd/yyyy"));
            this.add(new SimpleDateFormat("MM/dd/yy"));
        }
    };
    private static DateFormat defaultDateFormat = new SimpleDateFormat("dd.MM.yyyy");
    private static SimpleDateFormat daynameFormat = new SimpleDateFormat("EE");

    public static List<DateFormat> getDateFormats() {
        return dateFormats;
    }

    public static DateFormat getDefaultDateFormat() {
        return defaultDateFormat;
    }

    public static SimpleDateFormat getDefaultDaynameFormat() {
        return daynameFormat;
    }

    public static Date convertDate(String dateString) {
        if (dateString.equals("")) {
            return null;
        }
        Date date = null;
        for (DateFormat dateFormat : dateFormats) {
            dateFormat.setLenient(false);
            try {
                date = dateFormat.parse(dateString);
                logger.debug("DateFormat usable: " + ((SimpleDateFormat)dateFormat).toPattern());
            }
            catch (ParseException ex) {
                logger.debug("DateFormat not usable: " + ((SimpleDateFormat)dateFormat).toPattern());
            }
            if (date == null) continue;
            break;
        }
        if (date != null) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            int year = cal.get(1);
            if (year < 100) {
                year = year < 50 ? (year += 2000) : (year += 1900);
            }
            while (year > 4000) {
                year -= 1000;
            }
            cal.set(1, year);
            date = cal.getTime();
        }
        return date;
    }
}

