/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.frame;

import de.effectivecompany.base.datatypes.EFCBlob;
import de.effectivecompany.gui.components.EFCStatusBar;
import de.effectivecompany.gui.components.fx.EFCExcelViewerPane;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.awt.Component;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;

public class EFCExcelViewer
extends JInternalFrame {
    public static final long serialVersionUID = -342343136L;
    private static ImageIcon icon;
    private EFCStatusBar statusBar;
    EFCExcelViewerPane viewer;

    public EFCExcelViewer(String fileName, EFCBlob efcBlob) {
        super(fileName, true, true, true, true);
        this.init(fileName, efcBlob);
    }

    private void init(String fileName, EFCBlob efcBlob) {
        if (icon == null) {
            icon = EFCLookAndFeelManager.ICON_APP_WUG;
        }
        this.setFrameIcon(icon);
        this.setSize(EFCLookAndFeelManager.SIZE_FRAME_PRINT_PREVIEW);
        this.setPreferredSize(EFCLookAndFeelManager.SIZE_FRAME_PRINT_PREVIEW);
        this.viewer = new EFCExcelViewerPane(fileName, efcBlob);
        this.statusBar = new EFCStatusBar();
        JFXPanel statusbarPanel = new JFXPanel();
        EFCThreadUtil.doLaterFAT(() -> statusbarPanel.setScene(new Scene((Parent)this.statusBar)));
        this.viewer.add((Component)statusbarPanel, "South");
        this.setContentPane(this.viewer);
        this.setVisible(true);
        this.pack();
    }

    @Override
    public void dispose() {
        this.removeAll();
        this.viewer.terminate();
        this.viewer = null;
        if (this.statusBar != null) {
            this.statusBar.terminate();
            this.statusBar = null;
        }
        super.dispose();
    }
}

