/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.frame;

import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.data.EFCReportSelectionListEntry;
import de.effectivecompany.gui.actions.EFCAbstractAction;
import de.effectivecompany.gui.actions.EFCActionExit;
import de.effectivecompany.gui.actions.EFCActionPrintDefault;
import de.effectivecompany.gui.components.EFCController;
import de.effectivecompany.gui.components.EFCStatusBar;
import de.effectivecompany.gui.components.frame.EFCInternalFrameView;
import de.effectivecompany.gui.components.panel.EFCGlassPanel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.enums.EFCPrintBatchMode;
import de.effectivecompany.gui.interfaces.handler.ActionHandler;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.EFCThreadUtil;
import de.effectivecompany.gui.util.UnitConverter;
import de.effectivecompany.report.jasper.ReportInfoVerifier;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;

public class EFCPrintSelectionDialog
extends JInternalFrame {
    private static final long serialVersionUID = -9104482406450113428L;
    private JPanel mainPanel = new JPanel();
    private JList<EFCReportSelectionListEntry> reportSelect;
    private JToolBar toolbar = new JToolBar();
    private EFCStatusBar statusbar;
    private ReportInfoVerifier verifier;
    private MyActionHandler actionHandler;
    private EFCPrintBatchMode batchMode;
    private EFCController parent;
    private EFCGlassPanel glass;

    public EFCPrintSelectionDialog(EFCController parent, String title, List<EFCReportSelectionListEntry> datalist, ReportInfoVerifier verifier, EFCPrintBatchMode batchMode) {
        super(title, false, true, false, false);
        this.verifier = verifier;
        this.batchMode = batchMode;
        this.parent = parent;
        this.reportSelect = new JList();
        this.statusbar = new EFCStatusBar();
        this.actionHandler = new MyActionHandler(this);
        this.toolbar.setFloatable(false);
        this.reportSelect.setModel(new PrintListModel(datalist));
        this.reportSelect.setSelectionMode(0);
        this.reportSelect.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    EFCPrintSelectionDialog.this.actionHandler.handleAction("print_default", null);
                }
                super.mouseClicked(e);
            }
        });
        EFCAbstractAction action = new EFCActionExit();
        action.setActionHandler(this.actionHandler);
        JButton button = this.toolbar.add(action);
        button.setBorderPainted(false);
        button.setPreferredSize(UnitConverter.sizeFromDLU(EFCLookAndFeelManager.SIZE_BUTTON_TOOLBAR, this.toolbar));
        this.toolbar.add(button);
        action = new EFCActionPrintDefault();
        action.setActionHandler(this.actionHandler);
        button = this.toolbar.add(action);
        button.setBorderPainted(false);
        button.setPreferredSize(UnitConverter.sizeFromDLU(EFCLookAndFeelManager.SIZE_BUTTON_TOOLBAR, this.toolbar));
        this.toolbar.add(button);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.toolbar, "North");
        this.mainPanel.add((Component)new JScrollPane(this.reportSelect), "Center");
        JFXPanel statusbarPanel = new JFXPanel();
        EFCThreadUtil.doLaterFAT(() -> statusbarPanel.setScene(new Scene((Parent)this.statusbar)));
        this.mainPanel.add((Component)statusbarPanel, "South");
        this.glass = new EFCGlassPanel(this.mainPanel);
        this.setContentPane(this.glass);
        this.setSize(EFCLookAndFeelManager.SIZE_DIALOG_PRINTSELECTION);
        this.setFrameIcon(EFCLookAndFeelManager.ICON_APP_WUG);
        this.setDefaultCloseOperation(2);
        this.initLocation();
    }

    private void initLocation() {
        EFCInternalFrameView controllerView = this.parent.getView();
        int xOffset = (controllerView.getWidth() - this.getWidth()) / 2;
        int yOffset = (controllerView.getHeight() - this.getHeight()) / 2;
        int tmpStartX = controllerView.getX() + xOffset;
        int tmpStartY = controllerView.getY() + yOffset;
        if (tmpStartX < 0) {
            tmpStartX = 0;
        }
        if (tmpStartY < 0) {
            tmpStartY = 0;
        }
        this.setLocation(tmpStartX, tmpStartY);
    }

    public void setLocked(boolean isLocked) {
        this.glass.setEnabled(!isLocked);
        if (isLocked) {
            this.statusbar.setProgressBarVisible(true);
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
            this.statusbar.setProgressBarVisible(false);
        }
    }

    public MyActionHandler getActionHandler() {
        return this.actionHandler;
    }

    public void setActionHandler(MyActionHandler handler) {
        this.actionHandler = handler;
    }

    @Override
    public void dispose() {
        this.setVisible(false);
        this.setActionHandler(null);
        this.statusbar.terminate();
        this.statusbar = null;
        this.toolbar.removeAll();
        this.mainPanel.removeAll();
        this.toolbar = null;
        this.mainPanel = null;
        EFCDesktop.getInstance().remove(this);
        this.parent.setPrintSelectionDialog(null);
        super.dispose();
    }

    public final class MyActionHandler
    implements ActionHandler {
        private EFCPrintSelectionDialog myDlg;

        public MyActionHandler(EFCPrintSelectionDialog dlg) {
            this.myDlg = dlg;
        }

        @Override
        public void handleAction(String ident, Object param) {
            if ("exit".equals(ident)) {
                this.myDlg.dispose();
                this.myDlg = null;
            }
            if ("print_default".equals(ident)) {
                EFCReportSelectionListEntry sel = this.myDlg.reportSelect.getSelectedValue();
                if (sel == null) {
                    EFCDesktop.showErrorDlg(Translator.tr((String)"MSG_FRAME_NO_LISTENTRY_SELECTED"));
                    EFCPrintSelectionDialog.this.setEnabled(true);
                    return;
                }
                if (EFCPrintSelectionDialog.this.batchMode == EFCPrintBatchMode.MODE_BATCH_BY_SEARCH) {
                    EFCPrintSelectionDialog.this.verifier.openSearchFrameForPrintBatch(sel);
                    return;
                }
                if (EFCPrintSelectionDialog.this.batchMode == EFCPrintBatchMode.MODE_BATCH_BY_FRAME_LIST) {
                    EFCPrintSelectionDialog.this.verifier.printBatch(sel);
                    return;
                }
                EFCPrintSelectionDialog.this.verifier.printReport(sel);
            }
        }
    }

    private class PrintListModel
    extends AbstractListModel<EFCReportSelectionListEntry> {
        private static final long serialVersionUID = -1309007697797232525L;
        private List<EFCReportSelectionListEntry> datalist;

        public PrintListModel(List<EFCReportSelectionListEntry> datalist) {
            this.datalist = datalist;
        }

        @Override
        public EFCReportSelectionListEntry getElementAt(int index) {
            return this.datalist.get(index);
        }

        @Override
        public int getSize() {
            if (this.datalist == null) {
                return 0;
            }
            return this.datalist.size();
        }
    }
}

