/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.frame.searchframe;

import de.effectivecompany.base.datatypes.EFCBoolean;
import de.effectivecompany.base.datatypes.EFCOption;
import de.effectivecompany.base.gui.data.SearchService;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.frame.searchframe.EFCSearchCriteriaTable;
import de.effectivecompany.gui.components.frame.searchframe.columns.EFCSearchCriteriaBooleanColumn;
import de.effectivecompany.gui.components.frame.searchframe.columns.EFCSearchCriteriaColumn;
import de.effectivecompany.gui.components.frame.searchframe.columns.EFCSearchCriteriaOptionColumn;
import de.effectivecompany.gui.components.fx.components.EFCTableView;
import de.effectivecompany.gui.components.model.table.EFCTableColumnLayoutInfo;
import de.effectivecompany.gui.components.swing.ColumnFilterType;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.TableColumn;
import javafx.scene.layout.AnchorPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCSearchCriteriaTablePane
extends AnchorPane {
    private static Logger logger = LoggerFactory.getLogger(EFCSearchCriteriaTablePane.class);
    private static final String ROWS_HEADER = "CRITERIA";
    private EFCSearchCriteriaTable table = new EFCSearchCriteriaTable();
    private static final ObservableList<String> ROWS = FXCollections.observableArrayList(Arrays.asList(Translator.tr((String)"DLG_SEARCH_CRITERIA_EXACT") + " " + ColumnFilterType.EQUAL.getIdent(), Translator.tr((String)"DLG_SEARCH_CRITERIA_IS_NOT") + " " + ColumnFilterType.NOT_EQUAL.getIdent(), Translator.tr((String)"DLG_SEARCH_CRITERIA_CONTAINS") + " " + ColumnFilterType.CONTAIN.getIdent(), Translator.tr((String)"DLG_SEARCH_CRITERIA_BIGGER_OR_EQUAL") + " " + ColumnFilterType.BIGGER_OR_EQUAL.getIdent(), Translator.tr((String)"DLG_SEARCH_CRITERIA_LESSER_OR_EQUAL") + " " + ColumnFilterType.LESSER_OR_EQUAL.getIdent(), Translator.tr((String)"DLG_SEARCH_CRITERIA_STARTS_WITH") + " " + ColumnFilterType.STARTS_WITH.getIdent(), Translator.tr((String)"DLG_SEARCH_CRITERIA_ENDS_WITH") + " " + ColumnFilterType.ENDS_WITH.getIdent()));
    private SimpleIntegerProperty activeListIndex = new SimpleIntegerProperty(-1);
    private List<SearchService.SearchMetaInfo> listInfo = new LinkedList<SearchService.SearchMetaInfo>();

    public EFCSearchCriteriaTablePane() {
        this.init();
    }

    public void setSearchServiceMetaInfos(SearchService.DcSearchMetaInfo metaInfo) {
        this.listInfo = metaInfo.getSearchMetaInfos();
        this.setActiveListId(this.listInfo.get(0).getId());
    }

    private void init() {
        this.table.setEditable(true);
        this.table.getSelectionModel().setCellSelectionEnabled(true);
        this.table.getStyleClass().add((Object)"efcsearchtable");
        this.table.setPrefHeight(190.0);
        ListView criteriaList = new ListView();
        criteriaList.getStyleClass().add((Object)"efcsearchcriterialist");
        criteriaList.setPrefHeight(155.0);
        criteriaList.setMouseTransparent(true);
        criteriaList.setFocusTraversable(false);
        criteriaList.setItems(ROWS);
        this.getChildren().addAll((Object[])new Node[]{criteriaList, this.table});
        AnchorPane.setTopAnchor((Node)criteriaList, (Double)24.0);
        AnchorPane.setLeftAnchor((Node)criteriaList, (Double)5.0);
        AnchorPane.setRightAnchor((Node)criteriaList, (Double)30.0);
        AnchorPane.setLeftAnchor((Node)this.table, (Double)100.0);
        AnchorPane.setRightAnchor((Node)this.table, (Double)5.0);
    }

    private void initColumns(List<EFCTableColumnLayoutInfo> tableColumnLayoutInfos) {
        ConcurrentSkipListMap<Integer, TableColumn> columns = new ConcurrentSkipListMap<Integer, TableColumn>();
        ArrayList<EFCSearchCriteriaBooleanColumn> additionalColumns = new ArrayList<EFCSearchCriteriaBooleanColumn>();
        for (SearchService.SearchColumnInfo colInfo : this.listInfo.get(this.activeListIndex.get()).getFields()) {
            boolean contains = false;
            EFCTableColumnLayoutInfo tabColumn = null;
            if (tableColumnLayoutInfos != null) {
                for (EFCTableColumnLayoutInfo info : tableColumnLayoutInfos) {
                    tabColumn = info;
                    if (!tabColumn.getColumnName().equals(colInfo.getName())) continue;
                    contains = true;
                    break;
                }
            }
            TableColumn column = colInfo.getClazz().isAssignableFrom(EFCBoolean.class) ? new EFCSearchCriteriaBooleanColumn(colInfo.getName(), true) : (colInfo.getClazz().equals(EFCOption.class) ? new EFCSearchCriteriaOptionColumn(colInfo.getName(), colInfo.getOptionClass()) : new EFCSearchCriteriaColumn(colInfo.getName(), colInfo.getClazz()));
            if (contains) {
                column.setVisible(tabColumn.isVisible());
                column.setPrefWidth((double)tabColumn.getWidth());
                columns.put(tabColumn.getOrder(), column);
                continue;
            }
            additionalColumns.add((EFCSearchCriteriaBooleanColumn)column);
        }
        this.table.getColumns().setAll(columns.values());
        this.table.getColumns().addAll(additionalColumns);
        ObservableList values = FXCollections.observableArrayList();
        for (String val : ROWS) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(ROWS_HEADER, val);
            values.add(map);
        }
        this.table.getItems().setAll((Collection)values);
        if (this.table.getColumns().size() > 0) {
            this.table.scrollToColumnIndex(0);
        }
    }

    public String getColumnModelXML() {
        ArrayList<EFCTableColumnLayoutInfo> tableColumnLayoutInfos = new ArrayList<EFCTableColumnLayoutInfo>();
        String xmlString = null;
        for (int currentColumnIndex = 0; currentColumnIndex < this.table.getColumns().size(); ++currentColumnIndex) {
            TableColumn tableColumn = (TableColumn)this.table.getColumns().get(currentColumnIndex);
            EFCTableColumnLayoutInfo tableColumnLayoutInfo = new EFCTableColumnLayoutInfo(tableColumn.getId(), currentColumnIndex + 1, (int)tableColumn.getWidth(), tableColumn.isVisible());
            tableColumnLayoutInfos.add(tableColumnLayoutInfo);
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        XMLEncoder xmlEncoder = new XMLEncoder(output);
        xmlEncoder.writeObject(tableColumnLayoutInfos);
        xmlEncoder.close();
        xmlString = output.toString();
        return xmlString;
    }

    public void setColumnModelXML(String xml) {
        List tableColumnLayoutInfos = null;
        if (xml != null && !xml.isEmpty()) {
            XMLDecoder xmlDecoder = new XMLDecoder(new ByteArrayInputStream(xml.getBytes()));
            Object xmlObject = xmlDecoder.readObject();
            if (xmlObject instanceof List && !((List)xmlObject).isEmpty() && ((List)xmlObject).get(0) instanceof EFCTableColumnLayoutInfo) {
                tableColumnLayoutInfos = (List)xmlObject;
            }
            xmlDecoder.close();
        }
        this.initColumns(tableColumnLayoutInfos);
    }

    public SearchService.SearchMetaInfo getSearchListMetaInfo() {
        return this.listInfo.get(this.activeListIndex.get());
    }

    public void setActiveListId(String activeListId) {
        if (this.activeListIndex.get() != -1 && this.listInfo.get(this.activeListIndex.get()) != null) {
            logger.debug("### Aktuelle Spalteninfo: ({} Spalten) ###", (Object)this.listInfo.get(this.activeListIndex.get()).getFields().size());
        }
        for (int i = 0; i < this.listInfo.size(); ++i) {
            if (!this.listInfo.get(i).getId().equals(activeListId)) continue;
            this.activeListIndex.set(i);
            break;
        }
        logger.debug("### Neue Spalteninfo: ({} Spalten) ###", (Object)this.listInfo.get(this.activeListIndex.get()).getFields().size());
    }

    public void setColumnControlType(EFCTableView.ColumnControlType columnControlType) {
        this.table.setColumnControlType(columnControlType);
    }

    public SimpleIntegerProperty getActiveListIndex() {
        return this.activeListIndex;
    }

    public EFCSearchCriteriaTable getTable() {
        return this.table;
    }
}

