/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.frame.searchframe;

import de.effectivecompany.app.sys.DcSysUsrRightsDetMapElm;
import de.effectivecompany.app.sys.MdSysXml;
import de.effectivecompany.base.datatypes.EFCBoolean;
import de.effectivecompany.base.datatypes.EFCDate;
import de.effectivecompany.base.datatypes.EFCDateTime;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.base.gui.data.SearchResult;
import de.effectivecompany.base.gui.data.SearchResultList;
import de.effectivecompany.base.gui.data.SearchService;
import de.effectivecompany.base.gui.filter.Filter;
import de.effectivecompany.base.gui.filter.FilterCriteria;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.data.EFCReportSelectionListEntry;
import de.effectivecompany.gui.components.EFCController;
import de.effectivecompany.gui.components.EFCMainMenu;
import de.effectivecompany.gui.components.EFCToolBar;
import de.effectivecompany.gui.components.editor.util.DateFormatter;
import de.effectivecompany.gui.components.editor.util.DateTimeFormatter;
import de.effectivecompany.gui.components.frame.EFCFrameLayoutInfo;
import de.effectivecompany.gui.components.frame.EFCInternalFrameView;
import de.effectivecompany.gui.components.frame.EFCSearchFrameInfo;
import de.effectivecompany.gui.components.frame.searchframe.EFCSearchCriteriaTablePane;
import de.effectivecompany.gui.components.frame.searchframe.EFCSearchResultTablePane;
import de.effectivecompany.gui.components.frame.searchframe.actions.EFCSearchFrameActualizeAction;
import de.effectivecompany.gui.components.frame.searchframe.columns.EFCSearchCriteriaBooleanColumn;
import de.effectivecompany.gui.components.frame.searchframe.columns.EFCSearchCriteriaColumn;
import de.effectivecompany.gui.components.frame.searchframe.columns.components.EFCSearchListComboBox;
import de.effectivecompany.gui.components.frame.searchframe.columns.components.EFCSearchStringCell;
import de.effectivecompany.gui.components.frame.searchframe.columns.components.EFCStoredSearchComboBox;
import de.effectivecompany.gui.components.fx.EFCTableExportDialog;
import de.effectivecompany.gui.components.fx.components.EFCTableView;
import de.effectivecompany.gui.components.fx.event.EFCAbstractAction;
import de.effectivecompany.gui.components.fx.event.EFCActionPrintBatchStart;
import de.effectivecompany.gui.components.fx.event.EFCActionStartBatch;
import de.effectivecompany.gui.components.fx.event.EFCActionWindowLock;
import de.effectivecompany.gui.components.fx.pane.EFCLockPane;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.constants.EFCAction;
import de.effectivecompany.gui.enums.EFCAutostart;
import de.effectivecompany.gui.enums.EFCSearchMode;
import de.effectivecompany.gui.exceptions.ActionNotAllowedException;
import de.effectivecompany.gui.factory.EFCPanelSingleton;
import de.effectivecompany.gui.interfaces.frame.BaseDialog;
import de.effectivecompany.gui.interfaces.frame.EFCFrame;
import de.effectivecompany.gui.interfaces.handler.ActionHandler;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.EFCThreadUtil;
import de.effectivecompany.gui.util.UnitConverter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.embed.swing.JFXPanel;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class EFCSearchFrame
extends EFCInternalFrameView
implements EFCFrame,
ActionHandler {
    private static final long serialVersionUID = 461727109665007002L;
    private static final Logger logger = LoggerFactory.getLogger(EFCSearchFrame.class);
    public ObjectProperty<Filter> FILTER_PROPERTY = new SimpleObjectProperty();
    private de.effectivecompany.gui.components.fx.EFCMainMenu mainMenu = new de.effectivecompany.gui.components.fx.EFCMainMenu();
    private de.effectivecompany.gui.components.fx.EFCToolBar mainToolbar;
    private EFCSearchCriteriaTablePane searchCriteriaTable;
    private EFCSearchResultTablePane searchResultTable;
    private EFCSearchListComboBox searchListSelectBox;
    private EFCStoredSearchComboBox storedSearchSelectBox;
    public static final String CURRENT_DATE_H = "H";
    public static final String CURRENT_DATE_T = "T";
    private String[] CRITERIA_ISNULL_ARRAY = new String[]{"#NULL#", "#LEER#", "#EMPTY#", "<LEER>"};
    private final EFCLockPane pin = new EFCLockPane();
    private Filter baseFilter;
    protected EFCController parentController;
    private EFCAutostart autostart;
    private Map<String, Object> param;
    private String callingField;
    private EFCReportSelectionListEntry callingReport;
    private EFCSearchMode searchMode;
    private CheckBox deletedDataBox;
    private CheckBox archivedDataBox;
    private JFXPanel panel = new JFXPanel();
    private boolean isWindowPositionLocked = false;
    protected SearchService.DcSearchMetaInfo dcSearchMetaInfo;
    private SearchService searchService;
    AnchorPane searchPanel;
    BorderPane border;
    Scene scene;

    public EFCSearchFrame(EFCController parent, String callingField, Filter filter, SearchService service, EFCSearchMode searchMode) {
        this(parent, callingField, "", filter, service, searchMode);
    }

    public EFCSearchFrame(EFCController parent, String callingField, String title, Filter filter, SearchService service, EFCSearchMode searchMode) {
        this(parent, callingField, title, filter, service, EFCAutostart.NOTHING, null, searchMode);
    }

    public EFCSearchFrame(EFCController parent, String callingField, String title, Filter filter, SearchService service, EFCAutostart autostart, Map<String, Object> param, EFCSearchMode searchMode) {
        super(title, new Dimension(200, 200), parent);
        this.autostart = autostart;
        this.param = param;
        this.callingField = callingField;
        this.searchMode = searchMode;
        this.baseFilter = filter;
        this.searchService = service;
        this.mainMenu.setActionHandler(this);
        if (title.isEmpty()) {
            if (callingField == null || callingField.isEmpty()) {
                String specialTitle = parent.getSearchServiceTitle();
                if (specialTitle.isEmpty()) {
                    this.setTitle(Translator.tr((String)service.getId()));
                } else {
                    this.setTitle(Translator.tr((String)"DLG_TITLE_SERACHFRAME") + " " + specialTitle);
                }
            } else {
                this.setTitle(Translator.tr((String)service.getId()));
            }
        }
        this.parentController = parent;
        if (this.parentController != null) {
            this.parentController.addSearchFrame(this);
        }
        this.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                EFCSearchFrame.this.handleAction("exit", null);
            }
        });
        this.setSize(UnitConverter.sizeFromDLU(EFCLookAndFeelManager.SIZE_FRAME_SEARCH, EFCDesktop.getInstance()));
        this.setFrameIcon(EFCLookAndFeelManager.ICON_APP_WUG);
        this.initGui(service);
    }

    private void initGui(final SearchService searchService) {
        EFCThreadUtil.doLaterFAT(() -> {
            EFCAbstractAction action;
            this.border = new BorderPane();
            this.searchPanel = new AnchorPane();
            StackPane root = new StackPane();
            root.getChildren().addAll((Object[])new Node[]{this.border, this.pin});
            this.scene = new Scene((Parent)root);
            this.searchCriteriaTable = new EFCSearchCriteriaTablePane();
            this.searchResultTable = new EFCSearchResultTablePane(this, true);
            this.searchListSelectBox = new EFCSearchListComboBox(this);
            this.storedSearchSelectBox = new EFCStoredSearchComboBox(this);
            this.mainToolbar = this.mainMenu.getToolBar();
            this.mainToolbar.setToolbarButtonVisible(EFCAction.invert(EFCAction.T_FRAME_SEARCH), false);
            this.mainMenu.setEnabledActions(EFCAction.M_FRAME_SEARCH);
            if (this.searchMode == EFCSearchMode.MODE_FOR_BATCH) {
                action = new EFCActionStartBatch();
                action.setActionHandler(this);
                this.mainToolbar.addBeforeAction(action, this.mainMenu.getAction(EFCAction.A_EXPORT));
            }
            if (this.searchMode == EFCSearchMode.MODE_FOR_PRINT) {
                action = new EFCActionPrintBatchStart();
                action.setActionHandler(this);
                this.mainToolbar.addBeforeAction(action, this.mainMenu.getAction(EFCAction.A_EXPORT));
                this.callingReport = (EFCReportSelectionListEntry)this.param.get("CALLING_REPORT");
            }
            Label listSelectLabel = new Label(Translator.tr((String)"DLG_SEARCH_CRITERIA_TITLE"));
            this.deletedDataBox = new CheckBox(Translator.tr((String)"DLG_SEARCH_SHOW_DELETED_DATA"));
            this.archivedDataBox = new CheckBox(Translator.tr((String)"DLG_SEARCH_SHOW_ARCHIVED_DATA"));
            this.archivedDataBox.setDisable(true);
            HBox searchOptions = new HBox();
            searchOptions.setSpacing(5.0);
            searchOptions.getChildren().addAll((Object[])new Node[]{listSelectLabel, this.searchListSelectBox, this.storedSearchSelectBox, this.deletedDataBox, this.archivedDataBox});
            Label titleSepLabel = new Label(Translator.tr((String)"DLG_SEARCH_SEPARATOR_OPTION"));
            Separator titleSep = new Separator();
            Label criteriaSepLabel = new Label(Translator.tr((String)"DLG_SEARCH_SEPARATOR_CRITERIA"));
            Separator criteriaSep = new Separator();
            Label resultSepLabel = new Label(Translator.tr((String)"DLG_SEARCH_SEPARATOR_RESULT"));
            Separator resultSep = new Separator();
            this.searchPanel.getChildren().addAll((Object[])new Node[]{titleSepLabel, titleSep, searchOptions, criteriaSepLabel, criteriaSep, resultSepLabel, resultSep, this.searchCriteriaTable, this.searchResultTable});
            AnchorPane.setTopAnchor((Node)titleSepLabel, (Double)5.0);
            AnchorPane.setLeftAnchor((Node)titleSepLabel, (Double)5.0);
            AnchorPane.setRightAnchor((Node)titleSepLabel, (Double)5.0);
            AnchorPane.setTopAnchor((Node)titleSep, (Double)20.0);
            AnchorPane.setLeftAnchor((Node)titleSep, (Double)5.0);
            AnchorPane.setRightAnchor((Node)titleSep, (Double)5.0);
            AnchorPane.setTopAnchor((Node)searchOptions, (Double)30.0);
            AnchorPane.setLeftAnchor((Node)searchOptions, (Double)5.0);
            AnchorPane.setRightAnchor((Node)searchOptions, (Double)5.0);
            AnchorPane.setTopAnchor((Node)criteriaSepLabel, (Double)55.0);
            AnchorPane.setLeftAnchor((Node)criteriaSepLabel, (Double)5.0);
            AnchorPane.setRightAnchor((Node)criteriaSepLabel, (Double)5.0);
            AnchorPane.setTopAnchor((Node)criteriaSep, (Double)70.0);
            AnchorPane.setLeftAnchor((Node)criteriaSep, (Double)5.0);
            AnchorPane.setRightAnchor((Node)criteriaSep, (Double)5.0);
            AnchorPane.setTopAnchor((Node)this.searchCriteriaTable, (Double)80.0);
            AnchorPane.setLeftAnchor((Node)this.searchCriteriaTable, (Double)5.0);
            AnchorPane.setRightAnchor((Node)this.searchCriteriaTable, (Double)5.0);
            AnchorPane.setTopAnchor((Node)resultSepLabel, (Double)265.0);
            AnchorPane.setLeftAnchor((Node)resultSepLabel, (Double)5.0);
            AnchorPane.setRightAnchor((Node)resultSepLabel, (Double)5.0);
            AnchorPane.setTopAnchor((Node)resultSep, (Double)280.0);
            AnchorPane.setLeftAnchor((Node)resultSep, (Double)5.0);
            AnchorPane.setRightAnchor((Node)resultSep, (Double)5.0);
            AnchorPane.setTopAnchor((Node)this.searchResultTable, (Double)290.0);
            AnchorPane.setLeftAnchor((Node)this.searchResultTable, (Double)0.0);
            AnchorPane.setRightAnchor((Node)this.searchResultTable, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)this.searchResultTable, (Double)0.0);
            this.scene.focusOwnerProperty().addListener((ChangeListener)new ChangeListener<Node>(){

                public void changed(ObservableValue<? extends Node> observable, Node oldValue, Node newValue) {
                    if (oldValue instanceof TextField && oldValue.getParent() instanceof EFCSearchStringCell) {
                        EFCSearchStringCell cell = (EFCSearchStringCell)oldValue.getParent();
                        cell.commitEdit(((TextField)oldValue).getText());
                    }
                }
            });
            this.scene.addEventHandler(KeyEvent.ANY, (EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    Node owner = (Node)EFCSearchFrame.this.scene.focusOwnerProperty().get();
                    switch (event.getCode()) {
                        case F5: {
                            EFCSearchFrame.this.handleAction("actualize", null);
                            break;
                        }
                        case ESCAPE: {
                            if (!(owner instanceof TextField) || !(owner.getParent() instanceof EFCSearchStringCell)) break;
                            EFCSearchStringCell cell = (EFCSearchStringCell)owner.getParent();
                            cell.cancelEdit();
                            break;
                        }
                    }
                }
            });
            VBox top = new VBox();
            top.getChildren().add((Object)this.mainMenu);
            top.getChildren().add((Object)this.mainToolbar);
            this.border.setCenter((Node)this.searchPanel);
            this.border.setTop((Node)top);
            this.panel.setScene(this.scene);
        });
        Task<SearchService.DcSearchMetaInfo> task = new Task<SearchService.DcSearchMetaInfo>(){

            protected SearchService.DcSearchMetaInfo call() throws Exception {
                return searchService.getDcSearchMetaInfo();
            }
        };
        this.setWorking(true);
        task.setOnSucceeded(taskEvent -> {
            this.setWorking(false);
            if (taskEvent.getSource().valueProperty().get() != null) {
                this.dcSearchMetaInfo = (SearchService.DcSearchMetaInfo)taskEvent.getSource().valueProperty().get();
                EFCThreadUtil.doLaterFAT(() -> {
                    EFCFrameLayoutInfo posInfo = EFCPanelSingleton.getInstance().getFramePosition(this.dcSearchMetaInfo.getId(), this.parentController.getLayoutFileName());
                    if (posInfo != null) {
                        Dimension dim = new Dimension(posInfo.getWidth(), posInfo.getHeight());
                        this.setSize(dim);
                        this.setPreferredSize(dim);
                        if (this instanceof BaseDialog) {
                            this.setLocation(new Point(posInfo.getLocationX(), posInfo.getLocationY()));
                        } else {
                            EFCDesktop.getInstance().getDesktopManager().setBoundsForFrame(this, posInfo.getLocationX(), posInfo.getLocationY(), this.getPreferredSize().width, this.getPreferredSize().height);
                        }
                        this.isWindowPositionLocked = true;
                        EFCActionWindowLock windowLockAction = (EFCActionWindowLock)this.mainToolbar.getAction(EFCActionWindowLock.class);
                        if (windowLockAction != null) {
                            windowLockAction.setIsSelected(this.isWindowPositionLocked);
                        }
                        logger.info("setzte Benutzer-bezogene Frame-Position in: " + this.dcSearchMetaInfo.getId() + " - " + this.parentController.getLayoutFileName());
                    } else if (this instanceof BaseDialog) {
                        this.setLocation(null);
                    }
                    if (!this.isDialogView()) {
                        this.getContentPane().add((Component)this.panel);
                        this.setVisible(true);
                    }
                });
                this.searchCriteriaTable.setSearchServiceMetaInfos(this.dcSearchMetaInfo);
                EFCList<MdSysXml> data = EFCPanelSingleton.getInstance().getSearchPatternList(this.dcSearchMetaInfo.getId());
                this.searchListSelectBox.init(this.dcSearchMetaInfo);
                this.storedSearchSelectBox.init(data);
                if (this.autostart != null && this.autostart != EFCAutostart.NOTHING && this.param != null) {
                    this.autostart(this.autostart, this.param);
                }
                this.searchCriteriaTable.getTable().addTableColumnListener(this.searchResultTable.getTable());
            }
        });
        task.setOnFailed(taskEvent -> {
            this.setWorking(false);
            logger.error("", taskEvent.getSource().exceptionProperty().get());
            EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
        });
        EFCThreadUtil.getCachedExecutorService().execute((Runnable)task);
    }

    public void refreshStoredSearchSelectBox() {
        MdSysXml selectedSearch = (MdSysXml)this.storedSearchSelectBox.getSelectionModel().getSelectedItem();
        if (selectedSearch != null) {
            Filter filter = null;
            if (selectedSearch.getCode().getData() != null && !selectedSearch.getCode().getData().isEmpty()) {
                ByteArrayInputStream bais = new ByteArrayInputStream(selectedSearch.getCode().getData().getBytes());
                try {
                    filter = new Filter((InputStream)bais);
                }
                catch (SAXException e) {
                    e.printStackTrace();
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                logger.error("code value is NULL! ignoring " + selectedSearch.getSysxmlcodekey().getData());
                filter = new Filter();
            }
            this.searchCriteriaTable.setActiveListId(selectedSearch.getSysxmlcode().getData());
            this.searchListSelectBox.getSelectionModel().select(this.searchCriteriaTable.getActiveListIndex().get());
            this.loadFromFilter(filter);
        }
    }

    public void refreshSearchListSelectBox() {
        this.bindTables(false);
        this.searchCriteriaTable.setActiveListId(this.getActiveListId());
        DcSysUsrRightsDetMapElm modElm = EFCPanelSingleton.getInstance().getFrameTableModel(this.dcSearchMetaInfo.getId(), this.getActiveListId());
        EFCThreadUtil.doLaterFAT(() -> {
            if (modElm != null) {
                this.searchCriteriaTable.setColumnModelXML(modElm.getElmCode().getData());
                if (modElm.getElmByAdmin().getData().booleanValue()) {
                    this.searchCriteriaTable.setColumnControlType(EFCTableView.ColumnControlType.ALL_USERS);
                    this.searchResultTable.setColumnControlType(EFCTableView.ColumnControlType.ALL_USERS);
                } else {
                    this.searchCriteriaTable.setColumnControlType(EFCTableView.ColumnControlType.USER);
                    this.searchResultTable.setColumnControlType(EFCTableView.ColumnControlType.USER);
                }
            } else {
                this.searchCriteriaTable.setColumnModelXML(null);
                this.searchCriteriaTable.setColumnControlType(EFCTableView.ColumnControlType.NONE);
                this.searchResultTable.setColumnControlType(EFCTableView.ColumnControlType.NONE);
            }
        });
        this.getSearchResultTable().initColumns();
        this.bindTables(true);
    }

    public void bindTables(boolean bind) {
        if (bind) {
            this.getEFCSearchCriteriaTable().getTable().getColumns().forEach(critColumn -> this.searchResultTable.getTable().getColumns().forEach(resultColumn -> {
                if (critColumn.getId().equalsIgnoreCase(resultColumn.getId())) {
                    resultColumn.visibleProperty().bindBidirectional((Property)critColumn.visibleProperty());
                    resultColumn.prefWidthProperty().bind((ObservableValue)critColumn.widthProperty());
                    critColumn.prefWidthProperty().bind((ObservableValue)resultColumn.widthProperty());
                }
            }));
        } else {
            this.getEFCSearchCriteriaTable().getTable().getColumns().forEach(critColumn -> this.searchResultTable.getTable().getColumns().forEach(resultColumn -> {
                if (critColumn.getId().equalsIgnoreCase(resultColumn.getId())) {
                    resultColumn.visibleProperty().unbindBidirectional((Property)critColumn.visibleProperty());
                    resultColumn.prefWidthProperty().unbind();
                    critColumn.prefWidthProperty().unbind();
                }
            }));
        }
    }

    public String getCallingField() {
        return this.callingField;
    }

    public EFCReportSelectionListEntry getCallingReport() {
        return this.callingReport;
    }

    public EFCSearchMode getSearchMode() {
        return this.searchMode;
    }

    private void autostart(EFCAutostart type, Map<String, Object> param) {
        switch (type) {
            case SELECT: {
                SearchService.SearchMetaInfo searchMetaInfo;
                if (!param.containsKey("listname") || (searchMetaInfo = (SearchService.SearchMetaInfo)this.searchListSelectBox.getItems().stream().filter(item -> item.getId().equals(param.get("listname"))).findFirst().orElse(null)) == null) break;
                this.searchListSelectBox.getSelectionModel().select((Object)searchMetaInfo);
                break;
            }
            case SELECTSAVED: {
                MdSysXml storedSearch;
                if (!param.containsKey("listname") || (storedSearch = this.storedSearchSelectBox.getItems().stream().filter(item -> item.getSysxmlcodekey().getData() != null && item.getSysxmlcodekey().getData().equals(param.get("listname"))).findFirst().get()) == null) break;
                this.storedSearchSelectBox.getSelectionModel().select((Object)storedSearch);
                this.refreshStoredSearchSelectBox();
                break;
            }
            case SEARCH: {
                if (param.containsKey("listname")) {
                    SearchService.SearchMetaInfo search = this.searchListSelectBox.getItems().stream().filter(item -> item.getId() != null && item.getId().equals(param.get("listname"))).findFirst().get();
                    if (search == null) break;
                    this.searchListSelectBox.getSelectionModel().select((Object)search);
                    this.actualize(param);
                    break;
                }
                this.actualize(param);
                break;
            }
            case SEARCHSAVED: {
                MdSysXml storedSearch;
                if (!param.containsKey("listname") || (storedSearch = this.storedSearchSelectBox.getItems().stream().filter(item -> item.getSysxmlcodekey().getData() != null && item.getSysxmlcodekey().getData().equals(param.get("listname"))).findFirst().get()) == null) break;
                this.storedSearchSelectBox.getSelectionModel().select((Object)storedSearch);
                this.refreshStoredSearchSelectBox();
                this.actualize(param);
                break;
            }
            default: {
                logger.debug("autostart type not implemented");
            }
        }
    }

    private Boolean isCriteriaNull(String value) {
        for (int i = 0; i < this.CRITERIA_ISNULL_ARRAY.length; ++i) {
            if (!value.equals(this.CRITERIA_ISNULL_ARRAY[i])) continue;
            return true;
        }
        return false;
    }

    private void actualize(Map<String, Object> param) {
        if (param.containsKey("filter")) {
            if (param.get("filter") instanceof Filter) {
                this.loadFromFilter((Filter)param.get("filter"));
            } else {
                logger.debug("filter parameter is no Filter object, parameter ignored");
            }
        }
        this.handleAction("actualize", null);
    }

    public SearchService.DcSearchMetaInfo getSearchServiceMetaInfos() {
        return this.dcSearchMetaInfo;
    }

    public Filter buildFilter() {
        Filter subfilter;
        logger.debug("*** buildfilter ***");
        Filter filter = new Filter();
        if (this.baseFilter != null) {
            filter.addSubfilter(this.baseFilter);
        }
        if ((subfilter = this.getFilterFromTable(true)).getCriteriaSize() > 0) {
            filter.addSubfilter(subfilter);
        }
        return filter;
    }

    private Filter getFilterFromTable(Boolean isForSearch) {
        Filter filter = new Filter();
        for (int col = 1; col <= this.searchCriteriaTable.getTable().getColumns().size(); ++col) {
            TableColumn tableColumn = (TableColumn)this.searchCriteriaTable.getTable().getColumns().get(col - 1);
            block14: for (int row = 0; row < this.searchCriteriaTable.getTable().getItems().size(); ++row) {
                String field;
                String value;
                Map map = (Map)this.searchCriteriaTable.getTable().getItems().get(row);
                SearchService.SearchMetaInfo metaInfo = this.searchCriteriaTable.getSearchListMetaInfo();
                SearchService.SearchColumnInfo colInfo = metaInfo.getFields().stream().filter(item -> item.getName().equalsIgnoreCase(tableColumn.getId())).findFirst().get();
                if (colInfo == null || (value = (String)map.get(field = colInfo.getName().toUpperCase())) == null || value.isEmpty()) continue;
                if (tableColumn instanceof EFCSearchCriteriaColumn) {
                    Class<? extends Type> cellClass = ((EFCSearchCriteriaColumn)tableColumn).getColumnClass();
                    if (isForSearch.booleanValue() && value instanceof String && (EFCDate.class == cellClass || EFCDateTime.class == cellClass) && (value.toString().contains(CURRENT_DATE_H) || value.toString().contains(CURRENT_DATE_T))) {
                        String dateDiff = this.createDateDiff(value);
                        EFCDate newDate = null;
                        if (!dateDiff.equals("") && dateDiff.matches("[+|-]+\\d+")) {
                            dateDiff = dateDiff.replace("+", "");
                            Calendar calendar = Calendar.getInstance();
                            calendar.setTime(new Date());
                            calendar.add(6, Integer.decode(dateDiff));
                            newDate = new EFCDate(calendar.getTime());
                        } else {
                            newDate = new EFCDate(new Date());
                        }
                        value = EFCDate.class == cellClass ? newDate.toString() : new EFCDateTime(newDate).toString();
                    } else {
                        if (!(EFCDate.class != cellClass || this.isCriteriaNull(value).booleanValue() || value.toString().contains(CURRENT_DATE_H) || value.toString().contains(CURRENT_DATE_T))) {
                            value = new EFCDate(DateFormatter.convertDate(value)).toString();
                        }
                        if (!(EFCDateTime.class != cellClass || this.isCriteriaNull(value).booleanValue() || value.toString().contains(CURRENT_DATE_H) || value.toString().contains(CURRENT_DATE_T))) {
                            value = new EFCDateTime(DateTimeFormatter.convertDate(value)).toString();
                        }
                    }
                }
                switch (row) {
                    case 0: {
                        if (tableColumn.getClass().isAssignableFrom(EFCSearchCriteriaBooleanColumn.class)) {
                            if (value.equals("-1")) {
                                filter.addCriteria(new FilterCriteria(field, 10, null));
                                continue block14;
                            }
                            filter.addCriteria(new FilterCriteria(field, 0, (Object)value));
                            continue block14;
                        }
                        if (tableColumn.getClass().isAssignableFrom(EFCSearchCriteriaColumn.class)) {
                            if (isForSearch.booleanValue() && this.isCriteriaNull(value).booleanValue()) {
                                filter.addCriteria(new FilterCriteria(field, 10, null));
                                continue block14;
                            }
                            filter.addCriteria(new FilterCriteria(field, 0, (Object)value));
                            continue block14;
                        }
                        filter.addCriteria(new FilterCriteria(field, 0, (Object)value));
                        continue block14;
                    }
                    case 1: {
                        if (tableColumn.getClass().isAssignableFrom(EFCSearchCriteriaBooleanColumn.class)) {
                            if (value.equals("-1")) {
                                filter.addCriteria(new FilterCriteria(field, 11, null));
                                continue block14;
                            }
                            filter.addCriteria(new FilterCriteria(field, 1, (Object)value));
                            if (!value.equals("1")) continue block14;
                            Filter orFilter = new Filter(2);
                            orFilter.addCriteria(new FilterCriteria(field, 10, (Object)value));
                            filter.addSubfilter(orFilter);
                            continue block14;
                        }
                        if (isForSearch.booleanValue() && this.isCriteriaNull(value).booleanValue()) {
                            filter.addCriteria(new FilterCriteria(field, 1, (Object)""));
                            continue block14;
                        }
                        filter.addCriteria(new FilterCriteria(field, 1, (Object)value));
                        continue block14;
                    }
                    case 2: {
                        if (EFCLookAndFeelManager.SEARCH_POLICY == 1) {
                            filter.addCriteria(new FilterCriteria(field, 6, (Object)value));
                            continue block14;
                        }
                        filter.addCriteria(new FilterCriteria(field, 9, (Object)value));
                        continue block14;
                    }
                    case 3: {
                        filter.addCriteria(new FilterCriteria(field, 3, (Object)value));
                        continue block14;
                    }
                    case 4: {
                        filter.addCriteria(new FilterCriteria(field, 5, (Object)value));
                        continue block14;
                    }
                    case 5: {
                        filter.addCriteria(new FilterCriteria(field, 7, (Object)value));
                        continue block14;
                    }
                    case 6: {
                        filter.addCriteria(new FilterCriteria(field, 8, (Object)value));
                    }
                }
            }
        }
        if (!this.deletedDataBox.isSelected()) {
            filter.addCriteria(new FilterCriteria("ISDELETED", 0, (Object)0));
        }
        for (TableColumn col : this.searchResultTable.getTable().getSortOrder()) {
            switch (col.getSortType()) {
                case ASCENDING: {
                    filter.setOrderbytype("ASC");
                    break;
                }
                case DESCENDING: {
                    filter.setOrderbytype("DESC");
                }
            }
            filter.setOrderbyfield(col.getId());
        }
        this.FILTER_PROPERTY.set((Object)filter);
        return filter;
    }

    private String createDateDiff(Object value) {
        String dateDiff = value.toString();
        dateDiff = dateDiff.replace(CURRENT_DATE_H, "");
        dateDiff = dateDiff.replace(CURRENT_DATE_T, "");
        dateDiff = dateDiff.replace(" ", "");
        return dateDiff;
    }

    public void setResultList(SearchResultList list) {
        this.searchResultTable.setSearchResults(list);
    }

    public void loadFromFilter(Filter filter) {
        TableColumn<SearchResult, ?> col;
        if (filter != null) {
            this.FILTER_PROPERTY.set((Object)filter);
            this.searchCriteriaTable.getTable().getItems().forEach(map -> map.clear());
            logger.debug("loading from filter: {}", (Object)filter.toString());
            HashMap fieldCriteria = new HashMap();
            for (int i = 0; i < filter.getCriteriaSize(); ++i) {
                FilterCriteria criteria = filter.getCriteria(i);
                String field = criteria.getFieldname().toUpperCase();
                if (!fieldCriteria.containsKey(field)) {
                    fieldCriteria.put(field, new LinkedList());
                }
                ((List)fieldCriteria.get(field)).add(criteria);
            }
            this.searchCriteriaTable.getTable().getColumns().forEach(tableColumn -> {
                String colName;
                SearchService.SearchMetaInfo metaInfo = this.searchCriteriaTable.getSearchListMetaInfo();
                SearchService.SearchColumnInfo colInfo = metaInfo.getFields().stream().filter(item -> item.getName().equalsIgnoreCase(tableColumn.getId())).findFirst().get();
                if (colInfo != null && fieldCriteria.containsKey(colName = colInfo.getName().toUpperCase())) {
                    List criterias = (List)fieldCriteria.get(colName);
                    for (FilterCriteria criteria : criterias) {
                        String value = criteria.getValue().toString();
                        if (tableColumn instanceof EFCSearchCriteriaColumn) {
                            Class<? extends Type> cellClass = ((EFCSearchCriteriaColumn)((Object)tableColumn)).getColumnClass();
                            if (!(EFCDate.class != cellClass || value.isEmpty() || this.isCriteriaNull(value).booleanValue() || value.toString().contains(CURRENT_DATE_H) || value.toString().contains(CURRENT_DATE_T))) {
                                value = DateFormat.getDateInstance().format(new EFCDate(value).getDate());
                            }
                            if (!(EFCDateTime.class != cellClass || value.isEmpty() || this.isCriteriaNull(value).booleanValue() || value.toString().contains(CURRENT_DATE_H) || value.toString().contains(CURRENT_DATE_T))) {
                                value = DateFormat.getDateTimeInstance().format(new EFCDateTime(value).getDate());
                            }
                        }
                        switch (criteria.getCondition()) {
                            case 0: {
                                Map map = (Map)this.searchCriteriaTable.getTable().getItems().get(0);
                                map.put(colName, value);
                                break;
                            }
                            case 1: {
                                Map map = (Map)this.searchCriteriaTable.getTable().getItems().get(1);
                                map.put(colName, value);
                                break;
                            }
                            case 9: {
                                Map map = (Map)this.searchCriteriaTable.getTable().getItems().get(2);
                                map.put(colName, value);
                                break;
                            }
                            case 6: {
                                Map map = (Map)this.searchCriteriaTable.getTable().getItems().get(2);
                                map.put(colName, value);
                                break;
                            }
                            case 3: {
                                Map map = (Map)this.searchCriteriaTable.getTable().getItems().get(3);
                                map.put(colName, value);
                                break;
                            }
                            case 5: {
                                Map map = (Map)this.searchCriteriaTable.getTable().getItems().get(4);
                                map.put(colName, value);
                                break;
                            }
                            case 7: {
                                Map map = (Map)this.searchCriteriaTable.getTable().getItems().get(5);
                                map.put(colName, value);
                                break;
                            }
                            case 8: {
                                Map map = (Map)this.searchCriteriaTable.getTable().getItems().get(6);
                                map.put(colName, value);
                            }
                        }
                    }
                }
            });
        }
        this.searchCriteriaTable.getTable().refresh();
        if (filter.getOrderbyfield() != null && !filter.getOrderbyfield().isEmpty() && (col = this.searchResultTable.getTable().getColumn(filter.getOrderbyfield())) != null) {
            if (filter.getOrderbytype().equals("ASC")) {
                col.setSortType(TableColumn.SortType.ASCENDING);
            }
            if (filter.getOrderbytype().equals("DESC")) {
                col.setSortType(TableColumn.SortType.DESCENDING);
            }
            this.searchResultTable.getTable().getSortOrder().add(col);
        }
    }

    public String getActiveListId() {
        return ((SearchService.SearchMetaInfo)this.searchListSelectBox.valueProperty().get()).getId();
    }

    @Override
    public void handleAction(String ident, Object param) {
        if ("actualize".equals(ident)) {
            new EFCSearchFrameActualizeAction(this);
        } else if ("new".equals(ident)) {
            this.storedSearchSelectBox.getSelectionModel().select(0);
            this.refreshStoredSearchSelectBox();
            this.getSearchResultTable().getTable().getItems().clear();
        } else if ("savetablayout".equals(ident)) {
            EFCThreadUtil.fatBuilder(th -> {
                this.setWorking(true);
                th.doOutside(() -> {
                    String id = "";
                    EFCBoolean forAllUsers = new EFCBoolean(Boolean.valueOf(false));
                    try {
                        id = this.searchCriteriaTable.getSearchListMetaInfo().getId();
                    }
                    catch (Throwable t) {
                        EFCDesktop.reportError(t);
                    }
                    if (EFCPanelSingleton.getInstance().getIsUsrRgtTableLayoutAll().booleanValue()) {
                        forAllUsers.setData(Boolean.valueOf(EFCDesktop.showYesNoDlg(Translator.tr((String)"MSG_FRAME_OPTIONDLG_TABLELAYOUT_SAVE_FOR_ALL"), Translator.tr((String)"MSG_FRAME_OPTIONDLG_ADMINUSER")) == 0));
                    }
                    EFCPanelSingleton.getInstance().setFrameTableModel(this.dcSearchMetaInfo.getId(), id, this.searchCriteriaTable.getColumnModelXML(), forAllUsers.getBoolean());
                    th.fat(() -> {
                        if (forAllUsers.getBoolean().booleanValue()) {
                            this.searchResultTable.setColumnControlType(EFCTableView.ColumnControlType.ALL_USERS);
                            this.searchCriteriaTable.setColumnControlType(EFCTableView.ColumnControlType.ALL_USERS);
                        } else {
                            this.searchResultTable.setColumnControlType(EFCTableView.ColumnControlType.USER);
                            this.searchCriteriaTable.setColumnControlType(EFCTableView.ColumnControlType.USER);
                        }
                        this.setWorking(false);
                    });
                });
            });
        } else if ("deletetablayout".equals(ident)) {
            EFCThreadUtil.fatBuilder(th -> {
                this.setWorking(true);
                th.doOutside(() -> {
                    String id = "";
                    try {
                        id = this.searchCriteriaTable.getSearchListMetaInfo().getId();
                    }
                    catch (Throwable t) {
                        EFCDesktop.reportError(t);
                    }
                    EFCList tmpTabLayoutList = new EFCList();
                    tmpTabLayoutList.addAll(EFCPanelSingleton.getInstance().getFrameTableModelList(this.dcSearchMetaInfo.getId(), id));
                    boolean forAllUsers = false;
                    if (EFCPanelSingleton.getInstance().getUsrIsAdmin().booleanValue() && tmpTabLayoutList.stream().filter(mdSysXml -> !mdSysXml.getUsername().getData().equals("*")).findFirst() != null) {
                        forAllUsers = EFCDesktop.showYesNoDlg(Translator.tr((String)"MSG_FRAME_OPTIONDLG_TABLELAYOUT_DELETE_FOR_ALL"), Translator.tr((String)"MSG_FRAME_OPTIONDLG_ADMINUSER")) == 0;
                    }
                    EFCPanelSingleton.getInstance().removeFrameTableModel(forAllUsers, (List<MdSysXml>)tmpTabLayoutList);
                    th.fat(() -> {
                        this.setWorking(false);
                        this.refreshSearchListSelectBox();
                    });
                });
            });
        } else if ("save".equals(ident)) {
            EFCThreadUtil.fatBuilder(th -> {
                this.setWorking(true);
                th.doOutside(() -> {
                    boolean isContinue = true;
                    String id = "";
                    String userName = EFCPanelSingleton.getInstance().getUsrName();
                    MdSysXml selectedItem = null;
                    selectedItem = (MdSysXml)this.storedSearchSelectBox.getSelectionModel().getSelectedItem();
                    id = ((SearchService.SearchMetaInfo)this.searchListSelectBox.getSelectionModel().getSelectedItem()).getId();
                    String oldText = selectedItem != null ? selectedItem.getSysxmlcodekey().getData() : "";
                    String saveSearchText = EFCDesktop.showInputDialog("", "", Translator.tr((String)"MSG_FRAME_OPTIONDLG_SEARCHLIST_SAVE_AS_LABEL"), oldText, 25);
                    if (saveSearchText == null || saveSearchText.isEmpty()) {
                        isContinue = false;
                    }
                    if (isContinue) {
                        boolean forAllUsers = false;
                        if (EFCPanelSingleton.getInstance().getIsUsrRgtSearchListAll().booleanValue() && (forAllUsers = EFCDesktop.showYesNoDialog(Translator.tr((String)"MSG_FRAME_OPTIONDLG_ADMINUSER"), "", Translator.tr((String)"MSG_FRAME_OPTIONDLG_SEARCHLIST_SAVE_FOR_ALL")).booleanValue())) {
                            userName = "*";
                        }
                        String checkIdText = saveSearchText + " | " + userName;
                        MdSysXml existingRow = this.storedSearchSelectBox.getItems().stream().filter(item -> checkIdText.equals(item.getSysxmlcodekey().getData() + " | " + item.getUsername().getData())).findFirst().orElse(null);
                        boolean replaceEntry = true;
                        if (existingRow != null) {
                            replaceEntry = EFCDesktop.showYesNoDialog(Translator.tr((String)"MSG_FRAME_ERROR_ENTRY_ALLREADY_EXISTS_TITLE"), "", Translator.tr((String)"MSG_FRAME_OPTIONDLG_SEARCHLIST_REPLACE", (Object)saveSearchText));
                        }
                        if (replaceEntry) {
                            logger.debug("writing entry to database");
                            if (existingRow != null) {
                                logger.debug("-> old entry will be replaced");
                                EFCPanelSingleton.getInstance().removeSearchPattern(existingRow);
                            }
                            logger.debug("searchlist: " + id);
                            String filter = this.getFilterFromTable(false).getAsXML();
                            logger.debug("filter: " + filter);
                            MdSysXml row = EFCPanelSingleton.getInstance().setSearchPattern(this.dcSearchMetaInfo.getId(), id, saveSearchText, forAllUsers, filter);
                            if (row != null) {
                                th.fat(th2 -> {
                                    if (existingRow != null) {
                                        this.storedSearchSelectBox.getItems().remove((Object)existingRow);
                                    }
                                    this.storedSearchSelectBox.getItems().add((Object)row);
                                    this.storedSearchSelectBox.getSelectionModel().select((Object)row);
                                });
                            }
                        }
                    }
                    th.fat(th3 -> this.setWorking(false));
                });
            });
        } else if ("delete".equals(ident)) {
            EFCThreadUtil.fatBuilder(th -> {
                this.setWorking(true);
                th.doOutside(() -> {
                    AtomicBoolean isDeleted = new AtomicBoolean();
                    MdSysXml selectedItem = (MdSysXml)this.storedSearchSelectBox.getSelectionModel().getSelectedItem();
                    if (selectedItem == null) {
                        EFCDesktop.showWarningDialog(Translator.tr((String)"MSG_FRAME_ACTION_DELETE_ERROR_TITLE"), "", Translator.tr((String)"MSG_FRAME_NO_ENTRY_FOUND"));
                        return;
                    }
                    boolean deleteEntry = true;
                    if (selectedItem.getUsername().getData().equals("*") && !EFCPanelSingleton.getInstance().getIsUsrRgtSearchListAll().booleanValue()) {
                        EFCDesktop.showWarningDialog(Translator.tr((String)"MSG_FRAME_ACTION_DELETE_ERROR_TITLE"), "", Translator.tr((String)"MSG_FRAME_ACTION_DELETE_ONLY_BY_ADMINUSER"));
                        return;
                    }
                    deleteEntry = EFCDesktop.showYesNoDialog(Translator.tr((String)"MSG_FRAME_OPTIONDLG_DELETE_TITLE"), "", Translator.tr((String)"MSG_FRAME_OPTIONDLG_DELETE_ENTRY_CONFIRMATION", (Object[])new String[]{selectedItem.getSysxmlcodekey().getData() + " | " + selectedItem.getUsername().getData()}));
                    if (deleteEntry) {
                        logger.debug("deleting entry to database");
                        isDeleted.set(EFCPanelSingleton.getInstance().removeSearchPattern(selectedItem));
                    }
                    th.fat(() -> {
                        if (isDeleted.get()) {
                            this.storedSearchSelectBox.getItems().remove((Object)selectedItem);
                            this.storedSearchSelectBox.getSelectionModel().select(0);
                            this.searchListSelectBox.getSelectionModel().select(0);
                        }
                        this.setWorking(false);
                    });
                });
            });
        } else if ("frameinfo".equals(ident)) {
            new EFCSearchFrameInfo(this);
        } else if ("go_next".equals(ident)) {
            this.searchResultTable.selectNext();
        } else if ("go_previous".equals(ident)) {
            this.searchResultTable.selectBefore();
        } else if ("data_export".equals(ident)) {
            EFCTableExportDialog dlg = new EFCTableExportDialog(this.searchResultTable.getTable(), this.searchCriteriaTable.getSearchListMetaInfo());
            dlg.showAndWait();
        } else if ("start_batch".equals(ident)) {
            this.getParentController().handleSearchBatch(this.getSearchResultTable().getSearchresultKeys(), this.getCallingField());
            this.handleAction("exit", null);
        } else if ("start_print_batch".equals(ident)) {
            this.getParentController().printBatch(this.getSearchResultTable().getSearchresultKeys(), this.getCallingReport());
            this.handleAction("exit", null);
        } else if ("exit".equals(ident)) {
            this.dispose();
        } else if ("windowlock".equals(ident)) {
            this.lockWindowPosition(this.isWindowPositionLocked);
        }
    }

    protected void lockWindowPosition(Boolean isLocked) {
        if (!isLocked.booleanValue()) {
            String frameName = this.dcSearchMetaInfo.getId();
            Dimension preferredSize = this.getSize();
            Point location = this.getLocation();
            boolean isMaximized = this.isMaximum();
            EFCFrameLayoutInfo layoutInfo = new EFCFrameLayoutInfo(frameName, preferredSize.getSize().width, preferredSize.getSize().height, location.x, location.y, isMaximized);
            EFCPanelSingleton.getInstance().setFramePosition(frameName, this.parentController.getLayoutFileName(), layoutInfo);
        } else {
            EFCPanelSingleton.getInstance().removeFramePosition(this.dcSearchMetaInfo.getId(), this.parentController.getLayoutFileName());
        }
    }

    public EFCController getParentController() {
        return this.parentController;
    }

    @Override
    public void dispose() {
        this.parentController.removeSearchFrame(this);
        super.dispose();
    }

    @Override
    public boolean isClosingAllowed() throws ActionNotAllowedException {
        return true;
    }

    public EFCSearchResultTablePane getSearchResultTable() {
        return this.searchResultTable;
    }

    public EFCSearchCriteriaTablePane getEFCSearchCriteriaTable() {
        return this.searchCriteriaTable;
    }

    public void setWorking(boolean isWorking) {
        this.pin.setVisible(isWorking);
    }

    @Override
    public EFCMainMenu getMainMenu() {
        return null;
    }

    @Override
    public EFCToolBar getMainToolbar() {
        return null;
    }

    public JFXPanel getPanel() {
        return this.panel;
    }

    public SearchService getSearchService() {
        return this.searchService;
    }

    public EFCStoredSearchComboBox getStoredSearchSelectBox() {
        return this.storedSearchSelectBox;
    }
}

