/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.frame.searchframe;

import de.effectivecompany.base.datatypes.EFCBoolean;
import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.base.gui.data.SearchResult;
import de.effectivecompany.base.gui.data.SearchResultList;
import de.effectivecompany.base.gui.data.SearchService;
import de.effectivecompany.base.gui.key.Key;
import de.effectivecompany.gui.components.frame.searchframe.EFCSearchFrame;
import de.effectivecompany.gui.components.frame.searchframe.EFCSearchResultRowFactory;
import de.effectivecompany.gui.components.frame.searchframe.EFCSearchResultTable;
import de.effectivecompany.gui.components.frame.searchframe.columns.EFCSearchResultBooleanColumn;
import de.effectivecompany.gui.components.frame.searchframe.columns.EFCSearchResultColumn;
import de.effectivecompany.gui.components.fx.components.EFCTableView;
import de.effectivecompany.gui.enums.EFCSearchMode;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;

public class EFCSearchResultTablePane
extends AnchorPane {
    public static final String NUMBER_HEADER = "#";
    private EFCSearchFrame parent;
    private EFCSearchResultTable table = new EFCSearchResultTable();
    private SearchResultList resultList;
    private EFCMap<Integer, Key> keyMap = new EFCMap();
    private boolean withNumberRowHeader = false;
    private TableColumn<SearchResult, String> numberColumn;

    public EFCSearchResultTablePane(final EFCSearchFrame parent, boolean withNumberRowHeader) {
        this.parent = parent;
        this.withNumberRowHeader = withNumberRowHeader;
        this.table.setParent(this);
        this.table.setCriteriaPane(parent.getEFCSearchCriteriaTable().getTable());
        this.init();
        parent.getEFCSearchCriteriaTable().getActiveListIndex().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Platform.runLater(() -> {
                    parent.bindTables(false);
                    EFCSearchResultTablePane.this.initColumns();
                    parent.bindTables(true);
                });
            }
        });
    }

    public TableColumn<SearchResult, String> getNumberColumn() {
        return this.numberColumn;
    }

    public void selectNext() {
        this.table.selectNext();
    }

    public void selectBefore() {
        this.table.selectBefore();
    }

    public void init() {
        if (this.parent.getSearchMode() != EFCSearchMode.MODE_FOR_BATCH && this.parent.getSearchMode() != EFCSearchMode.MODE_FOR_PRINT) {
            this.table.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<SearchResult>(){

                public void changed(ObservableValue<? extends SearchResult> observable, SearchResult oldValue, SearchResult newValue) {
                    Map selectedItem;
                    Key key = null;
                    if (EFCSearchResultTablePane.this.table.getSelectionModel().getSelectedItem() != null && (selectedItem = ((SearchResult)EFCSearchResultTablePane.this.table.getSelectionModel().getSelectedItem()).getData()) != null) {
                        int keyId = System.identityHashCode(selectedItem);
                        if (EFCSearchResultTablePane.this.resultList != null && selectedItem != null && EFCSearchResultTablePane.this.keyMap.containsKey((Object)keyId)) {
                            key = (Key)EFCSearchResultTablePane.this.keyMap.get((Object)keyId);
                        }
                        EFCSearchResultTablePane.this.parent.getParentController().handleSearchUpdate(key, EFCSearchResultTablePane.this.parent.getCallingField(), EFCSearchResultTablePane.this.parent.getSearchServiceMetaInfos().getId(), EFCSearchResultTablePane.this.parent.buildFilter(), th -> {
                            EFCSearchResultTablePane.this.parent.getPanel().requestFocusInWindow();
                            EFCSearchResultTablePane.this.table.requestFocus();
                        });
                    }
                }
            });
        }
        this.getChildren().addAll((Object[])new Node[]{this.table});
        AnchorPane.setTopAnchor((Node)this.table, (Double)0.0);
        if (this.withNumberRowHeader) {
            AnchorPane.setLeftAnchor((Node)this.table, (Double)5.0);
        } else {
            AnchorPane.setLeftAnchor((Node)this.table, (Double)100.0);
        }
        AnchorPane.setRightAnchor((Node)this.table, (Double)5.0);
        AnchorPane.setBottomAnchor((Node)this.table, (Double)5.0);
    }

    public void initColumns() {
        ObservableList columns = FXCollections.observableArrayList();
        this.table.getItems().clear();
        if (this.withNumberRowHeader) {
            this.numberColumn = new TableColumn(NUMBER_HEADER);
            this.numberColumn.setId(NUMBER_HEADER);
            this.numberColumn.setReorderable(false);
            this.numberColumn.setCellValueFactory((Callback)new Callback<TableColumn.CellDataFeatures<SearchResult, String>, ObservableValue<String>>(){

                public ObservableValue<String> call(TableColumn.CellDataFeatures<SearchResult, String> p) {
                    return new ReadOnlyObjectWrapper((Object)((String)((SearchResult)p.getValue()).getData().get(EFCSearchResultTablePane.NUMBER_HEADER)));
                }
            });
            this.numberColumn.setCellFactory((Callback)new Callback<TableColumn<SearchResult, String>, TableCell<SearchResult, String>>(){

                public TableCell<SearchResult, String> call(TableColumn<SearchResult, String> param) {
                    TableCell<SearchResult, String> cell = new TableCell<SearchResult, String>(){

                        protected void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            if (this.getTableRow() != null) {
                                this.setText("" + (this.getTableRow().getIndex() + 1));
                            } else {
                                this.setText("");
                            }
                        }
                    };
                    cell.setAlignment(Pos.CENTER);
                    return cell;
                }
            });
            this.numberColumn.setPrefWidth(95.0);
            columns.add(this.numberColumn);
        }
        for (Object crit : this.parent.getEFCSearchCriteriaTable().getTable().getColumns()) {
            SearchService.SearchColumnInfo critColInfo;
            if (!(crit instanceof TableColumn)) continue;
            TableColumn critColumn = (TableColumn)crit;
            SearchService.SearchColumnInfo info = null;
            for (SearchService.SearchColumnInfo colInfo : this.parent.getEFCSearchCriteriaTable().getSearchListMetaInfo().getFields()) {
                if (!colInfo.getName().equalsIgnoreCase(critColumn.getId())) continue;
                info = colInfo;
                break;
            }
            if ((critColInfo = info) == null) continue;
            if (critColInfo.getClazz().isAssignableFrom(EFCBoolean.class)) {
                columns.add((Object)new EFCSearchResultBooleanColumn(critColInfo.getName(), false));
                continue;
            }
            columns.add((Object)new EFCSearchResultColumn(critColInfo));
        }
        this.table.getColumns().setAll((Collection)columns);
        this.table.setRowFactory(new EFCSearchResultRowFactory(){

            @Override
            public TableRow<SearchResult> call(TableView<SearchResult> tableView) {
                TableRow<SearchResult> row = super.call(tableView);
                if (EFCSearchResultTablePane.this.parent.getSearchMode() != EFCSearchMode.MODE_FOR_BATCH && EFCSearchResultTablePane.this.parent.getSearchMode() != EFCSearchMode.MODE_FOR_PRINT) {
                    row.setOnMouseClicked(event -> {
                        if (event.getClickCount() == 2 && !row.isEmpty()) {
                            EFCSearchResultTablePane.this.parent.handleAction("exit", null);
                        }
                    });
                }
                return row;
            }
        });
    }

    public List<Key> getSearchresultKeys() {
        LinkedList<Key> keyList = new LinkedList<Key>();
        if (this.table.getItems() == null) {
            return keyList;
        }
        for (SearchResult result : this.table.getItems()) {
            keyList.add(result.getKey());
        }
        return keyList;
    }

    public void setSearchResults(SearchResultList resultList) {
        this.table.getItems().clear();
        this.keyMap.clear();
        this.resultList = resultList;
        for (SearchResult result : resultList) {
            this.keyMap.put((Object)System.identityHashCode(result.getData()), (Object)result.getKey());
        }
        ObservableList allData = FXCollections.observableArrayList((Collection)resultList);
        this.table.getItems().setAll((Collection)allData);
        if (!this.table.getSortOrder().isEmpty()) {
            this.table.sort();
        }
        ScrollBar horizontaltablebar = this.table.getScrollbar(Orientation.HORIZONTAL);
        horizontaltablebar.setUnitIncrement(600.0);
        ScrollBar horizontalrowbar = this.parent.getEFCSearchCriteriaTable().getTable().getScrollbar(Orientation.HORIZONTAL);
        horizontalrowbar.setUnitIncrement(600.0);
        horizontalrowbar.valueProperty().bindBidirectional((Property)horizontaltablebar.valueProperty());
    }

    public void setColumnControlType(EFCTableView.ColumnControlType columnControlType) {
        this.table.setColumnControlType(columnControlType);
    }

    public EFCSearchResultTable getTable() {
        return this.table;
    }
}

