/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.frame.searchframe.actions;

import de.effectivecompany.base.efcbl.error.ApplicationException;
import de.effectivecompany.base.gui.data.SearchResultList;
import de.effectivecompany.gui.components.frame.searchframe.EFCSearchFrame;
import de.effectivecompany.gui.components.frame.searchframe.columns.components.EFCSearchStringCell;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.util.EFCThreadUtil;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCSearchFrameActualizeAction {
    private static final Logger logger = LoggerFactory.getLogger(EFCSearchFrameActualizeAction.class);

    public EFCSearchFrameActualizeAction(EFCSearchFrame searchFrame) {
        Node owner = (Node)searchFrame.getPanel().getScene().focusOwnerProperty().get();
        if (owner instanceof TextField && owner.getParent() instanceof EFCSearchStringCell) {
            EFCSearchStringCell cell = (EFCSearchStringCell)owner.getParent();
            cell.commitEdit(((TextField)owner).getText());
        }
        Task<SearchResultList> task = this.createTask(searchFrame);
        searchFrame.setWorking(true);
        task.setOnSucceeded(taskEvent -> {
            if (taskEvent.getSource().valueProperty().get() != null) {
                SearchResultList searchResults = (SearchResultList)taskEvent.getSource().valueProperty().get();
                searchFrame.setResultList(searchResults);
            }
            searchFrame.setWorking(false);
        });
        task.setOnFailed(taskEvent -> {
            searchFrame.setWorking(false);
            Exception ex = (Exception)taskEvent.getSource().exceptionProperty().get();
            if (ex instanceof ApplicationException) {
                logger.warn(((ApplicationException)((Object)((Object)ex))).getMessage());
                EFCDesktop.showErrorDlg(((ApplicationException)((Object)((Object)ex))).getMessage());
            } else {
                EFCDesktop.reportError(ex);
            }
        });
        EFCThreadUtil.getCachedExecutorService().submit((Runnable)task);
    }

    private Task<SearchResultList> createTask(final EFCSearchFrame searchFrame) {
        return new Task<SearchResultList>(){

            protected SearchResultList call() throws Exception {
                return searchFrame.getSearchService().search(searchFrame.getActiveListId(), searchFrame.buildFilter());
            }
        };
    }
}

