/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.frame.searchframe.columns.components;

import de.effectivecompany.base.gui.data.SearchService;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.frame.searchframe.EFCSearchFrame;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.util.Callback;

public class EFCSearchListComboBox
extends ComboBox<SearchService.SearchMetaInfo> {
    public EFCSearchListComboBox(final EFCSearchFrame parent) {
        this.setButtonCell((ListCell)new ListCell<SearchService.SearchMetaInfo>(){

            protected void updateItem(SearchService.SearchMetaInfo t, boolean bln) {
                super.updateItem((Object)t, bln);
                if (bln) {
                    this.setText("-");
                } else {
                    this.setText(Translator.tr((String)t.getId()));
                }
            }
        });
        this.setCellFactory((Callback)new Callback<ListView<SearchService.SearchMetaInfo>, ListCell<SearchService.SearchMetaInfo>>(){

            public ListCell<SearchService.SearchMetaInfo> call(ListView<SearchService.SearchMetaInfo> listview) {
                listview.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
                ListCell<SearchService.SearchMetaInfo> cell = new ListCell<SearchService.SearchMetaInfo>(){

                    protected void updateItem(SearchService.SearchMetaInfo t, boolean bln) {
                        super.updateItem((Object)t, bln);
                        if (t != null) {
                            this.setText(Translator.tr((String)t.getId()));
                        } else {
                            this.setText(null);
                        }
                    }
                };
                cell.setOnMousePressed(e -> parent.getStoredSearchSelectBox().getSelectionModel().select(0));
                return cell;
            }
        });
        this.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<SearchService.SearchMetaInfo>(){

            public void changed(ObservableValue<? extends SearchService.SearchMetaInfo> observable, SearchService.SearchMetaInfo oldValue, SearchService.SearchMetaInfo newValue) {
                parent.refreshSearchListSelectBox();
            }
        });
        this.setMinSize(180.0, 20.0);
        this.setMaxSize(180.0, 20.0);
        this.setPrefSize(180.0, 20.0);
    }

    public void init(SearchService.DcSearchMetaInfo dcSearchMetaInfo) {
        for (SearchService.SearchMetaInfo metaInfo : dcSearchMetaInfo.getSearchMetaInfos()) {
            this.getItems().add((Object)metaInfo);
            if (!metaInfo.isDefault()) continue;
            this.getSelectionModel().select((Object)metaInfo);
        }
    }
}

