/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.frame.searchframe.columns.components;

import de.effectivecompany.app.sys.MdSysXml;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.gui.components.frame.searchframe.EFCSearchFrame;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.util.Callback;

public class EFCStoredSearchComboBox
extends ComboBox<MdSysXml> {
    public EFCStoredSearchComboBox(EFCSearchFrame frame) {
        this.setButtonCell((ListCell)new ListCell<MdSysXml>(){

            protected void updateItem(MdSysXml t, boolean bln) {
                super.updateItem((Object)t, bln);
                if (t != null && t.getSysxmlcodekey().getData() != null && t.getUsername().getData() != null) {
                    this.setText(t.getSysxmlcodekey().getData() + " | " + t.getUsername().getData());
                } else {
                    this.setText("-");
                }
            }
        });
        this.setCellFactory((Callback)new Callback<ListView<MdSysXml>, ListCell<MdSysXml>>(){

            public ListCell<MdSysXml> call(ListView<MdSysXml> listview) {
                listview.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
                return new ListCell<MdSysXml>(){

                    protected void updateItem(MdSysXml t, boolean bln) {
                        super.updateItem((Object)t, bln);
                        if (t != null && t.getSysxmlcodekey().getData() != null && t.getUsername().getData() != null) {
                            this.setText(t.getSysxmlcodekey().getData() + " | " + t.getUsername().getData());
                        } else {
                            this.setText("-");
                        }
                    }
                };
            }
        });
        this.setOnAction(event -> frame.refreshStoredSearchSelectBox());
        this.setMinSize(180.0, 20.0);
        this.setMaxSize(180.0, 20.0);
        this.setPrefSize(180.0, 20.0);
    }

    public void init(EFCList<MdSysXml> data) {
        this.getItems().clear();
        this.getItems().add((Object)new MdSysXml());
        for (MdSysXml row : data) {
            this.getItems().add((Object)row);
        }
    }
}

