/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx;

import de.effectivecompany.base.datatypes.EFCDateTime;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.DatePicker;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.util.StringConverter;

public class EFCDateTimePicker
extends DatePicker {
    private SimpleObjectProperty<LocalDateTime> dateTimeValue = new SimpleObjectProperty((Object)LocalDateTime.now());
    private DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");

    public EFCDateTimePicker() {
        this.setConverter((StringConverter)new StringConverter<LocalDate>(){

            public String toString(LocalDate localDate) {
                if (EFCDateTimePicker.this.dateTimeValue.get() != null) {
                    return ((LocalDateTime)EFCDateTimePicker.this.dateTimeValue.get()).format(EFCDateTimePicker.this.dateTimeFormatter);
                }
                return "";
            }

            public LocalDate fromString(String value) {
                if (value == null) {
                    EFCDateTimePicker.this.dateTimeValue.set(null);
                    return null;
                }
                EFCDateTimePicker.this.dateTimeValue.set((Object)LocalDateTime.parse(value, EFCDateTimePicker.this.dateTimeFormatter));
                return ((LocalDateTime)EFCDateTimePicker.this.dateTimeValue.get()).toLocalDate();
            }
        });
        this.valueProperty().addListener((ChangeListener)new ChangeListener<LocalDate>(){

            public void changed(ObservableValue<? extends LocalDate> observable, LocalDate oldValue, LocalDate newValue) {
                if (newValue == null) {
                    EFCDateTimePicker.this.dateTimeValue.set(null);
                } else if (EFCDateTimePicker.this.dateTimeValue.get() == null) {
                    EFCDateTimePicker.this.dateTimeValue.set((Object)LocalDateTime.of(newValue, LocalTime.now()));
                } else {
                    LocalTime time = ((LocalDateTime)EFCDateTimePicker.this.dateTimeValue.get()).toLocalTime();
                    EFCDateTimePicker.this.dateTimeValue.set((Object)LocalDateTime.of(newValue, time));
                }
            }
        });
        this.dateTimeValue.addListener((ChangeListener)new ChangeListener<LocalDateTime>(){

            public void changed(ObservableValue<? extends LocalDateTime> observable, LocalDateTime oldValue, LocalDateTime newValue) {
                EFCDateTimePicker.this.valueProperty().set((Object)newValue.toLocalDate());
            }
        });
        this.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                switch (event.getCode()) {
                    case ENTER: {
                        EFCDateTimePicker.this.fireEvent((Event)this.recodeToTab(event));
                        event.consume();
                    }
                }
            }

            private KeyEvent recodeToTab(KeyEvent event) {
                return new KeyEvent(event.getEventType(), event.getCharacter(), event.getText(), KeyCode.TAB, event.isShiftDown(), event.isControlDown(), event.isAltDown(), event.isMetaDown());
            }
        });
        this.setPrefWidth(125.0);
    }

    public EFCDateTime getEFCDateTime() {
        if (this.dateTimeValue.get() != null) {
            return new EFCDateTime(Date.from(((LocalDateTime)this.dateTimeValue.get()).atZone(ZoneId.systemDefault()).toInstant()));
        }
        return null;
    }
}

