/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx;

import de.effectivecompany.app.dms.ExcelCell;
import de.effectivecompany.app.dms.ExcelRow;
import de.effectivecompany.app.dms.ExcelSheet;
import de.effectivecompany.app.dms.ExcelWorkBook;
import de.effectivecompany.app.dms.service.SvDms;
import de.effectivecompany.base.datatypes.EFCBlob;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.fx.SequencePrefix;
import de.effectivecompany.gui.components.fx.pane.EFCLockPane;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.awt.Component;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;

public class EFCExcelViewerPane
extends EFCPanel {
    public static final String NUMBER_HEADER = "#";
    private static final long serialVersionUID = 9026428421541707241L;
    private JFXPanel jfxPanel = new JFXPanel();
    private BorderPane root;
    private Scene scene;
    private EFCLockPane lockPane = new EFCLockPane();
    private final SvDms svDms = (SvDms)SpringHelper.getBean((String)"dms_SvDms");

    public EFCExcelViewerPane(String fileName, EFCBlob blob) {
        super("");
        this.load(fileName, blob);
    }

    public void load(final String fileName, final EFCBlob blob) {
        Platform.setImplicitExit((boolean)false);
        EFCThreadUtil.doLaterFAT(() -> {
            this.scene = this.setupViewer(600, 800);
            this.jfxPanel.setScene(this.scene);
            this.lockPane.setVisible(true);
            Task<ExcelWorkBook> excelTask = new Task<ExcelWorkBook>(){

                protected ExcelWorkBook call() throws Exception {
                    return EFCExcelViewerPane.this.svDms.getExcelWorkBook(new EFCString(fileName), blob);
                }
            };
            excelTask.setOnSucceeded(e -> {
                this.lockPane.setVisible(false);
                if (e.getSource().valueProperty().get() != null) {
                    ExcelWorkBook excelWorkBook = (ExcelWorkBook)e.getSource().valueProperty().get();
                    this.root.setCenter((Node)this.excelToGrid(excelWorkBook));
                }
            });
            excelTask.setOnFailed(taskEvent -> {
                this.lockPane.setVisible(false);
                EFCDesktop.showErrorDlg(taskEvent.getSource().exceptionProperty().get().toString());
            });
            EFCThreadUtil.getCachedExecutorService().submit((Runnable)excelTask);
        });
        this.add((Component)this.jfxPanel, "Center");
    }

    public Scene setupViewer(int w, int h) {
        this.root = new BorderPane();
        VBox top = new VBox();
        this.root.setTop((Node)top);
        HBox bottom = new HBox();
        bottom.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
        this.root.setBottom((Node)bottom);
        StackPane stack = new StackPane();
        stack.getChildren().addAll((Object[])new Node[]{this.root, this.lockPane});
        this.scene = new Scene((Parent)stack, (double)w, (double)h);
        return this.scene;
    }

    private TabPane excelToGrid(ExcelWorkBook excelWorkBook) {
        TabPane tabPane = new TabPane();
        SequencePrefix sequence = new SequencePrefix();
        for (ExcelSheet excelSheet : excelWorkBook.getExcelsheetList()) {
            TableView tableView = new TableView();
            TableColumn numberColumn = new TableColumn(NUMBER_HEADER);
            numberColumn.setId(NUMBER_HEADER);
            numberColumn.setReorderable(false);
            numberColumn.setCellFactory((Callback)new Callback<TableColumn<ExcelRow, String>, TableCell<ExcelRow, String>>(){

                public TableCell<ExcelRow, String> call(TableColumn<ExcelRow, String> param) {
                    TableCell<ExcelRow, String> cell = new TableCell<ExcelRow, String>(){

                        protected void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            if (this.getTableRow() != null) {
                                this.setText("" + (this.getTableRow().getIndex() + 1));
                            } else {
                                this.setText("");
                            }
                        }
                    };
                    cell.setAlignment(Pos.CENTER);
                    return cell;
                }
            });
            numberColumn.setPrefWidth(25.0);
            numberColumn.setSortable(false);
            tableView.getColumns().add((Object)numberColumn);
            if (excelSheet.getRowList().size() > 0) {
                ExcelRow row = (ExcelRow)excelSheet.getRowList().get(0);
                row.getColumnList().entrySet().forEach(entry -> {
                    TableColumn column1 = new TableColumn((String)sequence.next());
                    column1.setCellValueFactory((Callback)new EFCExcelRowValueFactory<String>(entry.getKey()){

                        public ObservableValue<String> call(TableColumn.CellDataFeatures<ExcelRow, String> param) {
                            ExcelCell cell = (ExcelCell)((ExcelRow)param.getValue()).getColumnList().get(this.getKey());
                            if (cell != null && cell.getValue() != null) {
                                return new SimpleStringProperty(cell.getValue().getData());
                            }
                            return new SimpleStringProperty();
                        }
                    });
                    tableView.getColumns().add((Object)column1);
                });
            }
            excelSheet.getRowList().forEach(rows -> tableView.getItems().add(rows));
            Tab tab = new Tab(excelSheet.getTitle().getData());
            tab.setClosable(false);
            tableView.setEditable(false);
            tab.setContent((Node)tableView);
            tabPane.getTabs().add((Object)tab);
        }
        return tabPane;
    }

    public abstract class EFCExcelRowValueFactory<T>
    implements Callback<TableColumn.CellDataFeatures<ExcelRow, T>, ObservableValue<T>> {
        private final Object key;

        public EFCExcelRowValueFactory(Object key) {
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }
    }
}

