/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx;

import de.effectivecompany.app.sst.SoGridEntry;
import de.effectivecompany.app.sst.SoGridEntryBorder;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.meta.ColorInfo;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.events.SelectionContextChangeEvent;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.Component;
import java.util.Comparator;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.text.TextAlignment;
import javafx.scene.transform.Scale;

public class EFCGridPane
extends EFCPanel {
    private static final long serialVersionUID = 1L;
    private JFXPanel jfxPanel = new JFXPanel();
    private GridPane grid;
    private ToggleGroup group = new ToggleGroup();
    private String unselectedStyle = "-fx-background-radius: 5, 5, 4, 3;-fx-background-insets: 0 0 0 0, 0, 0, 0;-fx-shadow-highlight-color : transparent;-fx-focus-color: transparent;-fx-faint-focus-color: transparent;-fx-border-color: transparent;-fx-border-width: .5;-fx-text-fill: -fx-text-base-color;-fx-border-color:grey;";
    private Group zoomGroup;

    public EFCGridPane(ElementManager elementManager, DataChangeManager dataChangeManager, String ident, String parentIdent) {
        super(elementManager, dataChangeManager, ident, parentIdent);
        this.initComponents();
    }

    private void initComponents() {
        Platform.setImplicitExit((boolean)false);
        this.createScene();
        this.setPreferredSize(EFCLookAndFeelManager.SIZE_FRAME_SEARCH);
        this.add((Component)this.jfxPanel, "Center");
    }

    private void createScene() {
        Platform.runLater(() -> {
            this.grid = new GridPane();
            Group contentGroup = new Group();
            this.zoomGroup = new Group();
            contentGroup.getChildren().add((Object)this.zoomGroup);
            this.zoomGroup.getChildren().add((Object)this.grid);
            ScrollPane scroll = new ScrollPane((Node)contentGroup);
            scroll.setFitToWidth(true);
            Scene scene = new Scene((Parent)scroll);
            this.jfxPanel.setScene(scene);
        });
    }

    public void setScale(double scaleX, double scaleY) {
        Platform.runLater(() -> {
            this.zoomGroup.getTransforms().clear();
            Scale scaleTransform = new Scale(scaleX, scaleY, 0.0, 0.0);
            this.zoomGroup.getTransforms().add((Object)scaleTransform);
        });
    }

    public void setData(EFCList<? extends SoGridEntry> data) {
        Platform.runLater(() -> {
            Comparator comp = (e1, e2) -> Integer.compare(e1.getCol().getData() + e1.getColSpan().getData(), e2.getCol().getData() + e2.getColSpan().getData());
            int maxCol = ((SoGridEntry)data.stream().max(comp).get()).getCol().getData();
            maxCol += ((SoGridEntry)data.stream().max(comp).get()).getColSpan().getData().intValue();
            Comparator compRow = (e1, e2) -> Integer.compare(e1.getRow().getData() + e1.getRowSpan().getData(), e2.getRow().getData() + e2.getRowSpan().getData());
            int maxRow = ((SoGridEntry)data.stream().max(compRow).get()).getRow().getData();
            maxRow += ((SoGridEntry)data.stream().max(compRow).get()).getRowSpan().getData().intValue();
            this.grid.getChildren().clear();
            this.grid.getRowConstraints().clear();
            this.grid.getColumnConstraints().clear();
            this.group.getToggles().clear();
            data.forEach(entry -> this.grid.add((Node)new EFCGridButton((BusinessObject)entry), entry.getCol().getData().intValue(), entry.getRow().getData().intValue(), entry.getColSpan().getData().intValue(), entry.getRowSpan().getData().intValue()));
            for (int row = 0; row <= maxRow; ++row) {
                RowConstraints rc = new RowConstraints();
                rc.setFillHeight(true);
                rc.setPercentHeight(50.0);
                rc.setVgrow(Priority.ALWAYS);
                this.grid.getRowConstraints().add((Object)rc);
            }
            for (int col = 0; col <= maxCol; ++col) {
                ColumnConstraints cc = new ColumnConstraints();
                cc.setFillWidth(true);
                cc.setHgrow(Priority.ALWAYS);
                cc.setPercentWidth(50.0);
                this.grid.getColumnConstraints().add((Object)cc);
            }
        });
    }

    @Override
    public void terminate() {
        this.removeAll();
        this.jfxPanel.removeAll();
        this.jfxPanel = null;
        this.grid = null;
    }

    private class EFCGridButton
    extends StackPane {
        private BusinessObject bo;

        public EFCGridButton(final BusinessObject bo) {
            this.bo = bo;
            EFCGridPane.this.setFocusable(false);
            final ToggleButton button = new ToggleButton();
            button.setMnemonicParsing(false);
            button.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (newValue.booleanValue()) {
                        Object selectedStyle = "-fx-background-radius: 5, 5, 4, 3;-fx-background-insets: 0 0 0 0, 0, 0, 0;-fx-shadow-highlight-color : transparent;-fx-outer-border : transparent;-fx-faint-focus-color: transparent;-fx-focus-color: transparent;-fx-inner-border : black;-fx-outer-border : black;-fx-font-weight: bold;-fx-border-color: black;";
                        String style = EFCGridButton.this.defaultStyle(bo);
                        if (style != null) {
                            selectedStyle = (String)selectedStyle + style;
                        }
                        button.setStyle((String)selectedStyle);
                    } else {
                        String style = EFCGridButton.this.defaultStyle(bo);
                        Object newStyle = EFCGridPane.this.unselectedStyle;
                        if (style != null) {
                            newStyle = (String)newStyle + style;
                        }
                        button.setStyle((String)newStyle);
                    }
                }
            });
            button.setToggleGroup(EFCGridPane.this.group);
            if (bo instanceof SoGridEntry) {
                SoGridEntry entry = (SoGridEntry)bo;
                button.setText(((SoGridEntry)bo).getText().getData());
                if (button.getText() == null || button.getText().isEmpty()) {
                    button.setDisable(true);
                }
                if (((SoGridEntry)bo).getToolTipText().getData() != null && !((SoGridEntry)bo).getToolTipText().getData().isEmpty()) {
                    button.setTooltip(new Tooltip(((SoGridEntry)bo).getToolTipText().getData()));
                }
                if (entry.getBorder() != null) {
                    SoGridEntryBorder border = entry.getBorder();
                    int top = border.getTop().getData();
                    int right = border.getRight().getData();
                    int bottom = border.getBottom().getData();
                    int left = border.getLeft().getData();
                    this.setStyle("-fx-border-color:black;-fx-border-width: " + top + " " + right + " " + bottom + " " + left + ";");
                }
            }
            String style = this.defaultStyle(bo);
            Object newStyle = EFCGridPane.this.unselectedStyle;
            if (style != null) {
                newStyle = (String)newStyle + style;
            }
            button.setStyle((String)newStyle);
            button.setOnAction(event -> {
                SelectionContextChangeEvent sece = new SelectionContextChangeEvent(EFCGridPane.this, 2086, EFCGridPane.this.getIdent(), null, null);
                sece.setSelected(this.getBo());
                DataChangeManager dcm = EFCGridPane.this.getDataChangeManager();
                if (dcm != null) {
                    dcm.onSelectionContextChanged(sece);
                }
            });
            button.setAlignment(Pos.CENTER);
            button.setTextAlignment(TextAlignment.CENTER);
            button.setMinSize(0.0, 0.0);
            button.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            this.getChildren().add((Object)button);
        }

        private String defaultStyle(BusinessObject bo) {
            if (bo instanceof ColorInfo) {
                ColorInfo colorInfo = (ColorInfo)bo;
                return "-fx-background-color: rgb(" + colorInfo.getColor().getRed() + ", " + colorInfo.getColor().getGreen() + ", " + colorInfo.getColor().getBlue() + ");-fx-background-radius:0;-fx-text-fill: -fx-text-base-color;";
            }
            return null;
        }

        public BusinessObject getBo() {
            return this.bo;
        }

        public void setBo(BusinessObject bo) {
            this.bo = bo;
        }
    }
}

