/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx;

import de.effectivecompany.app.app.service.SvSysUser;
import de.effectivecompany.app.syscl.ClSysPrnSrvDet;
import de.effectivecompany.base.datatypes.EFCBlob;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.data.EFCReportContainer;
import de.effectivecompany.gui.components.EFCFileChooser;
import de.effectivecompany.gui.components.frame.EFCPDFViewer;
import de.effectivecompany.gui.components.fx.EFCFxButton;
import de.effectivecompany.gui.components.fx.EFCPDFBoxThumbNailPane;
import de.effectivecompany.gui.components.fx.EFCToolBar;
import de.effectivecompany.gui.components.fx.pane.EFCLockPane;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.factory.EFCPrintFactory;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.ClipboardUtil;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.embed.swing.JFXPanel;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.ToolBar;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCPDFBoxViewer
extends EFCPanel {
    private static final long serialVersionUID = -3803064602836605861L;
    private static Logger logger = LoggerFactory.getLogger(EFCPDFBoxViewer.class);
    private EFCReportContainer efcReportContainer;
    private boolean isEmbedded;
    private Scene scene;
    private Group group;
    private VBox top;
    private ScrollPane centerMain;
    private EFCPDFBoxThumbNailPane thumbs;
    private Pane pdf;
    private JFXPanel jfxPanel = new JFXPanel();
    private EFCLockPane lockPane = new EFCLockPane();
    private int currentPage = 1;
    private final ImageView view = new ImageView();
    private float scale = 1.0f;
    private SvSysUser svSysUser = (SvSysUser)SpringHelper.getService(SvSysUser.class);
    PDFRenderer renderer;
    PDDocument document;
    private FitToPage zoomMode = FitToPage.AUTO;
    private EFCPDFViewer parent;
    private final float[] scalings = new float[]{0.01f, 0.1f, 0.25f, 0.5f, 0.75f, 1.0f, 1.25f, 1.5f, 2.0f, 4.0f, 7.5f, 10.0f};
    private int currentScaling = 5;

    public EFCPDFBoxViewer() {
        super(null, null, "", "", false);
        this.isEmbedded = false;
        this.initComponents();
    }

    public EFCPDFBoxViewer(String ident) {
        super(ident);
        this.isEmbedded = true;
        this.initComponents();
    }

    public EFCPDFBoxViewer(EFCPDFViewer parent, String ident) {
        this(ident);
        this.parent = parent;
    }

    public EFCPDFBoxViewer(ElementManager manager, DataChangeManager dcm, String ident) {
        super(manager, dcm, ident);
        this.initComponents();
    }

    public void load(EFCBlob blob) {
        this.load(new EFCReportContainer(blob));
    }

    public void load(EFCReportContainer efcReportContainer) {
        this.efcReportContainer = efcReportContainer;
        if (efcReportContainer != null && efcReportContainer.getBufferData() != null) {
            this.document = (PDDocument)efcReportContainer.getDocument();
            this.renderer = new PDFRenderer(this.document);
            this.currentPage = 1;
            if (this.document != null) {
                EFCThreadUtil.doLaterFAT(() -> {
                    this.thumbs.setupThumbnails(this.document, this.renderer, new Font("Serif", 0, 12), Translator.tr((String)"THUMBNAIL_PAGE"));
                    ((Label)this.top.lookup("#pgCount")).setText("/" + this.document.getNumberOfPages());
                    ComboBox pages = (ComboBox)this.top.lookup("#pages");
                    pages.getItems().clear();
                    for (int i = 1; i <= this.document.getNumberOfPages(); ++i) {
                        pages.getItems().add((Object)String.valueOf(i));
                    }
                    this.goToPage(this.currentPage);
                });
            }
        }
    }

    public void fitToX(FitToPage fitToPage, Float scale) {
        if (this.efcReportContainer == null || this.efcReportContainer.getDocument() == null || fitToPage == FitToPage.NONE) {
            return;
        }
        PDDocument document = (PDDocument)this.efcReportContainer.getDocument();
        int rotation = document.getPages().get(this.currentPage - 1).getRotation();
        if (fitToPage == FitToPage.AUTO) {
            if (rotation == 90 || rotation == 270) {
                this.fitToX(FitToPage.WIDTH, scale);
            } else {
                this.fitToX(FitToPage.HEIGHT, scale);
            }
        }
        this.view.setPreserveRatio(true);
        if (fitToPage == FitToPage.WIDTH) {
            float width = (float)this.centerMain.getWidth();
            if (scale != null) {
                this.view.setFitWidth((double)(width * scale.floatValue()));
            } else {
                this.view.setFitWidth((double)width);
            }
        } else if (fitToPage == FitToPage.HEIGHT) {
            float height = (float)(this.scene.getHeight() - this.top.getBoundsInLocal().getHeight() - 50.0);
            if (scale != null) {
                this.view.setFitHeight((double)(height * scale.floatValue()));
            } else {
                this.view.setFitHeight((double)height);
            }
        }
    }

    public Scene setupViewer(int w, int h) {
        this.view.setSmooth(true);
        this.view.setCache(true);
        this.pdf = new Pane();
        this.pdf.getChildren().add((Object)this.view);
        BorderPane root = new BorderPane();
        this.top = new VBox();
        root.setTop((Node)this.top);
        this.top.getChildren().add((Object)this.setupToolBar());
        HBox bottom = new HBox();
        bottom.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
        root.setBottom((Node)bottom);
        this.centerMain = new ScrollPane();
        this.centerMain.setPannable(true);
        this.centerMain.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.centerMain.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.centerMain.viewportBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> ov, Bounds ob, Bounds nb) {
                EFCPDFBoxViewer.this.adjustPagePosition(nb);
            }
        });
        this.group = new Group();
        this.group.getChildren().add((Object)this.pdf);
        this.centerMain.setContent((Node)this.group);
        this.thumbs = new EFCPDFBoxThumbNailPane(this);
        root.setCenter((Node)this.centerMain);
        root.setLeft((Node)this.thumbs);
        StackPane stack = new StackPane();
        stack.getChildren().addAll((Object[])new Node[]{root, this.lockPane});
        this.scene = new Scene((Parent)stack, (double)w, (double)h);
        EventHandler<ScrollEvent> scrollHandler = new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent event) {
                if (event.isControlDown()) {
                    double deltaY = event.getDeltaY();
                    if (deltaY > 0.0 && EFCPDFBoxViewer.this.currentScaling < EFCPDFBoxViewer.this.scalings.length - 1) {
                        EFCPDFBoxViewer.this.currentScaling = EFCPDFBoxViewer.findClosestIndex(EFCPDFBoxViewer.this.scale, EFCPDFBoxViewer.this.scalings);
                        if (EFCPDFBoxViewer.this.scale >= EFCPDFBoxViewer.this.scalings[EFCPDFBoxViewer.findClosestIndex(EFCPDFBoxViewer.this.scale, EFCPDFBoxViewer.this.scalings)]) {
                            ++EFCPDFBoxViewer.this.currentScaling;
                        }
                        EFCPDFBoxViewer.this.scale = EFCPDFBoxViewer.this.scalings[EFCPDFBoxViewer.this.currentScaling];
                    }
                    if (deltaY < 0.0 && EFCPDFBoxViewer.this.currentScaling > 0) {
                        EFCPDFBoxViewer.this.currentScaling = EFCPDFBoxViewer.findClosestIndex(EFCPDFBoxViewer.this.scale, EFCPDFBoxViewer.this.scalings);
                        if (EFCPDFBoxViewer.this.scale <= EFCPDFBoxViewer.this.scalings[EFCPDFBoxViewer.findClosestIndex(EFCPDFBoxViewer.this.scale, EFCPDFBoxViewer.this.scalings)]) {
                            --EFCPDFBoxViewer.this.currentScaling;
                        }
                        EFCPDFBoxViewer.this.scale = EFCPDFBoxViewer.this.scalings[EFCPDFBoxViewer.this.currentScaling];
                    }
                    EFCPDFBoxViewer.this.view.setFitHeight(EFCPDFBoxViewer.this.view.getImage().getHeight() * (double)EFCPDFBoxViewer.this.scale);
                    EFCPDFBoxViewer.this.adjustPagePosition(EFCPDFBoxViewer.this.centerMain.getViewportBounds());
                    event.consume();
                }
            }
        };
        this.pdf.addEventHandler(ScrollEvent.SCROLL, (EventHandler)scrollHandler);
        return this.scene;
    }

    public void initComponents() {
        Platform.setImplicitExit((boolean)false);
        EFCThreadUtil.doLaterFAT(() -> {
            this.scene = this.setupViewer(600, 800);
            this.jfxPanel.setScene(this.scene);
            this.addListeners();
        });
        this.add((Component)this.jfxPanel, "Center");
    }

    public void addListeners() {
        this.scene.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldSceneWidth, Number newSceneWidth) {
                EFCPDFBoxViewer.this.fitToX(EFCPDFBoxViewer.this.zoomMode, null);
            }
        });
        this.scene.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldSceneHeight, Number newSceneHeight) {
                EFCPDFBoxViewer.this.fitToX(EFCPDFBoxViewer.this.zoomMode, null);
            }
        });
    }

    public void goToPage(int newPage) {
        this.currentPage = newPage;
        this.thumbs.updateSelection(this.currentPage);
        this.decodePage();
    }

    private void decodePage() {
        EFCThreadUtil.fatBuilder(th -> {
            this.lockPane.lock();
            th.doOutside(() -> {
                if (this.efcReportContainer != null && this.efcReportContainer.getDocument() != null) {
                    if (this.document != null && this.document.getPages().getCount() > 0) {
                        try {
                            BufferedImage img = this.renderer.renderImageWithDPI(this.currentPage - 1, 144.0f);
                            th.fat(() -> {
                                this.view.setImage((Image)SwingFXUtils.toFXImage((BufferedImage)img, null));
                                this.fitToX(FitToPage.AUTO, null);
                                this.updateNavButtons();
                            });
                            this.adjustPagePosition(this.centerMain.getViewportBounds());
                        }
                        catch (IOException e) {
                            logger.error("Error Rendering PDF", (Throwable)e);
                        }
                    }
                    th.fat(() -> this.lockPane.unLock());
                }
            });
        });
    }

    private ToolBar setupToolBar() {
        EFCToolBar toolbar = new EFCToolBar();
        EFCFxButton back = new EFCFxButton("back", EFCLookAndFeelManager.ICON_TOOLBAR_GO_PREV_FX, "");
        back.changePseudoClass(EFCFxButton.ButtonState.TOOLBAR);
        back.setTextInvisible(true);
        ComboBox pages = new ComboBox();
        Label pageCount = new Label();
        EFCFxButton exit = new EFCFxButton("exit", EFCLookAndFeelManager.ICON_TOOLBAR_EXIT_FX, "");
        exit.changePseudoClass(EFCFxButton.ButtonState.TOOLBAR);
        exit.setTextInvisible(true);
        EFCFxButton print = new EFCFxButton("print", EFCLookAndFeelManager.ICON_TOOLBAR_PRINT_DEFAULT_FX, "");
        print.changePseudoClass(EFCFxButton.ButtonState.TOOLBAR);
        print.setTextInvisible(true);
        EFCFxButton save = new EFCFxButton("save", EFCLookAndFeelManager.ICON_TOOLBAR_SAVE_FX, "");
        save.changePseudoClass(EFCFxButton.ButtonState.TOOLBAR);
        save.setTextInvisible(true);
        EFCFxButton copy = new EFCFxButton("copy", EFCLookAndFeelManager.ICON_TOOLBAR_DOCFLOW_TAKEOVER_FX, "");
        copy.changePseudoClass(EFCFxButton.ButtonState.TOOLBAR);
        copy.setTextInvisible(true);
        EFCFxButton forward = new EFCFxButton("forward", EFCLookAndFeelManager.ICON_TOOLBAR_GO_NEXT_FX, "");
        forward.changePseudoClass(EFCFxButton.ButtonState.TOOLBAR);
        forward.setTextInvisible(true);
        EFCFxButton zoomIn = new EFCFxButton("zoomIn", EFCLookAndFeelManager.ICON_TOOLBAR_LIST_ADD_FX, "");
        zoomIn.changePseudoClass(EFCFxButton.ButtonState.TOOLBAR);
        zoomIn.setTextInvisible(true);
        EFCFxButton zoomOut = new EFCFxButton("zoomOut", EFCLookAndFeelManager.ICON_TOOLBAR_LIST_REMOVE_FX, "");
        zoomOut.changePseudoClass(EFCFxButton.ButtonState.TOOLBAR);
        zoomOut.setTextInvisible(true);
        pageCount.setId("pgCount");
        pages.setId("pages");
        print.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                EFCPDFBoxViewer.this.efcReportContainer.generatePDDocument();
                new EFCPrintFactory().print(EFCPDFBoxViewer.this.efcReportContainer);
            }
        });
        copy.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                EFCPDFBoxViewer.this.doSaveToClipboard();
            }
        });
        pages.getSelectionModel().selectedIndexProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number oldVal, Number newVal) {
                if (newVal.intValue() != -1 && newVal.intValue() + 1 != EFCPDFBoxViewer.this.currentPage) {
                    int newPage = newVal.intValue() + 1;
                    EFCThreadUtil.doLaterFAT(() -> EFCPDFBoxViewer.this.goToPage(newPage));
                }
            }
        });
        save.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                EFCFileChooser fileChooser;
                String defFilepath = null;
                if (EFCPDFBoxViewer.this.efcReportContainer.getClSysPrnSrv() != null) {
                    String username = EFCPDFBoxViewer.this.svSysUser.getUsrName().getData();
                    for (ClSysPrnSrvDet srvdet : EFCPDFBoxViewer.this.efcReportContainer.getClSysPrnSrv().getSysprnsrvdetList().getList()) {
                        if (!srvdet.getUsername().getData().equalsIgnoreCase(username) || srvdet.getFilepathprnlocal() == null || srvdet.getFilepathprnlocal().getData() == null) continue;
                        defFilepath = srvdet.getFilepathprnlocal().getData();
                        break;
                    }
                    if ((defFilepath == null || defFilepath.isEmpty()) && EFCPDFBoxViewer.this.efcReportContainer.getClSysPrnSrv().getFilepathprnlocal() != null && EFCPDFBoxViewer.this.efcReportContainer.getClSysPrnSrv().getFilepathprnlocal().getData() != null && !EFCPDFBoxViewer.this.efcReportContainer.getClSysPrnSrv().getFilepathprnlocal().getData().isEmpty()) {
                        defFilepath = EFCPDFBoxViewer.this.efcReportContainer.getClSysPrnSrv().getFilepathprnlocal().getData();
                    }
                }
                Object fileName = "";
                Map<String, Object> paramMap = EFCPDFBoxViewer.this.efcReportContainer.getParamMap();
                if (paramMap != null && paramMap.containsKey("EFC_PARAM2")) {
                    fileName = (String)paramMap.get("EFC_PARAM2");
                }
                if (paramMap != null && paramMap.containsKey("EFC_PARAM3")) {
                    fileName = (String)fileName + paramMap.get("EFC_PARAM3");
                }
                if (fileName != null && !((String)fileName).isEmpty()) {
                    fileName = (String)fileName + ".pdf";
                }
                FileNameExtensionFilter pdfFilter = new FileNameExtensionFilter("PDF", "pdf");
                if (defFilepath != null && !defFilepath.isEmpty()) {
                    fileChooser = new EFCFileChooser(new File(defFilepath));
                    fileChooser.setSelectedFile(new File((String)fileName));
                    fileChooser.addChoosableFileFilter(pdfFilter);
                    fileChooser.setFileFilter(pdfFilter);
                } else {
                    fileChooser = new EFCFileChooser();
                    fileChooser.setSelectedFile(new File((String)fileName));
                    fileChooser.addChoosableFileFilter(pdfFilter);
                    fileChooser.setFileFilter(pdfFilter);
                }
                if (fileChooser.showSaveDialog(EFCPDFBoxViewer.this) == 0) {
                    fileName = fileChooser.getSelectedFile().getPath();
                    if (!((String)fileName).endsWith(".pdf")) {
                        fileName = (String)fileName + ".pdf";
                    }
                    File target = new File((String)fileName);
                    EFCPDFBoxViewer.this.doSaveAs(target);
                }
            }
        });
        back.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                if (EFCPDFBoxViewer.this.currentPage > 1) {
                    EFCThreadUtil.doLaterFAT(() -> EFCPDFBoxViewer.this.goToPage(EFCPDFBoxViewer.this.currentPage - 1));
                }
            }
        });
        forward.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                if (EFCPDFBoxViewer.this.currentPage < ((PDDocument)EFCPDFBoxViewer.this.efcReportContainer.getDocument()).getNumberOfPages()) {
                    EFCThreadUtil.doLaterFAT(() -> EFCPDFBoxViewer.this.goToPage(EFCPDFBoxViewer.this.currentPage + 1));
                }
            }
        });
        zoomIn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                EFCPDFBoxViewer.this.zoomIn();
            }
        });
        zoomOut.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                EFCPDFBoxViewer.this.zoomOut();
            }
        });
        exit.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (EFCPDFBoxViewer.this.parent != null) {
                    EFCPDFBoxViewer.this.parent.dispose();
                }
            }
        });
        if (this.isEmbedded) {
            toolbar.getItems().addAll((Object[])new Node[]{exit, print, save, copy, pages, pageCount, back, forward, zoomIn, zoomOut});
        } else {
            toolbar.getItems().addAll((Object[])new Node[]{print, save, copy, pages, pageCount, back, forward, zoomIn, zoomOut});
        }
        return toolbar;
    }

    public void zoomOut() {
        this.zoomMode = FitToPage.NONE;
        if (this.currentScaling > 0) {
            this.currentScaling = EFCPDFBoxViewer.findClosestIndex(this.scale, this.scalings);
            if (this.scale <= this.scalings[EFCPDFBoxViewer.findClosestIndex(this.scale, this.scalings)]) {
                --this.currentScaling;
            }
            this.scale = this.scalings[this.currentScaling];
        }
        this.fitToX(FitToPage.AUTO, Float.valueOf(this.scale));
        this.adjustPagePosition(this.centerMain.getViewportBounds());
    }

    public void zoomIn() {
        this.zoomMode = FitToPage.NONE;
        if (this.currentScaling < this.scalings.length - 1) {
            this.currentScaling = EFCPDFBoxViewer.findClosestIndex(this.scale, this.scalings);
            if (this.scale >= this.scalings[EFCPDFBoxViewer.findClosestIndex(this.scale, this.scalings)]) {
                ++this.currentScaling;
            }
            this.scale = this.scalings[this.currentScaling];
        }
        this.fitToX(FitToPage.AUTO, Float.valueOf(this.scale));
        this.adjustPagePosition(this.centerMain.getViewportBounds());
    }

    public void doSaveAs(File target) {
        if (this.efcReportContainer.getBufferData() != null) {
            try {
                FileOutputStream fos = new FileOutputStream(target);
                fos.write(this.efcReportContainer.getBufferData().array());
                fos.flush();
                fos.close();
            }
            catch (Exception e) {
                logger.error("Save PDF failed", (Throwable)e);
            }
        }
    }

    public void doSaveToClipboard() {
        if (this.efcReportContainer.getBufferData() != null) {
            String newFileName;
            Object fileName = "";
            Map<String, Object> paramMap = this.efcReportContainer.getParamMap();
            if (paramMap != null && paramMap.containsKey("EFC_PARAM2")) {
                fileName = (String)paramMap.get("EFC_PARAM2");
            }
            if (paramMap != null && paramMap.containsKey("EFC_PARAM3")) {
                fileName = (String)fileName + paramMap.get("EFC_PARAM3");
            }
            if ((newFileName = JOptionPane.showInputDialog(Translator.tr((String)"INPUT_LABLE_FILENAME"), fileName)) != null && !newFileName.isEmpty()) {
                fileName = newFileName;
                try {
                    ClipboardUtil.filesToClipboardFX(ClipboardUtil.createFileInEFCTemp((String)fileName, ".pdf", this.efcReportContainer.getBufferData().array()));
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
    }

    private static int findClosestIndex(float scale, float[] scalings) {
        float currentMinDiff = Float.MAX_VALUE;
        int closest = 0;
        for (int i = 0; i < scalings.length - 1; ++i) {
            float diff = Math.abs(scalings[i] - scale);
            if (!(diff < currentMinDiff)) continue;
            currentMinDiff = diff;
            closest = i;
        }
        return closest;
    }

    private void updateNavButtons() {
        if (this.currentPage > 1) {
            this.top.lookup("#back").setDisable(false);
        } else {
            this.top.lookup("#back").setDisable(true);
        }
        if (this.currentPage < ((PDDocument)this.efcReportContainer.getDocument()).getNumberOfPages()) {
            this.top.lookup("#forward").setDisable(false);
        } else {
            this.top.lookup("#forward").setDisable(true);
        }
        ((ComboBox)this.top.lookup("#pages")).getSelectionModel().select(this.currentPage - 1);
    }

    private void adjustPagePosition(Bounds nb) {
        double adjustment = nb.getWidth() / 2.0 - this.group.getBoundsInLocal().getWidth() / 2.0;
        if (adjustment < 0.0) {
            adjustment = 0.0;
        }
        this.group.setTranslateX(adjustment);
    }

    public static enum FitToPage {
        AUTO,
        WIDTH,
        HEIGHT,
        NONE;

    }
}

