/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx;

import de.effectivecompany.gui.components.fx.EFCFxButton;
import de.effectivecompany.gui.components.fx.EFCMainMenu;
import de.effectivecompany.gui.components.fx.event.EFCAbstractAction;
import de.effectivecompany.gui.constants.EFCAction;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import javafx.scene.Node;
import javafx.scene.control.ToolBar;
import org.controlsfx.control.action.Action;

public class EFCToolBar
extends ToolBar {
    public static final long serialVersionUID = -34563456L;
    private List<EFCAbstractAction> actions = new ArrayList<EFCAbstractAction>();
    private EFCMainMenu mainMenu;

    public EFCToolBar() {
    }

    public EFCToolBar(EFCMainMenu mainMenu) {
        this();
        this.mainMenu = mainMenu;
    }

    public EFCFxButton add(EFCAbstractAction action) {
        return this.add(action, null);
    }

    public EFCFxButton addBeforeAction(EFCAbstractAction action, EFCAbstractAction other) {
        OptionalInt indexOpt = IntStream.range(0, this.getItems().size()).filter(i -> other.getIdent().equals(this.getItems().get(i) instanceof EFCFxButton ? ((EFCFxButton)((Object)((Object)this.getItems().get(i)))).getId() : "")).findFirst();
        return this.add(action, indexOpt.getAsInt());
    }

    public EFCFxButton add(EFCAbstractAction action, Integer index) {
        if (!this.actions.contains(action)) {
            this.actions.add(action);
        }
        EFCFxButton button = new EFCFxButton(action, EFCFxButton.ButtonState.TOOLBAR);
        button.setTextInvisible(true);
        if (index != null) {
            this.getItems().add(index.intValue(), (Object)button);
        } else {
            this.getItems().add((Object)button);
        }
        return button;
    }

    public void terminate() {
    }

    public EFCAbstractAction getAction(Class<?> actionClass) {
        return this.actions.stream().filter(action -> actionClass.isAssignableFrom(action.getClass())).findFirst().orElse(null);
    }

    public void setButtonVisible(EFCAbstractAction action, boolean visible) {
        if (visible && this.actions.contains(action)) {
            this.add(action, this.actions.indexOf(action));
        } else {
            for (int i = 0; i < this.getItems().size(); ++i) {
                Node component = (Node)this.getItems().get(i);
                if (!(component instanceof EFCFxButton) || ((EFCFxButton)component).getId() == null || action == null || ((EFCFxButton)component).getId() != action.getIdent()) continue;
                this.getItems().remove((Object)component);
            }
        }
    }

    public void setToolbarButtonVisible(EFCAction constant, boolean visible) {
        EFCAbstractAction action;
        if (this.mainMenu != null && (action = this.mainMenu.getAction(constant)) != null) {
            action.setDisabled(false);
            this.setButtonVisible(action, visible);
        }
    }

    public void setToolbarButtonVisible(EnumSet<EFCAction> set, boolean visible) {
        if (this.mainMenu != null) {
            for (EFCAction constant : set) {
                EFCAbstractAction action = this.mainMenu.getAction(constant);
                if (action == null) continue;
                action.setDisabled(false);
                this.setButtonVisible(action, visible);
            }
        }
    }

    public Boolean isButtonVisible(Action action) {
        return true;
    }

    public List<EFCAbstractAction> getActions() {
        return this.actions;
    }
}

