/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx;

import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.interfaces.manager.DataChangeManager;
import de.effectivecompany.gui.interfaces.manager.ElementManager;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.net.MalformedURLException;
import java.net.URL;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class EFCWebBrowser
extends EFCPanel {
    private static final long serialVersionUID = 3254434734313528635L;
    private JFXPanel jfxPanel = new JFXPanel();
    private WebEngine engine;
    private WebView view;

    public EFCWebBrowser(String url) {
        super(null, null, "browser", "", false);
        this.initComponents();
        this.loadURL(url);
    }

    public EFCWebBrowser(ElementManager elementManager, DataChangeManager dataChangeManager, String ident, String parentIdent, boolean border) {
        super(elementManager, dataChangeManager, ident, parentIdent, border);
        this.initComponents();
    }

    private void initComponents() {
        Platform.setImplicitExit((boolean)false);
        this.createScene();
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                if (EFCWebBrowser.this.view != null) {
                    EFCWebBrowser.this.view.autosize();
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.setPreferredSize(EFCLookAndFeelManager.SIZE_FRAME_SEARCH);
        this.add((Component)this.jfxPanel, "Center");
    }

    private void createScene() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                WebView view = new WebView();
                EFCWebBrowser.this.engine = view.getEngine();
                EFCWebBrowser.this.engine.getLoadWorker().exceptionProperty().addListener((ChangeListener)new ChangeListener<Throwable>(){

                    public void changed(ObservableValue<? extends Throwable> o, Throwable old, Throwable value) {
                        if (EFCWebBrowser.this.engine.getLoadWorker().getState() == Worker.State.FAILED) {
                            EFCThreadUtil.doLater(() -> JOptionPane.showMessageDialog(EFCWebBrowser.this, value != null ? EFCWebBrowser.this.engine.getLocation() + "\n" + value.getMessage() : EFCWebBrowser.this.engine.getLocation() + "\nUnexpected error.", "Loading error...", 0));
                        }
                    }
                });
                EFCWebBrowser.this.jfxPanel.setScene(new Scene((Parent)view));
            }
        });
    }

    public void loadURL(String url) {
        LoadURL action = new LoadURL(url);
        Platform.runLater((Runnable)action);
    }

    private static String toURL(String str) {
        try {
            return new URL(str).toExternalForm();
        }
        catch (MalformedURLException exception) {
            return null;
        }
    }

    public static void main(String[] args) {
        EFCThreadUtil.doLater(() -> {
            EFCWebBrowser browser = new EFCWebBrowser("http://agorum/roiwebui/roiwebui_module/executeAction.do?parameterIdentifier=parameter.PortalPage");
            JFrame frame = new JFrame();
            frame.getContentPane().add(browser);
            frame.setPreferredSize(new Dimension(1024, 600));
            frame.setDefaultCloseOperation(3);
            frame.pack();
            frame.setVisible(true);
            EFCWebBrowser browser1 = new EFCWebBrowser("http://agorum/roiwebui/roiwebui_module/executeAction.do?parameterIdentifier=parameter.PortalPage");
            JFrame frame1 = new JFrame();
            frame1.getContentPane().add(browser1);
            frame1.setPreferredSize(new Dimension(1024, 600));
            frame1.setDefaultCloseOperation(3);
            frame1.pack();
            frame1.setVisible(true);
        });
    }

    @Override
    public void terminate() {
        this.removeAll();
        this.jfxPanel.removeAll();
        this.jfxPanel = null;
        this.view = null;
        this.engine = null;
    }

    public class LoadURL
    implements Runnable {
        private String url;

        public LoadURL(String url) {
            this.url = url;
        }

        @Override
        public void run() {
            String tmp = EFCWebBrowser.toURL(this.url);
            if (tmp == null) {
                tmp = EFCWebBrowser.toURL("http://" + this.url);
            }
            EFCWebBrowser.this.engine.load(tmp);
        }
    }
}

