/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.chart;

import com.sun.javafx.charts.ChartLayoutAnimator;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.value.WritableValue;
import javafx.scene.Parent;
import javafx.scene.chart.Axis;
import javafx.util.Duration;
import javafx.util.StringConverter;

public final class DateAxis
extends Axis<Date> {
    private final LongProperty currentLowerBound = new SimpleLongProperty((Object)this, "currentLowerBound");
    private final LongProperty currentUpperBound = new SimpleLongProperty((Object)this, "currentUpperBound");
    private final ObjectProperty<StringConverter<Date>> tickLabelFormatter = new ObjectPropertyBase<StringConverter<Date>>(){

        protected void invalidated() {
            if (!DateAxis.this.isAutoRanging()) {
                DateAxis.this.invalidateRange();
                DateAxis.this.requestAxisLayout();
            }
        }

        public Object getBean() {
            return DateAxis.this;
        }

        public String getName() {
            return "tickLabelFormatter";
        }
    };
    private Date minDate;
    private Date maxDate;
    private ObjectProperty<Date> lowerBound = new ObjectPropertyBase<Date>(){

        protected void invalidated() {
            if (!DateAxis.this.isAutoRanging()) {
                DateAxis.this.invalidateRange();
                DateAxis.this.requestAxisLayout();
            }
        }

        public Object getBean() {
            return DateAxis.this;
        }

        public String getName() {
            return "lowerBound";
        }
    };
    private ObjectProperty<Date> upperBound = new ObjectPropertyBase<Date>(){

        protected void invalidated() {
            if (!DateAxis.this.isAutoRanging()) {
                DateAxis.this.invalidateRange();
                DateAxis.this.requestAxisLayout();
            }
        }

        public Object getBean() {
            return DateAxis.this;
        }

        public String getName() {
            return "upperBound";
        }
    };
    private ChartLayoutAnimator animator = new ChartLayoutAnimator((Parent)this);
    private Object currentAnimationID;
    private Interval actualInterval = Interval.DECADE;

    public DateAxis() {
    }

    public DateAxis(Date lowerBound, Date upperBound) {
        this();
        this.setAutoRanging(false);
        this.setLowerBound(lowerBound);
        this.setUpperBound(upperBound);
    }

    public DateAxis(String axisLabel, Date lowerBound, Date upperBound) {
        this(lowerBound, upperBound);
        this.setLabel(axisLabel);
    }

    public void invalidateRange(List<Date> list) {
        super.invalidateRange(list);
        Collections.sort(list);
        if (list.isEmpty()) {
            this.minDate = this.maxDate = new Date();
        } else if (list.size() == 1) {
            this.minDate = this.maxDate = list.get(0);
        } else if (list.size() > 1) {
            this.minDate = list.get(0);
            this.maxDate = list.get(list.size() - 1);
        }
    }

    protected Object autoRange(double length) {
        if (this.isAutoRanging()) {
            return new Object[]{this.minDate, this.maxDate};
        }
        if (this.getLowerBound() == null || this.getUpperBound() == null) {
            throw new IllegalArgumentException("If autoRanging is false, a lower and upper bound must be set.");
        }
        return this.getRange();
    }

    protected void setRange(Object range, boolean animating) {
        Object[] r = (Object[])range;
        Date oldLowerBound = this.getLowerBound();
        Date oldUpperBound = this.getUpperBound();
        Date lower = (Date)r[0];
        Date upper = (Date)r[1];
        this.setLowerBound(lower);
        this.setUpperBound(upper);
        if (animating) {
            this.animator.stop(this.currentAnimationID);
            this.currentAnimationID = this.animator.animate(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.currentLowerBound, (Object)oldLowerBound.getTime()), new KeyValue((WritableValue)this.currentUpperBound, (Object)oldUpperBound.getTime())}), new KeyFrame(Duration.millis((double)700.0), new KeyValue[]{new KeyValue((WritableValue)this.currentLowerBound, (Object)lower.getTime()), new KeyValue((WritableValue)this.currentUpperBound, (Object)upper.getTime())})});
        } else {
            this.currentLowerBound.set(this.getLowerBound().getTime());
            this.currentUpperBound.set(this.getUpperBound().getTime());
        }
    }

    protected Object getRange() {
        return new Object[]{this.getLowerBound(), this.getUpperBound()};
    }

    public double getZeroPosition() {
        return 0.0;
    }

    public double getDisplayPosition(Date date) {
        double length = this.getSide().isHorizontal() ? this.getWidth() : this.getHeight();
        double diff = this.currentUpperBound.get() - this.currentLowerBound.get();
        double range = length - this.getZeroPosition();
        double d = (double)(date.getTime() - this.currentLowerBound.get()) / diff;
        if (this.getSide().isVertical()) {
            return this.getHeight() - d * range + this.getZeroPosition();
        }
        return d * range + this.getZeroPosition();
    }

    public Date getValueForDisplay(double displayPosition) {
        double length = this.getSide().isHorizontal() ? this.getWidth() : this.getHeight();
        double diff = this.currentUpperBound.get() - this.currentLowerBound.get();
        double range = length - this.getZeroPosition();
        if (this.getSide().isVertical()) {
            return new Date((long)((displayPosition - this.getZeroPosition() - this.getHeight()) / -range * diff + (double)this.currentLowerBound.get()));
        }
        return new Date((long)((displayPosition - this.getZeroPosition()) / range * diff + (double)this.currentLowerBound.get()));
    }

    public boolean isValueOnAxis(Date date) {
        return date.getTime() > this.currentLowerBound.get() && date.getTime() < this.currentUpperBound.get();
    }

    public double toNumericValue(Date date) {
        return date.getTime();
    }

    public Date toRealValue(double v) {
        return new Date((long)v);
    }

    protected List<Date> calculateTickValues(double v, Object range) {
        Object[] r = (Object[])range;
        Date lower = (Date)r[0];
        Date upper = (Date)r[1];
        ArrayList<Date> dateList = new ArrayList<Date>();
        Calendar calendar = Calendar.getInstance();
        double averageTickGap = 100.0;
        double averageTicks = v / averageTickGap;
        ArrayList<Date> previousDateList = new ArrayList<Date>();
        Interval previousInterval = Interval.values()[0];
        for (Interval interval : Interval.values()) {
            calendar.setTime(lower);
            dateList.clear();
            previousDateList.clear();
            this.actualInterval = interval;
            while (calendar.getTime().getTime() <= upper.getTime()) {
                dateList.add(calendar.getTime());
                calendar.add(interval.interval, interval.amount);
            }
            if ((double)dateList.size() > averageTicks) {
                calendar.setTime(lower);
                while (calendar.getTime().getTime() <= upper.getTime()) {
                    previousDateList.add(calendar.getTime());
                    calendar.add(previousInterval.interval, previousInterval.amount);
                }
                break;
            }
            previousInterval = interval;
        }
        if ((double)previousDateList.size() - averageTicks > averageTicks - (double)dateList.size()) {
            dateList = previousDateList;
            this.actualInterval = previousInterval;
        }
        dateList.add(upper);
        List<Date> evenDateList = this.makeDatesEven(dateList, calendar);
        if (evenDateList.size() > 2) {
            Date secondDate = evenDateList.get(1);
            Date thirdDate = evenDateList.get(2);
            Date lastDate = evenDateList.get(dateList.size() - 2);
            Date previousLastDate = evenDateList.get(dateList.size() - 3);
            if (secondDate.getTime() - lower.getTime() < (thirdDate.getTime() - secondDate.getTime()) / 2L) {
                evenDateList.remove(secondDate);
            }
            if (upper.getTime() - lastDate.getTime() < (lastDate.getTime() - previousLastDate.getTime()) / 2L) {
                evenDateList.remove(lastDate);
            }
        }
        return evenDateList;
    }

    protected void layoutChildren() {
        if (!this.isAutoRanging()) {
            this.currentLowerBound.set(this.getLowerBound().getTime());
            this.currentUpperBound.set(this.getUpperBound().getTime());
        }
        super.layoutChildren();
    }

    protected String getTickMarkLabel(Date date) {
        DateFormat dateFormat;
        StringConverter<Date> converter = this.getTickLabelFormatter();
        if (converter != null) {
            return converter.toString((Object)date);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (this.actualInterval.interval == 1 && calendar.get(2) == 0 && calendar.get(5) == 1) {
            dateFormat = new SimpleDateFormat("yyyy");
        } else if (this.actualInterval.interval == 2 && calendar.get(5) == 1) {
            dateFormat = new SimpleDateFormat("MMM yy");
        } else {
            switch (this.actualInterval.interval) {
                default: {
                    dateFormat = DateFormat.getDateInstance(2);
                    break;
                }
                case 10: 
                case 12: {
                    dateFormat = DateFormat.getTimeInstance(3);
                    break;
                }
                case 13: {
                    dateFormat = DateFormat.getTimeInstance(2);
                    break;
                }
                case 14: {
                    dateFormat = DateFormat.getTimeInstance(0);
                }
            }
        }
        return dateFormat.format(date);
    }

    private List<Date> makeDatesEven(List<Date> dates, Calendar calendar) {
        if (dates.size() > 2) {
            ArrayList<Date> evenDates = new ArrayList<Date>();
            for (int i = 0; i < dates.size(); ++i) {
                calendar.setTime(dates.get(i));
                switch (this.actualInterval.interval) {
                    case 1: {
                        if (i != 0 && i != dates.size() - 1) {
                            calendar.set(2, 0);
                            calendar.set(5, 1);
                        }
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 6);
                        break;
                    }
                    case 2: {
                        if (i != 0 && i != dates.size() - 1) {
                            calendar.set(5, 1);
                        }
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 5);
                        break;
                    }
                    case 3: {
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 4);
                        break;
                    }
                    case 5: {
                        calendar.set(11, 0);
                        calendar.set(12, 0);
                        calendar.set(13, 0);
                        calendar.set(14, 3);
                        break;
                    }
                    case 10: {
                        if (i != 0 && i != dates.size() - 1) {
                            calendar.set(12, 0);
                            calendar.set(13, 0);
                        }
                        calendar.set(14, 2);
                        break;
                    }
                    case 12: {
                        if (i != 0 && i != dates.size() - 1) {
                            calendar.set(13, 0);
                        }
                        calendar.set(14, 1);
                        break;
                    }
                    case 13: {
                        calendar.set(14, 0);
                    }
                }
                evenDates.add(calendar.getTime());
            }
            return evenDates;
        }
        return dates;
    }

    public final ObjectProperty<Date> lowerBoundProperty() {
        return this.lowerBound;
    }

    public final Date getLowerBound() {
        return (Date)this.lowerBound.get();
    }

    public final void setLowerBound(Date date) {
        this.lowerBound.set((Object)date);
    }

    public final ObjectProperty<Date> upperBoundProperty() {
        return this.upperBound;
    }

    public final Date getUpperBound() {
        return (Date)this.upperBound.get();
    }

    public final void setUpperBound(Date date) {
        this.upperBound.set((Object)date);
    }

    public final StringConverter<Date> getTickLabelFormatter() {
        return (StringConverter)this.tickLabelFormatter.getValue();
    }

    public final void setTickLabelFormatter(StringConverter<Date> value) {
        this.tickLabelFormatter.setValue(value);
    }

    public final ObjectProperty<StringConverter<Date>> tickLabelFormatterProperty() {
        return this.tickLabelFormatter;
    }

    public double getScale() {
        double length = this.getSide().isHorizontal() ? this.getWidth() : this.getHeight();
        double diff = this.currentUpperBound.get() - this.currentLowerBound.get();
        double range = length - this.getZeroPosition();
        return length / diff;
    }

    private static enum Interval {
        DECADE(1, 10),
        YEAR(1, 1),
        MONTH_6(2, 6),
        MONTH_3(2, 3),
        MONTH_1(2, 1),
        WEEK(3, 1),
        DAY(5, 1),
        HOUR_12(10, 12),
        HOUR_6(10, 6),
        HOUR_3(10, 3),
        HOUR_1(10, 1),
        MINUTE_15(12, 15),
        MINUTE_5(12, 5),
        MINUTE_1(12, 1),
        SECOND_15(13, 15),
        SECOND_5(13, 5),
        SECOND_1(13, 1),
        MILLISECOND(14, 1);

        private final int amount;
        private final int interval;

        private Interval(int interval, int amount) {
            this.interval = interval;
            this.amount = amount;
        }
    }
}

