/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.components;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.CalendarSource;
import com.calendarfx.model.Entry;
import com.calendarfx.model.Interval;
import com.calendarfx.view.CalendarView;
import de.effectivecompany.app.sys.DcCalendar;
import de.effectivecompany.base.data.AbstractLazyList;
import de.effectivecompany.base.meta.MetaInfo;
import de.effectivecompany.gui.components.fx.pane.EFCLockPane;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.time.LocalTime;
import java.time.ZoneId;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;

public class EFCCalendar
extends StackPane {
    private CalendarView calendar;
    private EFCLockPane lockPane = new EFCLockPane();

    public EFCCalendar() {
        this.calendar = new CalendarView();
        this.getChildren().addAll((Object[])new Node[]{this.calendar, this.lockPane});
        this.calendar.setRequestedTime(LocalTime.now());
        this.calendar.setContextMenuCallback(null);
    }

    public void setData(AbstractLazyList calList) {
        EFCThreadUtil.fatBuilder(th -> {
            this.lockPane.setVisible(true);
            th.doOutside(() -> {
                try {
                    calList.lock();
                    calList.load();
                    calList.unlock();
                }
                catch (Throwable ex) {
                    EFCDesktop.reportError(ex);
                }
                th.fat(() -> {
                    this.calendar.getCalendarSources().clear();
                    CalendarSource myCalendarSource = new CalendarSource("Kalender");
                    int index = 1;
                    for (MetaInfo cal : calList) {
                        if (!(cal instanceof DcCalendar)) continue;
                        DcCalendar dcCalendar = (DcCalendar)cal;
                        Calendar calendar = new Calendar(dcCalendar.getCalname().getData());
                        calendar.setReadOnly(true);
                        calendar.setStyle(Calendar.Style.getStyle((int)index));
                        myCalendarSource.getCalendars().add((Object)calendar);
                        dcCalendar.getCalentryList().forEach(calentry -> {
                            if (calentry.getStart().getData() != null && calentry.getEnd().getData() != null) {
                                Entry calendarEntry = new Entry(calentry.getTitle().getData(), new Interval(calentry.getStart().getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime(), calentry.getEnd().getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime()));
                                calendarEntry.setLocation(calentry.getLocation().getData());
                                calendarEntry.setCalendar(calendar);
                            }
                        });
                        ++index;
                    }
                    this.calendar.getCalendarSources().setAll((Object[])new CalendarSource[]{myCalendarSource});
                    this.lockPane.setVisible(false);
                });
            });
        });
    }
}

