/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.components;

import de.effectivecompany.gui.components.fx.EFCFxButton;
import de.effectivecompany.gui.components.fx.event.EFCAbstractAction;
import de.effectivecompany.gui.components.fx.event.EFCActionToolbarDropDown;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;

public class EFCDropDownButton
extends HBox {
    private EFCFxButton mainbutton;
    private EFCFxButton dropdown;
    private ContextMenu contextMenu = new ContextMenu();

    public EFCDropDownButton(EFCAbstractAction action) {
        this.mainbutton = new EFCFxButton(action, EFCFxButton.ButtonState.TOOLBAR);
        this.mainbutton.setTextInvisible(true);
        this.dropdown = new EFCFxButton(new EFCActionToolbarDropDown(), EFCFxButton.ButtonState.TOOLBAR);
        this.dropdown.setTextInvisible(true);
        this.dropdown.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                EFCDropDownButton.this.contextMenu.show((Node)EFCDropDownButton.this.dropdown, Side.BOTTOM, 0.0, 0.0);
            }
        });
        this.getChildren().addAll((Object[])new Node[]{this.mainbutton, this.dropdown});
    }

    public MenuItem addDropdown(EFCAbstractAction action) {
        MenuItem menuitem = new MenuItem();
        menuitem.setText(action.getText());
        menuitem.setOnAction((EventHandler)action);
        menuitem.setMnemonicParsing(true);
        final AtomicReference<MenuItem> ref = new AtomicReference<MenuItem>(menuitem);
        action.disabledProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                ((MenuItem)ref.get()).setDisable(newValue.booleanValue());
            }
        });
        if (action.getGraphic() != null) {
            menuitem.setGraphic((Node)new ImageView(((ImageView)action.getGraphic()).getImage()));
        }
        menuitem.setAccelerator(action.getAccelerator());
        this.contextMenu.getItems().add((Object)menuitem);
        return menuitem;
    }

    public void addSeparator() {
        this.contextMenu.getItems().add((Object)new SeparatorMenuItem());
    }
}

