/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.components;

import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.fx.components.EFCTable;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Orientation;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.skin.TableHeaderRow;
import javafx.scene.control.skin.TableViewSkin;
import javafx.util.Callback;

public abstract class EFCTableView<T>
extends TableView<T>
implements EFCTable {
    private SimpleObjectProperty<ColumnControlType> columnControlType = new SimpleObjectProperty();
    private Node tableMenuButton;

    public EFCTableView() {
        this.setTableMenuButtonVisible(true);
        this.setPlaceholder((Node)new Label());
        this.setFixedCellSize(-1.0);
        this.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                EFCTableView.this.refresh();
            }
        });
        this.columnControlType.addListener((ChangeListener)new ChangeListener<ColumnControlType>(){

            public void changed(ObservableValue<? extends ColumnControlType> observable, ColumnControlType oldValue, ColumnControlType newValue) {
                if (EFCTableView.this.tableMenuButton == null) {
                    EFCTableView.this.tableMenuButton = EFCTableView.this.createContextMenuButton();
                }
                if (EFCTableView.this.tableMenuButton != null) {
                    switch (newValue) {
                        case ALL_USERS: {
                            EFCTableView.this.tableMenuButton.setStyle("-fx-background-color: red");
                            break;
                        }
                        case USER: {
                            EFCTableView.this.tableMenuButton.setStyle("-fx-background-color: blue");
                            break;
                        }
                        case NONE: {
                            EFCTableView.this.tableMenuButton.setStyle("-fx-background-color: lightgray");
                        }
                    }
                }
            }
        });
    }

    public ScrollBar getScrollbar(Orientation orientation) {
        ScrollBar result = null;
        for (Node n : this.lookupAll(".scroll-bar")) {
            ScrollBar bar;
            if (!(n instanceof ScrollBar) || !(bar = (ScrollBar)n).getOrientation().equals((Object)orientation)) continue;
            result = bar;
            break;
        }
        return result;
    }

    public TableColumn<T, EFCString> addColumn(String name) {
        TableColumn dataName = new TableColumn(Translator.tr((String)("FLD_" + name.toUpperCase())));
        dataName.setPrefWidth(200.0);
        dataName.setCellValueFactory((Callback)new PropertyValueFactory(name));
        dataName.setId(name);
        this.getColumns().add((Object)dataName);
        return dataName;
    }

    private Node createContextMenuButton() {
        TableViewSkin tableSkin = (TableViewSkin)this.getSkin();
        ObservableList children = tableSkin.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            Node node = (Node)children.get(i);
            if (!(node instanceof TableHeaderRow)) continue;
            TableHeaderRow tableHeaderRow = (TableHeaderRow)node;
            double defaultHeight = tableHeaderRow.getHeight();
            tableHeaderRow.setPrefHeight(defaultHeight);
            for (Node child : tableHeaderRow.getChildren()) {
                if (!child.getStyleClass().contains((Object)"show-hide-columns-button")) continue;
                child.setOnMousePressed(me -> {
                    ContextMenu columnPopupMenu = EFCTableView.createContextMenu(this);
                    columnPopupMenu.show(child, Side.BOTTOM, 0.0, 0.0);
                    me.consume();
                });
                return child;
            }
        }
        return null;
    }

    public void setColumnControlType(ColumnControlType columnControlType) {
        this.columnControlType.set((Object)columnControlType);
    }

    private static ContextMenu createContextMenu(TableView table) {
        ContextMenu cm = new ContextMenu();
        for (Object obj : table.getColumns()) {
            TableColumn tableColumn = (TableColumn)obj;
            CheckBox cb = new CheckBox(tableColumn.getText());
            cb.selectedProperty().bindBidirectional((Property)tableColumn.visibleProperty());
            CustomMenuItem cmi = new CustomMenuItem((Node)cb);
            cmi.setHideOnClick(false);
            cm.getItems().add((Object)cmi);
        }
        return cm;
    }

    public static enum ColumnControlType {
        ALL_USERS,
        USER,
        NONE;

    }
}

