/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.components.editor;

import de.effectivecompany.gui.components.fx.components.editor.EFCTextfield;
import de.effectivecompany.gui.factory.EFCPanelSingleton;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.function.UnaryOperator;
import javafx.scene.control.TextFormatter;

public class EFCDoubleTextfield
extends EFCTextfield {
    protected DecimalFormat format;
    protected UnaryOperator<TextFormatter.Change> filter;

    public EFCDoubleTextfield() {
        this.init();
    }

    public EFCDoubleTextfield(String ident) {
        super(ident);
        this.init();
    }

    @Override
    public void init() {
        DecimalFormatSymbols formatSymbols;
        this.format = new DecimalFormat();
        this.format.setGroupingUsed(false);
        EFCPanelSingleton.getInstance();
        if (EFCPanelSingleton.DECIMAL_SEPARATOR != null) {
            formatSymbols = this.format.getDecimalFormatSymbols();
            formatSymbols.setDecimalSeparator(EFCPanelSingleton.DECIMAL_SEPARATOR.charValue());
            this.format.setDecimalFormatSymbols(formatSymbols);
        }
        if (EFCPanelSingleton.GROUPING_SEPARATOR != null) {
            formatSymbols = this.format.getDecimalFormatSymbols();
            formatSymbols.setGroupingSeparator(EFCPanelSingleton.GROUPING_SEPARATOR.charValue());
            this.format.setDecimalFormatSymbols(formatSymbols);
        }
        UnaryOperator filter = change -> {
            for (char c : change.getText().toCharArray()) {
                if (Character.isDigit(c) || c == this.format.getDecimalFormatSymbols().getDecimalSeparator()) continue;
                return null;
            }
            return change;
        };
    }
}

