/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.fx.dialog;

import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.security.SecUtils;
import de.effectivecompany.gui.EFC;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.AuthResult;
import de.effectivecompany.gui.util.EFCThreadUtil;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

public class EFCLoginDialog {
    private Button okButton;
    private Button cancelButton;
    private static String ConnectTitle = "Effective Company";
    private TextField usernameField;
    private PasswordField passwordField;
    private TextField companyField;
    private final Label statusInfoLabel;
    private GridPane gridpane;
    private static Stage dialog;
    private static boolean isAuth;

    private EFCLoginDialog(String user, String passwd) {
        BorderPane border = new BorderPane();
        Scene scene = new Scene((Parent)border, (Paint)EFCLookAndFeelManager.COLORFX_DESKTOP_BACKGROUND);
        dialog = new Stage();
        dialog.setWidth(350.0);
        dialog.setHeight(230.0);
        dialog.setAlwaysOnTop(true);
        dialog.setTitle(ConnectTitle);
        dialog.setResizable(false);
        dialog.getIcons().addAll(EFCLookAndFeelManager.ICON_APP_FX);
        dialog.initModality(Modality.APPLICATION_MODAL);
        dialog.setScene(scene);
        dialog.setOnCloseRequest(event -> System.exit(0));
        this.gridpane = new GridPane();
        this.gridpane.setPadding(new Insets(5.0));
        this.gridpane.setHgap(5.0);
        this.gridpane.setVgap(5.0);
        Font fontLabel = new Font("SansSerif", 12.0);
        Font fontText = new Font("SansSerif", 12.0);
        EnterKeyHandler enterHandler = new EnterKeyHandler();
        Label companyLabel = new Label(Translator.tr((String)"FLD_LOGIN_COMPANY"));
        companyLabel.setFont(fontLabel);
        companyLabel.setFocusTraversable(false);
        this.companyField = new TextField();
        this.companyField.setFont(fontText);
        this.companyField.addEventHandler(KeyEvent.KEY_RELEASED, (EventHandler)enterHandler);
        Label userLabel = new Label(Translator.tr((String)"FLD_LOGIN_USERNAME"));
        userLabel.setFont(fontLabel);
        userLabel.setFocusTraversable(false);
        this.gridpane.add((Node)userLabel, 0, 2);
        this.usernameField = new TextField();
        this.usernameField.setFont(fontText);
        this.usernameField.addEventHandler(KeyEvent.KEY_RELEASED, (EventHandler)enterHandler);
        if (user != null && !user.isEmpty()) {
            this.usernameField.setText(user);
        }
        this.gridpane.add((Node)this.usernameField, 1, 2);
        Label passwordLabel = new Label(Translator.tr((String)"FLD_LOGIN_PASSWORD"));
        passwordLabel.setFont(fontLabel);
        passwordLabel.setFocusTraversable(false);
        this.gridpane.add((Node)passwordLabel, 0, 3);
        this.passwordField = new PasswordField();
        this.passwordField.setFont(fontText);
        this.passwordField.addEventHandler(KeyEvent.KEY_RELEASED, (EventHandler)enterHandler);
        if (passwd != null && !passwd.isEmpty()) {
            this.passwordField.setText(passwd);
        }
        this.gridpane.add((Node)this.passwordField, 1, 3);
        this.gridpane.setAlignment(Pos.CENTER);
        this.statusInfoLabel = new Label();
        this.statusInfoLabel.setPrefWidth(250.0);
        this.statusInfoLabel.setWrapText(true);
        this.statusInfoLabel.setAlignment(Pos.BASELINE_LEFT);
        this.statusInfoLabel.setText(EFC.getInstance().createPropertyString());
        this.statusInfoLabel.setPadding(new Insets(5.0));
        BorderPane borderGrid = new BorderPane();
        borderGrid.setCenter((Node)this.gridpane);
        borderGrid.setBottom((Node)this.statusInfoLabel);
        border.setCenter((Node)borderGrid);
        VBox vBox = new VBox();
        vBox.setPadding(new Insets(15.0, 12.0, 15.0, 12.0));
        ImageView imageView = new ImageView(EFCLookAndFeelManager.ICON_APP_EFC_LOGIN_FX);
        imageView.setFitWidth(80.0);
        imageView.setPreserveRatio(true);
        imageView.setSmooth(true);
        imageView.setCache(true);
        vBox.setAlignment(Pos.CENTER);
        vBox.getChildren().add((Object)imageView);
        HBox buttons = new HBox();
        buttons.setPadding(new Insets(15.0, 12.0, 15.0, 12.0));
        buttons.setSpacing(10.0);
        buttons.setAlignment(Pos.CENTER);
        this.okButton = new Button(Translator.tr((String)"_LOGIN"));
        this.okButton.setOnKeyPressed(event -> {
            if (event.getSource() != null && event.getSource() == this.okButton && event.getCode() == KeyCode.ENTER) {
                this.okButton.arm();
                this.okButton.fire();
            }
        });
        this.okButton.setFont(fontLabel);
        this.cancelButton = new Button(Translator.tr((String)"_CANCEL"));
        this.cancelButton.setFont(fontLabel);
        this.cancelButton.setOnKeyPressed(event -> {
            if (event.getSource() != null && event.getSource() == this.cancelButton && event.getCode() == KeyCode.ENTER) {
                this.cancelButton.arm();
                this.cancelButton.fire();
            }
        });
        buttons.getChildren().addAll((Object[])new Node[]{this.okButton, this.cancelButton});
        this.okButton.setOnAction(event -> this.okAction());
        this.cancelButton.setOnAction(event -> System.exit(0));
        border.setLeft((Node)vBox);
        border.setBottom((Node)buttons);
        border.setPadding(new Insets(5.0));
        if (this.usernameField.getText() != null && !this.usernameField.getText().isEmpty() && this.passwordField.getText() != null && !this.passwordField.getText().isEmpty()) {
            this.okAction();
        }
    }

    public static void getAuthentication(String user, String pw) {
        if (dialog == null && !isAuth) {
            new EFCLoginDialog(user, pw);
        }
        if (dialog != null) {
            Rectangle2D screenSize = Screen.getPrimary().getVisualBounds();
            dialog.setX(screenSize.getMinX() + screenSize.getWidth() / 2.0 - dialog.getWidth() / 2.0);
            dialog.setY(screenSize.getMinY() + screenSize.getHeight() / 2.0 - dialog.getHeight() / 2.0);
            dialog.show();
        }
    }

    private void okAction() {
        String username = SecUtils.encodeUserAndCompany((String)this.usernameField.getText().trim(), (String)this.companyField.getText().trim());
        String password = this.passwordField.getText();
        if ((this.usernameField.getText() == null || this.usernameField.getText().trim().isEmpty()) && (password == null || password.isEmpty())) {
            username = SecUtils.encodeUserAndCompany((String)"_efc_tf_user_", (String)"");
            password = "*";
        }
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        AuthResult result = EFC.getInstance().doLogin((Authentication)token);
        if (result.getAuth() != null && result.getAuth().isAuthenticated()) {
            isAuth = true;
            dialog.hide();
            this.terminate();
            EFCThreadUtil.doLater(() -> EFC.getInstance().startEFC());
        } else {
            this.statusInfoLabel.setText(result.getErrorText());
        }
    }

    public void terminate() {
        this.usernameField = null;
        this.passwordField = null;
        this.okButton = null;
        this.cancelButton = null;
        dialog = null;
    }

    static {
        isAuth = false;
    }

    private class EnterKeyHandler
    implements EventHandler<KeyEvent> {
        private EnterKeyHandler() {
        }

        public void handle(KeyEvent event) {
            if (event.getCode() == KeyCode.ENTER) {
                ObservableList children;
                int idx;
                if (event.getSource() instanceof PasswordField) {
                    EFCLoginDialog.this.okButton.arm();
                    EFCLoginDialog.this.okButton.fire();
                } else if (event.getSource() instanceof TextField && (idx = (children = EFCLoginDialog.this.gridpane.getChildrenUnmodifiable()).indexOf(event.getSource())) >= 0) {
                    for (int i = idx + 1; i < children.size(); ++i) {
                        if (!((Node)children.get(i)).isFocusTraversable()) continue;
                        ((Node)children.get(i)).requestFocus();
                        break;
                    }
                }
            }
        }
    }
}

